# Contents

> **_Note:_** Recent changes have occurred to the directory structure for `Available WebAssembly Runtime Builds` (see below diagrams).  All builds can now be found in one directory `sdk/wasm/builds`.  This was necessary to start supporting more options and functionality.

- Available WebAssembly Runtime Builds

    ```
        .
        |--- sdk/wasm/builds
            |--- debug                  - Debug build of the runtime.
                |--- corebindings.o         - Runtime linked lib - NOT DISTRIBUTED
                |--- driver.o               - Runtime linked lib - NOT DISTRIBUTED
                |--- dotnet.js                - Mono WebAssembly implementations
                |--- dotnet.wasm              - Mono WebAssembly implementations
                |--- dotnet.wasm.map          - Mono WebAssembly implementations
                |--- zlib-helper.o          - Runtime linked lib - NOT DISTRIBUTED
            |--- release                - Release build of the runtime.
                |--- corebindings.o         - Runtime linked lib - NOT DISTRIBUTED
                |--- driver.o               - Runtime linked lib - NOT DISTRIBUTED
                |--- dotnet.js                - Mono WebAssembly implementations
                |--- dotnet.wasm              - Mono WebAssembly implementations
                |--- zlib-helper.o          - Runtime linked lib - NOT DISTRIBUTED
            |--- release-dynamic         - Release build of the runtime with dynamic linking enabled
                |--- corebindings.o         - Runtime linked lib - NOT DISTRIBUTED
                |--- driver.o               - Runtime linked lib - NOT DISTRIBUTED
                |--- dotnet.js                - Mono WebAssembly implementations
                |--- dotnet.wasm              - Mono WebAssembly implementations
                |--- zlib-helper.o          - Runtime linked lib - NOT DISTRIBUTED
            |--- threads-debug          - Debug build that includes pthreads.
                |--- corebindings.o         - Runtime linked lib - NOT DISTRIBUTED
                |--- driver.o               - Runtime linked lib - NOT DISTRIBUTED
                |--- dotnet.js                - Mono WebAssembly implementations
                |--- dotnet.wasm              - Mono WebAssembly implementations
                |--- dotnet.wasm.map          - Mono WebAssembly implementations
                |--- dotnet.js.mem            - Mono WebAssembly implementations
                |--- dotnet.worker.js         - pthreads worker.  File must be deployed with the rest of the generated code files.
                |--- zlib-helper.o          - Runtime linked lib - NOT DISTRIBUTED
            |--- threads-release        - Release build that includes pthreads.
                |--- corebindings.o         - Runtime linked lib - NOT DISTRIBUTED
                |--- driver.o               - Runtime linked lib - NOT DISTRIBUTED
                |--- dotnet.js                - Mono WebAssembly implementations
                |--- dotnet.wasm              - Mono WebAssembly implementations
                |--- dotnet.wasm.map          - Mono WebAssembly implementations
                |--- dotnet.js.mem            - Mono WebAssembly implementations
                |--- dotnet.worker.js         - pthreads worker.  File must be deployed with the rest of the generated code files.
                |--- zlib-helper.o          - Runtime linked lib - NOT DISTRIBUTED

    ```

    _Note:_ In the above directories the only files that need to be distributed are the ones prefixed with **dotnet.***.

    _Note:_ The **`dotnet.worker.js`** and **`dotnet.js.mem`** files must be deployed with the rest of the generated code files if using the runtimes for threads.

- Core libraries to be used with the runtime.  Generated by the bcl build step.

    ```
        .
        |--- sdk/out/wasm-bcl                           
            |--- wasm               - Contains the DotNet Binary Core Library references and facades.
            |--- wasm_tools         - Contains the support tools used during build and distribution.       
    ```

- Source support files for custom building the Webassembly Runtime

    ```
        .
        |--- sdk/wasm/src
            |--- driver.c           - WebAssembly main driver program.
            |                           - Native interops with the library_mono.js
            |                           - Initializing and starting mono/
            |                           - Loading of assemblies
            |                           - etc ...
            |
            |--- library_mono.js    - Javascript low level backing support for Mono.
            |                           - Message pumping
            |                           - Loading and running the mono runtime.
            |                           - Setting environment variables
            |                           - AOT Profiler support
            |                           - Debugger support routines
            |
            |--- corebindings.c     - Native interface providing support for:
            |                           - Bindings for Core Javascript Objects
            |                           - Routines for calling managed code using FQN
            |                           - Marshalling code for js <-> managed objects
            |                           - etc ...
            |
            |--- binding_support.js - Javascript low level backing support for `corebindings.c`.
            |
            |--- dotnet_support.js  - Javascript low level backing support routines used by Blazor.
            |
            |--- zlib-helper.c      - Native interface providing support for zlib compression for System.IO.Compression.
            |
            |--- pinvoke-tables-default.h - Native pinvoke interface - this is a generated file.

    ```

# Building

* Use a separate mono repo checkout.
* The build depends on the mono sdk infrastructure.
* The makefile targets are in sdks/builds/wasm.mk.
* The build outputs are emitted to sdks/out/.

## Requirements

WebAssembly builds require Ninja in addition to the standard Mono dependencies. On MacOS, this can be installed with `brew install ninja`.

```ulimit -n 2048```

This raises the process limit high enough for the runtime to successfully build.

## Building mono components

```make -j -C sdks/builds provision-wasm```

This will download and setup emscripten.

``` make -j -C sdks/wasm runtime```

This will build the wasm device runtime.

``` make -j -C sdks/wasm bcl```

This will build the wasm specific version of the BCL.

``` make -j -C sdks/wasm cross```

This will build the AOT cross compiler. Its only needed if you intend
to use AOT.

## Building wasm components

``` make -j -C sdks/wasm```

This will build the actual wasm libraries etc.

Use the same commands after making changes to the various components.

# Sample

See [Getting Started Guides](./docs/getting-started)


# Testing instructions

## WebAssembly

Build the test runner and test suites

```bash
make -C sdks/wasm build
```

Right now the following targets are available:

- mono: Build the mono components.
- build: Build the test runner and test suites
- run-all-mini: Run mini test suite
- run-all-corlib: Run corlib test suite
- run-all-system: Run System test suite
- run-all-system-core: Run System.Core test suite
- run-all-binding: Run bindings test suite
- run-browser-tests: Run tests that require a browser environment
- build-aot-all: Build all AOT samples and tests
- run-aot-all: Run all AOT samples and tests
- build-aot-sample: Build hello world AOT sample
- run-aot-sample: Run hello world AOT sample
- build-interp-sample: Build hello world AOT interpreter sample
- run-interp-sample: Run hello world AOT interpreter sample
- build-aot-bindings-sample: Build sample using bindings
- build-aot-bindings-interp-sample: Build sample using bindings
- clean: cleans the wasm directory

For bcl or runtime changes, you must manually run the corresponding build/package steps in `builds`.
For test suite changes, it's enough to just rerun the local target.


# Debugging

The debugger requires dotnet core version 2.1.301 or greater installed.

To experiment with the debugger, do the following steps:

- When calling `packager.exe` pass the `-debug` argument to it.
- Start Chrome with remote debugging enabled (IE `/Applications/Google\ Chrome.app/Contents/MacOS/Google\ Chrome --remote-debugging-port=9222`)
- Run the proxy: `dotnet run -p ProxyDriver/ProxyDriver.csproj`
- Connect to the proxy by visiting http://localhost:9300/ and select the tab you wish to debug from the list of tabs
- Refresh the debugged page and you should be set

Beware that the debugger is in active development so bugs and missing features will be present.

# WebAssembly packager.exe

Read usage information about the utility see [WebAssembly packager.exe](./docs/packager.md)

# Threading support

To build the runtime with pthreads support use the following make target:

``` bash
make -j -C sdks/wasm runtime-threads
```

-- or --

```bash
make -j -C sdks/builds package-wasm-runtime-threads
```

During the main build two directories will be created:

```
    .
    |--- sdk/wasm/builds                           
        |--- threads-debug          - Debug build that includes pthreads.
            |--- corebindings.o         - Runtime linked lib - NOT DISTRIBUTED
            |--- driver.o               - Runtime linked lib - NOT DISTRIBUTED
            |--- dotnet.js                - Mono WebAssembly implementations
            |--- dotnet.wasm              - Mono WebAssembly implementations
            |--- dotnet.wasm.map          - Mono WebAssembly implementations
            |--- dotnet.js.mem            - Mono WebAssembly implementations
            |--- dotnet.worker.js         - pthreads worker.  File must be deployed with the rest of the generated code files.
            |--- zlib-helper.o          - Runtime linked lib - NOT DISTRIBUTED
        |--- threads-release        - Release build that includes pthreads.
            |--- corebindings.o         - Runtime linked lib - NOT DISTRIBUTED
            |--- driver.o               - Runtime linked lib - NOT DISTRIBUTED
            |--- dotnet.js                - Mono WebAssembly implementations
            |--- dotnet.wasm              - Mono WebAssembly implementations
            |--- dotnet.wasm.map          - Mono WebAssembly implementations
            |--- dotnet.js.mem            - Mono WebAssembly implementations
            |--- dotnet.worker.js         - pthreads worker.  File must be deployed with the rest of the generated code files.
            |--- zlib-helper.o          - Runtime linked lib - NOT DISTRIBUTED

```

_Note:_ The **`dotnet.worker.js`** and **`dotnet.js.mem`** files  must be deployed with the rest of the generated code files if using these two runtimes.

# Dynamic Linking support

To build the runtime with WebAssembly dynamic linking support use the following make target:

``` bash
make -j -C sdks/wasm runtime-dynamic
```

-- or --

```bash
make -j -C sdks/builds package-wasm-runtime-dynamic
```

During the main build one directory will be created:

```
    .
    |--- sdk/wasm/builds                           
        |--- release-dynamic        - Release build that includes dynamic linking support.
            |--- corebindings.o         - Runtime linked lib - NOT DISTRIBUTED
            |--- driver.o               - Runtime linked lib - NOT DISTRIBUTED
            |--- dotnet.js                - Mono WebAssembly implementations
            |--- dotnet.wasm              - Mono WebAssembly implementations
            |--- dotnet.wasm.map          - Mono WebAssembly implementations
            |--- dotnet.js.mem            - Mono WebAssembly implementations
            |--- zlib-helper.o          - Runtime linked lib - NOT DISTRIBUTED

```

# AOT support

AOT support is enabled by passing --aot to the packager.

This depends on building the cross compiler which can be done using:

``` bash
make -j -C sdks/wasm cross
```

If you don't have jsvu installed, run `make toolchain` from `sdks/wasm`. It requires a recent version of node installed in your system.

Run `make run-aot-sample` to run an aot-ed hello world sample.

To build and run AOT test suites:

``` bash
make -j -C sdks/wasm build-aot-<suite name>
make -j -C sdks/wasm check-aot-<suite name>
```

## AOT Bindings sample

To build the `sample` that uses bindings and http.

``` bash
make -j -C sdks/wasm build-aot-bindings-sample
```

This will build the `sample` in the `wasm/bin/aot-bindings-sample` ready to be served for browser consumption.

# Notes

[1]: https://github.com/kripken/emscripten

[2]: https://docs.microsoft.com/en-us/dotnet/framework/tools/developer-command-prompt-for-vs
