<img src="http://graal.ift.ulaval.ca/adrouin/kover.png" height="50" />

[![DOI](https://zenodo.org/badge/20289/aldro61/kover.svg)](https://zenodo.org/badge/latestdoi/20289/aldro61/kover)

Kover is an *out-of-core* implementation of the Set Covering Machine algorithm that has been tailored for genomic biomarker discovery. It produces highly interpretable models of phenotypes. The models are rule-based and rely on the presence/absence of k-mers.

## Introduction

Drouin, A., Giguère, S., Déraspe, M., Marchand, M., Tyers, M., Loo, V. G., Bourgault, A. M., Laviolette, F. & Corbeil, J. (2016). Predictive computational phenotyping and biomarker discovery using reference-free genome comparisons. BMC Genomics, 17(1), 754. [[PDF]](http://bmcgenomics.biomedcentral.com/articles/10.1186/s12864-016-2889-6)

> The identification of genomic biomarkers is a key step towards improving diagnostic tests and therapies. We present a new reference-free method for this task that relies on a k-mer representation of genomes and a machine learning algorithm that produces intelligible models. The method is computationally scalable and well-suited for whole genome sequencing studies. The method was validated by generating models that predict the antibiotic resistance of C. difficile, M. tuberculosis, P. aeruginosa and S. pneumoniae. We show that the obtained models are accurate and that they highlight biologically relevant biomarkers, while providing insight into the process of antibiotic resistance acquisition. Kover, an efficient implementation of our method, can readily scale to large genomic datasets. It is open-source and can be obtained from http://github.com/aldro61/kover.

### Video lecture:
Interpretable Models of Antibiotic Resistance with the Set Covering Machine Algorithm, Google, Cambridge, Massachusetts (February 2017) [ [slides](http://graal.ift.ulaval.ca/adrouin/talks/google_feb2017.pdf) ]

[![Google tech talk](https://img.youtube.com/vi/uomMdBdEwnk/0.jpg)](https://www.youtube.com/watch?v=uomMdBdEwnk)

## Installation

For installation instructions, see: http://aldro61.github.io/kover/doc_installation.html

## Example

For an example of use, see: http://aldro61.github.io/kover/doc_example.html

## Documentation

The documentation can be found at: http://aldro61.github.io/kover/

## Contact

If you need help using Kover or to report any bug, please use [Biostars](https://www.biostars.org/p/194520/).
