// Copyright 2010 The Go Authors.  All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.


typedef byte* kevent_udata;

struct sigaction;

void	runtime·sigpanic(void);

void	runtime·setitimer(int32, Itimerval*, Itimerval*);
void	runtime·sigaction(int32, struct sigaction*, struct sigaction*);
void	runtime·sigaltstack(SigaltstackT*, SigaltstackT*);
Sigset	runtime·sigprocmask(int32, Sigset);
void	runtime·unblocksignals(void);
int32	runtime·sysctl(uint32*, uint32, byte*, uintptr*, byte*, uintptr);

enum {
	SS_DISABLE = 4,
	SIG_BLOCK = 1,
	SIG_UNBLOCK = 2,
	SIG_SETMASK = 3,
	NSIG = 33,
	SI_USER = 0,
};
