# Введение

<div class="scrimba"><a href="https://scrimba.com/p/pnyzgAP/cMPa2Uk" target="_blank" rel="noopener noreferrer">Пройдите этот урок на Scrimba</a></div>

В центре любого Vuex-приложения находится **хранилище**. «Хранилище» — это контейнер, в котором хранится **состояние** вашего приложения. Два момента отличают хранилище Vuex от простого глобального объекта:

1. Хранилище Vuex реактивно. Когда компоненты Vue полагаются на его состояние, то они будут реактивно и эффективно обновляться, если состояние хранилища изменяется.

2. Нельзя напрямую изменять состояние хранилища. Единственный способ внести изменения — явно **вызвать мутацию**. Это гарантирует, что любое изменение состояния оставляет след и позволяет использовать инструментарий, чтобы лучше понимать ход работы приложения.

### Простейшее хранилище

> **ЗАМЕЧАНИЕ:** В примерах кода документации используется синтаксис ES2015. Если вы с ним ещё не знакомы, [сейчас самое время изучить](https://babeljs.io/docs/learn-es2015/)!

После [установки](../installation.md) Vuex, давайте создадим хранилище. Это довольно просто — необходимо указать начальный объект состояния и некоторые мутации:

``` js
// Убедитесь, что вызвали Vue.use(Vuex) сначала, если используете систему сборки

const store = new Vuex.Store({
  state: {
    count: 0
  },
  mutations: {
    increment (state) {
      state.count++
    }
  }
})
```

Теперь можно получить доступ к объекту состояния через `store.state` и вызвать изменение состояния с помощью метода `store.commit`:

``` js
store.commit('increment')

console.log(store.state.count) // -> 1
```

Запомните, причина, по которой мы вызываем мутацию, вместо изменения `store.state.count` напрямую, в том, что мы хотим явным образом отслеживать её. Это простое соглашение делает наше намерение более явным, что упрощает понимание происходящих изменений состояния приложения при чтении кода. Кроме того, это позволяет использовать инструменты для отслеживания каждой мутации, создания снимков состояния или даже использования «машины времени» для отладки.

Использование состояние хранилища в компоненте предполагает просто возврат необходимой части состояния в вычисляемом свойстве, поскольку состояние хранилища реактивно. Инициирование изменений — это просто запуск мутаций в методах компонентов.

Вот пример [простейшего приложения Vuex, реализующего счётчик](https://jsfiddle.net/n9jmu5v7/1269/).

Далее мы разберём все основные понятия детальнее и начнём с состояния.
