// Chunked File library
var should = require("should");
describe("library2", function() {
	var tickExtra, tickEmpty, tickMerged;
	var extraValue, testValue;

	before(function(done) {
		var asnycOk = false, asnycOk2 = false;
		var sameTick1 = true;
		require.ensure(["./extra"], function(require) {
			asnycOk = true;
			tickExtra = sameTick1;
			var sameTick2 = true;
			require.ensure([], function(require) {
				asnycOk2 = true;
				extraValue = require("./extra");
				tickEmpty = sameTick2;
				require.ensure(["./test.js"], function(require) {
					tickMerged = sameTick2;
					testValue = require("./test.js");
					done();
				});
			});
			sameTick2 = false;
		});
		sameTick1 = false;
	});

	it("should load stuff with require.ensure asynchron", function() {
		should.strictEqual(tickExtra, false);
	});

	it("should load not include stuff from parent, remove empty chunks and apply a post loader", function() {
		should.strictEqual(tickEmpty, true);
		extraValue.should.be.eql("Lib2 extra2 with post loader");
	});

	it("should merge chunks if maxChunks specified", function() {
		should.strictEqual(tickEmpty, true);
		testValue.should.be.eql("test module");
	});

	it("should load require.amd from options", function() {
		require.amd.should.have.property("fromOptions").be.eql(true);
	});

	it("should run empty AMD require", function() {
		var emptyRequire = false;
		require([], function() {
			emptyRequire = true;
		});
		emptyRequire.should.be.eql(true);
	});

	it("should provide free variables", function() {
		s3().should.be.eql("submodule3");
	});

	it("should define values", function() {
		(CONST_UNDEFINED === undefined).should.be.eql(true);
		(CONST_NULL === null).should.be.eql(true);
		CONST_TRUE.should.be.eql(true);
		CONST_FALSE.should.be.eql(false);
		CONST_FUNCTION().should.be.eql("ok");
		CONST_NUMBER.should.be.eql(123);
		CONST_NUMBER_EXPR.should.be.eql(123);
		(typeof CONST_TYPEOF).should.be.eql("typeof");

		var o = CONST_OBJECT;
		CONST_OBJECT.A.should.be.eql(1);
		CONST_OBJECT.B.should.be.eql("B");
		CONST_OBJECT.C().should.be.eql("C");
		o.A.should.be.eql(1);
		o.B.should.be.eql("B");
		o.C().should.be.eql("C");
		(function(o) {
			o.A.should.be.eql(1);
			o.B.should.be.eql("B");
			o.C().should.be.eql("C");
		}(CONST_OBJECT));

		if(CONST_FALSE) require("fail");
		if(!CONST_TRUE) require("fail");
		if(!CONST_NUMBER) require("fail");
		if(!CONST_NUMBER_EXPR) require("fail");
		if(typeof CONST_TYPEOF !== "typeof") require("fail");
		if(typeof CONST_FALSE !== "boolean") require("fail");
		if(typeof CONST_FUNCTION !== "function") require("fail");
		if(typeof CONST_OBJECT !== "object") require("fail");
		if(!CONST_OBJECT.A) require("fail");
		if(typeof CONST_OBJECT.A !== "number") require("fail");
	});
});
exports.library2 = {ok: true};

// it should not fail if comment in last line