/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.errorprone.BaseErrorProneCompiler;
import com.google.errorprone.ErrorProneAnalyzer;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.scanner.ScannerSupplier;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.api.MultiTaskListener;
import com.sun.tools.javac.util.Context;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;

public class BaseErrorProneJavaCompiler
implements JavaCompiler {
    private final JavaCompiler javacTool;
    private final ScannerSupplier scannerSupplier;

    public BaseErrorProneJavaCompiler(ScannerSupplier scannerSupplier) {
        this(JavacTool.create(), scannerSupplier);
    }

    BaseErrorProneJavaCompiler(JavaCompiler javacTool, ScannerSupplier scannerSupplier) {
        this.javacTool = javacTool;
        this.scannerSupplier = scannerSupplier;
    }

    @Override
    public JavaCompiler.CompilationTask getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes, Iterable<? extends JavaFileObject> compilationUnits) {
        ErrorProneOptions errorProneOptions;
        try {
            errorProneOptions = ErrorProneOptions.processArgs(options);
        }
        catch (InvalidCommandLineOptionException e) {
            throw new RuntimeException(e);
        }
        List<String> remainingOptions = Arrays.asList(errorProneOptions.getRemainingArgs());
        JavaCompiler.CompilationTask task = this.javacTool.getTask(out, fileManager, diagnosticListener, remainingOptions, classes, compilationUnits);
        Context context = ((JavacTaskImpl)task).getContext();
        BaseErrorProneCompiler.setupMessageBundle((Context)context);
        MultiTaskListener.instance(context).add((TaskListener)ErrorProneAnalyzer.createByScanningForPlugins((ScannerSupplier)this.scannerSupplier, (ErrorProneOptions)errorProneOptions, (Context)context));
        return task;
    }

    @Override
    public StandardJavaFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset charset) {
        return this.javacTool.getStandardFileManager(diagnosticListener, locale, charset);
    }

    @Override
    public int isSupportedOption(String option) {
        int numberOfArgs = this.javacTool.isSupportedOption(option);
        if (numberOfArgs != -1) {
            return numberOfArgs;
        }
        return ErrorProneOptions.isSupportedOption((String)option);
    }

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        return this.javacTool.run(in, out, err, arguments);
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        EnumSet<SourceVersion> filtered = EnumSet.noneOf(SourceVersion.class);
        for (SourceVersion version : this.javacTool.getSourceVersions()) {
            if (version.compareTo(SourceVersion.RELEASE_6) < 0) continue;
            filtered.add(version);
        }
        return filtered;
    }
}

