/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_AbstractArgumentParameterChecker_PotentialReplacement;
import com.google.errorprone.bugpatterns.AutoValue_AbstractArgumentParameterChecker_ReplacementWithSimilarity;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleBiFunction;
import javax.annotation.Nullable;

abstract class AbstractArgumentParameterChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private final double beta;
    private final Function<VisitorState, ImmutableSet<PotentialReplacement>> potentialReplacementsFunction;
    private final Predicate<Symbol.VarSymbol> parameterPredicate;
    private final ToDoubleBiFunction<String, String> similarityMetric;
    private final ImmutableSet<Tree.Kind> validKinds;

    protected AbstractArgumentParameterChecker(Function<VisitorState, ImmutableSet<PotentialReplacement>> potentialReplacementsFunction, Predicate<Symbol.VarSymbol> parameterPredicate, double beta, ToDoubleBiFunction<String, String> similarityMetric, ImmutableSet<Tree.Kind> validKinds) {
        this.potentialReplacementsFunction = potentialReplacementsFunction;
        this.parameterPredicate = parameterPredicate;
        this.beta = beta;
        this.similarityMetric = similarityMetric;
        this.validKinds = validKinds;
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol((NewClassTree)tree);
        if (methodSym == null) {
            return Description.NO_MATCH;
        }
        return this.findReplacements(tree.getArguments(), (List<Symbol.VarSymbol>)methodSym.getParameters(), methodSym.isVarArgs(), state, tree);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (methodSym == null) {
            return Description.NO_MATCH;
        }
        return this.findReplacements(tree.getArguments(), (List<Symbol.VarSymbol>)methodSym.getParameters(), methodSym.isVarArgs(), state, tree);
    }

    private Description findReplacements(java.util.List<? extends ExpressionTree> args, List<Symbol.VarSymbol> params, boolean isVarArgs, VisitorState state, Tree tree) {
        if (args.isEmpty()) {
            return Description.NO_MATCH;
        }
        ImmutableSet<PotentialReplacement> potentialReplacements = this.potentialReplacementsFunction.apply(state.withPath(new TreePath(state.getPath(), args.get(0))));
        SuggestedFix.Builder fix = SuggestedFix.builder();
        int maxArg = isVarArgs ? params.size() - 1 : params.size();
        for (int i = 0; i < maxArg; ++i) {
            ReplacementWithSimilarity bestReplacement;
            double currSimilarity;
            String extractedArgumentName;
            ExpressionTree arg = args.get(i);
            Symbol.VarSymbol param = params.get(i);
            if (!this.validKinds.contains((Object)arg.getKind()) || !this.parameterPredicate.test(param) || (extractedArgumentName = AbstractArgumentParameterChecker.extractArgumentName(arg)) == null || 1.0 - (currSimilarity = this.similarityMetric.applyAsDouble(extractedArgumentName, ((Name)param.getSimpleName()).toString())) < this.beta || (bestReplacement = (ReplacementWithSimilarity)potentialReplacements.stream().filter(replacement -> !replacement.sym().equals(ASTHelpers.getSymbol((Tree)arg))).filter(replacement -> AbstractArgumentParameterChecker.isSubtypeHandleCompletionFailures(replacement.sym(), param, state)).map(replacement -> ReplacementWithSimilarity.create(replacement, this.similarityMetric.applyAsDouble(replacement.argumentName(), ((Name)param.getSimpleName()).toString()))).max(Comparator.comparingDouble(ReplacementWithSimilarity::similarity)).orElse(null)) == null || !(bestReplacement.similarity() - currSimilarity >= this.beta)) continue;
            fix.replace((Tree)arg, bestReplacement.replacement().replacementString());
        }
        if (fix.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)fix.build());
    }

    private static boolean isSubtypeHandleCompletionFailures(Symbol replacement, Symbol.VarSymbol param, VisitorState state) {
        Type replacementType;
        if (replacement instanceof Symbol.VarSymbol) {
            replacementType = replacement.asType();
        } else if (replacement instanceof Symbol.MethodSymbol) {
            replacementType = ((Type.MethodType)replacement.asType()).getReturnType();
        } else {
            return false;
        }
        try {
            return state.getTypes().isSubtype(replacementType, (Type)param.asType());
        }
        catch (Symbol.CompletionFailure e) {
            return false;
        }
    }

    @Nullable
    protected static String extractArgumentName(ExpressionTree expr) {
        switch (expr.getKind()) {
            case MEMBER_SELECT: {
                return ((MemberSelectTree)expr).getIdentifier().toString();
            }
            case METHOD_INVOCATION: {
                Symbol sym = ASTHelpers.getSymbol((Tree)expr);
                return sym == null ? null : sym.getSimpleName().toString();
            }
            case IDENTIFIER: {
                IdentifierTree idTree = (IdentifierTree)expr;
                if (idTree.getName().contentEquals("this")) {
                    Symbol sym = ASTHelpers.getSymbol((Tree)idTree);
                    return sym == null ? null : ASTHelpers.enclosingClass((Symbol)sym).getSimpleName().toString();
                }
                return ((IdentifierTree)expr).getName().toString();
            }
        }
        return null;
    }

    protected static abstract class PotentialReplacement {
        protected PotentialReplacement() {
        }

        abstract String argumentName();

        abstract String replacementString();

        abstract Symbol sym();

        protected static PotentialReplacement create(String argumentName, String replacementString, Symbol sym) {
            return new AutoValue_AbstractArgumentParameterChecker_PotentialReplacement(argumentName, replacementString, sym);
        }
    }

    static abstract class ReplacementWithSimilarity {
        ReplacementWithSimilarity() {
        }

        abstract PotentialReplacement replacement();

        abstract double similarity();

        static ReplacementWithSimilarity create(PotentialReplacement replacement, double similarity) {
            return new AutoValue_AbstractArgumentParameterChecker_ReplacementWithSimilarity(replacement, similarity);
        }
    }

    protected static class ParameterPredicate
    implements Predicate<Symbol.VarSymbol> {
        private final ImmutableSet<String> lowSimilarityNames;
        private final int minLength;

        protected ParameterPredicate(ImmutableSet<String> lowSimilarityNames, int minLength) {
            this.lowSimilarityNames = lowSimilarityNames;
            this.minLength = minLength;
        }

        @Override
        public boolean test(Symbol.VarSymbol sym) {
            String paramName = ((Name)sym.getSimpleName()).toString();
            return paramName.length() > this.minLength && !this.lowSimilarityNames.contains((Object)paramName);
        }
    }
}

