/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

@BugPattern(name="ExpectedExceptionChecker", category=BugPattern.Category.JUNIT, summary="Calls to ExpectedException#expect should always be followed by exactly one statement.", severity=BugPattern.SeverityLevel.WARNING)
public class ExpectedExceptionChecker
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    static final Matcher<StatementTree> MATCHER = Matchers.expressionStatement((Matcher)MethodMatchers.instanceMethod().onExactClass("org.junit.rules.ExpectedException").withNameMatching(Pattern.compile("expect.*")));
    static final Matcher<ExpressionTree> IS_A = Matchers.staticMethod().onClassAny(new String[]{"org.hamcrest.Matchers", "org.hamcrest.CoreMatchers"}).withSignature("<T>isA(java.lang.Class<T>)");

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (tree.getBody() == null) {
            return Description.NO_MATCH;
        }
        PeekingIterator it = Iterators.peekingIterator(tree.getBody().getStatements().iterator());
        while (it.hasNext() && !MATCHER.matches((Tree)it.peek(), state)) {
            it.next();
        }
        ArrayList<MethodInvocationTree> expectations = new ArrayList<MethodInvocationTree>();
        while (it.hasNext() && MATCHER.matches((Tree)it.peek(), state)) {
            expectations.add((MethodInvocationTree)((ExpressionStatementTree)it.next()).getExpression());
        }
        ArrayList<StatementTree> suffix = new ArrayList<StatementTree>();
        Iterators.addAll(suffix, (Iterator)it);
        if (suffix.size() <= 1) {
            return Description.NO_MATCH;
        }
        String exceptionClass = "Throwable";
        ArrayList<String> newAsserts = new ArrayList<String>();
        SuggestedFix.Builder fix = SuggestedFix.builder();
        block12: for (MethodInvocationTree expectation : expectations) {
            Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)expectation);
            Symtab symtab = state.getSymtab();
            List<? extends ExpressionTree> args = expectation.getArguments();
            switch (((Name)symbol.getSimpleName()).toString()) {
                case "expect": {
                    if (ASTHelpers.isSubtype((Type)((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)symbol.getParameters())).asType(), (Type)symtab.classType, (VisitorState)state)) {
                        exceptionClass = state.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)((ExpressionTree)Iterables.getOnlyElement(args))));
                        continue block12;
                    }
                    fix.addStaticImport("org.hamcrest.MatcherAssert.assertThat");
                    newAsserts.add(String.format("assertThat(thrown, %s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(args))));
                    continue block12;
                }
                case "expectCause": {
                    ExpressionTree matcher = (ExpressionTree)Iterables.getOnlyElement(expectation.getArguments());
                    if (IS_A.matches((Tree)matcher, state)) {
                        fix.addStaticImport("com.google.common.truth.Truth.assertThat");
                        newAsserts.add(String.format("assertThat(thrown).hasCauseThat().isInstanceOf(%s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(((MethodInvocationTree)matcher).getArguments()))));
                        continue block12;
                    }
                    fix.addStaticImport("org.hamcrest.MatcherAssert.assertThat");
                    newAsserts.add(String.format("assertThat(thrown.getCause(), %s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(args))));
                    continue block12;
                }
                case "expectMessage": {
                    if (ASTHelpers.isSubtype((Type)((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)symbol.getParameters())).asType(), (Type)symtab.stringType, (VisitorState)state)) {
                        fix.addStaticImport("com.google.common.truth.Truth.assertThat");
                        newAsserts.add(String.format("assertThat(thrown).hasMessageThat().contains(%s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(args))));
                        continue block12;
                    }
                    fix.addStaticImport("org.hamcrest.MatcherAssert.assertThat");
                    newAsserts.add(String.format("assertThat(thrown.getMessage(), %s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(args))));
                    continue block12;
                }
            }
            throw new AssertionError((Object)("unknown expect method: " + symbol.getSimpleName()));
        }
        fix.replace(((JCTree)expectations.get(0)).getStartPosition(), ((JCTree)suffix.get(0)).getStartPosition(), "");
        SuggestedFix baseFix = fix.build();
        List<Fix> fixes = ExpectedExceptionChecker.allFixes(suffix, exceptionClass, newAsserts, baseFix);
        Description.Builder description = this.buildDescription(tree);
        if (!fixes.isEmpty()) {
            description.addAllFixes(fixes);
        } else {
            description.addFix(ExpectedExceptionChecker.fixStatement(SuggestedFix.builder().merge(baseFix), (StatementTree)Iterables.getLast(suffix), exceptionClass, newAsserts));
        }
        return description.build();
    }

    private static List<Fix> allFixes(List<StatementTree> suffix, String exceptionClass, List<String> newAsserts, SuggestedFix baseFix) {
        return (List)Lists.reverse(suffix).stream().filter(t -> !JUnitMatchers.containsTestMethod((Tree)t)).map(t -> ExpectedExceptionChecker.fixStatement(SuggestedFix.builder().merge(baseFix), t, exceptionClass, newAsserts)).collect(ImmutableList.toImmutableList());
    }

    private static Fix fixStatement(SuggestedFix.Builder fix, StatementTree expectThrows, String exceptionClass, List<String> newAsserts) {
        StringBuilder fixPrefix = new StringBuilder();
        if (newAsserts.isEmpty()) {
            fix.addStaticImport("org.junit.Assert.assertThrows");
            fixPrefix.append("assertThrows");
        } else {
            fix.addStaticImport("org.junit.Assert.expectThrows");
            fixPrefix.append(String.format("%s thrown = expectThrows", exceptionClass));
        }
        fixPrefix.append(String.format("(%s.class, () -> ", exceptionClass));
        if (expectThrows.getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
            fixPrefix.append("{");
        }
        fix.prefixWith((Tree)expectThrows, fixPrefix.toString());
        if (expectThrows.getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
            fix.postfixWith((Tree)((ExpressionStatementTree)expectThrows).getExpression(), ")");
            fix.postfixWith((Tree)expectThrows, Joiner.on((char)'\n').join(newAsserts));
        } else {
            fix.postfixWith((Tree)expectThrows, "});\n" + Joiner.on((char)'\n').join(newAsserts));
        }
        return fix.build();
    }
}

