/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import javax.annotation.Nullable;

@BugPattern(name="GuavaSelfEquals", summary="An object is tested for equality to itself using Guava Libraries", explanation="The arguments to this equal method are the same object, so it always returns true.  Either change the arguments to point to different objects or substitute true.", category=BugPattern.Category.GUAVA, severity=BugPattern.SeverityLevel.ERROR)
public class GuavaSelfEquals
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> GUAVA_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("com.google.common.base.Objects").named("equal"), Matchers.sameArgument((int)0, (int)1)});

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (!GUAVA_MATCHER.matches((Tree)methodInvocationTree, state)) {
            return Description.NO_MATCH;
        }
        return this.describe(methodInvocationTree, state);
    }

    private Description describe(MethodInvocationTree methodInvocationTree, VisitorState state) {
        GuavaSelfEquals.verifyArgsType(methodInvocationTree);
        List<? extends ExpressionTree> args = methodInvocationTree.getArguments();
        ExpressionTree toReplace = args.get(1).getKind() == Tree.Kind.IDENTIFIER ? args.get(1) : (args.get(0).getKind() == Tree.Kind.IDENTIFIER ? args.get(0) : args.get(1));
        Fix fix = GuavaSelfEquals.generateFix(methodInvocationTree, state, toReplace);
        return this.describeMatch(methodInvocationTree, fix);
    }

    protected static void verifyArgsType(MethodInvocationTree methodInvocationTree) {
        block3: for (ExpressionTree expressionTree : methodInvocationTree.getArguments()) {
            switch (expressionTree.getKind()) {
                case IDENTIFIER: 
                case MEMBER_SELECT: {
                    continue block3;
                }
            }
            throw new IllegalStateException("Expected arg " + expressionTree + " to be a field access or identifier");
        }
    }

    protected static Fix generateFix(Tree tree, VisitorState state, ExpressionTree toReplace) {
        Fix fieldFix = GuavaSelfEquals.fieldFix(toReplace, state);
        if (fieldFix != null) {
            return fieldFix;
        }
        return SuggestedFix.replace((Tree)tree, (String)"true");
    }

    @Nullable
    protected static Fix fieldFix(Tree toReplace, VisitorState state) {
        TreePath path;
        for (path = state.getPath(); path != null && path.getLeaf().getKind() != Tree.Kind.CLASS && path.getLeaf().getKind() != Tree.Kind.BLOCK; path = path.getParentPath()) {
        }
        if (path == null) {
            return null;
        }
        List members = path.getLeaf().getKind() == Tree.Kind.CLASS ? ((JCTree.JCClassDecl)path.getLeaf()).getMembers() : ((JCTree.JCBlock)path.getLeaf()).getStatements();
        for (JCTree jcTree : members) {
            if (jcTree.getKind() != Tree.Kind.VARIABLE) continue;
            JCTree.JCVariableDecl declaration = (JCTree.JCVariableDecl)jcTree;
            Symbol.TypeSymbol variableTypeSymbol = state.getTypes().erasure((Type)ASTHelpers.getType((Tree)declaration)).tsym;
            if (!ASTHelpers.getSymbol((Tree)toReplace).isMemberOf(variableTypeSymbol, state.getTypes())) continue;
            if (toReplace.getKind() == Tree.Kind.IDENTIFIER) {
                return SuggestedFix.prefixWith((Tree)toReplace, (String)(declaration.getName() + "."));
            }
            return SuggestedFix.replace((Tree)((JCTree.JCFieldAccess)toReplace).getExpression(), (String)declaration.getName().toString());
        }
        return null;
    }
}

