/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.BinaryTree;

@BugPattern(name="IdentityBinaryExpression", category=BugPattern.Category.JDK, summary="Writing \"a && a\", \"a || a\", \"a & a\", or \"a | a\" is equivalent to \"a\".", explanation="Writing `a && a`, `a || a`, `a & a`, or `a | a` is equivalent to `a`.", severity=BugPattern.SeverityLevel.ERROR)
public class IdentityBinaryExpression
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        String opName;
        switch (tree.getKind()) {
            case CONDITIONAL_AND: {
                opName = "&&";
                break;
            }
            case CONDITIONAL_OR: {
                opName = "||";
                break;
            }
            case AND: {
                opName = "&";
                break;
            }
            case OR: {
                opName = "|";
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        if (!tree.getLeftOperand().toString().equals(tree.getRightOperand().toString())) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("Writing `a %s a` is equivalent to `a`", opName)).build();
    }
}

