/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.util.Options;
import java.util.List;
import javax.lang.model.element.Modifier;

@BugPattern(name="JUnit4TestNotRun", summary="Test method will not be run; please add @Test annotation", explanation="Unlike in JUnit 3, JUnit 4 tests will not be run unless annotated with @Test. The test method that triggered this error looks like it was meant to be a test, but was not so annotated, so it will not be run. If you intend for this test method not to run, please add both an @Test and an @Ignore annotation to make it clear that you are purposely disabling it. If this is a helper method and not a test, consider reducing its visibility to non-public, if possible.", category=BugPattern.Category.JUNIT, severity=BugPattern.SeverityLevel.ERROR)
public class JUnit4TestNotRun
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String JUNIT4_TEST_ANNOTATION = "org.junit.Test";
    private static final JUnitMatchers.JUnit4TestClassMatcher isJUnit4TestClass = new JUnitMatchers.JUnit4TestClassMatcher();
    private static final Matcher<MethodTree> POSSIBLE_TEST_METHOD = Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasModifier((Modifier)Modifier.PUBLIC), Matchers.methodReturns((Supplier)Suppliers.VOID_TYPE), Matchers.methodHasParameters((Matcher[])new Matcher[0]), Matchers.not((Matcher)JUnitMatchers.hasJUnitAnnotation), Matchers.enclosingClass((Matcher)isJUnit4TestClass)});

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        if (!POSSIBLE_TEST_METHOD.matches((Tree)methodTree, state)) {
            return Description.NO_MATCH;
        }
        if (JUnitMatchers.isJunit3TestCase.matches((Tree)methodTree, state)) {
            return this.describeMatch(methodTree, JUnit4TestNotRun.prefixMethodWithTestAnnotation(methodTree, state));
        }
        if (Options.instance(state.context).getBoolean("expandedTestNotRunHeuristic")) {
            List<? extends AnnotationTree> annotations = methodTree.getModifiers().getAnnotations();
            if (annotations != null && !annotations.isEmpty()) {
                return Description.NO_MATCH;
            }
            if (Matchers.not((Matcher)Matchers.hasModifier((Modifier)Modifier.STATIC)).matches((Tree)methodTree, state) && JUnitMatchers.containsTestMethod((Tree)methodTree)) {
                return this.describeMatch(methodTree, JUnit4TestNotRun.prefixMethodWithTestAnnotation(methodTree, state));
            }
        }
        return Description.NO_MATCH;
    }

    private static Fix prefixMethodWithTestAnnotation(MethodTree methodTree, VisitorState state) {
        String methodSource;
        if (Matchers.hasModifier((Modifier)Modifier.STATIC).matches((Tree)methodTree, state) && (methodSource = state.getSourceForNode((Tree)methodTree)) != null) {
            String methodString = "@Test\n" + methodSource.toString().replaceFirst(" static ", " ");
            return SuggestedFix.builder().addImport(JUNIT4_TEST_ANNOTATION).replace((Tree)methodTree, methodString).build();
        }
        return SuggestedFix.builder().addImport(JUNIT4_TEST_ANNOTATION).prefixWith((Tree)methodTree, "@Test\n").build();
    }
}

