/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.CanBeStaticAnalyzer;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.Modifier;

@BugPattern(name="MethodCanBeStatic", summary="Private methods that do not reference the enclosing instance should be static", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.SUGGESTION)
public class MethodCanBeStatic
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        if (sym.isStatic() || sym.isConstructor() || sym.getModifiers().contains((Object)Modifier.NATIVE)) {
            return Description.NO_MATCH;
        }
        if (!sym.isPrivate()) {
            return Description.NO_MATCH;
        }
        if (CanBeStaticAnalyzer.referencesOuter(tree, sym, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree.getModifiers(), (Fix)SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.STATIC}));
    }
}

