/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.GuavaSelfEquals;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(name="SelfEquality", summary="Variable compared to itself", explanation="There is no good reason to test a primitive value or reference for equality with itself.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class SelfEquality
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        if (!Matchers.anyOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.EQUAL_TO), Matchers.kindIs((Tree.Kind)Tree.Kind.NOT_EQUAL_TO)}).matches((Tree)tree, state) || !ASTHelpers.sameVariable((ExpressionTree)tree.getLeftOperand(), (ExpressionTree)tree.getRightOperand())) {
            return Description.NO_MATCH;
        }
        StringBuilder fixedExpression = new StringBuilder();
        ExpressionTree leftOperand = tree.getLeftOperand();
        ExpressionTree rightOperand = tree.getRightOperand();
        Type leftType = ((JCTree)((Object)leftOperand)).type;
        Types types = state.getTypes();
        Symtab symtab = state.getSymtab();
        ExpressionTree toReplace = rightOperand.getKind() == Tree.Kind.IDENTIFIER ? rightOperand : (leftOperand.getKind() == Tree.Kind.IDENTIFIER ? leftOperand : rightOperand);
        Fix fix = GuavaSelfEquals.fieldFix(toReplace, state);
        if (fix == null) {
            if (tree.getKind() == Tree.Kind.EQUAL_TO) {
                fixedExpression.append("!");
            }
            if (types.isSameType(leftType, symtab.floatType)) {
                fixedExpression.append("Float.isNaN(" + leftOperand + ")");
                fix = SuggestedFix.replace((Tree)tree, (String)fixedExpression.toString());
            } else if (types.isSameType(leftType, symtab.doubleType)) {
                fixedExpression.append("Double.isNaN(" + leftOperand + ")");
                fix = SuggestedFix.replace((Tree)tree, (String)fixedExpression.toString());
            } else {
                fix = tree.getKind() == Tree.Kind.EQUAL_TO ? SuggestedFix.replace((Tree)tree, (String)"true") : SuggestedFix.replace((Tree)tree, (String)"false");
            }
        }
        return fix == null ? this.describeMatch(tree) : this.describeMatch(tree, fix);
    }
}

