/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.GuavaSelfEquals;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;

@BugPattern(name="SelfEquals", summary="An object is tested for equality to itself", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class SelfEquals
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> EQUALS_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("java.lang.Object").named("equals").withParameters(new String[]{"java.lang.Object"}), Matchers.receiverSameAsArgument((int)0)});

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (!EQUALS_MATCHER.matches((Tree)methodInvocationTree, state)) {
            return Description.NO_MATCH;
        }
        return this.describe(methodInvocationTree, state);
    }

    private Description describe(MethodInvocationTree methodInvocationTree, VisitorState state) {
        GuavaSelfEquals.verifyArgsType(methodInvocationTree);
        List<? extends ExpressionTree> args = methodInvocationTree.getArguments();
        ExpressionTree toReplace = args.get(0);
        Fix fix = GuavaSelfEquals.generateFix(methodInvocationTree, state, toReplace);
        return this.describeMatch(methodInvocationTree, fix);
    }
}

