/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.dagger;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inject.dagger.Util;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.HashSet;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;

@BugPattern(name="MultibindsInsteadOfMultibindings", summary="`@Multibinds` is the new way to declare multibindings.", explanation="Nested `@Multibindings` interfaces are being replaced by `@Multibinds` methods in a module.", category=BugPattern.Category.DAGGER, severity=BugPattern.SeverityLevel.ERROR)
public class MultibindsInsteadOfMultibindings
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<Tree> IS_MULTIBINDINGS_INTERFACE = Matchers.hasAnnotation((String)"dagger.Multibindings");

    public Description matchClass(ClassTree tree, VisitorState state) {
        ImmutableList<ClassTree> multibindingsInterfaces = this.multibindingsInterfaces(tree, state);
        if (multibindingsInterfaces.isEmpty()) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        Optional<Fix> moveMethodsUp = this.moveMethodsUp(tree, multibindingsInterfaces, state);
        if (moveMethodsUp.isPresent()) {
            description.addFix((Fix)moveMethodsUp.get());
        }
        description.addFix(this.includeNestedModules(tree, multibindingsInterfaces, state));
        return description.build();
    }

    private ImmutableList<ClassTree> multibindingsInterfaces(ClassTree tree, VisitorState state) {
        ImmutableList.Builder multibindingsInterfaces = ImmutableList.builder();
        for (Tree tree2 : tree.getMembers()) {
            if (!IS_MULTIBINDINGS_INTERFACE.matches(tree2, state)) continue;
            multibindingsInterfaces.add((Object)((ClassTree)tree2));
        }
        return multibindingsInterfaces.build();
    }

    private Optional<Fix> moveMethodsUp(ClassTree module, ImmutableList<ClassTree> multibindingsInterfaces, VisitorState state) {
        if (!Util.CAN_HAVE_ABSTRACT_BINDING_METHODS.matches((Tree)module, state)) {
            return Optional.absent();
        }
        SuggestedFix.Builder moveMethodsUp = SuggestedFix.builder().removeImport("dagger.Multibindings").addImport("dagger.multibindings.Multibinds").merge(Util.makeConcreteClassAbstract(module, state));
        HashSet<Name> methodNames = new HashSet<Name>();
        for (ClassTree multibindingsInterface : multibindingsInterfaces) {
            ImmutableList.Builder newMethods = ImmutableList.builder();
            for (MethodTree methodTree : this.getInterfaceMethods(multibindingsInterface)) {
                if (this.moduleHasMethodWithSameName(module, state, methodTree) || !methodNames.add(methodTree.getName())) {
                    return Optional.absent();
                }
                newMethods.add((Object)this.multibindsMethod(module, methodTree, state));
            }
            moveMethodsUp.replace((Tree)multibindingsInterface, Joiner.on((char)'\n').join((Iterable)newMethods.build()));
        }
        return Optional.of((Object)moveMethodsUp.build());
    }

    private String multibindsMethod(ClassTree module, MethodTree methodTree, VisitorState state) {
        return String.format("%s %s %s();", Joiner.on((char)' ').skipNulls().join((Object)"@Multibinds", (Object)state.getSourceForNode((Tree)methodTree.getModifiers()), new Object[]{module.getKind().equals((Object)Tree.Kind.INTERFACE) ? null : Modifier.ABSTRACT}), methodTree.getReturnType(), methodTree.getName());
    }

    private boolean moduleHasMethodWithSameName(ClassTree module, VisitorState state, MethodTree methodTree) {
        return Matchers.hasMethod((Matcher)Matchers.methodIsNamed((String)methodTree.getName().toString())).matches((Tree)module, state);
    }

    private Fix includeNestedModules(ClassTree module, ImmutableList<ClassTree> multibindingsInterfaces, VisitorState state) {
        SuggestedFix.Builder includeNestedModules = SuggestedFix.builder().removeImport("dagger.Multibindings").addImport("dagger.multibindings.Multibinds");
        AnnotationTree moduleAnnotation = this.moduleAnnotation(module);
        ImmutableList.Builder moduleClassLiteralsBuilder = ImmutableList.builder();
        for (ClassTree multibindingsInterface : multibindingsInterfaces) {
            includeNestedModules.replace((Tree)Util.findAnnotation("dagger.Multibindings", multibindingsInterface).get(), "@" + state.getSourceForNode(moduleAnnotation.getAnnotationType()));
            for (MethodTree methodTree : this.getInterfaceMethods(multibindingsInterface)) {
                includeNestedModules.prefixWith((Tree)methodTree, "@Multibinds ");
            }
            moduleClassLiteralsBuilder.add((Object)(module.getSimpleName() + "." + multibindingsInterface.getSimpleName() + ".class"));
        }
        includeNestedModules.merge(SuggestedFixes.addValuesToAnnotationArgument((AnnotationTree)moduleAnnotation, (String)"includes", (Collection)moduleClassLiteralsBuilder.build(), (VisitorState)state));
        return includeNestedModules.build();
    }

    private AnnotationTree moduleAnnotation(ClassTree module) {
        return (AnnotationTree)Util.findAnnotation("dagger.Module", module).or(Util.findAnnotation("dagger.producers.ProducerModule", module)).get();
    }

    private ImmutableList<MethodTree> getInterfaceMethods(ClassTree tree) {
        ImmutableList.Builder methods = ImmutableList.builder();
        for (Tree tree2 : tree.getMembers()) {
            if (!tree2.getKind().equals((Object)Tree.Kind.METHOD)) continue;
            methods.add((Object)((MethodTree)tree2));
        }
        return methods.build();
    }
}

