/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByUtils;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;

@BugPattern(name="GuardedByValidator", summary="Invalid @GuardedBy expression", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class GuardedByValidator
extends BugChecker
implements BugChecker.VariableTreeMatcher,
BugChecker.MethodTreeMatcher {
    private static final String MESSAGE_FORMAT = "Invalid @GuardedBy expression: %s";

    public Description matchMethod(MethodTree tree, VisitorState state) {
        return GuardedByValidator.validate(this, tree, state);
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        return GuardedByValidator.validate(this, tree, state);
    }

    static Description validate(BugChecker checker, Tree tree, VisitorState state) {
        GuardedByUtils.GuardedByValidationResult result = GuardedByUtils.isGuardedByValid(tree, state);
        if (result.isValid().booleanValue()) {
            return Description.NO_MATCH;
        }
        return BugChecker.buildDescriptionFromChecker((Tree)tree, (BugChecker)checker).setMessage(String.format(MESSAGE_FORMAT, result.message())).build();
    }
}

