/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.constant;

import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.utility.JavaInstance;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class MethodTypeConstant
implements StackManipulation {
    private static final StackManipulation.Size SIZE = StackSize.SINGLE.toIncreasingSize();
    private final Type methodType;

    protected MethodTypeConstant(Type methodType) {
        this.methodType = methodType;
    }

    public static StackManipulation of(MethodDescription.InDefinedShape methodDescription) {
        return new MethodTypeConstant(Type.getMethodType((String)methodDescription.getDescriptor()));
    }

    public static StackManipulation of(JavaInstance.MethodType methodType) {
        Type[] parameterType = new Type[methodType.getParameterTypes().size()];
        int index = 0;
        for (TypeDescription typeDescription : methodType.getParameterTypes()) {
            parameterType[index++] = Type.getType((String)typeDescription.getDescriptor());
        }
        return new MethodTypeConstant(Type.getMethodType((Type)Type.getType((String)methodType.getReturnType().getDescriptor()), (Type[])parameterType));
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitLdcInsn((Object)this.methodType);
        return SIZE;
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.methodType.equals((Object)((MethodTypeConstant)other).methodType);
    }

    public int hashCode() {
        return this.methodType.hashCode();
    }

    public String toString() {
        return "MethodTypeConstant{methodType=" + this.methodType + '}';
    }
}

