/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.tools.example.debug.tty.EventRequestSpec;
import com.sun.tools.example.debug.tty.MalformedMemberNameException;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.ReferenceTypeSpec;

abstract class WatchpointSpec
extends EventRequestSpec {
    final String fieldId;

    WatchpointSpec(ReferenceTypeSpec refSpec, String fieldId) throws MalformedMemberNameException {
        super(refSpec);
        this.fieldId = fieldId;
        if (!this.isJavaIdentifier(fieldId)) {
            throw new MalformedMemberNameException(fieldId);
        }
    }

    public int hashCode() {
        return this.refSpec.hashCode() + this.fieldId.hashCode() + this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof WatchpointSpec) {
            WatchpointSpec watchpoint = (WatchpointSpec)obj;
            return this.fieldId.equals(watchpoint.fieldId) && this.refSpec.equals(watchpoint.refSpec) && this.getClass().equals(watchpoint.getClass());
        }
        return false;
    }

    @Override
    String errorMessageFor(Exception e) {
        if (e instanceof NoSuchFieldException) {
            return MessageOutput.format("No field in", new Object[]{this.fieldId, this.refSpec.toString()});
        }
        return super.errorMessageFor(e);
    }
}

