/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.api.Formattable;
import com.sun.tools.javac.file.PathFileObject;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.AbstractDiagnosticFormatter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import javax.tools.JavaFileObject;

public final class RawDiagnosticFormatter
extends AbstractDiagnosticFormatter {
    public RawDiagnosticFormatter(Options options) {
        super(null, new AbstractDiagnosticFormatter.SimpleConfiguration(options, EnumSet.of(DiagnosticFormatter.Configuration.DiagnosticPart.SUMMARY, DiagnosticFormatter.Configuration.DiagnosticPart.DETAILS, DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS)));
    }

    @Override
    public String formatDiagnostic(JCDiagnostic d, Locale l) {
        try {
            StringBuilder buf = new StringBuilder();
            if (d.getPosition() != -1L) {
                buf.append(this.formatSource(d, false, (Locale)null));
                buf.append(':');
                buf.append(this.formatPosition(d, DiagnosticFormatter.PositionKind.LINE, (Locale)null));
                buf.append(':');
                buf.append(this.formatPosition(d, DiagnosticFormatter.PositionKind.COLUMN, (Locale)null));
                buf.append(':');
            } else if (d.getSource() != null && d.getSource().getKind() == JavaFileObject.Kind.CLASS) {
                buf.append(this.formatSource(d, false, (Locale)null));
                buf.append(":-:-:");
            } else {
                buf.append('-');
            }
            buf.append(' ');
            buf.append(this.formatMessage(d, (Locale)null));
            if (this.displaySource(d)) {
                buf.append("\n");
                buf.append(this.formatSourceLine(d, 0));
            }
            return buf.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String formatMessage(JCDiagnostic d, Locale l) {
        List<String> subDiags;
        StringBuilder buf = new StringBuilder();
        Collection<String> args = this.formatArguments(d, l);
        buf.append(this.localize(null, d.getCode(), args.toArray()));
        if (d.isMultiline() && ((AbstractCollection)((Object)this.getConfiguration().getVisible())).contains((Object)DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS) && (subDiags = this.formatSubdiagnostics(d, null)).nonEmpty()) {
            String sep = "";
            buf.append(",{");
            for (String sub : this.formatSubdiagnostics(d, null)) {
                buf.append(sep);
                buf.append("(");
                buf.append(sub);
                buf.append(")");
                sep = ",";
            }
            buf.append('}');
        }
        return buf.toString();
    }

    @Override
    protected String formatArgument(JCDiagnostic diag, Object arg, Locale l) {
        String s;
        if (arg instanceof Formattable) {
            s = arg.toString();
        } else if (arg instanceof JCTree.JCExpression) {
            JCTree.JCExpression tree = (JCTree.JCExpression)arg;
            s = "@" + tree.getStartPosition();
        } else {
            s = arg instanceof PathFileObject ? ((PathFileObject)arg).getShortName() : super.formatArgument(diag, arg, null);
        }
        return arg instanceof JCDiagnostic ? "(" + s + ")" : s;
    }

    @Override
    protected String localize(Locale l, String key, Object ... args) {
        StringBuilder buf = new StringBuilder();
        buf.append(key);
        String sep = ": ";
        for (Object o : args) {
            buf.append(sep);
            buf.append(o);
            sep = ", ";
        }
        return buf.toString();
    }

    @Override
    public boolean isRaw() {
        return true;
    }
}

