/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.BaseLineInfo;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.LineInfo;
import com.sun.tools.jdi.LocalVariableImpl;
import com.sun.tools.jdi.LocationImpl;
import com.sun.tools.jdi.MethodImpl;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.SDE;
import com.sun.tools.jdi.StratumLineInfo;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConcreteMethodImpl
extends MethodImpl {
    private Location location = null;
    private SoftReference<SoftLocationXRefs> softBaseLocationXRefsRef;
    private SoftReference<SoftLocationXRefs> softOtherLocationXRefsRef;
    private SoftReference<List<LocalVariable>> variablesRef = null;
    private boolean absentVariableInformation = false;
    private long firstIndex = -1L;
    private long lastIndex = -1L;
    private SoftReference<byte[]> bytecodesRef = null;
    private int argSlotCount = -1;

    ConcreteMethodImpl(VirtualMachine vm, ReferenceTypeImpl declaringType, long ref, String name, String signature, String genericSignature, int modifiers) {
        super(vm, declaringType, ref, name, signature, genericSignature, modifiers);
    }

    @Override
    public Location location() {
        if (this.location == null) {
            this.getBaseLocations();
        }
        return this.location;
    }

    List<Location> sourceNameFilter(List<Location> list, SDE.Stratum stratum, String sourceName) throws AbsentInformationException {
        if (sourceName == null) {
            return list;
        }
        ArrayList<Location> locs = new ArrayList<Location>();
        for (Location loc : list) {
            if (!((LocationImpl)loc).sourceName(stratum).equals(sourceName)) continue;
            locs.add(loc);
        }
        return locs;
    }

    @Override
    List<Location> allLineLocations(SDE.Stratum stratum, String sourceName) throws AbsentInformationException {
        List<Location> lineLocations = this.getLocations((SDE.Stratum)stratum).lineLocations;
        if (lineLocations.size() == 0) {
            throw new AbsentInformationException();
        }
        return Collections.unmodifiableList(this.sourceNameFilter(lineLocations, stratum, sourceName));
    }

    @Override
    List<Location> locationsOfLine(SDE.Stratum stratum, String sourceName, int lineNumber) throws AbsentInformationException {
        SoftLocationXRefs info = this.getLocations(stratum);
        if (info.lineLocations.size() == 0) {
            throw new AbsentInformationException();
        }
        List<Location> list = info.lineMapper.get(lineNumber);
        if (list == null) {
            list = new ArrayList<Location>(0);
        }
        return Collections.unmodifiableList(this.sourceNameFilter(list, stratum, sourceName));
    }

    @Override
    public Location locationOfCodeIndex(long codeIndex) {
        if (this.firstIndex == -1L) {
            this.getBaseLocations();
        }
        if (codeIndex < this.firstIndex || codeIndex > this.lastIndex) {
            return null;
        }
        return new LocationImpl(this.virtualMachine(), this, codeIndex);
    }

    @Override
    LineInfo codeIndexToLineInfo(SDE.Stratum stratum, long codeIndex) {
        LocationImpl current;
        if (this.firstIndex == -1L) {
            this.getBaseLocations();
        }
        if (codeIndex < this.firstIndex || codeIndex > this.lastIndex) {
            throw new InternalError("Location with invalid code index");
        }
        List<Location> lineLocations = this.getLocations((SDE.Stratum)stratum).lineLocations;
        if (lineLocations.size() == 0) {
            return super.codeIndexToLineInfo(stratum, codeIndex);
        }
        Iterator<Location> iter = lineLocations.iterator();
        LocationImpl bestMatch = (LocationImpl)iter.next();
        while (iter.hasNext() && (current = (LocationImpl)iter.next()).codeIndex() <= codeIndex) {
            bestMatch = current;
        }
        return bestMatch.getLineInfo(stratum);
    }

    @Override
    public List<LocalVariable> variables() throws AbsentInformationException {
        return this.getVariables();
    }

    @Override
    public List<LocalVariable> variablesByName(String name) throws AbsentInformationException {
        List<LocalVariable> variables = this.getVariables();
        ArrayList<LocalVariable> retList = new ArrayList<LocalVariable>(2);
        for (LocalVariable variable : variables) {
            if (!variable.name().equals(name)) continue;
            retList.add(variable);
        }
        return retList;
    }

    @Override
    public List<LocalVariable> arguments() throws AbsentInformationException {
        List<LocalVariable> variables = this.getVariables();
        ArrayList<LocalVariable> retList = new ArrayList<LocalVariable>(variables.size());
        for (LocalVariable variable : variables) {
            if (!variable.isArgument()) continue;
            retList.add(variable);
        }
        return retList;
    }

    @Override
    public byte[] bytecodes() {
        byte[] bytecodes;
        byte[] byArray = bytecodes = this.bytecodesRef == null ? null : this.bytecodesRef.get();
        if (bytecodes == null) {
            try {
                bytecodes = JDWP.Method.Bytecodes.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this.declaringType, (long)this.ref).bytes;
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
            this.bytecodesRef = new SoftReference<byte[]>(bytecodes);
        }
        return (byte[])bytecodes.clone();
    }

    @Override
    int argSlotCount() throws AbsentInformationException {
        if (this.argSlotCount == -1) {
            this.getVariables();
        }
        return this.argSlotCount;
    }

    private SoftLocationXRefs getLocations(SDE.Stratum stratum) {
        SoftLocationXRefs info;
        if (stratum.isJava()) {
            return this.getBaseLocations();
        }
        String stratumID = stratum.id();
        SoftLocationXRefs softLocationXRefs = info = this.softOtherLocationXRefsRef == null ? null : this.softOtherLocationXRefsRef.get();
        if (info != null && info.stratumID.equals(stratumID)) {
            return info;
        }
        ArrayList<Location> lineLocations = new ArrayList<Location>();
        HashMap<Integer, List<Location>> lineMapper = new HashMap<Integer, List<Location>>();
        int lowestLine = -1;
        int highestLine = -1;
        SDE.LineStratum lastLineStratum = null;
        SDE.Stratum baseStratum = this.declaringType.stratum("Java");
        for (LocationImpl locationImpl : this.getBaseLocations().lineLocations) {
            int lineNumber;
            int baseLineNumber = locationImpl.lineNumber(baseStratum);
            SDE.LineStratum lineStratum = stratum.lineStratum(this.declaringType, baseLineNumber);
            if (lineStratum == null || (lineNumber = lineStratum.lineNumber()) == -1 || lineStratum.equals(lastLineStratum)) continue;
            lastLineStratum = lineStratum;
            if (lineNumber > highestLine) {
                highestLine = lineNumber;
            }
            if (lineNumber < lowestLine || lowestLine == -1) {
                lowestLine = lineNumber;
            }
            locationImpl.addStratumLineInfo(new StratumLineInfo(stratumID, lineNumber, lineStratum.sourceName(), lineStratum.sourcePath()));
            lineLocations.add(locationImpl);
            Integer key = lineNumber;
            ArrayList<LocationImpl> mappedLocs = (ArrayList<LocationImpl>)lineMapper.get(key);
            if (mappedLocs == null) {
                mappedLocs = new ArrayList<LocationImpl>(1);
                lineMapper.put(key, mappedLocs);
            }
            mappedLocs.add(locationImpl);
        }
        info = new SoftLocationXRefs(stratumID, lineMapper, lineLocations, lowestLine, highestLine);
        this.softOtherLocationXRefsRef = new SoftReference<SoftLocationXRefs>(info);
        return info;
    }

    private SoftLocationXRefs getBaseLocations() {
        SoftLocationXRefs info;
        SoftLocationXRefs softLocationXRefs = info = this.softBaseLocationXRefsRef == null ? null : this.softBaseLocationXRefsRef.get();
        if (info != null) {
            return info;
        }
        JDWP.Method.LineTable lntab = null;
        try {
            lntab = JDWP.Method.LineTable.process(this.vm, this.declaringType, this.ref);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        int count = lntab.lines.length;
        ArrayList<Location> lineLocations = new ArrayList<Location>(count);
        HashMap<Integer, List<Location>> lineMapper = new HashMap<Integer, List<Location>>();
        int lowestLine = -1;
        int highestLine = -1;
        for (int i = 0; i < count; ++i) {
            long bci = lntab.lines[i].lineCodeIndex;
            int lineNumber = lntab.lines[i].lineNumber;
            if (i + 1 != count && bci == lntab.lines[i + 1].lineCodeIndex) continue;
            if (lineNumber > highestLine) {
                highestLine = lineNumber;
            }
            if (lineNumber < lowestLine || lowestLine == -1) {
                lowestLine = lineNumber;
            }
            LocationImpl loc = new LocationImpl(this.virtualMachine(), this, bci);
            loc.addBaseLineInfo(new BaseLineInfo(lineNumber, this.declaringType));
            lineLocations.add(loc);
            Integer key = lineNumber;
            ArrayList<LocationImpl> mappedLocs = (ArrayList<LocationImpl>)lineMapper.get(key);
            if (mappedLocs == null) {
                mappedLocs = new ArrayList<LocationImpl>(1);
                lineMapper.put(key, mappedLocs);
            }
            mappedLocs.add(loc);
        }
        if (this.location == null) {
            this.firstIndex = lntab.start;
            this.lastIndex = lntab.end;
            this.location = count > 0 ? (Location)lineLocations.get(0) : new LocationImpl(this.virtualMachine(), this, this.firstIndex);
        }
        info = new SoftLocationXRefs("Java", lineMapper, lineLocations, lowestLine, highestLine);
        this.softBaseLocationXRefsRef = new SoftReference<SoftLocationXRefs>(info);
        return info;
    }

    private List<LocalVariable> getVariables1_4() throws AbsentInformationException {
        JDWP.Method.VariableTable vartab = null;
        try {
            vartab = JDWP.Method.VariableTable.process(this.vm, this.declaringType, this.ref);
        }
        catch (JDWPException exc) {
            if (exc.errorCode() == 101) {
                this.absentVariableInformation = true;
                throw new AbsentInformationException();
            }
            throw exc.toJDIException();
        }
        this.argSlotCount = vartab.argCnt;
        int count = vartab.slots.length;
        ArrayList<LocalVariable> variables = new ArrayList<LocalVariable>(count);
        for (int i = 0; i < count; ++i) {
            JDWP.Method.VariableTable.SlotInfo si = vartab.slots[i];
            if (si.name.startsWith("this$") || si.name.equals("this")) continue;
            LocationImpl scopeStart = new LocationImpl(this.virtualMachine(), this, si.codeIndex);
            LocationImpl scopeEnd = new LocationImpl(this.virtualMachine(), this, si.codeIndex + (long)si.length - 1L);
            LocalVariableImpl variable = new LocalVariableImpl(this.virtualMachine(), this, si.slot, scopeStart, scopeEnd, si.name, si.signature, null);
            variables.add(variable);
        }
        return variables;
    }

    private List<LocalVariable> getVariables1() throws AbsentInformationException {
        if (!this.vm.canGet1_5LanguageFeatures()) {
            return this.getVariables1_4();
        }
        JDWP.Method.VariableTableWithGeneric vartab = null;
        try {
            vartab = JDWP.Method.VariableTableWithGeneric.process(this.vm, this.declaringType, this.ref);
        }
        catch (JDWPException exc) {
            if (exc.errorCode() == 101) {
                this.absentVariableInformation = true;
                throw new AbsentInformationException();
            }
            throw exc.toJDIException();
        }
        this.argSlotCount = vartab.argCnt;
        int count = vartab.slots.length;
        ArrayList<LocalVariable> variables = new ArrayList<LocalVariable>(count);
        for (int i = 0; i < count; ++i) {
            JDWP.Method.VariableTableWithGeneric.SlotInfo si = vartab.slots[i];
            if (si.name.startsWith("this$") || si.name.equals("this")) continue;
            LocationImpl scopeStart = new LocationImpl(this.virtualMachine(), this, si.codeIndex);
            LocationImpl scopeEnd = new LocationImpl(this.virtualMachine(), this, si.codeIndex + (long)si.length - 1L);
            LocalVariableImpl variable = new LocalVariableImpl(this.virtualMachine(), this, si.slot, scopeStart, scopeEnd, si.name, si.signature, si.genericSignature);
            variables.add(variable);
        }
        return variables;
    }

    private List<LocalVariable> getVariables() throws AbsentInformationException {
        List<LocalVariable> variables;
        if (this.absentVariableInformation) {
            throw new AbsentInformationException();
        }
        List<LocalVariable> list = variables = this.variablesRef == null ? null : this.variablesRef.get();
        if (variables != null) {
            return variables;
        }
        variables = this.getVariables1();
        variables = Collections.unmodifiableList(variables);
        this.variablesRef = new SoftReference<List<LocalVariable>>(variables);
        return variables;
    }

    private static class SoftLocationXRefs {
        final String stratumID;
        final Map<Integer, List<Location>> lineMapper;
        final List<Location> lineLocations;
        final int lowestLine;
        final int highestLine;

        SoftLocationXRefs(String stratumID, Map<Integer, List<Location>> lineMapper, List<Location> lineLocations, int lowestLine, int highestLine) {
            this.stratumID = stratumID;
            this.lineMapper = Collections.unmodifiableMap(lineMapper);
            this.lineLocations = Collections.unmodifiableList(lineLocations);
            this.lowestLine = lowestLine;
            this.highestLine = highestLine;
        }
    }
}

