/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jline.extra;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Supplier;
import jdk.internal.jline.console.ConsoleReader;
import jdk.internal.jline.console.KeyMap;
import jdk.internal.jline.console.history.History;
import jdk.internal.jline.console.history.MemoryHistory;

public abstract class EditingHistory
implements History {
    private final History fullHistory;
    private History currentDelegate;
    private static final String CTRL_UP = "\u001b[1;5A";
    private static final String CTRL_DOWN = "\u001b[1;5B";

    protected EditingHistory(ConsoleReader in, Iterable<? extends String> originalHistory) {
        MemoryHistory fullHistory = new MemoryHistory();
        fullHistory.setIgnoreDuplicates(false);
        this.fullHistory = fullHistory;
        this.currentDelegate = fullHistory;
        this.bind(in, CTRL_UP, () -> this.moveHistoryToSnippet(in, ((EditingHistory)in.getHistory())::previousSnippet));
        this.bind(in, CTRL_DOWN, () -> this.moveHistoryToSnippet(in, ((EditingHistory)in.getHistory())::nextSnippet));
        if (originalHistory != null) {
            this.load(originalHistory);
        }
    }

    private void moveHistoryToSnippet(ConsoleReader in, Supplier<Boolean> action) {
        if (!action.get().booleanValue()) {
            try {
                in.beep();
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        try {
            Method setBuffer = in.getClass().getDeclaredMethod("setBuffer", String.class);
            setBuffer.setAccessible(true);
            setBuffer.invoke((Object)in, in.getHistory().current().toString());
            in.flush();
        }
        catch (IOException | ReflectiveOperationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void bind(ConsoleReader in, String shortcut, Object action) {
        KeyMap km = in.getKeys();
        for (int i = 0; i < shortcut.length(); ++i) {
            Object value = km.getBound(Character.toString(shortcut.charAt(i)));
            if (value instanceof KeyMap) {
                km = (KeyMap)value;
                continue;
            }
            km.bind(shortcut.substring(i), action);
        }
    }

    @Override
    public int size() {
        return this.currentDelegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.currentDelegate.isEmpty();
    }

    @Override
    public int index() {
        return this.currentDelegate.index();
    }

    @Override
    public void clear() {
        if (this.currentDelegate != this.fullHistory) {
            throw new IllegalStateException("narrowed");
        }
        this.currentDelegate.clear();
    }

    @Override
    public CharSequence get(int index) {
        return this.currentDelegate.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(CharSequence line) {
        int fullSize;
        NarrowingHistoryLine currentLine = null;
        int origIndex = this.fullHistory.index();
        try {
            this.fullHistory.moveToEnd();
            fullSize = this.fullHistory.index();
            if (this.currentDelegate == this.fullHistory && origIndex < this.fullHistory.index()) {
                for (History.Entry entry : this.fullHistory) {
                    int[] cluster;
                    if (!(entry.value() instanceof NarrowingHistoryLine) || (cluster = ((NarrowingHistoryLine)entry.value()).span)[0] != origIndex || cluster[1] <= cluster[0]) continue;
                    this.currentDelegate = new MemoryHistory();
                    for (int i = cluster[0]; i <= cluster[1]; ++i) {
                        this.currentDelegate.add(this.fullHistory.get(i));
                    }
                }
            }
            this.fullHistory.moveToEnd();
            while (this.fullHistory.previous()) {
                CharSequence c = this.fullHistory.current();
                if (!(c instanceof NarrowingHistoryLine)) continue;
                currentLine = (NarrowingHistoryLine)c;
                break;
            }
        }
        finally {
            this.fullHistory.moveTo(origIndex);
        }
        if (currentLine == null || currentLine.span[1] != -1) {
            currentLine = new NarrowingHistoryLine(line, fullSize);
            line = currentLine;
        }
        StringBuilder complete = new StringBuilder();
        for (int i = currentLine.span[0]; i < fullSize; ++i) {
            complete.append(this.fullHistory.get(i));
        }
        complete.append(line);
        if (this.isComplete(complete)) {
            ((NarrowingHistoryLine)currentLine).span[1] = fullSize;
            this.currentDelegate = this.fullHistory;
        }
        this.fullHistory.add(line);
    }

    protected abstract boolean isComplete(CharSequence var1);

    @Override
    public void set(int index, CharSequence item) {
        if (this.currentDelegate != this.fullHistory) {
            throw new IllegalStateException("narrowed");
        }
        this.currentDelegate.set(index, item);
    }

    @Override
    public CharSequence remove(int i) {
        if (this.currentDelegate != this.fullHistory) {
            throw new IllegalStateException("narrowed");
        }
        return this.currentDelegate.remove(i);
    }

    @Override
    public CharSequence removeFirst() {
        if (this.currentDelegate != this.fullHistory) {
            throw new IllegalStateException("narrowed");
        }
        return this.currentDelegate.removeFirst();
    }

    @Override
    public CharSequence removeLast() {
        if (this.currentDelegate != this.fullHistory) {
            throw new IllegalStateException("narrowed");
        }
        return this.currentDelegate.removeLast();
    }

    @Override
    public void replace(CharSequence item) {
        if (this.currentDelegate != this.fullHistory) {
            throw new IllegalStateException("narrowed");
        }
        this.currentDelegate.replace(item);
    }

    @Override
    public ListIterator<History.Entry> entries(int index) {
        return this.currentDelegate.entries(index);
    }

    @Override
    public ListIterator<History.Entry> entries() {
        return this.currentDelegate.entries();
    }

    @Override
    public Iterator<History.Entry> iterator() {
        return this.currentDelegate.iterator();
    }

    @Override
    public CharSequence current() {
        return this.currentDelegate.current();
    }

    @Override
    public boolean previous() {
        return this.currentDelegate.previous();
    }

    @Override
    public boolean next() {
        return this.currentDelegate.next();
    }

    @Override
    public boolean moveToFirst() {
        return this.currentDelegate.moveToFirst();
    }

    @Override
    public boolean moveToLast() {
        return this.currentDelegate.moveToLast();
    }

    @Override
    public boolean moveTo(int index) {
        return this.currentDelegate.moveTo(index);
    }

    @Override
    public void moveToEnd() {
        this.currentDelegate.moveToEnd();
    }

    public boolean previousSnippet() {
        for (int i = this.index() - 1; i >= 0; --i) {
            if (!(this.get(i) instanceof NarrowingHistoryLine)) continue;
            this.moveTo(i);
            return true;
        }
        return false;
    }

    public boolean nextSnippet() {
        for (int i = this.index() + 1; i < this.size(); ++i) {
            if (!(this.get(i) instanceof NarrowingHistoryLine)) continue;
            this.moveTo(i);
            return true;
        }
        if (this.index() < this.size()) {
            this.moveToEnd();
            return true;
        }
        return false;
    }

    public final void load(Iterable<? extends String> originalHistory) {
        class PersistentNarrowingHistoryLine
        extends NarrowingHistoryLine
        implements PersistentEntryMarker {
            public PersistentNarrowingHistoryLine(CharSequence delegate, int start) {
                super(delegate, start);
            }
        }
        PersistentNarrowingHistoryLine currentHistoryLine = null;
        boolean start = true;
        int currentLine = 0;
        for (String string : originalHistory) {
            StringBuilder line = new StringBuilder(string);
            int trailingBackSlashes = this.countTrailintBackslashes(line);
            boolean continuation = trailingBackSlashes % 2 != 0;
            line.delete(line.length() - trailingBackSlashes / 2 - (continuation ? 1 : 0), line.length());
            if (start) {
                currentHistoryLine = new PersistentNarrowingHistoryLine(line, currentLine);
                this.fullHistory.add(currentHistoryLine);
            } else {
                class PersistentLine
                implements CharSequence,
                PersistentEntryMarker {
                    private final CharSequence delegate;

                    public PersistentLine(CharSequence delegate) {
                        this.delegate = delegate;
                    }

                    @Override
                    public int length() {
                        return this.delegate.length();
                    }

                    @Override
                    public char charAt(int index) {
                        return this.delegate.charAt(index);
                    }

                    @Override
                    public CharSequence subSequence(int start, int end) {
                        return this.delegate.subSequence(start, end);
                    }

                    @Override
                    public String toString() {
                        return this.delegate.toString();
                    }
                }
                this.fullHistory.add(new PersistentLine(line));
            }
            start = !continuation;
            ((NarrowingHistoryLine)currentHistoryLine).span[1] = currentLine++;
        }
    }

    public Collection<? extends String> save() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<History.Entry> entries = this.fullHistory.iterator();
        if (entries.hasNext()) {
            History.Entry entry = entries.next();
            while (entry != null) {
                StringBuilder historyLine = new StringBuilder(entry.value());
                int trailingBackSlashes = this.countTrailintBackslashes(historyLine);
                for (int i = 0; i < trailingBackSlashes; ++i) {
                    historyLine.append("\\");
                }
                History.Entry entry2 = entry = entries.hasNext() ? entries.next() : null;
                if (entry != null && !(entry.value() instanceof NarrowingHistoryLine)) {
                    historyLine.append("\\");
                }
                result.add(historyLine.toString());
            }
        }
        return result;
    }

    private int countTrailintBackslashes(CharSequence text) {
        int count = 0;
        for (int i = text.length() - 1; i >= 0 && text.charAt(i) == '\\'; --i) {
            ++count;
        }
        return count;
    }

    public List<String> currentSessionEntries() {
        ArrayList<String> result = new ArrayList<String>();
        for (History.Entry e : this.fullHistory) {
            if (e.value() instanceof PersistentEntryMarker) continue;
            result.add(e.value().toString());
        }
        return result;
    }

    public void fullHistoryReplace(String source) {
        this.fullHistory.replace(source);
    }

    private static interface PersistentEntryMarker {
    }

    private class NarrowingHistoryLine
    implements CharSequence {
        private final CharSequence delegate;
        private final int[] span;

        public NarrowingHistoryLine(CharSequence delegate, int start) {
            this.delegate = delegate;
            this.span = new int[]{start, -1};
        }

        @Override
        public int length() {
            return this.delegate.length();
        }

        @Override
        public char charAt(int index) {
            return this.delegate.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.delegate.subSequence(start, end);
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }
    }
}

