/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.toolkit;

import com.sun.source.doctree.BlockTagTree;
import com.sun.source.doctree.CommentTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.util.DocTreeFactory;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTrees;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.tools.JavaFileObject;
import jdk.javadoc.internal.doclets.toolkit.Configuration;
import jdk.javadoc.internal.doclets.toolkit.util.Utils;

public class CommentUtils {
    final Configuration configuration;
    final DocTreeFactory treeFactory;
    final HashMap<Element, DocCommentDuo> dcTreesMap = new HashMap();
    final DocTrees trees;
    final Elements elementUtils;

    protected CommentUtils(Configuration configuration) {
        this.configuration = configuration;
        this.trees = configuration.root.getDocTrees();
        this.treeFactory = this.trees.getDocTreeFactory();
        this.elementUtils = configuration.root.getElementUtils();
    }

    public List<? extends DocTree> makePropertyDescriptionTree(List<? extends DocTree> content) {
        ArrayList<UnknownBlockTagTree> out = new ArrayList<UnknownBlockTagTree>();
        Name name = this.elementUtils.getName("propertyDescription");
        out.add(this.treeFactory.newUnknownBlockTagTree(name, content));
        return out;
    }

    public List<? extends DocTree> makePropertyDescriptionTree(String content) {
        ArrayList<CommentTree> inlist = new ArrayList<CommentTree>();
        inlist.add(this.treeFactory.newCommentTree(content));
        ArrayList<UnknownBlockTagTree> out = new ArrayList<UnknownBlockTagTree>();
        Name name = this.elementUtils.getName("propertyDescription");
        out.add(this.treeFactory.newUnknownBlockTagTree(name, inlist));
        return out;
    }

    public List<? extends DocTree> makeFirstSentenceTree(String content) {
        ArrayList<TextTree> out = new ArrayList<TextTree>();
        out.add(this.treeFactory.newTextTree(content));
        return out;
    }

    public DocTree makeSeeTree(String sig, Element e) {
        ArrayList<ReferenceTree> list = new ArrayList<ReferenceTree>();
        list.add(this.treeFactory.newReferenceTree(sig));
        return this.treeFactory.newSeeTree(list);
    }

    public DocTree makeTextTree(String content) {
        TextTree text = this.treeFactory.newTextTree(content);
        return text;
    }

    public void setEnumValuesTree(Configuration config, Element e) {
        Utils utils = config.utils;
        String klassName = utils.getSimpleName(utils.getEnclosingTypeElement(e));
        ArrayList<TextTree> fs = new ArrayList<TextTree>();
        fs.add(this.treeFactory.newTextTree(config.getText("doclet.enum_values_doc.firstsentence")));
        ArrayList<TextTree> body = new ArrayList<TextTree>();
        body.add(this.treeFactory.newTextTree(config.getText("doclet.enum_values_doc.body", klassName)));
        ArrayList<TextTree> descriptions = new ArrayList<TextTree>();
        descriptions.add(this.treeFactory.newTextTree(config.getText("doclet.enum_values_doc.return")));
        ArrayList<ReturnTree> tags = new ArrayList<ReturnTree>();
        tags.add(this.treeFactory.newReturnTree(descriptions));
        DocCommentTree docTree = this.treeFactory.newDocCommentTree(fs, body, tags);
        this.dcTreesMap.put(e, new DocCommentDuo(null, docTree));
    }

    public void setEnumValueOfTree(Configuration config, Element e) {
        ArrayList<TextTree> fs = new ArrayList<TextTree>();
        fs.add(this.treeFactory.newTextTree(config.getText("doclet.enum_valueof_doc.firstsentence")));
        ArrayList<TextTree> body = new ArrayList<TextTree>();
        body.add(this.treeFactory.newTextTree(config.getText("doclet.enum_valueof_doc.body")));
        ArrayList<BlockTagTree> tags = new ArrayList<BlockTagTree>();
        ArrayList<TextTree> paramDescs = new ArrayList<TextTree>();
        paramDescs.add(this.treeFactory.newTextTree(config.getText("doclet.enum_valueof_doc.param_name")));
        ExecutableElement ee = (ExecutableElement)e;
        List<? extends VariableElement> parameters = ee.getParameters();
        VariableElement param = parameters.get(0);
        IdentifierTree id = this.treeFactory.newIdentifierTree(this.elementUtils.getName(param.getSimpleName().toString()));
        tags.add(this.treeFactory.newParamTree(false, id, paramDescs));
        ArrayList<TextTree> returnDescs = new ArrayList<TextTree>();
        returnDescs.add(this.treeFactory.newTextTree(config.getText("doclet.enum_valueof_doc.return")));
        tags.add(this.treeFactory.newReturnTree(returnDescs));
        ArrayList<TextTree> throwsDescs = new ArrayList<TextTree>();
        throwsDescs.add(this.treeFactory.newTextTree(config.getText("doclet.enum_valueof_doc.throws_ila")));
        ReferenceTree ref = this.treeFactory.newReferenceTree("java.lang.IllegalArgumentException");
        tags.add(this.treeFactory.newThrowsTree(ref, throwsDescs));
        throwsDescs = new ArrayList();
        throwsDescs.add(this.treeFactory.newTextTree(config.getText("doclet.enum_valueof_doc.throws_npe")));
        ref = this.treeFactory.newReferenceTree("java.lang.NullPointerException");
        tags.add(this.treeFactory.newThrowsTree(ref, throwsDescs));
        DocCommentTree docTree = this.treeFactory.newDocCommentTree(fs, body, tags);
        this.dcTreesMap.put(e, new DocCommentDuo(null, docTree));
    }

    public DocCommentDuo getSyntheticCommentDuo(Element e) {
        return this.dcTreesMap.get(e);
    }

    public DocCommentDuo getHtmlCommentDuo(Element e) {
        JavaFileObject fo = null;
        if (e.getKind().equals((Object)ElementKind.OTHER)) {
            fo = this.configuration.getOverviewPath();
        } else if (e.getKind().equals((Object)ElementKind.PACKAGE)) {
            fo = this.configuration.workArounds.getJavaFileObject((PackageElement)e);
        }
        if (fo == null) {
            return null;
        }
        DocCommentTree dcTree = this.trees.getDocCommentTree(fo);
        if (dcTree == null) {
            return null;
        }
        DocTreePath treePath = this.trees.getDocTreePath(fo);
        return new DocCommentDuo(treePath.getTreePath(), dcTree);
    }

    public void setDocCommentTree(Element element, List<DocTree> firstSentence, List<DocTree> bodyTags, List<DocTree> blockTags, Utils utils) {
        DocCommentTree docTree = this.treeFactory.newDocCommentTree(firstSentence, bodyTags, blockTags);
        this.dcTreesMap.put(element, new DocCommentDuo(null, docTree));
        utils.removeCommentHelper(element);
    }

    public static class DocCommentDuo {
        public final TreePath treePath;
        public final DocCommentTree dcTree;

        public DocCommentDuo(TreePath treePath, DocCommentTree dcTree) {
            this.treePath = treePath;
            this.dcTree = dcTree;
        }
    }
}

