/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.toolkit.taglets;

import com.sun.source.doctree.DocTree;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import jdk.javadoc.internal.doclets.toolkit.Configuration;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.taglets.BaseInlineTaglet;
import jdk.javadoc.internal.doclets.toolkit.taglets.TagletWriter;
import jdk.javadoc.internal.doclets.toolkit.util.CommentHelper;
import jdk.javadoc.internal.doclets.toolkit.util.Utils;

public class ValueTaglet
extends BaseInlineTaglet {
    public ValueTaglet() {
        this.name = DocTree.Kind.VALUE.tagName;
    }

    @Override
    public boolean inMethod() {
        return true;
    }

    @Override
    public boolean inConstructor() {
        return true;
    }

    @Override
    public boolean inOverview() {
        return true;
    }

    @Override
    public boolean inPackage() {
        return true;
    }

    @Override
    public boolean inType() {
        return true;
    }

    private VariableElement getVariableElement(Element holder, Configuration config, DocTree tag) {
        Utils utils = config.utils;
        CommentHelper ch = utils.getCommentHelper(holder);
        String signature = ch.getReferencedSignature(tag);
        if (signature == null) {
            if (utils.isVariableElement(holder)) {
                return (VariableElement)holder;
            }
            return null;
        }
        String[] sigValues = signature.split("#");
        String memberName = null;
        TypeElement te = null;
        if (sigValues.length == 1) {
            if (utils.isExecutableElement(holder) || utils.isVariableElement(holder)) {
                te = utils.getEnclosingTypeElement(holder);
            } else if (utils.isTypeElement(holder)) {
                te = utils.getTopMostContainingTypeElement(holder);
            }
            memberName = sigValues[0];
        } else {
            Elements elements = config.root.getElementUtils();
            te = elements.getTypeElement(sigValues[0]);
            memberName = sigValues[1];
        }
        if (te == null) {
            return null;
        }
        for (Element element : utils.getFields(te)) {
            if (!utils.getSimpleName(element).equals(memberName)) continue;
            return (VariableElement)element;
        }
        return null;
    }

    @Override
    public Content getTagletOutput(Element holder, DocTree tag, TagletWriter writer) {
        Utils utils = writer.configuration().utils;
        VariableElement field = this.getVariableElement(holder, writer.configuration(), tag);
        if (field == null) {
            if (tag.toString().isEmpty()) {
                writer.getMsgRetriever().warning(holder, "doclet.value_tag_invalid_use", new Object[0]);
            } else {
                writer.getMsgRetriever().warning(holder, "doclet.value_tag_invalid_reference", tag.toString());
            }
        } else {
            if (field.getConstantValue() != null) {
                return writer.valueTagOutput(field, utils.constantValueExpresion(field), !utils.elementsEqual(field, holder));
            }
            writer.getMsgRetriever().warning(holder, "doclet.value_tag_invalid_constant", utils.getSimpleName(field));
        }
        return writer.getOutputInstance();
    }
}

