/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import jdk.jshell.JDIEnv;
import jdk.jshell.JDINotConnectedException;
import jdk.jshell.JShell;

class JDIConnection {
    private VirtualMachine vm;
    private Process process = null;
    private int outputCompleteCount = 0;
    private final JShell proc;
    private final JDIEnv env;
    private final Connector connector;
    private final Map<String, Connector.Argument> connectorArgs;
    private final int traceFlags;

    synchronized void notifyOutputComplete() {
        ++this.outputCompleteCount;
        this.notifyAll();
    }

    synchronized void waitOutputComplete() {
        if (this.process != null) {
            while (this.outputCompleteCount < 2) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private Connector findConnector(String name) {
        for (Connector cntor : Bootstrap.virtualMachineManager().allConnectors()) {
            if (!cntor.name().equals(name)) continue;
            return cntor;
        }
        return null;
    }

    private Map<String, Connector.Argument> mergeConnectorArgs(Connector connector, Map<String, String> argumentName2Value) {
        Map<String, Connector.Argument> arguments = connector.defaultArguments();
        for (Map.Entry<String, String> argumentEntry : argumentName2Value.entrySet()) {
            String name = argumentEntry.getKey();
            String value = argumentEntry.getValue();
            Connector.Argument argument = arguments.get(name);
            if (argument == null) {
                throw new IllegalArgumentException("Argument is not defined for connector:" + name + " -- " + connector.name());
            }
            argument.setValue(value);
        }
        return arguments;
    }

    JDIConnection(JDIEnv env, String connectorName, Map<String, String> argumentName2Value, int traceFlags, JShell proc) {
        this.env = env;
        this.proc = proc;
        this.connector = this.findConnector(connectorName);
        if (this.connector == null) {
            throw new IllegalArgumentException("No connector named: " + connectorName);
        }
        this.connectorArgs = this.mergeConnectorArgs(this.connector, argumentName2Value);
        this.traceFlags = traceFlags;
    }

    synchronized VirtualMachine open() {
        if (this.connector instanceof LaunchingConnector) {
            this.vm = this.launchTarget();
        } else if (this.connector instanceof AttachingConnector) {
            this.vm = this.attachTarget();
        } else if (this.connector instanceof ListeningConnector) {
            this.vm = this.listenTarget();
        } else {
            throw new InternalError("Invalid connect type");
        }
        this.vm.setDebugTraceMode(this.traceFlags);
        return this.vm;
    }

    synchronized boolean setConnectorArg(String name, String value) {
        if (this.vm != null) {
            return false;
        }
        Connector.Argument argument = this.connectorArgs.get(name);
        if (argument == null) {
            return false;
        }
        argument.setValue(value);
        return true;
    }

    String connectorArg(String name) {
        Connector.Argument argument = this.connectorArgs.get(name);
        if (argument == null) {
            return "";
        }
        return argument.value();
    }

    public synchronized VirtualMachine vm() {
        if (this.vm == null) {
            throw new JDINotConnectedException();
        }
        return this.vm;
    }

    synchronized boolean isOpen() {
        return this.vm != null;
    }

    boolean isLaunch() {
        return this.connector instanceof LaunchingConnector;
    }

    synchronized boolean isRunning() {
        return this.process != null && this.process.isAlive();
    }

    public synchronized void disposeVM() {
        try {
            if (this.vm != null) {
                this.vm.dispose();
                this.vm = null;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        finally {
            if (this.process != null) {
                this.process.destroy();
                this.process = null;
            }
            this.waitOutputComplete();
        }
    }

    private void dumpStream(InputStream inStream, PrintStream pStream) throws IOException {
        block3: {
            BufferedReader in = new BufferedReader(new InputStreamReader(inStream));
            try {
                int i;
                while ((i = in.read()) != -1) {
                    pStream.print((char)i);
                }
            }
            catch (IOException ex) {
                String s = ex.getMessage();
                if (s.startsWith("Bad file number")) break block3;
                throw ex;
            }
        }
    }

    private void displayRemoteOutput(final InputStream inStream, final PrintStream pStream) {
        Thread thr = new Thread("output reader"){

            @Override
            public void run() {
                try {
                    JDIConnection.this.dumpStream(inStream, pStream);
                }
                catch (IOException ex) {
                    JDIConnection.this.proc.debug(ex, "Failed reading output");
                    JDIConnection.this.env.shutdown();
                }
                finally {
                    JDIConnection.this.notifyOutputComplete();
                }
            }
        };
        thr.setPriority(9);
        thr.start();
    }

    private void readRemoteInput(final OutputStream outStream, final InputStream inputStream) {
        Thread thr = new Thread("input reader"){

            @Override
            public void run() {
                try {
                    int cnt;
                    byte[] buf = new byte[256];
                    while ((cnt = inputStream.read(buf)) != -1) {
                        outStream.write(buf, 0, cnt);
                        outStream.flush();
                    }
                }
                catch (IOException ex) {
                    JDIConnection.this.proc.debug(ex, "Failed reading output");
                    JDIConnection.this.env.shutdown();
                }
            }
        };
        thr.setPriority(9);
        thr.start();
    }

    private VirtualMachine launchTarget() {
        LaunchingConnector launcher = (LaunchingConnector)this.connector;
        try {
            VirtualMachine new_vm = launcher.launch(this.connectorArgs);
            this.process = new_vm.process();
            this.displayRemoteOutput(this.process.getErrorStream(), this.proc.err);
            this.displayRemoteOutput(this.process.getInputStream(), this.proc.out);
            this.readRemoteInput(this.process.getOutputStream(), this.proc.in);
            return new_vm;
        }
        catch (Exception ex) {
            this.reportLaunchFail(ex, "launch");
            return null;
        }
    }

    private VirtualMachine attachTarget() {
        AttachingConnector attacher = (AttachingConnector)this.connector;
        try {
            return attacher.attach(this.connectorArgs);
        }
        catch (Exception ex) {
            this.reportLaunchFail(ex, "attach");
            return null;
        }
    }

    private VirtualMachine listenTarget() {
        ListeningConnector listener = (ListeningConnector)this.connector;
        try {
            String retAddress = listener.startListening(this.connectorArgs);
            this.proc.debug(1, "Listening at address: " + retAddress, new Object[0]);
            this.vm = listener.accept(this.connectorArgs);
            listener.stopListening(this.connectorArgs);
            return this.vm;
        }
        catch (Exception ex) {
            this.reportLaunchFail(ex, "listen");
            return null;
        }
    }

    private void reportLaunchFail(Exception ex, String context) {
        throw new InternalError("Failed remote " + context + ": " + this.connector + " -- " + this.connectorArgs, ex);
    }
}

