/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell;

import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import jdk.jshell.GeneralWrap;

abstract class Wrap
implements GeneralWrap {
    Wrap() {
    }

    private static Wrap methodWrap(String prefix, String source, String suffix) {
        NoWrap wunit = new NoWrap(source);
        return new DoitMethodWrap(new CompoundWrap(prefix, wunit, suffix));
    }

    public static Wrap methodWrap(String source) {
        return Wrap.methodWrap("", source, Wrap.semi(source) + "        return null;\n");
    }

    public static Wrap methodReturnWrap(String source) {
        return Wrap.methodWrap("return ", source, Wrap.semi(source));
    }

    public static Wrap methodUnreachableSemiWrap(String source) {
        return Wrap.methodWrap("", source, Wrap.semi(source));
    }

    public static Wrap methodUnreachableWrap(String source) {
        return Wrap.methodWrap("", source, "");
    }

    private static String indent(int n) {
        return "                              ".substring(0, n * 4);
    }

    private static String nlindent(int n) {
        return "\n" + Wrap.indent(n);
    }

    public static Wrap corralledMethod(String source, Range modRange, Range tpRange, Range typeRange, String name, Range paramRange, Range throwsRange, int id, int indent) {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(Wrap.indent(indent) + (indent == 1 ? "public static" + Wrap.nlindent(indent) : ""));
        if (!modRange.isEmpty()) {
            l.add(new RangeWrap(source, modRange));
            l.add(" ");
        }
        if (tpRange != null) {
            l.add("<");
            l.add(new RangeWrap(source, tpRange));
            l.add("> ");
        }
        if (!typeRange.isEmpty()) {
            l.add(new RangeWrap(source, typeRange));
            l.add(" ");
        }
        l.add(name + "(");
        if (paramRange != null && !paramRange.isEmpty()) {
            l.add(Wrap.nlindent(indent + 1));
            l.add(new RangeWrap(source, paramRange));
        }
        l.add(")");
        if (throwsRange != null) {
            l.add(" throws ");
            l.add(new RangeWrap(source, throwsRange));
        }
        l.add(" {" + Wrap.nlindent(indent + 1) + "throw new jdk.internal.jshell.remote.RemoteResolutionException(" + id + ");" + Wrap.nlindent(indent) + "}\n");
        return new CompoundWrap(l.toArray());
    }

    public static Wrap corralledType(String source, Range modRange, Tree.Kind kind, String name, Range tpRange, Range extendsRange, List<Range> implementsRanges, List<Wrap> members, boolean defaultConstructor, int id, int indent) {
        boolean isInterface = kind == Tree.Kind.INTERFACE;
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(Wrap.indent(indent) + (indent == 1 ? "public static" + Wrap.nlindent(indent) : ""));
        if (!modRange.isEmpty()) {
            l.add(new RangeWrap(source, modRange));
            l.add(" ");
        }
        l.add((isInterface ? "interface " : "class ") + name);
        if (tpRange != null) {
            l.add("<");
            l.add(new RangeWrap(source, tpRange));
            l.add("> ");
        }
        if (extendsRange != null && !extendsRange.isEmpty()) {
            l.add(" extends ");
            l.add(new RangeWrap(source, extendsRange));
        }
        for (int i = 0; i < implementsRanges.size(); ++i) {
            Range ir = implementsRanges.get(i);
            l.add(i == 0 ? " implements " : ", ");
            l.add(new RangeWrap(source, ir));
        }
        if (defaultConstructor) {
            l.add(" {" + Wrap.nlindent(indent + 1) + (indent == 1 ? "public " : "") + name + "()  {" + Wrap.nlindent(indent + 2) + "throw new jdk.internal.jshell.remote.RemoteResolutionException(" + id + ");" + Wrap.nlindent(indent + 1) + "}\n");
        } else {
            l.add(" {\n");
        }
        l.addAll(members);
        l.add(Wrap.indent(indent) + "}\n");
        return new CompoundWrap(l.toArray());
    }

    public static Wrap corralledVar(String source, Range modRange, Range typeRange, String brackets, Range nameRange, int indent) {
        RangeWrap wname = new RangeWrap(source, nameRange);
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(Wrap.indent(indent) + (indent == 1 ? "public static" + Wrap.nlindent(indent) : ""));
        if (!modRange.isEmpty()) {
            l.add(new RangeWrap(source, modRange));
            l.add(" ");
        }
        l.add(new RangeWrap(source, typeRange));
        l.add(" ");
        l.add(wname);
        l.add(Wrap.semi(wname));
        return new CompoundWrap(l.toArray());
    }

    public static Wrap varWrap(String source, Range rtype, String brackets, Range rname, Range rinit) {
        CompoundWrap wmeth;
        RangeWrap wname = new RangeWrap(source, rname);
        RangeWrap wtype = new RangeWrap(source, rtype);
        VarDeclareWrap wVarDecl = new VarDeclareWrap(wtype, brackets, wname);
        if (rinit == null) {
            wmeth = new CompoundWrap(new NoWrap(" "), "   return null;\n");
        } else {
            RangeWrap winit = new RangeWrap(source, rinit);
            wmeth = new CompoundWrap(wtype, brackets + " ", wname, "_ =\n        ", winit, Wrap.semi(winit), "        return ", wname, " = ", wname, "_;\n");
        }
        DoitMethodWrap wInitMeth = new DoitMethodWrap(wmeth);
        return new CompoundWrap(wVarDecl, wInitMeth);
    }

    public static Wrap tempVarWrap(String source, String typename, String name) {
        NoWrap winit = new NoWrap(source);
        CompoundWrap wmeth = new CompoundWrap("return " + name + " =\n        ", winit, Wrap.semi(winit));
        DoitMethodWrap wInitMeth = new DoitMethodWrap(wmeth);
        String varDecl = "    public static\n    " + typename + " " + name + ";\n";
        return new CompoundWrap(varDecl, wInitMeth);
    }

    public static Wrap importWrap(String source) {
        return new NoWrap(source);
    }

    public static Wrap classMemberWrap(String source) {
        NoWrap w = new NoWrap(source);
        return new CompoundWrap("    public static\n    ", w);
    }

    private static int countLines(String s) {
        return Wrap.countLines(s, 0, s.length());
    }

    private static int countLines(String s, int from, int toEx) {
        int cnt = 0;
        int idx = from;
        while ((idx = s.indexOf(10, idx)) > 0 && idx < toEx) {
            ++cnt;
            ++idx;
        }
        return cnt;
    }

    private static String semi(Wrap w) {
        return Wrap.semi(w.wrapped());
    }

    private static String semi(String s) {
        return s.endsWith(";") ? "\n" : (s.endsWith(";\n") ? "" : ";\n");
    }

    private static class VarDeclareWrap
    extends CompoundWrap {
        VarDeclareWrap(Wrap wtype, String brackets, Wrap wname) {
            super("    public static ", wtype, brackets + " ", wname, Wrap.semi(wname));
        }
    }

    private static class DoitMethodWrap
    extends CompoundWrap {
        DoitMethodWrap(Wrap w) {
            super("    public static Object do_it$() throws Throwable {\n        ", w, "    }\n");
        }
    }

    private static class NoWrap
    extends RangeWrap {
        NoWrap(String unit) {
            super(unit, new Range(unit));
        }
    }

    private static class RangeWrap
    extends Wrap {
        final Range range;
        final String wrapped;
        final int firstSnline;
        final int lastSnline;

        RangeWrap(String snippetSource, Range usedWithinSnippet) {
            this.range = usedWithinSnippet;
            this.wrapped = usedWithinSnippet.part(snippetSource);
            usedWithinSnippet.verify(snippetSource);
            this.firstSnline = Wrap.countLines(snippetSource, 0, this.range.begin);
            this.lastSnline = this.firstSnline + Wrap.countLines(snippetSource, this.range.begin, this.range.end);
        }

        @Override
        public String wrapped() {
            return this.wrapped;
        }

        @Override
        public int snippetIndexToWrapIndex(int sni) {
            if (sni < this.range.begin) {
                return 0;
            }
            if (sni > this.range.end) {
                return this.range.length();
            }
            return sni - this.range.begin;
        }

        @Override
        public int wrapIndexToSnippetIndex(int wi) {
            if (wi < 0) {
                return 0;
            }
            int max = this.range.length();
            if (wi > max) {
                wi = max;
            }
            return wi + this.range.begin;
        }

        @Override
        public int firstSnippetIndex() {
            return this.range.begin;
        }

        @Override
        public int lastSnippetIndex() {
            return this.range.end;
        }

        @Override
        public int snippetLineToWrapLine(int snline) {
            if (snline < this.firstSnline) {
                return 0;
            }
            if (snline >= this.lastSnline) {
                return this.lastSnline - this.firstSnline;
            }
            return snline - this.firstSnline;
        }

        @Override
        public int wrapLineToSnippetLine(int wline) {
            if (wline < 0) {
                return 0;
            }
            int max = this.lastSnline - this.firstSnline;
            if (wline > max) {
                wline = max;
            }
            return wline + this.firstSnline;
        }

        @Override
        public int firstSnippetLine() {
            return this.firstSnline;
        }

        @Override
        public int lastSnippetLine() {
            return this.lastSnline;
        }
    }

    public static class CompoundWrap
    extends Wrap {
        final Object[] os;
        final String wrapped;
        final int snidxFirst;
        final int snidxLast;
        final int snlineFirst;
        final int snlineLast;

        CompoundWrap(Object ... os) {
            this.os = os;
            int sniFirst = Integer.MAX_VALUE;
            int sniLast = Integer.MIN_VALUE;
            int snlnFirst = Integer.MAX_VALUE;
            int snlnLast = Integer.MIN_VALUE;
            StringBuilder sb = new StringBuilder();
            for (Object o : os) {
                if (o instanceof String) {
                    String s = (String)o;
                    sb.append(s);
                    continue;
                }
                if (o instanceof Wrap) {
                    Wrap w = (Wrap)o;
                    if (w.firstSnippetIndex() < sniFirst) {
                        sniFirst = w.firstSnippetIndex();
                    }
                    if (w.lastSnippetIndex() > sniLast) {
                        sniLast = w.lastSnippetIndex();
                    }
                    if (w.firstSnippetLine() < snlnFirst) {
                        snlnFirst = w.firstSnippetLine();
                    }
                    if (w.lastSnippetLine() > snlnLast) {
                        snlnLast = w.lastSnippetLine();
                    }
                    sb.append(w.wrapped());
                    continue;
                }
                throw new InternalError("Bad object in CommoundWrap: " + o);
            }
            this.wrapped = sb.toString();
            this.snidxFirst = sniFirst;
            this.snidxLast = sniLast;
            this.snlineFirst = snlnFirst;
            this.snlineLast = snlnLast;
        }

        @Override
        public String wrapped() {
            return this.wrapped;
        }

        @Override
        public int snippetIndexToWrapIndex(int sni) {
            int before = 0;
            for (Object o : this.os) {
                if (o instanceof String) {
                    String s = (String)o;
                    before += s.length();
                    continue;
                }
                if (!(o instanceof Wrap)) continue;
                Wrap w = (Wrap)o;
                if (sni >= w.firstSnippetIndex() && sni <= w.lastSnippetIndex()) {
                    return w.snippetIndexToWrapIndex(sni) + before;
                }
                before += w.wrapped().length();
            }
            return 0;
        }

        @Override
        public int wrapIndexToSnippetIndex(int wi) {
            int before = 0;
            for (Object o : this.os) {
                if (o instanceof String) {
                    String s = (String)o;
                    before += s.length();
                    continue;
                }
                if (!(o instanceof Wrap)) continue;
                Wrap w = (Wrap)o;
                int len = w.wrapped().length();
                if (wi - before <= len) {
                    return w.wrapIndexToSnippetIndex(wi - before);
                }
                before += len;
            }
            return this.lastSnippetIndex();
        }

        @Override
        public int firstSnippetIndex() {
            return this.snidxFirst;
        }

        @Override
        public int lastSnippetIndex() {
            return this.snidxLast;
        }

        @Override
        public int snippetLineToWrapLine(int snline) {
            int before = 0;
            for (Object o : this.os) {
                if (o instanceof String) {
                    String s = (String)o;
                    before += Wrap.countLines(s);
                    continue;
                }
                if (!(o instanceof Wrap)) continue;
                Wrap w = (Wrap)o;
                if (snline >= w.firstSnippetLine() && snline <= w.lastSnippetLine()) {
                    return w.snippetLineToWrapLine(snline) + before;
                }
                before += Wrap.countLines(w.wrapped());
            }
            return 0;
        }

        @Override
        public int wrapLineToSnippetLine(int wline) {
            int before = 0;
            for (Object o : this.os) {
                if (o instanceof String) {
                    String s = (String)o;
                    before += Wrap.countLines(s);
                    continue;
                }
                if (!(o instanceof Wrap)) continue;
                Wrap w = (Wrap)o;
                int lns = Wrap.countLines(w.wrapped());
                if (wline - before < lns) {
                    return w.wrapLineToSnippetLine(wline - before);
                }
                before += lns;
            }
            return 0;
        }

        @Override
        public int firstSnippetLine() {
            return this.snlineFirst;
        }

        @Override
        public int lastSnippetLine() {
            return this.snlineLast;
        }
    }

    public static final class Range {
        final int begin;
        final int end;

        Range(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        Range(String s) {
            this.begin = 0;
            this.end = s.length();
        }

        String part(String s) {
            return s.substring(this.begin, this.end);
        }

        int length() {
            return this.end - this.begin;
        }

        boolean isEmpty() {
            return this.end == this.begin;
        }

        void verify(String s) {
            if (this.begin < 0 || this.end <= this.begin || this.end > s.length()) {
                throw new InternalError("Bad Range: " + s + "[" + this.begin + "," + this.end + "]");
            }
        }

        public String toString() {
            return "Range[" + this.begin + "," + this.end + "]";
        }
    }
}

