/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.platform;

import com.sun.source.util.Plugin;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.platform.PlatformDescription;
import com.sun.tools.javac.platform.PlatformProvider;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.Processor;

public class JDKPlatformProvider
implements PlatformProvider {
    private static final String[] symbolFileLocation = new String[]{"lib", "ct.sym"};
    private static final Set<String> SUPPORTED_JAVA_PLATFORM_VERSIONS = new TreeSet<String>();

    @Override
    public Iterable<String> getSupportedPlatformNames() {
        return SUPPORTED_JAVA_PLATFORM_VERSIONS;
    }

    @Override
    public PlatformDescription getPlatform(String platformName, String options) {
        return new PlatformDescriptionImpl(platformName);
    }

    private static String targetNumericVersion(Target target) {
        return Integer.toString(target.ordinal() - Target.JDK1_1.ordinal() + 1);
    }

    static Path findCtSym() {
        String javaHome = System.getProperty("java.home");
        Path file = Paths.get(javaHome, new String[0]);
        for (String name : symbolFileLocation) {
            file = file.resolve(name);
        }
        return file;
    }

    static {
        Path ctSymFile = JDKPlatformProvider.findCtSym();
        if (Files.exists(ctSymFile, new LinkOption[0])) {
            try (FileSystem fs = FileSystems.newFileSystem(ctSymFile, null);
                 DirectoryStream<Path> dir = Files.newDirectoryStream(fs.getRootDirectories().iterator().next());){
                for (Path section : dir) {
                    for (char ver : section.getFileName().toString().toCharArray()) {
                        String verString = Character.toString(ver);
                        Target t = Target.lookup(verString);
                        if (t == null) continue;
                        SUPPORTED_JAVA_PLATFORM_VERSIONS.add(JDKPlatformProvider.targetNumericVersion(t));
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        SUPPORTED_JAVA_PLATFORM_VERSIONS.add(JDKPlatformProvider.targetNumericVersion(Target.DEFAULT));
    }

    static class PlatformDescriptionImpl
    implements PlatformDescription {
        private final Map<Path, FileSystem> ctSym2FileSystem = new HashMap<Path, FileSystem>();
        private final String version;

        PlatformDescriptionImpl(String version2) {
            this.version = version2;
        }

        @Override
        public Collection<Path> getPlatformPath() {
            ArrayList<Path> paths;
            block20: {
                if (Target.lookup(this.version) == Target.DEFAULT) {
                    return null;
                }
                paths = new ArrayList<Path>();
                Path file = JDKPlatformProvider.findCtSym();
                if (Files.exists(file, new LinkOption[0])) {
                    FileSystem fs = this.ctSym2FileSystem.get(file);
                    if (fs == null) {
                        try {
                            fs = FileSystems.newFileSystem(file, null);
                            this.ctSym2FileSystem.put(file, fs);
                        }
                        catch (IOException ex) {
                            throw new IllegalStateException(ex);
                        }
                    }
                    Path root = fs.getRootDirectories().iterator().next();
                    try (DirectoryStream<Path> dir = Files.newDirectoryStream(root);){
                        for (Path section : dir) {
                            if (!section.getFileName().toString().contains(this.version)) continue;
                            paths.add(section);
                        }
                        break block20;
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
                throw new IllegalStateException("Cannot find ct.sym!");
            }
            return paths;
        }

        @Override
        public String getSourceVersion() {
            return this.version;
        }

        @Override
        public String getTargetVersion() {
            return this.version;
        }

        @Override
        public List<PlatformDescription.PluginInfo<Processor>> getAnnotationProcessors() {
            return Collections.emptyList();
        }

        @Override
        public List<PlatformDescription.PluginInfo<Plugin>> getPlugins() {
            return Collections.emptyList();
        }

        @Override
        public List<String> getAdditionalOptions() {
            return Collections.emptyList();
        }

        @Override
        public void close() throws IOException {
            for (FileSystem fs : this.ctSym2FileSystem.values()) {
                fs.close();
            }
            this.ctSym2FileSystem.clear();
        }
    }
}

