/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import jdk.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import jdk.javadoc.internal.doclets.formats.html.HtmlDocletWriter;
import jdk.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.util.ClassTree;
import jdk.javadoc.internal.doclets.toolkit.util.DocPath;

public abstract class AbstractTreeWriter
extends HtmlDocletWriter {
    protected final ClassTree classtree;

    protected AbstractTreeWriter(ConfigurationImpl configuration, DocPath filename, ClassTree classtree) throws IOException {
        super(configuration, filename);
        this.classtree = classtree;
    }

    protected void addLevelInfo(TypeElement parent, Collection<TypeElement> collection, boolean isEnum, Content contentTree) {
        if (!collection.isEmpty()) {
            HtmlTree ul = new HtmlTree(HtmlTag.UL);
            for (TypeElement local : collection) {
                HtmlTree li = new HtmlTree(HtmlTag.LI);
                li.addStyle(HtmlStyle.circle);
                this.addPartialInfo(local, li);
                this.addExtendsImplements(parent, local, li);
                this.addLevelInfo(local, this.classtree.directSubClasses(local, isEnum), isEnum, li);
                ((Content)ul).addContent(li);
            }
            contentTree.addContent(ul);
        }
    }

    protected void addTree(SortedSet<TypeElement> sset, String heading, HtmlTree div) {
        this.addTree(sset, heading, div, false);
    }

    protected void addTree(SortedSet<TypeElement> sset, String heading, HtmlTree div, boolean isEnums) {
        if (!sset.isEmpty()) {
            HtmlTree htmlTree;
            TypeElement firstTypeElement = sset.first();
            Content headingContent = this.getResource(heading);
            HtmlTree sectionHeading = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, true, headingContent);
            if (this.configuration.allowTag(HtmlTag.SECTION)) {
                htmlTree = HtmlTree.SECTION(sectionHeading);
            } else {
                div.addContent(sectionHeading);
                htmlTree = div;
            }
            this.addLevelInfo(!this.utils.isInterface(firstTypeElement) ? firstTypeElement : null, sset, isEnums, htmlTree);
            if (this.configuration.allowTag(HtmlTag.SECTION)) {
                div.addContent(htmlTree);
            }
        }
    }

    protected void addExtendsImplements(TypeElement parent, TypeElement typeElement, Content contentTree) {
        TreeSet<Element> interfaces = new TreeSet<Element>(this.utils.makeGeneralPurposeComparator());
        typeElement.getInterfaces().stream().forEach(t -> interfaces.add(this.utils.asTypeElement((TypeMirror)t)));
        if (interfaces.size() > (this.utils.isInterface(typeElement) ? 1 : 0)) {
            boolean isFirst = true;
            for (TypeElement typeElement2 : interfaces) {
                if (parent == typeElement2 || !this.utils.isPublic(typeElement2) && !this.utils.isLinkable(typeElement2)) continue;
                if (isFirst) {
                    isFirst = false;
                    if (this.utils.isInterface(typeElement)) {
                        contentTree.addContent(" (");
                        contentTree.addContent(this.getResource("doclet.also"));
                        contentTree.addContent(" extends ");
                    } else {
                        contentTree.addContent(" (implements ");
                    }
                } else {
                    contentTree.addContent(", ");
                }
                this.addPreQualifiedClassLink(LinkInfoImpl.Kind.TREE, typeElement2, contentTree);
            }
            if (!isFirst) {
                contentTree.addContent(")");
            }
        }
    }

    protected void addPartialInfo(TypeElement typeElement, Content contentTree) {
        this.addPreQualifiedStrongClassLink(LinkInfoImpl.Kind.TREE, typeElement, contentTree);
    }

    @Override
    protected Content getNavLinkTree() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.treeLabel);
        return li;
    }
}

