/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import jdk.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import jdk.javadoc.internal.doclets.formats.html.HtmlDocletWriter;
import jdk.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import jdk.javadoc.internal.doclets.formats.html.markup.StringContent;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.util.DocPath;
import jdk.javadoc.internal.doclets.toolkit.util.DocPaths;
import jdk.javadoc.internal.doclets.toolkit.util.DocletAbortException;

public class PackageFrameWriter
extends HtmlDocletWriter {
    private PackageElement packageElement;
    private SortedSet<TypeElement> documentedClasses;

    public PackageFrameWriter(ConfigurationImpl configuration, PackageElement packageElement) throws IOException {
        super(configuration, DocPath.forPackage(packageElement).resolve(DocPaths.PACKAGE_FRAME));
        this.packageElement = packageElement;
        if (this.utils.getSpecifiedPackages().isEmpty()) {
            this.documentedClasses = new TreeSet<Element>(this.utils.makeGeneralPurposeComparator());
            this.documentedClasses.addAll(configuration.root.getIncludedClasses());
        }
    }

    public static void generate(ConfigurationImpl configuration, PackageElement packageElement) {
        try {
            PackageFrameWriter packgen = new PackageFrameWriter(configuration, packageElement);
            String pkgName = configuration.utils.getPackageName(packageElement);
            HtmlTree body = packgen.getBody(false, packgen.getWindowTitle(pkgName));
            StringContent pkgNameContent = new StringContent(pkgName);
            HtmlTree htmlTree = configuration.allowTag(HtmlTag.MAIN) ? HtmlTree.MAIN() : body;
            HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, HtmlStyle.bar, packgen.getTargetPackageLink(packageElement, "classFrame", pkgNameContent));
            htmlTree.addContent(heading);
            HtmlTree div = new HtmlTree(HtmlTag.DIV);
            div.addStyle(HtmlStyle.indexContainer);
            packgen.addClassListing(div);
            htmlTree.addContent(div);
            if (configuration.allowTag(HtmlTag.MAIN)) {
                body.addContent(htmlTree);
            }
            packgen.printHtmlDocument(configuration.metakeywords.getMetaKeywords(packageElement), false, body);
            packgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), DocPaths.PACKAGE_FRAME.getPath());
            throw new DocletAbortException(exc);
        }
    }

    protected void addClassListing(HtmlTree contentTree) {
        ConfigurationImpl config = this.configuration;
        if (this.utils.isIncluded(this.packageElement)) {
            this.addClassKindListing(this.utils.getInterfaces(this.packageElement), this.getResource("doclet.Interfaces"), contentTree);
            this.addClassKindListing(this.utils.getOrdinaryClasses(this.packageElement), this.getResource("doclet.Classes"), contentTree);
            this.addClassKindListing(this.utils.getEnums(this.packageElement), this.getResource("doclet.Enums"), contentTree);
            this.addClassKindListing(this.utils.getExceptions(this.packageElement), this.getResource("doclet.Exceptions"), contentTree);
            this.addClassKindListing(this.utils.getErrors(this.packageElement), this.getResource("doclet.Errors"), contentTree);
            this.addClassKindListing(this.utils.getAnnotationTypes(this.packageElement), this.getResource("doclet.AnnotationTypes"), contentTree);
        } else {
            this.addClassKindListing(config.typeElementCatalog.interfaces(this.packageElement), this.getResource("doclet.Interfaces"), contentTree);
            this.addClassKindListing(config.typeElementCatalog.ordinaryClasses(this.packageElement), this.getResource("doclet.Classes"), contentTree);
            this.addClassKindListing(config.typeElementCatalog.enums(this.packageElement), this.getResource("doclet.Enums"), contentTree);
            this.addClassKindListing(config.typeElementCatalog.exceptions(this.packageElement), this.getResource("doclet.Exceptions"), contentTree);
            this.addClassKindListing(config.typeElementCatalog.errors(this.packageElement), this.getResource("doclet.Errors"), contentTree);
            this.addClassKindListing(config.typeElementCatalog.annotationTypes(this.packageElement), this.getResource("doclet.AnnotationTypes"), contentTree);
        }
    }

    protected void addClassKindListing(Iterable<TypeElement> list, Content labelContent, HtmlTree contentTree) {
        SortedSet<TypeElement> tset = this.utils.filterOutPrivateClasses(list, this.configuration.javafx);
        if (!tset.isEmpty()) {
            boolean printedHeader = false;
            HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.SECTION) ? HtmlTree.SECTION() : contentTree;
            HtmlTree ul = new HtmlTree(HtmlTag.UL);
            ul.setTitle(labelContent);
            for (TypeElement typeElement : tset) {
                if (this.documentedClasses != null && !this.documentedClasses.contains(typeElement) || !this.utils.isCoreClass(typeElement) || !this.configuration.isGeneratedDoc(typeElement)) continue;
                if (!printedHeader) {
                    HtmlTree heading = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, true, labelContent);
                    htmlTree.addContent(heading);
                    printedHeader = true;
                }
                Content arr_i_name = new StringContent(this.utils.getSimpleName(typeElement));
                if (this.utils.isInterface(typeElement)) {
                    arr_i_name = HtmlTree.SPAN(HtmlStyle.interfaceName, arr_i_name);
                }
                Content link = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.PACKAGE_FRAME, typeElement).label(arr_i_name).target("classFrame"));
                HtmlTree li = HtmlTree.LI(link);
                ul.addContent(li);
            }
            htmlTree.addContent(ul);
            if (this.configuration.allowTag(HtmlTag.SECTION)) {
                contentTree.addContent(htmlTree);
            }
        }
    }
}

