/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.toolkit;

import com.sun.source.util.DocTreePath;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import jdk.javadoc.internal.doclets.toolkit.CommentUtils;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.OverviewElement;
import jdk.javadoc.internal.doclets.toolkit.WorkArounds;
import jdk.javadoc.internal.doclets.toolkit.WriterFactory;
import jdk.javadoc.internal.doclets.toolkit.builders.BuilderFactory;
import jdk.javadoc.internal.doclets.toolkit.taglets.TagletManager;
import jdk.javadoc.internal.doclets.toolkit.util.DocFile;
import jdk.javadoc.internal.doclets.toolkit.util.DocFileFactory;
import jdk.javadoc.internal.doclets.toolkit.util.DocletAbortException;
import jdk.javadoc.internal.doclets.toolkit.util.Extern;
import jdk.javadoc.internal.doclets.toolkit.util.Group;
import jdk.javadoc.internal.doclets.toolkit.util.MessageRetriever;
import jdk.javadoc.internal.doclets.toolkit.util.MetaKeywords;
import jdk.javadoc.internal.doclets.toolkit.util.TypeElementCatalog;
import jdk.javadoc.internal.doclets.toolkit.util.Utils;
import jdk.javadoc.internal.doclets.toolkit.util.VisibleMemberMap;

public abstract class Configuration {
    protected BuilderFactory builderFactory;
    public TagletManager tagletManager;
    public String builderXMLPath;
    private static final String DEFAULT_BUILDER_XML = "resources/doclet.xml";
    public String tagletpath = "";
    public boolean serialwarn = false;
    public int sourcetab;
    public String tabSpaces;
    public boolean linksource = false;
    public boolean nosince = false;
    public boolean copydocfilesubdirs = false;
    public boolean backwardCompatibility = true;
    public String charset = "";
    public boolean keywords = false;
    public final MetaKeywords metakeywords;
    protected Set<String> excludedDocFileDirs;
    protected Set<String> excludedQualifiers;
    public DocletEnvironment root;
    public Utils utils;
    public WorkArounds workArounds;
    public String destDirName = "";
    public String docFileDestDirName = "";
    public String docencoding = null;
    public boolean nocomment = false;
    public String encoding = null;
    public boolean showauthor = false;
    public boolean javafx = false;
    public boolean showversion = false;
    public boolean nodeprecated = false;
    public TypeElementCatalog typeElementCatalog;
    public MessageRetriever message = null;
    public boolean notimestamp = false;
    public final Group group = new Group(this);
    public final Extern extern = new Extern(this);
    public Reporter reporter;
    public Locale locale;
    public boolean quiet = false;
    private String urlForLink;
    private String pkglistUrlForLink;
    private String urlForLinkOffline;
    private String pkglistUrlForLinkOffline;
    private List<GroupContainer> groups;
    public CommentUtils cmtUtils;
    public SortedSet<PackageElement> packages;
    protected final List<Doclet.Option> optionsProcessed;
    public final OverviewElement overviewElement;
    public final Map<TypeElement, List<Element>> propertiesCache = new HashMap<TypeElement, List<Element>>();
    public final Map<Element, Element> classPropertiesMap = new HashMap<Element, Element>();
    public final Map<Element, VisibleMemberMap.GetterSetter> getterSetterMap = new HashMap<Element, VisibleMemberMap.GetterSetter>();
    public DocFileFactory docFileFactory;
    final LinkedHashSet<List<String>> customTagStrs = new LinkedHashSet();

    public abstract String getDocletSpecificBuildDate();

    public abstract boolean finishOptionSettings();

    public abstract MessageRetriever getDocletSpecificMsg();

    public Configuration() {
        this.message = new MessageRetriever(this, "jdk.javadoc.internal.doclets.toolkit.resources.doclets");
        this.excludedDocFileDirs = new HashSet<String>();
        this.excludedQualifiers = new HashSet<String>();
        this.setTabWidth(8);
        this.metakeywords = new MetaKeywords(this);
        this.optionsProcessed = new ArrayList<Doclet.Option>();
        this.groups = new ArrayList<GroupContainer>(0);
        this.overviewElement = new OverviewElement(this.root);
    }

    public BuilderFactory getBuilderFactory() {
        if (this.builderFactory == null) {
            this.builderFactory = new BuilderFactory(this);
        }
        return this.builderFactory;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    private void initPackages() {
        this.packages = new TreeSet<Element>(this.utils.makePackageComparator());
        this.packages.addAll(this.utils.getSpecifiedPackages());
        for (TypeElement aClass : this.utils.getSpecifiedClasses()) {
            this.packages.add(this.utils.containingPackage(aClass));
        }
    }

    public Set<Doclet.Option> getSupportedOptions() {
        Doclet.Option[] options = new Doclet.Option[]{new Option(this, "author"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.showauthor = true;
                return true;
            }
        }, new Option(this, "d", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.destDirName = Configuration.addTrailingFileSep(args.next());
                return true;
            }
        }, new Option(this, "docencoding", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.docencoding = args.next();
                return true;
            }
        }, new Option(this, "docfilessubdirs"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.copydocfilesubdirs = true;
                return true;
            }
        }, new Hidden(this, "encoding", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.encoding = args.next();
                return true;
            }
        }, new Option(this, "excludedocfilessubdir", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.addToSet(Configuration.this.excludedDocFileDirs, args.next());
                return true;
            }
        }, new Option(this, "group", 2){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.groups.add(new GroupContainer(args.next(), args.next()));
                return true;
            }
        }, new Hidden(this, "javafx"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.javafx = true;
                return true;
            }
        }, new Option(this, "keywords"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.keywords = true;
                return true;
            }
        }, new Option(this, "link", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.urlForLink = args.next();
                Configuration.this.pkglistUrlForLink = Configuration.this.urlForLink;
                return true;
            }
        }, new Option(this, "linksource"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.linksource = true;
                return true;
            }
        }, new Option(this, "linkoffline", 2){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.urlForLinkOffline = args.next();
                Configuration.this.pkglistUrlForLinkOffline = args.next();
                return true;
            }
        }, new Option(this, "nocomment"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.nocomment = true;
                return true;
            }
        }, new Option(this, "nodeprecated"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.nodeprecated = true;
                return true;
            }
        }, new Option(this, "nosince"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.nosince = true;
                return true;
            }
        }, new Option(this, "notimestamp"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.notimestamp = true;
                return true;
            }
        }, new Option(this, "noqualifier", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.addToSet(Configuration.this.excludedQualifiers, args.next());
                return true;
            }
        }, new Hidden(this, "quiet"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.quiet = true;
                return true;
            }
        }, new Option(this, "serialwarn"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.serialwarn = true;
                return true;
            }
        }, new Option(this, "sourcetab", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.linksource = true;
                try {
                    Configuration.this.setTabWidth(Integer.parseInt(args.next()));
                }
                catch (NumberFormatException e) {
                    Configuration.this.sourcetab = -1;
                }
                if (Configuration.this.sourcetab <= 0) {
                    Configuration.this.message.warning("doclet.sourcetab_warning", new Object[0]);
                    Configuration.this.setTabWidth(8);
                }
                return true;
            }
        }, new Option(this, "tag", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                ArrayList<String> list = new ArrayList<String>();
                list.add(opt);
                list.add(args.next());
                Configuration.this.customTagStrs.add(list);
                return true;
            }
        }, new Option(this, "taglet", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                ArrayList<String> list = new ArrayList<String>();
                list.add(opt);
                list.add(args.next());
                Configuration.this.customTagStrs.add(list);
                return true;
            }
        }, new Option(this, "tagletpath", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.tagletpath = args.next();
                return true;
            }
        }, new Option(this, "version"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                Configuration.this.optionsProcessed.add(this);
                Configuration.this.showversion = true;
                return true;
            }
        }};
        TreeSet<Doclet.Option> set = new TreeSet<Doclet.Option>();
        set.addAll(Arrays.asList(options));
        return set;
    }

    private void finishOptionSettings0() throws Fault {
        this.ensureOutputDirExists();
        if (this.urlForLink != null && this.pkglistUrlForLink != null) {
            this.extern.link(this.urlForLink, this.pkglistUrlForLink, this.reporter, false);
        }
        if (this.urlForLinkOffline != null && this.pkglistUrlForLinkOffline != null) {
            this.extern.link(this.urlForLinkOffline, this.pkglistUrlForLinkOffline, this.reporter, true);
        }
        if (this.docencoding == null) {
            this.docencoding = this.encoding;
        }
        this.typeElementCatalog = new TypeElementCatalog(this.utils.getSpecifiedClasses(), this);
        this.initTagletManager(this.customTagStrs);
        this.groups.stream().forEach(grp -> this.group.checkPackageGroups(grp.value1, grp.value2));
    }

    public boolean setOptions() {
        try {
            this.initPackages();
            this.finishOptionSettings0();
            if (!this.finishOptionSettings()) {
                return false;
            }
        }
        catch (Fault f) {
            throw new DocletAbortException(f.getMessage());
        }
        return true;
    }

    private void ensureOutputDirExists() throws Fault {
        DocFile destDir = DocFile.createFileForDirectory(this, this.destDirName);
        if (!destDir.exists()) {
            if (!this.destDirName.isEmpty()) {
                this.reporter.print(Diagnostic.Kind.NOTE, this.getText("doclet.dest_dir_create", this.destDirName));
            }
            destDir.mkdirs();
        } else {
            if (!destDir.isDirectory()) {
                throw new Fault(this.getText("doclet.destination_directory_not_directory_0", destDir.getPath()));
            }
            if (!destDir.canWrite()) {
                throw new Fault(this.getText("doclet.destination_directory_not_writable_0", destDir.getPath()));
            }
        }
    }

    private void initTagletManager(Set<List<String>> customTagStrs) {
        this.tagletManager = this.tagletManager == null ? new TagletManager(this.nosince, this.showversion, this.showauthor, this.javafx, this.message) : this.tagletManager;
        for (List<String> args : customTagStrs) {
            if (args.get(0).equals("-taglet")) {
                this.tagletManager.addCustomTag(args.get(1), this.getFileManager(), this.tagletpath);
                continue;
            }
            List<String> tokens = this.tokenize(args.get(1), ':', 3);
            if (tokens.size() == 1) {
                String tagName = args.get(1);
                if (this.tagletManager.isKnownCustomTag(tagName)) {
                    this.tagletManager.addNewSimpleCustomTag(tagName, null, "");
                    continue;
                }
                StringBuilder heading = new StringBuilder(tagName + ":");
                heading.setCharAt(0, Character.toUpperCase(tagName.charAt(0)));
                this.tagletManager.addNewSimpleCustomTag(tagName, heading.toString(), "a");
                continue;
            }
            if (tokens.size() == 2) {
                this.tagletManager.addNewSimpleCustomTag(tokens.get(0), tokens.get(1), "");
                continue;
            }
            if (tokens.size() >= 3) {
                this.tagletManager.addNewSimpleCustomTag(tokens.get(0), tokens.get(2), tokens.get(1));
                continue;
            }
            this.message.error("doclet.Error_invalid_custom_tag_argument", args.get(1));
        }
    }

    private List<String> tokenize(String s, char separator, int maxTokens) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        boolean prevIsEscapeChar = false;
        for (int i = 0; i < s.length(); i += Character.charCount(i)) {
            int currentChar = s.codePointAt(i);
            if (prevIsEscapeChar) {
                token.appendCodePoint(currentChar);
                prevIsEscapeChar = false;
                continue;
            }
            if (currentChar == separator && tokens.size() < maxTokens - 1) {
                tokens.add(token.toString());
                token = new StringBuilder();
                continue;
            }
            if (currentChar == 92) {
                prevIsEscapeChar = true;
                continue;
            }
            token.appendCodePoint(currentChar);
        }
        if (token.length() > 0) {
            tokens.add(token.toString());
        }
        return tokens;
    }

    private void addToSet(Set<String> s, String str) {
        StringTokenizer st = new StringTokenizer(str, ":");
        while (st.hasMoreTokens()) {
            String current = st.nextToken();
            s.add(current);
        }
    }

    public static String addTrailingFileSep(String path) {
        int indexDblfs;
        String fs = System.getProperty("file.separator");
        String dblfs = fs + fs;
        while ((indexDblfs = path.indexOf(dblfs, 1)) >= 0) {
            path = path.substring(0, indexDblfs) + path.substring(indexDblfs + fs.length());
        }
        if (!path.endsWith(fs)) {
            path = path + fs;
        }
        return path;
    }

    public boolean generalValidOptions() {
        boolean docencodingfound = false;
        for (Doclet.Option opt : this.optionsProcessed) {
            if (!opt.matches("-docencoding")) continue;
            docencodingfound = true;
            if (this.checkOutputFileEncoding(this.docencoding)) continue;
            return false;
        }
        return docencodingfound || this.encoding == null || this.encoding.isEmpty() || this.checkOutputFileEncoding(this.encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkOutputFileEncoding(String docencoding) {
        ByteArrayOutputStream ost = new ByteArrayOutputStream();
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)ost, docencoding);
        }
        catch (UnsupportedEncodingException exc) {
            this.reporter.print(Diagnostic.Kind.ERROR, this.getText("doclet.Encoding_not_supported", docencoding));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (osw != null) {
                    osw.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public boolean shouldExcludeDocFileDir(String docfilesubdir) {
        return this.excludedDocFileDirs.contains(docfilesubdir);
    }

    public boolean shouldExcludeQualifier(String qualifier) {
        if (this.excludedQualifiers.contains("all") || this.excludedQualifiers.contains(qualifier) || this.excludedQualifiers.contains(qualifier + ".*")) {
            return true;
        }
        int index = -1;
        while ((index = qualifier.indexOf(".", index + 1)) != -1) {
            if (!this.excludedQualifiers.contains(qualifier.substring(0, index + 1) + "*")) continue;
            return true;
        }
        return false;
    }

    public String getClassName(TypeElement te) {
        PackageElement pkg = this.utils.containingPackage(te);
        return this.shouldExcludeQualifier(this.utils.getPackageName(pkg)) ? this.utils.getSimpleName(te) : this.utils.getFullyQualifiedName(te);
    }

    public String getText(String key) {
        try {
            return this.getDocletSpecificMsg().getText(key, new Object[0]);
        }
        catch (Exception e) {
            return this.message.getText(key, new Object[0]);
        }
    }

    public String getText(String key, String a1) {
        try {
            return this.getDocletSpecificMsg().getText(key, a1);
        }
        catch (MissingResourceException e) {
            return this.message.getText(key, a1);
        }
    }

    public String getText(String key, String a1, String a2) {
        try {
            return this.getDocletSpecificMsg().getText(key, a1, a2);
        }
        catch (MissingResourceException e) {
            return this.message.getText(key, a1, a2);
        }
    }

    public String getText(String key, String a1, String a2, String a3) {
        try {
            return this.getDocletSpecificMsg().getText(key, a1, a2, a3);
        }
        catch (MissingResourceException e) {
            return this.message.getText(key, a1, a2, a3);
        }
    }

    public abstract Content newContent();

    public Content getResource(String key) {
        Content c = this.newContent();
        c.addContent(this.getText(key));
        return c;
    }

    public Content getResource(String key, Object o) {
        return this.getResource(key, o, null, null);
    }

    public Content getResource(String key, Object o1, Object o2) {
        return this.getResource(key, o1, o2, null);
    }

    public Content getResource(String key, Object o0, Object o1, Object o2) {
        Content c = this.newContent();
        Pattern p = Pattern.compile("\\{([012])\\}");
        String text = this.getText(key);
        Matcher m = p.matcher(text);
        int start = 0;
        while (m.find(start)) {
            c.addContent(text.substring(start, m.start()));
            Object o = null;
            switch (m.group(1).charAt(0)) {
                case '0': {
                    o = o0;
                    break;
                }
                case '1': {
                    o = o1;
                    break;
                }
                case '2': {
                    o = o2;
                }
            }
            if (o == null) {
                c.addContent("{" + m.group(1) + "}");
            } else if (o instanceof String) {
                c.addContent((String)o);
            } else if (o instanceof Content) {
                c.addContent((Content)o);
            }
            start = m.end();
        }
        c.addContent(text.substring(start));
        return c;
    }

    public boolean isGeneratedDoc(TypeElement te) {
        if (!this.nodeprecated) {
            return true;
        }
        return !this.utils.isDeprecated(te) && !this.utils.isDeprecated(this.utils.containingPackage(te));
    }

    public abstract WriterFactory getWriterFactory();

    public InputStream getBuilderXML() throws IOException {
        return this.builderXMLPath == null ? Configuration.class.getResourceAsStream(DEFAULT_BUILDER_XML) : DocFile.createFileForInput(this, this.builderXMLPath).openInputStream();
    }

    public abstract Locale getLocale();

    public abstract JavaFileObject getOverviewPath();

    public abstract JavaFileManager getFileManager();

    private void setTabWidth(int n) {
        this.sourcetab = n;
        this.tabSpaces = String.format("%" + n + "s", "");
    }

    public abstract boolean showMessage(DocTreePath var1, String var2);

    public abstract boolean showMessage(Element var1, String var2);

    protected static class GroupContainer {
        final String value1;
        final String value2;

        public GroupContainer(String value1, String value2) {
            this.value1 = value1;
            this.value2 = value2;
        }
    }

    public abstract class Hidden
    extends Option {
        public Hidden(Configuration config, String name, int argCount) {
            super("doclet.xusage.", config, name, argCount);
        }

        public Hidden(Configuration config, String name) {
            this(config, name, 0);
        }

        @Override
        public Doclet.Option.Kind getKind() {
            return Doclet.Option.Kind.OTHER;
        }
    }

    public abstract class XOption
    extends Option {
        public XOption(Configuration config, String keyname, String name, int argCount) {
            super(config, keyname, name, argCount);
        }

        public XOption(Configuration config, String name, int argCount) {
            super("doclet.xusage.", config, name, argCount);
        }

        public XOption(Configuration config, String name) {
            this(config, name, 0);
        }

        @Override
        public Doclet.Option.Kind getKind() {
            return Doclet.Option.Kind.EXTENDED;
        }
    }

    public static abstract class Option
    implements Doclet.Option,
    Comparable<Option> {
        private final String name;
        private final String parameters;
        private final String description;
        private final int argCount;
        protected final Configuration c;

        protected Option(Configuration config, String keyName, String name, int argCount) {
            this.c = config;
            String key = keyName + "name";
            String oname = this.getOptionsMessage(key);
            if (oname.isEmpty()) {
                this.name = name;
                this.parameters = "<MISSING KEY>";
                this.description = "<MISSING KEY>";
            } else {
                this.name = oname;
                this.parameters = this.getOptionsMessage(keyName + "parameters");
                this.description = this.getOptionsMessage(keyName + "description");
            }
            this.argCount = argCount;
        }

        protected Option(String prefix, Configuration config, String name, int argCount) {
            this(config, prefix + name.toLowerCase() + ".", name, argCount);
        }

        protected Option(Configuration config, String name, int argCount) {
            this("doclet.usage.", config, name, argCount);
        }

        protected Option(Configuration config, String name) {
            this(config, name, 0);
        }

        private String getOptionsMessage(String key) {
            try {
                return this.c.getDocletSpecificMsg().getText(key, null);
            }
            catch (MissingResourceException ignore) {
                return "";
            }
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Doclet.Option.Kind getKind() {
            return Doclet.Option.Kind.STANDARD;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getParameters() {
            return this.parameters;
        }

        public String toString() {
            String opt = this.name + " " + this.parameters;
            int optlen = opt.length();
            int spaces = 32 - optlen;
            StringBuffer sb = new StringBuffer("  -").append(opt);
            for (int i = 0; i < spaces; ++i) {
                sb.append(" ");
            }
            sb.append(this.description);
            return sb.toString();
        }

        @Override
        public int getArgumentCount() {
            return this.argCount;
        }

        @Override
        public boolean matches(String option) {
            String arg = option.startsWith("-") ? option.substring(1) : option;
            return this.name.toLowerCase().equals(arg.toLowerCase());
        }

        @Override
        public int compareTo(Option that) {
            return this.getName().compareTo(that.getName());
        }
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = 0L;

        Fault(String msg) {
            super(msg);
        }

        Fault(String msg, Exception cause) {
            super(msg, cause);
        }
    }
}

