/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.tool;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.Log;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Reporter;

public class Messager
extends Log
implements Reporter {
    final Context context;
    final String programName;
    private Locale locale;
    private final JavacMessages messages;
    private final JCDiagnostic.Factory javadocDiags;
    static final PrintWriter defaultOutWriter = new PrintWriter(System.out);
    static final PrintWriter defaultErrWriter = new PrintWriter(System.err);

    public static Messager instance0(Context context) {
        Log instance = (Log)context.get(logKey);
        if (instance == null || !(instance instanceof Messager)) {
            throw new InternalError("no messager instance!");
        }
        return (Messager)instance;
    }

    public static void preRegister(Context context, final String programName) {
        context.put(logKey, new Context.Factory<Log>(){

            @Override
            public Log make(Context c) {
                return new Messager(c, programName);
            }
        });
    }

    public static void preRegister(Context context, final String programName, final PrintWriter outWriter, final PrintWriter errWriter) {
        context.put(logKey, new Context.Factory<Log>(){

            @Override
            public Log make(Context c) {
                return new Messager(c, programName, outWriter, errWriter);
            }
        });
    }

    @Override
    public void print(Diagnostic.Kind kind, String msg) {
        switch (kind) {
            case ERROR: {
                this.printError(msg);
                return;
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                this.printWarning(msg);
                return;
            }
        }
        this.printNotice(msg);
    }

    @Override
    public void print(Diagnostic.Kind kind, DocTreePath path, String msg) {
        switch (kind) {
            case ERROR: {
                this.printError(path, msg);
                return;
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                this.printWarning(path, msg);
                return;
            }
        }
        this.printWarning(path, msg);
    }

    @Override
    public void print(Diagnostic.Kind kind, Element e, String msg) {
        switch (kind) {
            case ERROR: {
                this.printError(e, msg);
                return;
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                this.printWarning(e, msg);
                return;
            }
        }
        this.printWarning(e, msg);
    }

    public Messager(Context context, String programName) {
        this(context, programName, defaultOutWriter, defaultErrWriter);
    }

    public Messager(Context context, String programName, PrintWriter outWriter, PrintWriter errWriter) {
        super(context, errWriter, errWriter, outWriter);
        this.messages = JavacMessages.instance(context);
        this.messages.add(locale -> ResourceBundle.getBundle("jdk.javadoc.internal.tool.resources.javadoc", locale));
        this.javadocDiags = new JCDiagnostic.Factory(this.messages, "javadoc");
        this.programName = programName;
        this.context = context;
        this.locale = Locale.getDefault();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    String getText(String key, Object ... args) {
        return this.messages.getLocalizedString(this.locale, key, args);
    }

    private String getDiagSource(DocTreePath path) {
        if (path == null) {
            return this.programName;
        }
        JavacTrees trees = JavacTrees.instance(this.context);
        DocSourcePositions sourcePositions = trees.getSourcePositions();
        CompilationUnitTree cu = path.getTreePath().getCompilationUnit();
        long spos = sourcePositions.getStartPosition(cu, path.getDocComment(), path.getLeaf());
        long lineNumber = cu.getLineMap().getLineNumber(spos);
        String fname = cu.getSourceFile().getName();
        String posString = fname + ":" + lineNumber;
        return posString;
    }

    private String getDiagSource(Element e) {
        if (e == null) {
            return this.programName;
        }
        JavacTrees trees = JavacTrees.instance(this.context);
        TreePath path = trees.getPath(e);
        DocSourcePositions sourcePositions = trees.getSourcePositions();
        JCTree tree = trees.getTree(e);
        CompilationUnitTree cu = path.getCompilationUnit();
        long spos = sourcePositions.getStartPosition(cu, tree);
        long lineNumber = cu.getLineMap().getLineNumber(spos);
        String fname = cu.getSourceFile().getName();
        String posString = fname + ":" + lineNumber;
        return posString;
    }

    public void printError(String msg) {
        this.printError((DocTreePath)null, msg);
    }

    public void printError(DocTreePath path, String msg) {
        String prefix = this.getDiagSource(path);
        if (this.diagListener != null) {
            this.report(JCDiagnostic.DiagnosticType.ERROR, prefix, msg);
            return;
        }
        this.incrementErrorCount(prefix, msg);
    }

    public void printError(Element e, String msg) {
        String prefix = this.getDiagSource(e);
        if (this.diagListener != null) {
            this.report(JCDiagnostic.DiagnosticType.ERROR, prefix, msg);
            return;
        }
        this.incrementErrorCount(prefix, msg);
    }

    private void incrementErrorCount(String prefix, String msg) {
        if (this.nerrors < this.MaxErrors) {
            this.errWriter.println(prefix + ": " + this.getText("javadoc.error", new Object[0]) + " - " + msg);
            this.errWriter.flush();
            this.prompt();
            ++this.nerrors;
        }
    }

    public void printWarning(String msg) {
        this.printWarning((DocTreePath)null, msg);
    }

    public void printWarning(DocTreePath path, String msg) {
        String prefix = this.getDiagSource(path);
        if (this.diagListener != null) {
            this.report(JCDiagnostic.DiagnosticType.WARNING, prefix, msg);
            return;
        }
        this.incrementWarningCount(prefix, msg);
    }

    public void printWarning(Element e, String msg) {
        String prefix = this.getDiagSource(e);
        if (this.diagListener != null) {
            this.report(JCDiagnostic.DiagnosticType.WARNING, prefix, msg);
            return;
        }
        this.incrementWarningCount(prefix, msg);
    }

    private void incrementWarningCount(String prefix, String msg) {
        if (this.nwarnings < this.MaxWarnings) {
            this.warnWriter.println(prefix + ": " + this.getText("javadoc.warning", new Object[0]) + " - " + msg);
            this.warnWriter.flush();
            ++this.nwarnings;
        }
    }

    public void printNotice(String msg) {
        this.printNotice((DocTreePath)null, msg);
    }

    public void printNotice(DocTreePath path, String msg) {
        String prefix = this.getDiagSource(path);
        if (this.diagListener != null) {
            this.report(JCDiagnostic.DiagnosticType.NOTE, null, prefix + ": " + msg);
            return;
        }
        if (path == null) {
            this.noticeWriter.println(msg);
        } else {
            this.noticeWriter.println(prefix + ": " + msg);
        }
        this.noticeWriter.flush();
    }

    public void printNotice(Element e, String msg) {
        String pos = this.getDiagSource(e);
        if (this.diagListener != null) {
            this.report(JCDiagnostic.DiagnosticType.NOTE, pos, msg);
            return;
        }
        if (e == null) {
            this.noticeWriter.println(msg);
        } else {
            this.noticeWriter.println(pos + ": " + msg);
        }
        this.noticeWriter.flush();
    }

    public void error(Element e, String key, Object ... args) {
        this.printError(e, this.getText(key, args));
    }

    public void error(DocTreePath path, String key, Object ... args) {
        this.printError(path, this.getText(key, args));
    }

    @Override
    public void error(String key, Object ... args) {
        this.printError((Element)null, this.getText(key, args));
    }

    @Override
    public void warning(String key, Object ... args) {
        this.printWarning((Element)null, this.getText(key, args));
    }

    public void warning(Element e, String key, Object ... args) {
        this.printWarning(e, this.getText(key, args));
    }

    public void warning(DocTreePath path, String key, Object ... args) {
        this.printWarning(path, this.getText(key, args));
    }

    public void notice(String key, Object ... args) {
        this.printNotice(this.getText(key, args));
    }

    public int nerrors() {
        return this.nerrors;
    }

    public int nwarnings() {
        return this.nwarnings;
    }

    public void exitNotice() {
        if (this.nerrors > 0) {
            this.notice(this.nerrors > 1 ? "main.errors" : "main.error", "" + this.nerrors);
        }
        if (this.nwarnings > 0) {
            this.notice(this.nwarnings > 1 ? "main.warnings" : "main.warning", "" + this.nwarnings);
        }
    }

    public void exit() {
        throw new ExitJavadoc();
    }

    private void report(JCDiagnostic.DiagnosticType type, String pos, String msg) {
        switch (type) {
            case ERROR: 
            case WARNING: {
                String prefix = pos == null ? this.programName : pos;
                this.report(this.javadocDiags.create(type, null, null, "msg", prefix, msg));
                break;
            }
            case NOTE: {
                String key = pos == null ? "msg" : "pos.msg";
                this.report(this.javadocDiags.create(type, null, null, key, pos, msg));
                break;
            }
            default: {
                throw new IllegalArgumentException(type.toString());
            }
        }
    }

    public class ExitJavadoc
    extends Error {
        private static final long serialVersionUID = 0L;
    }
}

