/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.lookup;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.lookup.CanonicalSymbolResolver;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.lookup.Scope;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.tree.Tree;
import java.util.HashMap;
import java.util.Map;

public class ImportIndex
implements Scope {
    private final Map<String, Supplier<ClassSymbol>> thunks;

    public ImportIndex(ImmutableMap<String, Supplier<ClassSymbol>> thunks) {
        this.thunks = thunks;
    }

    public static ImportIndex create(CanonicalSymbolResolver resolve, TopLevelIndex cpi, ImmutableList<Tree.ImportDecl> imports) {
        HashMap<Object, Supplier<ClassSymbol>> thunks = new HashMap<Object, Supplier<ClassSymbol>>();
        for (Tree.ImportDecl i : imports) {
            if (i.stat() || i.wild()) continue;
            thunks.put(Iterables.getLast(i.type()), ImportIndex.thunk(resolve, cpi, i));
        }
        for (Tree.ImportDecl i : imports) {
            String last;
            if (!i.stat() || thunks.containsKey(last = (String)Iterables.getLast(i.type()))) continue;
            thunks.put(last, ImportIndex.thunk(resolve, cpi, i));
        }
        return new ImportIndex((ImmutableMap<String, Supplier<ClassSymbol>>)ImmutableMap.copyOf(thunks));
    }

    private static Supplier<ClassSymbol> thunk(final CanonicalSymbolResolver resolve, final TopLevelIndex cpi, final Tree.ImportDecl i) {
        return Suppliers.memoize((Supplier)new Supplier<ClassSymbol>(){

            public ClassSymbol get() {
                LookupResult result = cpi.lookup(new LookupKey((Iterable<String>)i.type()));
                if (result == null) {
                    return null;
                }
                return resolve.resolve(result);
            }
        });
    }

    @Override
    public LookupResult lookup(LookupKey lookup) {
        Supplier<ClassSymbol> thunk = this.thunks.get(lookup.first());
        if (thunk == null) {
            return null;
        }
        ClassSymbol sym = (ClassSymbol)thunk.get();
        if (sym == null) {
            return null;
        }
        return new LookupResult(sym, lookup);
    }
}

