/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugCheckerInfo;
import com.google.errorprone.CodeTransformer;
import com.google.errorprone.ErrorProneAnalyzer;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.MaskedClassLoader;
import com.google.errorprone.RefactoringCollection;
import com.google.errorprone.scanner.ErrorProneScannerTransformer;
import com.google.errorprone.scanner.Scanner;
import com.google.errorprone.scanner.ScannerSupplier;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.api.MultiTaskListener;
import com.sun.tools.javac.main.Main;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JavacMessages;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.Processor;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class BaseErrorProneCompiler {
    private final DiagnosticListener<? super JavaFileObject> diagnosticListener;
    private final PrintWriter errOutput;
    private final String compilerName;
    private final ScannerSupplier scannerSupplier;

    private BaseErrorProneCompiler(String compilerName, PrintWriter errOutput, DiagnosticListener<? super JavaFileObject> diagnosticListener, ScannerSupplier scannerSupplier) {
        this.errOutput = errOutput;
        this.compilerName = compilerName;
        this.diagnosticListener = diagnosticListener;
        this.scannerSupplier = (ScannerSupplier)Preconditions.checkNotNull((Object)scannerSupplier, (Object)"scannerSupplier must not be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public Main.Result run(String[] args) {
        return this.run(args, new Context());
    }

    private static Iterable<String> defaultToLatestSupportedLanguageLevel(Iterable<String> args) {
        String overrideLanguageLevel;
        switch (StandardSystemProperty.JAVA_SPECIFICATION_VERSION.value()) {
            case "1.7": {
                overrideLanguageLevel = "7";
                break;
            }
            case "1.8": {
                overrideLanguageLevel = "8";
                break;
            }
            default: {
                return args;
            }
        }
        return Iterables.concat(Arrays.asList("-Xlint:-options", "-source", overrideLanguageLevel, "-target", overrideLanguageLevel), args);
    }

    private static Iterable<String> setCompilePolicyToByFile(Iterable<String> args) throws InvalidCommandLineOptionException {
        for (String arg : args) {
            String value;
            if (!arg.startsWith("-XDcompilePolicy")) continue;
            switch (value = arg.substring(arg.indexOf(61) + 1)) {
                case "byfile": 
                case "simple": {
                    break;
                }
                default: {
                    throw new InvalidCommandLineOptionException(String.format("-XDcompilePolicy=%s is not supported by Error Prone", value));
                }
            }
            return args;
        }
        return Iterables.concat(args, Arrays.asList("-XDcompilePolicy=byfile"));
    }

    private String[] prepareCompilation(String[] argv, Context context) throws InvalidCommandLineOptionException {
        ErrorProneAnalyzer analyzer;
        Iterable<String> newArgs = BaseErrorProneCompiler.defaultToLatestSupportedLanguageLevel(Arrays.asList(argv));
        newArgs = BaseErrorProneCompiler.setCompilePolicyToByFile(newArgs);
        ErrorProneOptions epOptions = ErrorProneOptions.processArgs(newArgs);
        argv = epOptions.getRemainingArgs();
        if (this.diagnosticListener != null) {
            context.put(DiagnosticListener.class, this.diagnosticListener);
        }
        MaskedClassLoader.preRegisterFileManager(context);
        BaseErrorProneCompiler.setupMessageBundle(context);
        if (epOptions.patchingOptions().doRefactor()) {
            RefactoringCollection refactoringCollection = epOptions.patchingOptions().inPlace() ? RefactoringCollection.refactorInPlace() : RefactoringCollection.refactorToPatchFile(epOptions.patchingOptions().baseDirectory());
            CodeTransformer codeTransformer = (CodeTransformer)((Supplier)epOptions.patchingOptions().customRefactorer().or(() -> {
                ScannerSupplier toUse = this.scannerSupplier;
                Set<String> namedCheckers = epOptions.patchingOptions().namedCheckers();
                if (!namedCheckers.isEmpty()) {
                    toUse = this.scannerSupplier.filter((Predicate<? super BugCheckerInfo>)((Predicate)bci -> namedCheckers.contains(bci.canonicalName())));
                }
                return ErrorProneScannerTransformer.create((Scanner)toUse.applyOverrides(epOptions).get());
            })).get();
            analyzer = ErrorProneAnalyzer.createWithCustomDescriptionListener(codeTransformer, epOptions, context, refactoringCollection);
            context.put(RefactoringCollection.class, refactoringCollection);
        } else {
            analyzer = ErrorProneAnalyzer.createByScanningForPlugins(this.scannerSupplier, epOptions, context);
        }
        MultiTaskListener.instance(context).add(analyzer);
        return argv;
    }

    private Main.Result run(String[] argv, Context context) {
        try {
            argv = this.prepareCompilation(argv, context);
        }
        catch (InvalidCommandLineOptionException e) {
            this.errOutput.println(e.getMessage());
            this.errOutput.flush();
            return Main.Result.CMDERR;
        }
        try {
            Main.Result compileResult = new Main(this.compilerName, this.errOutput).compile(argv, context);
            return this.wrapPotentialRefactoringCall(compileResult, context.get(RefactoringCollection.class));
        }
        catch (InvalidCommandLineOptionException e) {
            this.errOutput.println(e.getMessage());
            this.errOutput.flush();
            return Main.Result.CMDERR;
        }
    }

    public Main.Result run(String[] argv, List<JavaFileObject> javaFileObjects) {
        Context context = new Context();
        return this.run(argv, context, null, javaFileObjects, Collections.emptyList());
    }

    public Main.Result run(String[] argv, Context context, JavaFileManager fileManager, List<JavaFileObject> javaFileObjects, Iterable<? extends Processor> processors) {
        try {
            argv = this.prepareCompilation(argv, context);
        }
        catch (InvalidCommandLineOptionException e) {
            this.errOutput.println(e.getMessage());
            this.errOutput.flush();
            return Main.Result.CMDERR;
        }
        JavacTool tool = JavacTool.create();
        JavacTaskImpl task = (JavacTaskImpl)tool.getTask(this.errOutput, fileManager, null, Arrays.asList(argv), null, javaFileObjects, context);
        if (processors != null) {
            task.setProcessors(processors);
        }
        try {
            return this.wrapPotentialRefactoringCall(task.doCall(), context.get(RefactoringCollection.class));
        }
        catch (InvalidCommandLineOptionException e) {
            this.errOutput.println(e.getMessage());
            this.errOutput.flush();
            return Main.Result.CMDERR;
        }
    }

    private Main.Result wrapPotentialRefactoringCall(Main.Result original, @Nullable RefactoringCollection refactoringCollection) {
        if (refactoringCollection == null) {
            return original;
        }
        try {
            RefactoringCollection.RefactoringResult refactoringResult = refactoringCollection.applyChanges();
            if (refactoringResult.type() == RefactoringCollection.RefactoringResultType.CHANGED) {
                this.errOutput.println(refactoringResult.message());
                this.errOutput.flush();
            }
            return original;
        }
        catch (Exception e) {
            this.errOutput.append(e.getMessage());
            this.errOutput.flush();
            return Main.Result.ERROR;
        }
    }

    public static void setupMessageBundle(Context context) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.google.errorprone.errors");
        JavacMessages.instance(context).add(l -> bundle);
    }

    public static class Builder {
        private DiagnosticListener<? super JavaFileObject> diagnosticListener = null;
        private PrintWriter errOutput = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)System.err, Charset.defaultCharset())), true);
        private String compilerName = "javac (with error-prone)";
        private ScannerSupplier scannerSupplier;

        public BaseErrorProneCompiler build() {
            return new BaseErrorProneCompiler(this.compilerName, this.errOutput, this.diagnosticListener, this.scannerSupplier);
        }

        public Builder named(String compilerName) {
            this.compilerName = compilerName;
            return this;
        }

        public Builder redirectOutputTo(PrintWriter errOutput) {
            this.errOutput = errOutput;
            return this;
        }

        public Builder listenToDiagnostics(DiagnosticListener<? super JavaFileObject> listener) {
            this.diagnosticListener = listener;
            return this;
        }

        public Builder report(ScannerSupplier scannerSupplier) {
            this.scannerSupplier = scannerSupplier;
            return this;
        }
    }
}

