/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.scanner;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.errorprone.BugCheckerInfo;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.scanner.InstanceReturningScannerSupplierImpl;
import com.google.errorprone.scanner.Scanner;
import com.google.errorprone.scanner.ScannerSupplierImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckReturnValue;

public abstract class ScannerSupplier
implements Supplier<Scanner> {
    @SafeVarargs
    public static ScannerSupplier fromBugCheckerClasses(Class<? extends BugChecker> ... checkerClasses) {
        return ScannerSupplier.fromBugCheckerClasses(Arrays.asList(checkerClasses));
    }

    private static ImmutableMap<String, BugPattern.SeverityLevel> defaultSeverities(Iterable<BugCheckerInfo> checkers) {
        ImmutableMap.Builder severities = ImmutableMap.builder();
        for (BugCheckerInfo check : checkers) {
            severities.put((Object)check.canonicalName(), (Object)check.defaultSeverity());
        }
        return severities.build();
    }

    public static ScannerSupplier fromBugCheckerClasses(Iterable<Class<? extends BugChecker>> checkers) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Class<? extends BugChecker> checker : checkers) {
            builder.add((Object)BugCheckerInfo.create(checker));
        }
        return ScannerSupplier.fromBugCheckerInfos((Iterable<BugCheckerInfo>)builder.build());
    }

    public static ScannerSupplier fromBugCheckerInfos(Iterable<BugCheckerInfo> checkers) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (BugCheckerInfo checker : checkers) {
            builder.put((Object)checker.canonicalName(), (Object)checker);
        }
        ImmutableBiMap allChecks = builder.build();
        return new ScannerSupplierImpl((ImmutableBiMap<String, BugCheckerInfo>)allChecks, ScannerSupplier.defaultSeverities((Iterable<BugCheckerInfo>)allChecks.values()), (ImmutableSet<String>)ImmutableSet.of());
    }

    public static ScannerSupplier fromScanner(Scanner scanner) {
        return new InstanceReturningScannerSupplierImpl(scanner);
    }

    @VisibleForTesting
    public abstract ImmutableBiMap<String, BugCheckerInfo> getAllChecks();

    public abstract ImmutableSet<BugCheckerInfo> getEnabledChecks();

    public abstract ImmutableMap<String, BugPattern.SeverityLevel> severities();

    protected abstract ImmutableSet<String> disabled();

    @CheckReturnValue
    public ScannerSupplier applyOverrides(ErrorProneOptions errorProneOptions) throws InvalidCommandLineOptionException {
        ImmutableMap<String, ErrorProneOptions.Severity> severityOverrides = errorProneOptions.getSeverityMap();
        if (severityOverrides.isEmpty() && !errorProneOptions.isEnableAllChecks() && !errorProneOptions.isDropErrorsToWarnings()) {
            return this;
        }
        ImmutableBiMap<String, BugCheckerInfo> checks = this.getAllChecks();
        LinkedHashMap<String, BugPattern.SeverityLevel> severities = new LinkedHashMap<String, BugPattern.SeverityLevel>((Map<String, BugPattern.SeverityLevel>)this.severities());
        HashSet<String> disabled = new HashSet<String>((Collection<String>)this.disabled());
        ArrayListMultimap checksByAllNames = ArrayListMultimap.create();
        for (BugCheckerInfo checker : this.getAllChecks().values()) {
            for (String name : checker.allNames()) {
                checksByAllNames.put((Object)name, (Object)checker);
            }
        }
        if (errorProneOptions.isEnableAllChecks()) {
            disabled.forEach(c -> severities.put((String)c, ((BugCheckerInfo)checks.get(c)).defaultSeverity()));
            disabled.clear();
        }
        if (errorProneOptions.isDropErrorsToWarnings()) {
            checksByAllNames.values().stream().filter((? super T c) -> c.defaultSeverity() == BugPattern.SeverityLevel.ERROR && c.suppressibility().disableable()).forEach(c -> severities.put(c.canonicalName(), BugPattern.SeverityLevel.WARNING));
        }
        severityOverrides.forEach((arg_0, arg_1) -> this.lambda$applyOverrides$3((Multimap)checksByAllNames, errorProneOptions, severities, disabled, arg_0, arg_1));
        return new ScannerSupplierImpl(checks, (ImmutableMap<String, BugPattern.SeverityLevel>)ImmutableMap.copyOf(severities), (ImmutableSet<String>)ImmutableSet.copyOf(disabled));
    }

    @CheckReturnValue
    public ScannerSupplier plus(ScannerSupplier other) {
        ImmutableBiMap combinedAllChecks = ImmutableBiMap.builder().putAll(this.getAllChecks()).putAll(other.getAllChecks()).build();
        ImmutableMap combinedSeverities = ImmutableMap.builder().putAll(this.severities()).putAll(other.severities()).build();
        ImmutableSet disabled = ImmutableSet.copyOf((Collection)Sets.union(this.disabled(), other.disabled()));
        return new ScannerSupplierImpl((ImmutableBiMap<String, BugCheckerInfo>)combinedAllChecks, (ImmutableMap<String, BugPattern.SeverityLevel>)combinedSeverities, (ImmutableSet<String>)disabled);
    }

    @CheckReturnValue
    public ScannerSupplier filter(Predicate<? super BugCheckerInfo> predicate) {
        ImmutableSet.Builder disabled = ImmutableSet.builder();
        for (BugCheckerInfo check : this.getAllChecks().values()) {
            if (predicate.apply((Object)check)) continue;
            disabled.add((Object)check.canonicalName());
        }
        return new ScannerSupplierImpl(this.getAllChecks(), this.severities(), (ImmutableSet<String>)disabled.build());
    }

    private /* synthetic */ void lambda$applyOverrides$3(Multimap checksByAllNames, ErrorProneOptions errorProneOptions, Map severities, Set disabled, String checkName, ErrorProneOptions.Severity newSeverity) {
        Collection checksWithName = checksByAllNames.get((Object)checkName);
        if (checksWithName.isEmpty()) {
            if (errorProneOptions.ignoreUnknownChecks()) {
                return;
            }
            throw new InvalidCommandLineOptionException(checkName + " is not a valid checker name");
        }
        block6: for (BugCheckerInfo check : checksWithName) {
            switch (newSeverity) {
                case OFF: {
                    if (!check.suppressibility().disableable()) {
                        throw new InvalidCommandLineOptionException(check.canonicalName() + " may not be disabled");
                    }
                    severities.remove(check.canonicalName());
                    disabled.add(check.canonicalName());
                    continue block6;
                }
                case DEFAULT: {
                    severities.put(check.canonicalName(), check.defaultSeverity());
                    disabled.remove(check.canonicalName());
                    continue block6;
                }
                case WARN: {
                    if (!this.disabled().contains((Object)check.canonicalName()) && !check.suppressibility().disableable() && check.defaultSeverity() == BugPattern.SeverityLevel.ERROR) {
                        throw new InvalidCommandLineOptionException(check.canonicalName() + " is not disableable and may not be demoted to a warning");
                    }
                    severities.put(check.canonicalName(), BugPattern.SeverityLevel.WARNING);
                    disabled.remove(check.canonicalName());
                    continue block6;
                }
                case ERROR: {
                    severities.put(check.canonicalName(), BugPattern.SeverityLevel.ERROR);
                    disabled.remove(check.canonicalName());
                    continue block6;
                }
            }
            throw new IllegalStateException("Unexpected severity level: " + (Object)((Object)newSeverity));
        }
    }
}

