/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.util.ErrorProneToken;
import com.sun.tools.javac.parser.JavaTokenizer;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.parser.UnicodeReader;
import com.sun.tools.javac.util.Context;

public class ErrorProneTokens {
    public static ImmutableList<ErrorProneToken> getTokens(String source, Context context) {
        if (source == null) {
            return ImmutableList.of();
        }
        ScannerFactory fac = ScannerFactory.instance(context);
        char[] buffer = source.toCharArray();
        AccessibleScanner scanner = new AccessibleScanner(fac, new CommentSavingTokenizer(fac, buffer, buffer.length));
        ImmutableList.Builder tokens = ImmutableList.builder();
        do {
            scanner.nextToken();
            tokens.add((Object)new ErrorProneToken(scanner.token()));
        } while (scanner.token().kind != Tokens.TokenKind.EOF);
        return tokens.build();
    }

    static class AccessibleReader
    extends UnicodeReader {
        protected AccessibleReader(ScannerFactory fac, char[] buffer, int length) {
            super(fac, buffer, length);
        }
    }

    static class AccessibleScanner
    extends Scanner {
        protected AccessibleScanner(ScannerFactory fac, JavaTokenizer tokenizer) {
            super(fac, tokenizer);
        }
    }

    static class CommentWithTextAndPosition
    implements Tokens.Comment {
        private final int pos;
        private final int endPos;
        private final AccessibleReader reader;
        private final Tokens.Comment.CommentStyle style;
        private String text = null;

        public CommentWithTextAndPosition(int pos, int endPos, AccessibleReader reader, Tokens.Comment.CommentStyle style) {
            this.pos = pos;
            this.endPos = endPos;
            this.reader = reader;
            this.style = style;
        }

        @Override
        public int getSourcePos(int index) {
            Preconditions.checkArgument((0 <= index && index < this.endPos - this.pos ? 1 : 0) != 0, (String)"Expected %s in the range [0, %s)", (int)index, (int)(this.endPos - this.pos));
            return this.pos + index;
        }

        @Override
        public Tokens.Comment.CommentStyle getStyle() {
            return this.style;
        }

        @Override
        public String getText() {
            String text = this.text;
            if (text == null) {
                this.text = text = new String(this.reader.getRawCharacters());
            }
            return text;
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }

        public String toString() {
            return String.format("Comment: '%s'", this.getText());
        }
    }

    static class CommentSavingTokenizer
    extends JavaTokenizer {
        CommentSavingTokenizer(ScannerFactory fac, char[] buffer, int length) {
            super(fac, buffer, length);
        }

        @Override
        protected Tokens.Comment processComment(int pos, int endPos, Tokens.Comment.CommentStyle style) {
            char[] buf = this.reader.getRawCharacters(pos, endPos);
            return new CommentWithTextAndPosition(pos, endPos, new AccessibleReader(this.fac, buf, buf.length), style);
        }
    }
}

