/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.truth.Correspondence;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class MultimapSubject
extends Subject<MultimapSubject, Multimap<?, ?>> {
    MultimapSubject(FailureStrategy failureStrategy, @Nullable Multimap<?, ?> multimap) {
        super(failureStrategy, multimap);
    }

    public void isEmpty() {
        if (!((Multimap)this.actual()).isEmpty()) {
            this.fail("is empty");
        }
    }

    public void isNotEmpty() {
        if (((Multimap)this.actual()).isEmpty()) {
            this.fail("is not empty");
        }
    }

    public void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize(%s) must be >= 0", (int)expectedSize);
        int actualSize = ((Multimap)this.actual()).size();
        if (actualSize != expectedSize) {
            this.failWithBadResults("has a size of", expectedSize, "is", actualSize);
        }
    }

    public void containsKey(@Nullable Object key) {
        if (!((Multimap)this.actual()).containsKey(key)) {
            this.fail("contains key", key);
        }
    }

    public void doesNotContainKey(@Nullable Object key) {
        if (((Multimap)this.actual()).containsKey(key)) {
            this.fail("does not contain key", key);
        }
    }

    public void containsEntry(@Nullable Object key, @Nullable Object value) {
        if (!((Multimap)this.actual()).containsEntry(key, value)) {
            Map.Entry entry = Maps.immutableEntry((Object)key, (Object)value);
            if (((Multimap)this.actual()).containsKey(key)) {
                this.failWithRawMessage("Not true that %s contains entry <%s>. However, it has a mapping from <%s> to <%s>", this.actualAsString(), entry, key, ((Multimap)this.actual()).asMap().get(key));
            }
            if (((Multimap)this.actual()).containsValue(value)) {
                LinkedHashSet keys = new LinkedHashSet();
                for (Map.Entry actualEntry : ((Multimap)this.actual()).entries()) {
                    if (!Objects.equal(actualEntry.getValue(), (Object)value)) continue;
                    keys.add(actualEntry.getKey());
                }
                this.failWithRawMessage("Not true that %s contains entry <%s>. However, the following keys are mapped to <%s>: %s", this.actualAsString(), entry, value, keys);
            }
            this.fail("contains entry", (Object)Maps.immutableEntry((Object)key, (Object)value));
        }
    }

    public void doesNotContainEntry(@Nullable Object key, @Nullable Object value) {
        if (((Multimap)this.actual()).containsEntry(key, value)) {
            this.fail("does not contain entry", (Object)Maps.immutableEntry((Object)key, (Object)value));
        }
    }

    public IterableSubject valuesForKey(@Nullable Object key) {
        return new IterableValuesForKey(this.failureStrategy, this, key);
    }

    @Override
    public void isEqualTo(@Nullable Object other) {
        if (!Objects.equal(this.actual(), (Object)other)) {
            if (this.actual() instanceof ListMultimap && other instanceof SetMultimap || this.actual() instanceof SetMultimap && other instanceof ListMultimap) {
                String mapType1 = this.actual() instanceof ListMultimap ? "ListMultimap" : "SetMultimap";
                String mapType2 = other instanceof ListMultimap ? "ListMultimap" : "SetMultimap";
                this.failWithRawMessage("Not true that %s %s is equal to %s <%s>. A %s cannot equal a %s if either is non-empty.", mapType1, this.actualAsString(), mapType2, other, mapType1, mapType2);
            } else {
                if (this.actual() instanceof ListMultimap) {
                    this.containsExactlyEntriesIn((Multimap)other).inOrder();
                } else if (this.actual() instanceof SetMultimap) {
                    this.containsExactlyEntriesIn((Multimap)other);
                }
                this.fail("is equal to", other);
            }
        }
    }

    @CanIgnoreReturnValue
    public Ordered containsExactlyEntriesIn(Multimap<?, ?> expectedMultimap) {
        Preconditions.checkNotNull(expectedMultimap, (Object)"expectedMultimap");
        return this.containsExactly("contains exactly", expectedMultimap);
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Ordered containsExactly(Multimap<?, ?> expectedMultimap) {
        return this.containsExactlyEntriesIn(expectedMultimap);
    }

    private Ordered containsExactly(String failVerb, Multimap<?, ?> expectedMultimap) {
        ListMultimap<?, ?> missing = MultimapSubject.difference(expectedMultimap, (Multimap)this.actual());
        ListMultimap<?, ?> extra = MultimapSubject.difference((Multimap)this.actual(), expectedMultimap);
        if (!missing.isEmpty()) {
            if (!extra.isEmpty()) {
                this.failWithRawMessage("Not true that %s %s <%s>. It is missing <%s> and has unexpected items <%s>", this.actualAsString(), failVerb, expectedMultimap, MultimapSubject.countDuplicatesMultimap(missing), MultimapSubject.countDuplicatesMultimap(extra));
            } else {
                this.failWithBadResults(failVerb, expectedMultimap, "is missing", MultimapSubject.countDuplicatesMultimap(missing));
            }
        } else if (!extra.isEmpty()) {
            this.failWithBadResults(failVerb, expectedMultimap, "has unexpected items", MultimapSubject.countDuplicatesMultimap(extra));
        }
        return new MultimapInOrder(expectedMultimap);
    }

    private static <K, V> Collection<V> get(Multimap<K, V> multimap, @Nullable Object key) {
        if (multimap.containsKey(key)) {
            return (Collection)multimap.asMap().get(key);
        }
        return Collections.emptyList();
    }

    private static ListMultimap<?, ?> difference(Multimap<?, ?> minuend, Multimap<?, ?> subtrahend) {
        LinkedListMultimap difference = LinkedListMultimap.create();
        for (Object key : minuend.keySet()) {
            List<?> valDifference = MultimapSubject.difference(Lists.newArrayList(MultimapSubject.get(minuend, key)), Lists.newArrayList(MultimapSubject.get(subtrahend, key)));
            difference.putAll(key, valDifference);
        }
        return difference;
    }

    private static List<?> difference(List<?> minuend, List<?> subtrahend) {
        LinkedHashMultiset remaining = LinkedHashMultiset.create(subtrahend);
        ArrayList difference = Lists.newArrayList();
        for (Object elem : minuend) {
            if (remaining.remove(elem)) continue;
            difference.add(elem);
        }
        return difference;
    }

    private static <K, V> String countDuplicatesMultimap(Multimap<K, V> multimap) {
        ArrayList<String> entries = new ArrayList<String>();
        for (Object key : multimap.keySet()) {
            entries.add(key + "=" + SubjectUtils.countDuplicates(multimap.get(key)));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Joiner.on((String)", ").appendTo(sb, entries);
        sb.append("}");
        return sb.toString();
    }

    public <A, E> UsingCorrespondence<A, E> comparingValuesUsing(Correspondence<A, E> correspondence) {
        return new UsingCorrespondence(correspondence);
    }

    public final class UsingCorrespondence<A, E> {
        private final Correspondence<A, E> correspondence;

        private UsingCorrespondence(Correspondence<A, E> correspondence) {
            this.correspondence = (Correspondence)Preconditions.checkNotNull(correspondence);
        }

        public void containsEntry(@Nullable Object expectedKey, @Nullable E expectedValue) {
            if (((Multimap)MultimapSubject.this.actual()).containsKey(expectedKey)) {
                Collection actualValues = (Collection)this.getCastSubject().asMap().get(expectedKey);
                for (Object actualValue : actualValues) {
                    if (!this.correspondence.compare(actualValue, expectedValue)) continue;
                    return;
                }
                MultimapSubject.this.failWithRawMessage("Not true that %s contains at least one entry with key <%s> and a value that %s <%s>. However, it has a mapping from that key to <%s>", MultimapSubject.this.actualAsString(), expectedKey, this.correspondence, expectedValue, actualValues);
            } else {
                LinkedHashSet keys = new LinkedHashSet();
                for (Map.Entry actualEntry : this.getCastSubject().entries()) {
                    if (!this.correspondence.compare(actualEntry.getValue(), expectedValue)) continue;
                    keys.add(actualEntry.getKey());
                }
                if (!keys.isEmpty()) {
                    MultimapSubject.this.failWithRawMessage("Not true that %s contains at least one entry with key <%s> and a value that %s <%s>. However, the following keys are mapped to such values: <%s>", MultimapSubject.this.actualAsString(), expectedKey, this.correspondence, expectedValue, keys);
                } else {
                    MultimapSubject.this.failWithRawMessage("Not true that %s contains at least one entry with key <%s> and a value that %s <%s>", MultimapSubject.this.actualAsString(), expectedKey, this.correspondence, expectedValue);
                }
            }
        }

        public void doesNotContainEntry(@Nullable Object excludedKey, @Nullable E excludedValue) {
            if (((Multimap)MultimapSubject.this.actual()).containsKey(excludedKey)) {
                Collection actualValues = (Collection)this.getCastSubject().asMap().get(excludedKey);
                ArrayList matchingValues = new ArrayList();
                for (Object actualValue : actualValues) {
                    if (!this.correspondence.compare(actualValue, excludedValue)) continue;
                    matchingValues.add(actualValue);
                }
                if (!matchingValues.isEmpty()) {
                    MultimapSubject.this.failWithRawMessage("Not true that %s did not contain an entry with key <%s> and a value that %s <%s>. It maps that key to the following such values: <%s>", MultimapSubject.this.actualAsString(), excludedKey, this.correspondence, excludedValue, matchingValues);
                }
            }
        }

        @CanIgnoreReturnValue
        private Ordered containsExactlyEntriesIn(Multimap<?, ? extends E> expectedMultimap) {
            throw new UnsupportedOperationException();
        }

        private IterableSubject.UsingCorrespondence<A, E> valuesForKey(@Nullable Object key) {
            throw new UnsupportedOperationException();
        }

        private Multimap<?, A> getCastSubject() {
            return (Multimap)MultimapSubject.this.actual();
        }
    }

    private class MultimapInOrder
    implements Ordered {
        private final Multimap<?, ?> expectedMultimap;

        MultimapInOrder(Multimap<?, ?> expectedMultimap) {
            this.expectedMultimap = expectedMultimap;
        }

        @Override
        public void inOrder() {
            boolean keysInOrder = Lists.newArrayList((Iterable)((Multimap)MultimapSubject.this.actual()).keySet()).equals(Lists.newArrayList((Iterable)this.expectedMultimap.keySet()));
            LinkedHashSet keysWithValuesOutOfOrder = Sets.newLinkedHashSet();
            LinkedHashSet allKeys = Sets.newLinkedHashSet();
            allKeys.addAll(((Multimap)MultimapSubject.this.actual()).keySet());
            allKeys.addAll(this.expectedMultimap.keySet());
            for (Object key : allKeys) {
                ArrayList expectedVals;
                ArrayList actualVals = Lists.newArrayList((Iterable)MultimapSubject.get((Multimap)MultimapSubject.this.actual(), key));
                if (actualVals.equals(expectedVals = Lists.newArrayList((Iterable)MultimapSubject.get(this.expectedMultimap, key)))) continue;
                keysWithValuesOutOfOrder.add(key);
            }
            if (!keysInOrder) {
                if (!keysWithValuesOutOfOrder.isEmpty()) {
                    MultimapSubject.this.failWithRawMessage("Not true that %s contains exactly <%s> in order. The keys are not in order, and the values for keys <%s> are not in order either", MultimapSubject.this.actualAsString(), this.expectedMultimap, keysWithValuesOutOfOrder);
                } else {
                    MultimapSubject.this.failWithRawMessage("Not true that %s contains exactly <%s> in order. The keys are not in order", MultimapSubject.this.actualAsString(), this.expectedMultimap);
                }
            } else if (!keysWithValuesOutOfOrder.isEmpty()) {
                MultimapSubject.this.failWithRawMessage("Not true that %s contains exactly <%s> in order. The values for keys <%s> are not in order", MultimapSubject.this.actualAsString(), this.expectedMultimap, keysWithValuesOutOfOrder);
            }
        }
    }

    private class IterableValuesForKey
    extends IterableSubject {
        @Nullable
        private final Object key;
        @Nullable
        private final String stringRepresentation;

        IterableValuesForKey(FailureStrategy failureStrategy, @Nullable MultimapSubject multimapSubject2, Object key) {
            super(failureStrategy, ((Multimap)multimapSubject2.actual()).get(key));
            this.key = key;
            this.stringRepresentation = multimapSubject2.actualAsString();
        }

        @Override
        protected String actualCustomStringRepresentation() {
            return "Values for key <" + this.key + "> (<" + this.actual() + ">) in " + this.stringRepresentation;
        }
    }
}

