"""

@kylel

"""

import unittest

import json

from mmda.types.annotation import Span, SpanGroup
from mmda.types.document import Document
from mmda.parsers.pdfplumber_parser import PDFPlumberParser
from mmda.predictors.hf_predictors.span_group_classification_predictor import (
    SpanGroupClassificationPredictor
)

TEST_SCIBERT_WEIGHTS = 'allenai/scibert_scivocab_uncased'
# TEST_BIB_PARSER_WEIGHTS = '/Users/kylel/ai2/mmda/stefans/'

TEST_DOC_JSON = {"symbols": "modelling reward . In International Conference on\nLearning Representations ( ICLR ) .\nMarco Baroni ,\nGeorgiana Dinu ,\nand Germ\u00b4an\nKruszewski . 2014 .\nDon\u2019t count , predict !\nA\nsystematic comparison of context - counting vs .\ncontext - predicting semantic vectors . In Proceedings\nof the 52nd Annual Meeting of the Association for\nComputational Linguistics , ACL 2014 , June 22 - 27 ,\n2014 , Baltimore , MD , USA , Volume 1 : Long Papers ,\npages 238 \u2013 247 .\nYoshua Bengio , R\u00b4ejean Ducharme , Pascal Vincent , and\nChristian Janvin . 2003 . A neural probabilistic lan -\nguage model .\nJournal of Machine Learning Re -\nsearch , 3 : 1137 \u2013 1155 .\nAntoine Bordes , Nicolas Usunier , Alberto Garc\u00b4\u0131a -\nDur\u00b4an , Jason Weston , and Oksana Yakhnenko .\n2013 . Translating embeddings for modeling multi -\nrelational data . In Advances in Neural Information\nProcessing Systems 26 : 27th Annual Conference on\nNeural Information Processing Systems 2013 . Pro -\nceedings of a meeting held December 5 - 8 , 2013 ,\nLake Tahoe , Nevada , United States . , pages 2787 \u2013\n2795 .\nS . R . K . Branavan , David Silver , and Regina Barzi -\nlay . 2011 . Learning to win by reading manuals in a\nmonte - carlo framework . In The 49th Annual Meet -\ning of the Association for Computational Linguis -\ntics : Human Language Technologies , Proceedings\nof the Conference , 19 - 24 June , 2011 , Portland , Ore -\ngon , USA , pages 268 \u2013 277 .\nDanqi Chen , Adam Fisch , Jason Weston , and Antoine\nBordes . 2017 . Reading wikipedia to answer open -\ndomain questions . CoRR , abs / 1704 . 00051 .\nMaxime Chevalier - Boisvert ,\nDzmitry\nBahdanau ,\nSalem Lahlou , Lucas Willems , Chitwan Saharia ,\nThien Huu Nguyen , and Yoshua Bengio . 2018 .\nBabyai : First steps towards grounded language\nlearning with a human in the loop .\nCoRR ,\nabs / 1810 . 08272 .\nZihang Dai , Zhilin Yang , Yiming Yang , Jaime G .\nCarbonell , Quoc V . Le , and Ruslan Salakhutdi -\nnov . 2019 .\nTransformer - xl : Attentive language\nmodels beyond a \ufb01xed - length context .\nCoRR ,\nabs / 1901 . 02860 .\nYann N . Dauphin , Angela Fan , Michael Auli , and\nDavid Grangier . 2017 .\nLanguage modeling with\ngated convolutional networks . In Proceedings of the\n34th International Conference on Machine Learn -\ning , ICML 2017 , Sydney , NSW , Australia , 6 - 11 Au -\ngust 2017 , pages 933 \u2013 941 .\nJacob Devlin , Ming - Wei Chang , Kenton Lee , and\nKristina Toutanova . 2018a . BERT : pre - training of\ndeep bidirectional transformers for language under -\nstanding . CoRR , abs / 1810 . 04805 .\nJacob Devlin , Ming - Wei Chang , Kenton Lee , and\nKristina Toutanova . 2018b .\nBERT : Pre - training\nof Deep Bidirectional Transformers for Language\nUnderstanding .\narXiv : 1810 . 04805 [ cs ] .\nArXiv :\n1810 . 04805 .\nHady Elsahar , Pavlos Vougiouklis , Arslen Remaci ,\nChristophe Gravier , Jonathon Hare , Frederique\nLaforest , and Elena Simperl . 2018 . T - rex : A large\nscale alignment of natural language with knowledge\nbase triples . In Proceedings of the Eleventh Interna -\ntional Conference on Language Resources and Eval -\nuation ( LREC - 2018 ) .\nYoav Goldberg . 2019 . Assessing bert\u2019s syntactic abili -\nties . CoRR , abs / 1901 . 05287 .\nFelix Hill , Roi Reichart , and Anna Korhonen . 2015 .\nSimlex - 999 : Evaluating semantic models with ( gen -\nuine ) similarity estimation . Computational Linguis -\ntics , 41 ( 4 ) : 665 \u2013 695 .\nSepp Hochreiter and J\u00a8urgen Schmidhuber . 1997 .\nLong short - term memory .\nNeural Computation ,\n9 ( 8 ) : 1735 \u2013 1780 .\nTom Kwiatkowski , Jennimaria Palomaki , Olivia\nRhinehart , Michael Collins , Ankur Parikh , Chris Al -\nberti , Danielle Epstein , Illia Polosukhin , Matthew\nKelcey , Jacob Devlin , et al . 2019 . Natural questions :\na benchmark for question answering research .\nJelena Luketina , Nantas Nardelli , Gregory Farquhar ,\nJakob Foerster , Jacob Andreas , Edward Grefen -\nstette , Shimon Whiteson , and Tim Rockt\u00a8aschel .\n2019 .\nA Survey of Reinforcement Learning In -\nformed by Natural Language . In Proceedings of\nthe Twenty - Eighth International Joint Conference\non Arti\ufb01cial Intelligence , IJCAI 2019 , August 10 - 16\n2019 , Macao , China .\nRebecca Marvin and Tal Linzen . 2018 . Targeted syn -\ntactic evaluation of language models . In Proceed -\nings of the 2018 Conference on Empirical Methods\nin Natural Language Processing , Brussels , Belgium ,\nOctober 31 - November 4 , 2018 , pages 1192 \u2013 1202 .\nR . Thomas McCoy , Ellie Pavlick , and Tal Linzen .\n2019 . Right for the wrong reasons : Diagnosing syn -\ntactic heuristics in natural language inference .\nG\u00b4abor Melis , Chris Dyer , and Phil Blunsom . 2017 . On\nthe state of the art of evaluation in neural language\nmodels . CoRR , abs / 1707 . 05589 .\nStephen Merity , Caiming Xiong , James Bradbury , and\nRichard Socher . 2016 .\nPointer sentinel mixture\nmodels . CoRR , abs / 1609 . 07843 .\nTomas Mikolov and Geo \ufb00 rey Zweig . 2012 . Context\ndependent recurrent neural network language model .\nIn 2012 IEEE Spoken Language Technology Work -\nshop ( SLT ) , Miami , FL , USA , December 2 - 5 , 2012 ,\npages 234 \u2013 239 .\n", "pages": [{"spans": [{"start": 0, "end": 5056}]}], "tokens": [{"spans": [{"start": 0, "end": 9}]}, {"spans": [{"start": 10, "end": 16}]}, {"spans": [{"start": 17, "end": 18}]}, {"spans": [{"start": 19, "end": 21}]}, {"spans": [{"start": 22, "end": 35}]}, {"spans": [{"start": 36, "end": 46}]}, {"spans": [{"start": 47, "end": 49}]}, {"spans": [{"start": 50, "end": 58}]}, {"spans": [{"start": 59, "end": 74}]}, {"spans": [{"start": 75, "end": 76}]}, {"spans": [{"start": 77, "end": 81}]}, {"spans": [{"start": 82, "end": 83}]}, {"spans": [{"start": 84, "end": 85}]}, {"spans": [{"start": 86, "end": 91}]}, {"spans": [{"start": 92, "end": 98}]}, {"spans": [{"start": 99, "end": 100}]}, {"spans": [{"start": 101, "end": 110}]}, {"spans": [{"start": 111, "end": 115}]}, {"spans": [{"start": 116, "end": 117}]}, {"spans": [{"start": 118, "end": 121}]}, {"spans": [{"start": 122, "end": 129}]}, {"spans": [{"start": 130, "end": 140}]}, {"spans": [{"start": 141, "end": 142}]}, {"spans": [{"start": 143, "end": 147}]}, {"spans": [{"start": 148, "end": 149}]}, {"spans": [{"start": 150, "end": 155}]}, {"spans": [{"start": 156, "end": 161}]}, {"spans": [{"start": 162, "end": 163}]}, {"spans": [{"start": 164, "end": 171}]}, {"spans": [{"start": 172, "end": 173}]}, {"spans": [{"start": 174, "end": 175}]}, {"spans": [{"start": 176, "end": 186}]}, {"spans": [{"start": 187, "end": 197}]}, {"spans": [{"start": 198, "end": 200}]}, {"spans": [{"start": 201, "end": 208}]}, {"spans": [{"start": 209, "end": 210}]}, {"spans": [{"start": 211, "end": 219}]}, {"spans": [{"start": 220, "end": 222}]}, {"spans": [{"start": 223, "end": 224}]}, {"spans": [{"start": 225, "end": 232}]}, {"spans": [{"start": 233, "end": 234}]}, {"spans": [{"start": 235, "end": 245}]}, {"spans": [{"start": 246, "end": 254}]}, {"spans": [{"start": 255, "end": 262}]}, {"spans": [{"start": 263, "end": 264}]}, {"spans": [{"start": 265, "end": 267}]}, {"spans": [{"start": 268, "end": 279}]}, {"spans": [{"start": 280, "end": 282}]}, {"spans": [{"start": 283, "end": 286}]}, {"spans": [{"start": 287, "end": 291}]}, {"spans": [{"start": 292, "end": 298}]}, {"spans": [{"start": 299, "end": 306}]}, {"spans": [{"start": 307, "end": 309}]}, {"spans": [{"start": 310, "end": 313}]}, {"spans": [{"start": 314, "end": 325}]}, {"spans": [{"start": 326, "end": 329}]}, {"spans": [{"start": 330, "end": 343}]}, {"spans": [{"start": 344, "end": 355}]}, {"spans": [{"start": 356, "end": 357}]}, {"spans": [{"start": 358, "end": 361}]}, {"spans": [{"start": 362, "end": 366}]}, {"spans": [{"start": 367, "end": 368}]}, {"spans": [{"start": 369, "end": 373}]}, {"spans": [{"start": 374, "end": 376}]}, {"spans": [{"start": 377, "end": 378}]}, {"spans": [{"start": 379, "end": 381}]}, {"spans": [{"start": 382, "end": 383}]}, {"spans": [{"start": 384, "end": 388}]}, {"spans": [{"start": 389, "end": 390}]}, {"spans": [{"start": 391, "end": 400}]}, {"spans": [{"start": 401, "end": 402}]}, {"spans": [{"start": 403, "end": 405}]}, {"spans": [{"start": 406, "end": 407}]}, {"spans": [{"start": 408, "end": 411}]}, {"spans": [{"start": 412, "end": 413}]}, {"spans": [{"start": 414, "end": 420}]}, {"spans": [{"start": 421, "end": 422}]}, {"spans": [{"start": 423, "end": 424}]}, {"spans": [{"start": 425, "end": 429}]}, {"spans": [{"start": 430, "end": 436}]}, {"spans": [{"start": 437, "end": 438}]}, {"spans": [{"start": 439, "end": 444}]}, {"spans": [{"start": 445, "end": 448}]}, {"spans": [{"start": 449, "end": 450}]}, {"spans": [{"start": 451, "end": 454}]}, {"spans": [{"start": 455, "end": 456}]}, {"spans": [{"start": 457, "end": 463}]}, {"spans": [{"start": 464, "end": 470}]}, {"spans": [{"start": 471, "end": 472}]}, {"spans": [{"start": 473, "end": 480}]}, {"spans": [{"start": 481, "end": 489}]}, {"spans": [{"start": 490, "end": 491}]}, {"spans": [{"start": 492, "end": 498}]}, {"spans": [{"start": 499, "end": 506}]}, {"spans": [{"start": 507, "end": 508}]}, {"spans": [{"start": 509, "end": 512}]}, {"spans": [{"start": 513, "end": 522}]}, {"spans": [{"start": 523, "end": 529}]}, {"spans": [{"start": 530, "end": 531}]}, {"spans": [{"start": 532, "end": 536}]}, {"spans": [{"start": 537, "end": 538}]}, {"spans": [{"start": 539, "end": 540}]}, {"spans": [{"start": 541, "end": 547}]}, {"spans": [{"start": 548, "end": 561}]}, {"spans": [{"start": 562, "end": 565}]}, {"spans": [{"start": 566, "end": 567}]}, {"spans": [{"start": 568, "end": 573}]}, {"spans": [{"start": 574, "end": 579}]}, {"spans": [{"start": 580, "end": 581}]}, {"spans": [{"start": 582, "end": 589}]}, {"spans": [{"start": 590, "end": 592}]}, {"spans": [{"start": 593, "end": 600}]}, {"spans": [{"start": 601, "end": 609}]}, {"spans": [{"start": 610, "end": 612}]}, {"spans": [{"start": 613, "end": 614}]}, {"spans": [{"start": 615, "end": 621}]}, {"spans": [{"start": 622, "end": 623}]}, {"spans": [{"start": 624, "end": 625}]}, {"spans": [{"start": 626, "end": 627}]}, {"spans": [{"start": 628, "end": 632}]}, {"spans": [{"start": 633, "end": 634}]}, {"spans": [{"start": 635, "end": 639}]}, {"spans": [{"start": 640, "end": 641}]}, {"spans": [{"start": 642, "end": 649}]}, {"spans": [{"start": 650, "end": 656}]}, {"spans": [{"start": 657, "end": 658}]}, {"spans": [{"start": 659, "end": 666}]}, {"spans": [{"start": 667, "end": 674}]}, {"spans": [{"start": 675, "end": 676}]}, {"spans": [{"start": 677, "end": 684}]}, {"spans": [{"start": 685, "end": 692}]}, {"spans": [{"start": 693, "end": 694}]}, {"spans": [{"start": 695, "end": 701}]}, {"spans": [{"start": 702, "end": 703}]}, {"spans": [{"start": 704, "end": 709}]}, {"spans": [{"start": 710, "end": 716}]}, {"spans": [{"start": 717, "end": 718}]}, {"spans": [{"start": 719, "end": 722}]}, {"spans": [{"start": 723, "end": 729}]}, {"spans": [{"start": 730, "end": 739}]}, {"spans": [{"start": 740, "end": 741}]}, {"spans": [{"start": 742, "end": 746}]}, {"spans": [{"start": 747, "end": 748}]}, {"spans": [{"start": 749, "end": 760}]}, {"spans": [{"start": 761, "end": 771}]}, {"spans": [{"start": 772, "end": 775}]}, {"spans": [{"start": 776, "end": 784}]}, {"spans": [{"start": 785, "end": 790}]}, {"spans": [{"start": 791, "end": 792}]}, {"spans": [{"start": 793, "end": 803}]}, {"spans": [{"start": 804, "end": 808}]}, {"spans": [{"start": 809, "end": 810}]}, {"spans": [{"start": 811, "end": 813}]}, {"spans": [{"start": 814, "end": 822}]}, {"spans": [{"start": 823, "end": 825}]}, {"spans": [{"start": 826, "end": 832}]}, {"spans": [{"start": 833, "end": 844}]}, {"spans": [{"start": 845, "end": 855}]}, {"spans": [{"start": 856, "end": 863}]}, {"spans": [{"start": 864, "end": 866}]}, {"spans": [{"start": 867, "end": 868}]}, {"spans": [{"start": 869, "end": 873}]}, {"spans": [{"start": 874, "end": 880}]}, {"spans": [{"start": 881, "end": 891}]}, {"spans": [{"start": 892, "end": 894}]}, {"spans": [{"start": 895, "end": 901}]}, {"spans": [{"start": 902, "end": 913}]}, {"spans": [{"start": 914, "end": 924}]}, {"spans": [{"start": 925, "end": 932}]}, {"spans": [{"start": 933, "end": 937}]}, {"spans": [{"start": 938, "end": 939}]}, {"spans": [{"start": 940, "end": 943}]}, {"spans": [{"start": 944, "end": 945}]}, {"spans": [{"start": 946, "end": 954}]}, {"spans": [{"start": 955, "end": 957}]}, {"spans": [{"start": 958, "end": 959}]}, {"spans": [{"start": 960, "end": 967}]}, {"spans": [{"start": 968, "end": 972}]}, {"spans": [{"start": 973, "end": 981}]}, {"spans": [{"start": 982, "end": 983}]}, {"spans": [{"start": 984, "end": 985}]}, {"spans": [{"start": 986, "end": 987}]}, {"spans": [{"start": 988, "end": 989}]}, {"spans": [{"start": 990, "end": 994}]}, {"spans": [{"start": 995, "end": 996}]}, {"spans": [{"start": 997, "end": 1001}]}, {"spans": [{"start": 1002, "end": 1007}]}, {"spans": [{"start": 1008, "end": 1009}]}, {"spans": [{"start": 1010, "end": 1016}]}, {"spans": [{"start": 1017, "end": 1018}]}, {"spans": [{"start": 1019, "end": 1025}]}, {"spans": [{"start": 1026, "end": 1032}]}, {"spans": [{"start": 1033, "end": 1034}]}, {"spans": [{"start": 1035, "end": 1036}]}, {"spans": [{"start": 1037, "end": 1042}]}, {"spans": [{"start": 1043, "end": 1047}]}, {"spans": [{"start": 1048, "end": 1049}]}, {"spans": [{"start": 1050, "end": 1054}]}, {"spans": [{"start": 1055, "end": 1056}]}, {"spans": [{"start": 1057, "end": 1058}]}, {"spans": [{"start": 1059, "end": 1060}]}, {"spans": [{"start": 1061, "end": 1062}]}, {"spans": [{"start": 1063, "end": 1064}]}, {"spans": [{"start": 1065, "end": 1066}]}, {"spans": [{"start": 1067, "end": 1068}]}, {"spans": [{"start": 1069, "end": 1077}]}, {"spans": [{"start": 1078, "end": 1079}]}, {"spans": [{"start": 1080, "end": 1085}]}, {"spans": [{"start": 1086, "end": 1092}]}, {"spans": [{"start": 1093, "end": 1094}]}, {"spans": [{"start": 1095, "end": 1098}]}, {"spans": [{"start": 1099, "end": 1105}]}, {"spans": [{"start": 1106, "end": 1111}]}, {"spans": [{"start": 1112, "end": 1113}]}, {"spans": [{"start": 1114, "end": 1117}]}, {"spans": [{"start": 1118, "end": 1119}]}, {"spans": [{"start": 1120, "end": 1124}]}, {"spans": [{"start": 1125, "end": 1126}]}, {"spans": [{"start": 1127, "end": 1135}]}, {"spans": [{"start": 1136, "end": 1138}]}, {"spans": [{"start": 1139, "end": 1142}]}, {"spans": [{"start": 1143, "end": 1145}]}, {"spans": [{"start": 1146, "end": 1153}]}, {"spans": [{"start": 1154, "end": 1161}]}, {"spans": [{"start": 1162, "end": 1164}]}, {"spans": [{"start": 1165, "end": 1166}]}, {"spans": [{"start": 1167, "end": 1172}]}, {"spans": [{"start": 1173, "end": 1174}]}, {"spans": [{"start": 1175, "end": 1180}]}, {"spans": [{"start": 1181, "end": 1190}]}, {"spans": [{"start": 1191, "end": 1192}]}, {"spans": [{"start": 1193, "end": 1195}]}, {"spans": [{"start": 1196, "end": 1199}]}, {"spans": [{"start": 1200, "end": 1204}]}, {"spans": [{"start": 1205, "end": 1211}]}, {"spans": [{"start": 1212, "end": 1216}]}, {"spans": [{"start": 1217, "end": 1218}]}, {"spans": [{"start": 1219, "end": 1222}]}, {"spans": [{"start": 1223, "end": 1225}]}, {"spans": [{"start": 1226, "end": 1229}]}, {"spans": [{"start": 1230, "end": 1241}]}, {"spans": [{"start": 1242, "end": 1245}]}, {"spans": [{"start": 1246, "end": 1259}]}, {"spans": [{"start": 1260, "end": 1267}]}, {"spans": [{"start": 1268, "end": 1269}]}, {"spans": [{"start": 1270, "end": 1274}]}, {"spans": [{"start": 1275, "end": 1276}]}, {"spans": [{"start": 1277, "end": 1282}]}, {"spans": [{"start": 1283, "end": 1291}]}, {"spans": [{"start": 1292, "end": 1304}]}, {"spans": [{"start": 1305, "end": 1306}]}, {"spans": [{"start": 1307, "end": 1318}]}, {"spans": [{"start": 1319, "end": 1321}]}, {"spans": [{"start": 1322, "end": 1325}]}, {"spans": [{"start": 1326, "end": 1336}]}, {"spans": [{"start": 1337, "end": 1338}]}, {"spans": [{"start": 1339, "end": 1341}]}, {"spans": [{"start": 1342, "end": 1343}]}, {"spans": [{"start": 1344, "end": 1346}]}, {"spans": [{"start": 1347, "end": 1351}]}, {"spans": [{"start": 1352, "end": 1353}]}, {"spans": [{"start": 1354, "end": 1358}]}, {"spans": [{"start": 1359, "end": 1360}]}, {"spans": [{"start": 1361, "end": 1369}]}, {"spans": [{"start": 1370, "end": 1371}]}, {"spans": [{"start": 1372, "end": 1375}]}, {"spans": [{"start": 1376, "end": 1377}]}, {"spans": [{"start": 1378, "end": 1381}]}, {"spans": [{"start": 1382, "end": 1383}]}, {"spans": [{"start": 1384, "end": 1387}]}, {"spans": [{"start": 1388, "end": 1389}]}, {"spans": [{"start": 1390, "end": 1395}]}, {"spans": [{"start": 1396, "end": 1399}]}, {"spans": [{"start": 1400, "end": 1401}]}, {"spans": [{"start": 1402, "end": 1405}]}, {"spans": [{"start": 1406, "end": 1407}]}, {"spans": [{"start": 1408, "end": 1413}]}, {"spans": [{"start": 1414, "end": 1418}]}, {"spans": [{"start": 1419, "end": 1420}]}, {"spans": [{"start": 1421, "end": 1425}]}, {"spans": [{"start": 1426, "end": 1431}]}, {"spans": [{"start": 1432, "end": 1433}]}, {"spans": [{"start": 1434, "end": 1439}]}, {"spans": [{"start": 1440, "end": 1446}]}, {"spans": [{"start": 1447, "end": 1448}]}, {"spans": [{"start": 1449, "end": 1452}]}, {"spans": [{"start": 1453, "end": 1460}]}, {"spans": [{"start": 1461, "end": 1467}]}, {"spans": [{"start": 1468, "end": 1469}]}, {"spans": [{"start": 1470, "end": 1474}]}, {"spans": [{"start": 1475, "end": 1476}]}, {"spans": [{"start": 1477, "end": 1484}]}, {"spans": [{"start": 1485, "end": 1494}]}, {"spans": [{"start": 1495, "end": 1497}]}, {"spans": [{"start": 1498, "end": 1504}]}, {"spans": [{"start": 1505, "end": 1509}]}, {"spans": [{"start": 1510, "end": 1511}]}, {"spans": [{"start": 1512, "end": 1518}]}, {"spans": [{"start": 1519, "end": 1528}]}, {"spans": [{"start": 1529, "end": 1530}]}, {"spans": [{"start": 1531, "end": 1535}]}, {"spans": [{"start": 1536, "end": 1537}]}, {"spans": [{"start": 1538, "end": 1541}]}, {"spans": [{"start": 1542, "end": 1543}]}, {"spans": [{"start": 1544, "end": 1548}]}, {"spans": [{"start": 1549, "end": 1550}]}, {"spans": [{"start": 1551, "end": 1556}]}, {"spans": [{"start": 1557, "end": 1558}]}, {"spans": [{"start": 1559, "end": 1565}]}, {"spans": [{"start": 1566, "end": 1575}]}, {"spans": [{"start": 1576, "end": 1577}]}, {"spans": [{"start": 1578, "end": 1586}]}, {"spans": [{"start": 1587, "end": 1588}]}, {"spans": [{"start": 1589, "end": 1596}]}, {"spans": [{"start": 1597, "end": 1605}]}, {"spans": [{"start": 1606, "end": 1607}]}, {"spans": [{"start": 1608, "end": 1613}]}, {"spans": [{"start": 1614, "end": 1620}]}, {"spans": [{"start": 1621, "end": 1622}]}, {"spans": [{"start": 1623, "end": 1628}]}, {"spans": [{"start": 1629, "end": 1636}]}, {"spans": [{"start": 1637, "end": 1638}]}, {"spans": [{"start": 1639, "end": 1646}]}, {"spans": [{"start": 1647, "end": 1654}]}, {"spans": [{"start": 1655, "end": 1656}]}, {"spans": [{"start": 1657, "end": 1662}]}, {"spans": [{"start": 1663, "end": 1666}]}, {"spans": [{"start": 1667, "end": 1673}]}, {"spans": [{"start": 1674, "end": 1675}]}, {"spans": [{"start": 1676, "end": 1679}]}, {"spans": [{"start": 1680, "end": 1686}]}, {"spans": [{"start": 1687, "end": 1693}]}, {"spans": [{"start": 1694, "end": 1695}]}, {"spans": [{"start": 1696, "end": 1700}]}, {"spans": [{"start": 1701, "end": 1702}]}, {"spans": [{"start": 1703, "end": 1709}]}, {"spans": [{"start": 1710, "end": 1711}]}, {"spans": [{"start": 1712, "end": 1717}]}, {"spans": [{"start": 1718, "end": 1723}]}, {"spans": [{"start": 1724, "end": 1731}]}, {"spans": [{"start": 1732, "end": 1740}]}, {"spans": [{"start": 1741, "end": 1749}]}, {"spans": [{"start": 1750, "end": 1758}]}, {"spans": [{"start": 1759, "end": 1763}]}, {"spans": [{"start": 1764, "end": 1765}]}, {"spans": [{"start": 1766, "end": 1771}]}, {"spans": [{"start": 1772, "end": 1774}]}, {"spans": [{"start": 1775, "end": 1778}]}, {"spans": [{"start": 1779, "end": 1783}]}, {"spans": [{"start": 1784, "end": 1785}]}, {"spans": [{"start": 1786, "end": 1790}]}, {"spans": [{"start": 1791, "end": 1792}]}, {"spans": [{"start": 1793, "end": 1796}]}, {"spans": [{"start": 1797, "end": 1798}]}, {"spans": [{"start": 1799, "end": 1803}]}, {"spans": [{"start": 1804, "end": 1805}]}, {"spans": [{"start": 1806, "end": 1811}]}, {"spans": [{"start": 1812, "end": 1813}]}, {"spans": [{"start": 1814, "end": 1820}]}, {"spans": [{"start": 1821, "end": 1824}]}, {"spans": [{"start": 1825, "end": 1826}]}, {"spans": [{"start": 1827, "end": 1833}]}, {"spans": [{"start": 1834, "end": 1838}]}, {"spans": [{"start": 1839, "end": 1840}]}, {"spans": [{"start": 1841, "end": 1847}]}, {"spans": [{"start": 1848, "end": 1852}]}, {"spans": [{"start": 1853, "end": 1854}]}, {"spans": [{"start": 1855, "end": 1860}]}, {"spans": [{"start": 1861, "end": 1862}]}, {"spans": [{"start": 1863, "end": 1864}]}, {"spans": [{"start": 1865, "end": 1874}]}, {"spans": [{"start": 1875, "end": 1876}]}, {"spans": [{"start": 1877, "end": 1881}]}, {"spans": [{"start": 1882, "end": 1883}]}, {"spans": [{"start": 1884, "end": 1885}]}, {"spans": [{"start": 1886, "end": 1888}]}, {"spans": [{"start": 1889, "end": 1890}]}, {"spans": [{"start": 1891, "end": 1894}]}, {"spans": [{"start": 1895, "end": 1901}]}, {"spans": [{"start": 1902, "end": 1912}]}, {"spans": [{"start": 1913, "end": 1914}]}, {"spans": [{"start": 1915, "end": 1918}]}, {"spans": [{"start": 1919, "end": 1920}]}, {"spans": [{"start": 1921, "end": 1925}]}, {"spans": [{"start": 1926, "end": 1927}]}, {"spans": [{"start": 1928, "end": 1939}]}, {"spans": [{"start": 1940, "end": 1941}]}, {"spans": [{"start": 1942, "end": 1944}]}, {"spans": [{"start": 1945, "end": 1946}]}, {"spans": [{"start": 1947, "end": 1956}]}, {"spans": [{"start": 1957, "end": 1965}]}, {"spans": [{"start": 1966, "end": 1972}]}, {"spans": [{"start": 1973, "end": 1979}]}, {"spans": [{"start": 1980, "end": 1981}]}, {"spans": [{"start": 1982, "end": 1986}]}, {"spans": [{"start": 1987, "end": 1988}]}, {"spans": [{"start": 1989, "end": 1995}]}, {"spans": [{"start": 1996, "end": 2003}]}, {"spans": [{"start": 2004, "end": 2005}]}, {"spans": [{"start": 2006, "end": 2010}]}, {"spans": [{"start": 2011, "end": 2012}]}, {"spans": [{"start": 2013, "end": 2016}]}, {"spans": [{"start": 2017, "end": 2018}]}, {"spans": [{"start": 2019, "end": 2023}]}, {"spans": [{"start": 2024, "end": 2025}]}, {"spans": [{"start": 2026, "end": 2031}]}, {"spans": [{"start": 2032, "end": 2033}]}, {"spans": [{"start": 2034, "end": 2038}]}, {"spans": [{"start": 2039, "end": 2040}]}, {"spans": [{"start": 2041, "end": 2042}]}, {"spans": [{"start": 2043, "end": 2050}]}, {"spans": [{"start": 2051, "end": 2052}]}, {"spans": [{"start": 2053, "end": 2059}]}, {"spans": [{"start": 2060, "end": 2063}]}, {"spans": [{"start": 2064, "end": 2065}]}, {"spans": [{"start": 2066, "end": 2073}]}, {"spans": [{"start": 2074, "end": 2078}]}, {"spans": [{"start": 2079, "end": 2080}]}, {"spans": [{"start": 2081, "end": 2084}]}, {"spans": [{"start": 2085, "end": 2090}]}, {"spans": [{"start": 2091, "end": 2099}]}, {"spans": [{"start": 2100, "end": 2101}]}, {"spans": [{"start": 2102, "end": 2106}]}, {"spans": [{"start": 2107, "end": 2108}]}, {"spans": [{"start": 2109, "end": 2117}]}, {"spans": [{"start": 2118, "end": 2126}]}, {"spans": [{"start": 2127, "end": 2131}]}, {"spans": [{"start": 2132, "end": 2137}]}, {"spans": [{"start": 2138, "end": 2151}]}, {"spans": [{"start": 2152, "end": 2160}]}, {"spans": [{"start": 2161, "end": 2162}]}, {"spans": [{"start": 2163, "end": 2165}]}, {"spans": [{"start": 2166, "end": 2177}]}, {"spans": [{"start": 2178, "end": 2180}]}, {"spans": [{"start": 2181, "end": 2184}]}, {"spans": [{"start": 2185, "end": 2189}]}, {"spans": [{"start": 2190, "end": 2203}]}, {"spans": [{"start": 2204, "end": 2214}]}, {"spans": [{"start": 2215, "end": 2217}]}, {"spans": [{"start": 2218, "end": 2225}]}, {"spans": [{"start": 2226, "end": 2231}]}, {"spans": [{"start": 2232, "end": 2233}]}, {"spans": [{"start": 2234, "end": 2237}]}, {"spans": [{"start": 2238, "end": 2239}]}, {"spans": [{"start": 2240, "end": 2244}]}, {"spans": [{"start": 2245, "end": 2249}]}, {"spans": [{"start": 2250, "end": 2251}]}, {"spans": [{"start": 2252, "end": 2258}]}, {"spans": [{"start": 2259, "end": 2260}]}, {"spans": [{"start": 2261, "end": 2264}]}, {"spans": [{"start": 2265, "end": 2266}]}, {"spans": [{"start": 2267, "end": 2276}]}, {"spans": [{"start": 2277, "end": 2278}]}, {"spans": [{"start": 2279, "end": 2280}]}, {"spans": [{"start": 2281, "end": 2282}]}, {"spans": [{"start": 2283, "end": 2285}]}, {"spans": [{"start": 2286, "end": 2288}]}, {"spans": [{"start": 2289, "end": 2290}]}, {"spans": [{"start": 2291, "end": 2295}]}, {"spans": [{"start": 2296, "end": 2300}]}, {"spans": [{"start": 2301, "end": 2302}]}, {"spans": [{"start": 2303, "end": 2308}]}, {"spans": [{"start": 2309, "end": 2312}]}, {"spans": [{"start": 2313, "end": 2314}]}, {"spans": [{"start": 2315, "end": 2318}]}, {"spans": [{"start": 2319, "end": 2320}]}, {"spans": [{"start": 2321, "end": 2326}]}, {"spans": [{"start": 2327, "end": 2333}]}, {"spans": [{"start": 2334, "end": 2335}]}, {"spans": [{"start": 2336, "end": 2340}]}, {"spans": [{"start": 2341, "end": 2342}]}, {"spans": [{"start": 2343, "end": 2346}]}, {"spans": [{"start": 2347, "end": 2352}]}, {"spans": [{"start": 2353, "end": 2354}]}, {"spans": [{"start": 2355, "end": 2361}]}, {"spans": [{"start": 2362, "end": 2365}]}, {"spans": [{"start": 2366, "end": 2367}]}, {"spans": [{"start": 2368, "end": 2371}]}, {"spans": [{"start": 2372, "end": 2380}]}, {"spans": [{"start": 2381, "end": 2390}]}, {"spans": [{"start": 2391, "end": 2392}]}, {"spans": [{"start": 2393, "end": 2398}]}, {"spans": [{"start": 2399, "end": 2400}]}, {"spans": [{"start": 2401, "end": 2405}]}, {"spans": [{"start": 2406, "end": 2407}]}, {"spans": [{"start": 2408, "end": 2411}]}, {"spans": [{"start": 2412, "end": 2413}]}, {"spans": [{"start": 2414, "end": 2422}]}, {"spans": [{"start": 2423, "end": 2425}]}, {"spans": [{"start": 2426, "end": 2430}]}, {"spans": [{"start": 2431, "end": 2444}]}, {"spans": [{"start": 2445, "end": 2457}]}, {"spans": [{"start": 2458, "end": 2461}]}, {"spans": [{"start": 2462, "end": 2470}]}, {"spans": [{"start": 2471, "end": 2476}]}, {"spans": [{"start": 2477, "end": 2478}]}, {"spans": [{"start": 2479, "end": 2487}]}, {"spans": [{"start": 2488, "end": 2489}]}, {"spans": [{"start": 2490, "end": 2494}]}, {"spans": [{"start": 2495, "end": 2496}]}, {"spans": [{"start": 2497, "end": 2500}]}, {"spans": [{"start": 2501, "end": 2502}]}, {"spans": [{"start": 2503, "end": 2507}]}, {"spans": [{"start": 2508, "end": 2509}]}, {"spans": [{"start": 2510, "end": 2515}]}, {"spans": [{"start": 2516, "end": 2517}]}, {"spans": [{"start": 2518, "end": 2523}]}, {"spans": [{"start": 2524, "end": 2530}]}, {"spans": [{"start": 2531, "end": 2532}]}, {"spans": [{"start": 2533, "end": 2537}]}, {"spans": [{"start": 2538, "end": 2539}]}, {"spans": [{"start": 2540, "end": 2543}]}, {"spans": [{"start": 2544, "end": 2549}]}, {"spans": [{"start": 2550, "end": 2551}]}, {"spans": [{"start": 2552, "end": 2558}]}, {"spans": [{"start": 2559, "end": 2562}]}, {"spans": [{"start": 2563, "end": 2564}]}, {"spans": [{"start": 2565, "end": 2568}]}, {"spans": [{"start": 2569, "end": 2577}]}, {"spans": [{"start": 2578, "end": 2587}]}, {"spans": [{"start": 2588, "end": 2589}]}, {"spans": [{"start": 2590, "end": 2595}]}, {"spans": [{"start": 2596, "end": 2597}]}, {"spans": [{"start": 2598, "end": 2602}]}, {"spans": [{"start": 2603, "end": 2604}]}, {"spans": [{"start": 2605, "end": 2608}]}, {"spans": [{"start": 2609, "end": 2610}]}, {"spans": [{"start": 2611, "end": 2619}]}, {"spans": [{"start": 2620, "end": 2622}]}, {"spans": [{"start": 2623, "end": 2627}]}, {"spans": [{"start": 2628, "end": 2641}]}, {"spans": [{"start": 2642, "end": 2654}]}, {"spans": [{"start": 2655, "end": 2658}]}, {"spans": [{"start": 2659, "end": 2667}]}, {"spans": [{"start": 2668, "end": 2681}]}, {"spans": [{"start": 2682, "end": 2683}]}, {"spans": [{"start": 2684, "end": 2689}]}, {"spans": [{"start": 2690, "end": 2691}]}, {"spans": [{"start": 2692, "end": 2696}]}, {"spans": [{"start": 2697, "end": 2698}]}, {"spans": [{"start": 2699, "end": 2704}]}, {"spans": [{"start": 2705, "end": 2706}]}, {"spans": [{"start": 2707, "end": 2709}]}, {"spans": [{"start": 2710, "end": 2711}]}, {"spans": [{"start": 2712, "end": 2713}]}, {"spans": [{"start": 2714, "end": 2719}]}, {"spans": [{"start": 2720, "end": 2721}]}, {"spans": [{"start": 2722, "end": 2726}]}, {"spans": [{"start": 2727, "end": 2728}]}, {"spans": [{"start": 2729, "end": 2734}]}, {"spans": [{"start": 2735, "end": 2736}]}, {"spans": [{"start": 2737, "end": 2741}]}, {"spans": [{"start": 2742, "end": 2749}]}, {"spans": [{"start": 2750, "end": 2751}]}, {"spans": [{"start": 2752, "end": 2758}]}, {"spans": [{"start": 2759, "end": 2770}]}, {"spans": [{"start": 2771, "end": 2772}]}, {"spans": [{"start": 2773, "end": 2779}]}, {"spans": [{"start": 2780, "end": 2786}]}, {"spans": [{"start": 2787, "end": 2788}]}, {"spans": [{"start": 2789, "end": 2799}]}, {"spans": [{"start": 2800, "end": 2807}]}, {"spans": [{"start": 2808, "end": 2809}]}, {"spans": [{"start": 2810, "end": 2818}]}, {"spans": [{"start": 2819, "end": 2823}]}, {"spans": [{"start": 2824, "end": 2825}]}, {"spans": [{"start": 2826, "end": 2836}]}, {"spans": [{"start": 2837, "end": 2845}]}, {"spans": [{"start": 2846, "end": 2847}]}, {"spans": [{"start": 2848, "end": 2851}]}, {"spans": [{"start": 2852, "end": 2857}]}, {"spans": [{"start": 2858, "end": 2865}]}, {"spans": [{"start": 2866, "end": 2867}]}, {"spans": [{"start": 2868, "end": 2872}]}, {"spans": [{"start": 2873, "end": 2874}]}, {"spans": [{"start": 2875, "end": 2876}]}, {"spans": [{"start": 2877, "end": 2878}]}, {"spans": [{"start": 2879, "end": 2882}]}, {"spans": [{"start": 2883, "end": 2884}]}, {"spans": [{"start": 2885, "end": 2886}]}, {"spans": [{"start": 2887, "end": 2892}]}, {"spans": [{"start": 2893, "end": 2898}]}, {"spans": [{"start": 2899, "end": 2908}]}, {"spans": [{"start": 2909, "end": 2911}]}, {"spans": [{"start": 2912, "end": 2919}]}, {"spans": [{"start": 2920, "end": 2928}]}, {"spans": [{"start": 2929, "end": 2933}]}, {"spans": [{"start": 2934, "end": 2943}]}, {"spans": [{"start": 2944, "end": 2948}]}, {"spans": [{"start": 2949, "end": 2956}]}, {"spans": [{"start": 2957, "end": 2958}]}, {"spans": [{"start": 2959, "end": 2961}]}, {"spans": [{"start": 2962, "end": 2973}]}, {"spans": [{"start": 2974, "end": 2976}]}, {"spans": [{"start": 2977, "end": 2980}]}, {"spans": [{"start": 2981, "end": 2989}]}, {"spans": [{"start": 2990, "end": 2997}]}, {"spans": [{"start": 2998, "end": 2999}]}, {"spans": [{"start": 3000, "end": 3006}]}, {"spans": [{"start": 3007, "end": 3017}]}, {"spans": [{"start": 3018, "end": 3020}]}, {"spans": [{"start": 3021, "end": 3029}]}, {"spans": [{"start": 3030, "end": 3039}]}, {"spans": [{"start": 3040, "end": 3043}]}, {"spans": [{"start": 3044, "end": 3048}]}, {"spans": [{"start": 3049, "end": 3050}]}, {"spans": [{"start": 3051, "end": 3057}]}, {"spans": [{"start": 3058, "end": 3059}]}, {"spans": [{"start": 3060, "end": 3064}]}, {"spans": [{"start": 3065, "end": 3066}]}, {"spans": [{"start": 3067, "end": 3071}]}, {"spans": [{"start": 3072, "end": 3073}]}, {"spans": [{"start": 3074, "end": 3075}]}, {"spans": [{"start": 3076, "end": 3080}]}, {"spans": [{"start": 3081, "end": 3089}]}, {"spans": [{"start": 3090, "end": 3091}]}, {"spans": [{"start": 3092, "end": 3096}]}, {"spans": [{"start": 3097, "end": 3098}]}, {"spans": [{"start": 3099, "end": 3108}]}, {"spans": [{"start": 3109, "end": 3115}]}, {"spans": [{"start": 3116, "end": 3125}]}, {"spans": [{"start": 3126, "end": 3131}]}, {"spans": [{"start": 3132, "end": 3133}]}, {"spans": [{"start": 3134, "end": 3138}]}, {"spans": [{"start": 3139, "end": 3140}]}, {"spans": [{"start": 3141, "end": 3145}]}, {"spans": [{"start": 3146, "end": 3147}]}, {"spans": [{"start": 3148, "end": 3151}]}, {"spans": [{"start": 3152, "end": 3153}]}, {"spans": [{"start": 3154, "end": 3158}]}, {"spans": [{"start": 3159, "end": 3160}]}, {"spans": [{"start": 3161, "end": 3166}]}, {"spans": [{"start": 3167, "end": 3168}]}, {"spans": [{"start": 3169, "end": 3174}]}, {"spans": [{"start": 3175, "end": 3179}]}, {"spans": [{"start": 3180, "end": 3181}]}, {"spans": [{"start": 3182, "end": 3185}]}, {"spans": [{"start": 3186, "end": 3194}]}, {"spans": [{"start": 3195, "end": 3196}]}, {"spans": [{"start": 3197, "end": 3200}]}, {"spans": [{"start": 3201, "end": 3205}]}, {"spans": [{"start": 3206, "end": 3214}]}, {"spans": [{"start": 3215, "end": 3216}]}, {"spans": [{"start": 3217, "end": 3221}]}, {"spans": [{"start": 3222, "end": 3223}]}, {"spans": [{"start": 3224, "end": 3230}]}, {"spans": [{"start": 3231, "end": 3232}]}, {"spans": [{"start": 3233, "end": 3236}]}, {"spans": [{"start": 3237, "end": 3238}]}, {"spans": [{"start": 3239, "end": 3249}]}, {"spans": [{"start": 3250, "end": 3258}]}, {"spans": [{"start": 3259, "end": 3265}]}, {"spans": [{"start": 3266, "end": 3270}]}, {"spans": [{"start": 3271, "end": 3272}]}, {"spans": [{"start": 3273, "end": 3276}]}, {"spans": [{"start": 3277, "end": 3278}]}, {"spans": [{"start": 3279, "end": 3283}]}, {"spans": [{"start": 3284, "end": 3285}]}, {"spans": [{"start": 3286, "end": 3296}]}, {"spans": [{"start": 3297, "end": 3307}]}, {"spans": [{"start": 3308, "end": 3309}]}, {"spans": [{"start": 3310, "end": 3323}]}, {"spans": [{"start": 3324, "end": 3331}]}, {"spans": [{"start": 3332, "end": 3333}]}, {"spans": [{"start": 3334, "end": 3338}]}, {"spans": [{"start": 3339, "end": 3340}]}, {"spans": [{"start": 3341, "end": 3343}]}, {"spans": [{"start": 3344, "end": 3345}]}, {"spans": [{"start": 3346, "end": 3347}]}, {"spans": [{"start": 3348, "end": 3349}]}, {"spans": [{"start": 3350, "end": 3351}]}, {"spans": [{"start": 3352, "end": 3355}]}, {"spans": [{"start": 3356, "end": 3357}]}, {"spans": [{"start": 3358, "end": 3361}]}, {"spans": [{"start": 3362, "end": 3363}]}, {"spans": [{"start": 3364, "end": 3368}]}, {"spans": [{"start": 3369, "end": 3379}]}, {"spans": [{"start": 3380, "end": 3383}]}, {"spans": [{"start": 3384, "end": 3391}]}, {"spans": [{"start": 3392, "end": 3403}]}, {"spans": [{"start": 3404, "end": 3405}]}, {"spans": [{"start": 3406, "end": 3410}]}, {"spans": [{"start": 3411, "end": 3412}]}, {"spans": [{"start": 3413, "end": 3417}]}, {"spans": [{"start": 3418, "end": 3423}]}, {"spans": [{"start": 3424, "end": 3425}]}, {"spans": [{"start": 3426, "end": 3430}]}, {"spans": [{"start": 3431, "end": 3437}]}, {"spans": [{"start": 3438, "end": 3439}]}, {"spans": [{"start": 3440, "end": 3446}]}, {"spans": [{"start": 3447, "end": 3458}]}, {"spans": [{"start": 3459, "end": 3460}]}, {"spans": [{"start": 3461, "end": 3462}]}, {"spans": [{"start": 3463, "end": 3464}]}, {"spans": [{"start": 3465, "end": 3466}]}, {"spans": [{"start": 3467, "end": 3468}]}, {"spans": [{"start": 3469, "end": 3470}]}, {"spans": [{"start": 3471, "end": 3475}]}, {"spans": [{"start": 3476, "end": 3477}]}, {"spans": [{"start": 3478, "end": 3482}]}, {"spans": [{"start": 3483, "end": 3484}]}, {"spans": [{"start": 3485, "end": 3488}]}, {"spans": [{"start": 3489, "end": 3500}]}, {"spans": [{"start": 3501, "end": 3502}]}, {"spans": [{"start": 3503, "end": 3513}]}, {"spans": [{"start": 3514, "end": 3522}]}, {"spans": [{"start": 3523, "end": 3524}]}, {"spans": [{"start": 3525, "end": 3531}]}, {"spans": [{"start": 3532, "end": 3541}]}, {"spans": [{"start": 3542, "end": 3543}]}, {"spans": [{"start": 3544, "end": 3551}]}, {"spans": [{"start": 3552, "end": 3559}]}, {"spans": [{"start": 3560, "end": 3561}]}, {"spans": [{"start": 3562, "end": 3567}]}, {"spans": [{"start": 3568, "end": 3574}]}, {"spans": [{"start": 3575, "end": 3576}]}, {"spans": [{"start": 3577, "end": 3582}]}, {"spans": [{"start": 3583, "end": 3585}]}, {"spans": [{"start": 3586, "end": 3587}]}, {"spans": [{"start": 3588, "end": 3593}]}, {"spans": [{"start": 3594, "end": 3595}]}, {"spans": [{"start": 3596, "end": 3604}]}, {"spans": [{"start": 3605, "end": 3612}]}, {"spans": [{"start": 3613, "end": 3614}]}, {"spans": [{"start": 3615, "end": 3620}]}, {"spans": [{"start": 3621, "end": 3631}]}, {"spans": [{"start": 3632, "end": 3633}]}, {"spans": [{"start": 3634, "end": 3641}]}, {"spans": [{"start": 3642, "end": 3648}]}, {"spans": [{"start": 3649, "end": 3650}]}, {"spans": [{"start": 3651, "end": 3656}]}, {"spans": [{"start": 3657, "end": 3663}]}, {"spans": [{"start": 3664, "end": 3665}]}, {"spans": [{"start": 3666, "end": 3668}]}, {"spans": [{"start": 3669, "end": 3671}]}, {"spans": [{"start": 3672, "end": 3673}]}, {"spans": [{"start": 3674, "end": 3678}]}, {"spans": [{"start": 3679, "end": 3680}]}, {"spans": [{"start": 3681, "end": 3688}]}, {"spans": [{"start": 3689, "end": 3698}]}, {"spans": [{"start": 3699, "end": 3700}]}, {"spans": [{"start": 3701, "end": 3702}]}, {"spans": [{"start": 3703, "end": 3712}]}, {"spans": [{"start": 3713, "end": 3716}]}, {"spans": [{"start": 3717, "end": 3725}]}, {"spans": [{"start": 3726, "end": 3735}]}, {"spans": [{"start": 3736, "end": 3744}]}, {"spans": [{"start": 3745, "end": 3746}]}, {"spans": [{"start": 3747, "end": 3753}]}, {"spans": [{"start": 3754, "end": 3762}]}, {"spans": [{"start": 3763, "end": 3764}]}, {"spans": [{"start": 3765, "end": 3771}]}, {"spans": [{"start": 3772, "end": 3780}]}, {"spans": [{"start": 3781, "end": 3782}]}, {"spans": [{"start": 3783, "end": 3790}]}, {"spans": [{"start": 3791, "end": 3799}]}, {"spans": [{"start": 3800, "end": 3801}]}, {"spans": [{"start": 3802, "end": 3807}]}, {"spans": [{"start": 3808, "end": 3816}]}, {"spans": [{"start": 3817, "end": 3818}]}, {"spans": [{"start": 3819, "end": 3824}]}, {"spans": [{"start": 3825, "end": 3832}]}, {"spans": [{"start": 3833, "end": 3834}]}, {"spans": [{"start": 3835, "end": 3841}]}, {"spans": [{"start": 3842, "end": 3848}]}, {"spans": [{"start": 3849, "end": 3850}]}, {"spans": [{"start": 3851, "end": 3857}]}, {"spans": [{"start": 3858, "end": 3859}]}, {"spans": [{"start": 3860, "end": 3866}]}, {"spans": [{"start": 3867, "end": 3875}]}, {"spans": [{"start": 3876, "end": 3877}]}, {"spans": [{"start": 3878, "end": 3881}]}, {"spans": [{"start": 3882, "end": 3885}]}, {"spans": [{"start": 3886, "end": 3898}]}, {"spans": [{"start": 3899, "end": 3900}]}, {"spans": [{"start": 3901, "end": 3905}]}, {"spans": [{"start": 3906, "end": 3907}]}, {"spans": [{"start": 3908, "end": 3909}]}, {"spans": [{"start": 3910, "end": 3916}]}, {"spans": [{"start": 3917, "end": 3919}]}, {"spans": [{"start": 3920, "end": 3933}]}, {"spans": [{"start": 3934, "end": 3942}]}, {"spans": [{"start": 3943, "end": 3945}]}, {"spans": [{"start": 3946, "end": 3947}]}, {"spans": [{"start": 3948, "end": 3954}]}, {"spans": [{"start": 3955, "end": 3957}]}, {"spans": [{"start": 3958, "end": 3965}]}, {"spans": [{"start": 3966, "end": 3974}]}, {"spans": [{"start": 3975, "end": 3976}]}, {"spans": [{"start": 3977, "end": 3979}]}, {"spans": [{"start": 3980, "end": 3991}]}, {"spans": [{"start": 3992, "end": 3994}]}, {"spans": [{"start": 3995, "end": 3998}]}, {"spans": [{"start": 3999, "end": 4005}]}, {"spans": [{"start": 4006, "end": 4007}]}, {"spans": [{"start": 4008, "end": 4014}]}, {"spans": [{"start": 4015, "end": 4028}]}, {"spans": [{"start": 4029, "end": 4034}]}, {"spans": [{"start": 4035, "end": 4045}]}, {"spans": [{"start": 4046, "end": 4048}]}, {"spans": [{"start": 4049, "end": 4058}]}, {"spans": [{"start": 4059, "end": 4071}]}, {"spans": [{"start": 4072, "end": 4073}]}, {"spans": [{"start": 4074, "end": 4079}]}, {"spans": [{"start": 4080, "end": 4084}]}, {"spans": [{"start": 4085, "end": 4086}]}, {"spans": [{"start": 4087, "end": 4093}]}, {"spans": [{"start": 4094, "end": 4096}]}, {"spans": [{"start": 4097, "end": 4098}]}, {"spans": [{"start": 4099, "end": 4101}]}, {"spans": [{"start": 4102, "end": 4106}]}, {"spans": [{"start": 4107, "end": 4108}]}, {"spans": [{"start": 4109, "end": 4114}]}, {"spans": [{"start": 4115, "end": 4116}]}, {"spans": [{"start": 4117, "end": 4122}]}, {"spans": [{"start": 4123, "end": 4124}]}, {"spans": [{"start": 4125, "end": 4132}]}, {"spans": [{"start": 4133, "end": 4139}]}, {"spans": [{"start": 4140, "end": 4143}]}, {"spans": [{"start": 4144, "end": 4147}]}, {"spans": [{"start": 4148, "end": 4154}]}, {"spans": [{"start": 4155, "end": 4156}]}, {"spans": [{"start": 4157, "end": 4161}]}, {"spans": [{"start": 4162, "end": 4163}]}, {"spans": [{"start": 4164, "end": 4172}]}, {"spans": [{"start": 4173, "end": 4176}]}, {"spans": [{"start": 4177, "end": 4178}]}, {"spans": [{"start": 4179, "end": 4185}]}, {"spans": [{"start": 4186, "end": 4196}]}, {"spans": [{"start": 4197, "end": 4199}]}, {"spans": [{"start": 4200, "end": 4208}]}, {"spans": [{"start": 4209, "end": 4215}]}, {"spans": [{"start": 4216, "end": 4217}]}, {"spans": [{"start": 4218, "end": 4220}]}, {"spans": [{"start": 4221, "end": 4228}]}, {"spans": [{"start": 4229, "end": 4230}]}, {"spans": [{"start": 4231, "end": 4235}]}, {"spans": [{"start": 4236, "end": 4238}]}, {"spans": [{"start": 4239, "end": 4242}]}, {"spans": [{"start": 4243, "end": 4247}]}, {"spans": [{"start": 4248, "end": 4258}]}, {"spans": [{"start": 4259, "end": 4261}]}, {"spans": [{"start": 4262, "end": 4271}]}, {"spans": [{"start": 4272, "end": 4279}]}, {"spans": [{"start": 4280, "end": 4282}]}, {"spans": [{"start": 4283, "end": 4290}]}, {"spans": [{"start": 4291, "end": 4299}]}, {"spans": [{"start": 4300, "end": 4310}]}, {"spans": [{"start": 4311, "end": 4312}]}, {"spans": [{"start": 4313, "end": 4321}]}, {"spans": [{"start": 4322, "end": 4323}]}, {"spans": [{"start": 4324, "end": 4331}]}, {"spans": [{"start": 4332, "end": 4333}]}, {"spans": [{"start": 4334, "end": 4341}]}, {"spans": [{"start": 4342, "end": 4344}]}, {"spans": [{"start": 4345, "end": 4346}]}, {"spans": [{"start": 4347, "end": 4355}]}, {"spans": [{"start": 4356, "end": 4357}]}, {"spans": [{"start": 4358, "end": 4359}]}, {"spans": [{"start": 4360, "end": 4364}]}, {"spans": [{"start": 4365, "end": 4366}]}, {"spans": [{"start": 4367, "end": 4372}]}, {"spans": [{"start": 4373, "end": 4377}]}, {"spans": [{"start": 4378, "end": 4379}]}, {"spans": [{"start": 4380, "end": 4384}]}, {"spans": [{"start": 4385, "end": 4386}]}, {"spans": [{"start": 4387, "end": 4388}]}, {"spans": [{"start": 4389, "end": 4390}]}, {"spans": [{"start": 4391, "end": 4397}]}, {"spans": [{"start": 4398, "end": 4403}]}, {"spans": [{"start": 4404, "end": 4405}]}, {"spans": [{"start": 4406, "end": 4411}]}, {"spans": [{"start": 4412, "end": 4419}]}, {"spans": [{"start": 4420, "end": 4421}]}, {"spans": [{"start": 4422, "end": 4425}]}, {"spans": [{"start": 4426, "end": 4429}]}, {"spans": [{"start": 4430, "end": 4436}]}, {"spans": [{"start": 4437, "end": 4438}]}, {"spans": [{"start": 4439, "end": 4443}]}, {"spans": [{"start": 4444, "end": 4445}]}, {"spans": [{"start": 4446, "end": 4451}]}, {"spans": [{"start": 4452, "end": 4455}]}, {"spans": [{"start": 4456, "end": 4459}]}, {"spans": [{"start": 4460, "end": 4465}]}, {"spans": [{"start": 4466, "end": 4473}]}, {"spans": [{"start": 4474, "end": 4475}]}, {"spans": [{"start": 4476, "end": 4486}]}, {"spans": [{"start": 4487, "end": 4490}]}, {"spans": [{"start": 4491, "end": 4492}]}, {"spans": [{"start": 4493, "end": 4499}]}, {"spans": [{"start": 4500, "end": 4510}]}, {"spans": [{"start": 4511, "end": 4513}]}, {"spans": [{"start": 4514, "end": 4521}]}, {"spans": [{"start": 4522, "end": 4530}]}, {"spans": [{"start": 4531, "end": 4540}]}, {"spans": [{"start": 4541, "end": 4542}]}, {"spans": [{"start": 4543, "end": 4549}]}, {"spans": [{"start": 4550, "end": 4555}]}, {"spans": [{"start": 4556, "end": 4557}]}, {"spans": [{"start": 4558, "end": 4563}]}, {"spans": [{"start": 4564, "end": 4568}]}, {"spans": [{"start": 4569, "end": 4570}]}, {"spans": [{"start": 4571, "end": 4574}]}, {"spans": [{"start": 4575, "end": 4579}]}, {"spans": [{"start": 4580, "end": 4587}]}, {"spans": [{"start": 4588, "end": 4589}]}, {"spans": [{"start": 4590, "end": 4594}]}, {"spans": [{"start": 4595, "end": 4596}]}, {"spans": [{"start": 4597, "end": 4599}]}, {"spans": [{"start": 4600, "end": 4603}]}, {"spans": [{"start": 4604, "end": 4609}]}, {"spans": [{"start": 4610, "end": 4612}]}, {"spans": [{"start": 4613, "end": 4616}]}, {"spans": [{"start": 4617, "end": 4620}]}, {"spans": [{"start": 4621, "end": 4623}]}, {"spans": [{"start": 4624, "end": 4634}]}, {"spans": [{"start": 4635, "end": 4637}]}, {"spans": [{"start": 4638, "end": 4644}]}, {"spans": [{"start": 4645, "end": 4653}]}, {"spans": [{"start": 4654, "end": 4660}]}, {"spans": [{"start": 4661, "end": 4662}]}, {"spans": [{"start": 4663, "end": 4667}]}, {"spans": [{"start": 4668, "end": 4669}]}, {"spans": [{"start": 4670, "end": 4673}]}, {"spans": [{"start": 4674, "end": 4675}]}, {"spans": [{"start": 4676, "end": 4680}]}, {"spans": [{"start": 4681, "end": 4682}]}, {"spans": [{"start": 4683, "end": 4688}]}, {"spans": [{"start": 4689, "end": 4690}]}, {"spans": [{"start": 4691, "end": 4698}]}, {"spans": [{"start": 4699, "end": 4705}]}, {"spans": [{"start": 4706, "end": 4707}]}, {"spans": [{"start": 4708, "end": 4715}]}, {"spans": [{"start": 4716, "end": 4721}]}, {"spans": [{"start": 4722, "end": 4723}]}, {"spans": [{"start": 4724, "end": 4729}]}, {"spans": [{"start": 4730, "end": 4738}]}, {"spans": [{"start": 4739, "end": 4740}]}, {"spans": [{"start": 4741, "end": 4744}]}, {"spans": [{"start": 4745, "end": 4752}]}, {"spans": [{"start": 4753, "end": 4759}]}, {"spans": [{"start": 4760, "end": 4761}]}, {"spans": [{"start": 4762, "end": 4766}]}, {"spans": [{"start": 4767, "end": 4768}]}, {"spans": [{"start": 4769, "end": 4776}]}, {"spans": [{"start": 4777, "end": 4785}]}, {"spans": [{"start": 4786, "end": 4793}]}, {"spans": [{"start": 4794, "end": 4800}]}, {"spans": [{"start": 4801, "end": 4802}]}, {"spans": [{"start": 4803, "end": 4807}]}, {"spans": [{"start": 4808, "end": 4809}]}, {"spans": [{"start": 4810, "end": 4813}]}, {"spans": [{"start": 4814, "end": 4815}]}, {"spans": [{"start": 4816, "end": 4820}]}, {"spans": [{"start": 4821, "end": 4822}]}, {"spans": [{"start": 4823, "end": 4828}]}, {"spans": [{"start": 4829, "end": 4830}]}, {"spans": [{"start": 4831, "end": 4836}]}, {"spans": [{"start": 4837, "end": 4844}]}, {"spans": [{"start": 4845, "end": 4848}]}, {"spans": [{"start": 4849, "end": 4852}]}, {"spans": [{"start": 4853, "end": 4854}]}, {"spans": [{"start": 4855, "end": 4858}]}, {"spans": [{"start": 4859, "end": 4864}]}, {"spans": [{"start": 4865, "end": 4866}]}, {"spans": [{"start": 4867, "end": 4871}]}, {"spans": [{"start": 4872, "end": 4873}]}, {"spans": [{"start": 4874, "end": 4881}]}, {"spans": [{"start": 4882, "end": 4891}]}, {"spans": [{"start": 4892, "end": 4901}]}, {"spans": [{"start": 4902, "end": 4908}]}, {"spans": [{"start": 4909, "end": 4916}]}, {"spans": [{"start": 4917, "end": 4925}]}, {"spans": [{"start": 4926, "end": 4931}]}, {"spans": [{"start": 4932, "end": 4933}]}, {"spans": [{"start": 4934, "end": 4936}]}, {"spans": [{"start": 4937, "end": 4941}]}, {"spans": [{"start": 4942, "end": 4946}]}, {"spans": [{"start": 4947, "end": 4953}]}, {"spans": [{"start": 4954, "end": 4962}]}, {"spans": [{"start": 4963, "end": 4973}]}, {"spans": [{"start": 4974, "end": 4978}]}, {"spans": [{"start": 4979, "end": 4980}]}, {"spans": [{"start": 4981, "end": 4985}]}, {"spans": [{"start": 4986, "end": 4987}]}, {"spans": [{"start": 4988, "end": 4991}]}, {"spans": [{"start": 4992, "end": 4993}]}, {"spans": [{"start": 4994, "end": 4995}]}, {"spans": [{"start": 4996, "end": 5001}]}, {"spans": [{"start": 5002, "end": 5003}]}, {"spans": [{"start": 5004, "end": 5006}]}, {"spans": [{"start": 5007, "end": 5008}]}, {"spans": [{"start": 5009, "end": 5012}]}, {"spans": [{"start": 5013, "end": 5014}]}, {"spans": [{"start": 5015, "end": 5023}]}, {"spans": [{"start": 5024, "end": 5025}]}, {"spans": [{"start": 5026, "end": 5027}]}, {"spans": [{"start": 5028, "end": 5029}]}, {"spans": [{"start": 5030, "end": 5031}]}, {"spans": [{"start": 5032, "end": 5036}]}, {"spans": [{"start": 5037, "end": 5038}]}, {"spans": [{"start": 5039, "end": 5044}]}, {"spans": [{"start": 5045, "end": 5048}]}, {"spans": [{"start": 5049, "end": 5050}]}, {"spans": [{"start": 5051, "end": 5054}]}, {"spans": [{"start": 5055, "end": 5056}]}]}


class TestSpangroupClassificationPredictor(unittest.TestCase):
    def setUp(self):
        self.doc = Document.from_json(doc_dict=TEST_DOC_JSON)
        sg1 = SpanGroup(spans=[Span(start=86, end=456)])
        sg2 = SpanGroup(spans=[Span(start=457, end=641)])
        self.doc.annotate(bibs=[sg1, sg2])

        self.predictor = SpanGroupClassificationPredictor.from_pretrained(
            model_name_or_path=TEST_SCIBERT_WEIGHTS,
            span_group_name='tokens',
            context_name='pages'
        )

    def test_predict_pages_tokens(self):
        predictor = SpanGroupClassificationPredictor.from_pretrained(
            model_name_or_path=TEST_SCIBERT_WEIGHTS,
            span_group_name='tokens',
            context_name='pages'
        )
        token_tags = predictor.predict(document=self.doc)
        assert len(token_tags) == len([token for page in self.doc.pages for token in page.tokens])

        self.doc.annotate(token_tags=token_tags)
        for token_tag in token_tags:
            assert isinstance(token_tag.metadata.label, str)
            assert isinstance(token_tag.metadata.score, float)

    def test_predict_bibs_tokens(self):
        self.predictor.context_name = 'bibs'
        token_tags = self.predictor.predict(document=self.doc)
        assert len(token_tags) == len([token for bib in self.doc.bibs for token in bib.tokens])

    def test_missing_fields(self):
        self.predictor.span_group_name = 'OHNO'
        with self.assertRaises(AssertionError) as e:
            self.predictor.predict(document=self.doc)
            assert 'OHNO' in e.exception

        self.predictor.span_group_name = 'tokens'
        self.predictor.context_name = 'BLABLA'
        with self.assertRaises(AssertionError) as e:
            self.predictor.predict(document=self.doc)
            assert 'BLABLA' in e.exception

        self.predictor.context_name = 'pages'


