// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/compute/v1/disk_service.proto

package compute // import "github.com/yandex-cloud/go-genproto/yandex/cloud/compute/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/yandex-cloud/go-genproto/yandex/api"
import operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
import _ "github.com/yandex-cloud/go-genproto/yandex/cloud/validation"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type GetDiskRequest struct {
	// ID of the Disk resource to return.
	// To get the disk ID use a [DiskService.List] request.
	DiskId               string   `protobuf:"bytes,1,opt,name=disk_id,json=diskId,proto3" json:"disk_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDiskRequest) Reset()         { *m = GetDiskRequest{} }
func (m *GetDiskRequest) String() string { return proto.CompactTextString(m) }
func (*GetDiskRequest) ProtoMessage()    {}
func (*GetDiskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_disk_service_314d5b4ba085ca45, []int{0}
}
func (m *GetDiskRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDiskRequest.Unmarshal(m, b)
}
func (m *GetDiskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDiskRequest.Marshal(b, m, deterministic)
}
func (dst *GetDiskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDiskRequest.Merge(dst, src)
}
func (m *GetDiskRequest) XXX_Size() int {
	return xxx_messageInfo_GetDiskRequest.Size(m)
}
func (m *GetDiskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDiskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDiskRequest proto.InternalMessageInfo

func (m *GetDiskRequest) GetDiskId() string {
	if m != nil {
		return m.DiskId
	}
	return ""
}

type ListDisksRequest struct {
	// ID of the folder to list disks in.
	// To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListDisksResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListDisksResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on the [Disk.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z]([-a-z0-9]{,61}[a-z0-9])?$`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDisksRequest) Reset()         { *m = ListDisksRequest{} }
func (m *ListDisksRequest) String() string { return proto.CompactTextString(m) }
func (*ListDisksRequest) ProtoMessage()    {}
func (*ListDisksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_disk_service_314d5b4ba085ca45, []int{1}
}
func (m *ListDisksRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDisksRequest.Unmarshal(m, b)
}
func (m *ListDisksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDisksRequest.Marshal(b, m, deterministic)
}
func (dst *ListDisksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDisksRequest.Merge(dst, src)
}
func (m *ListDisksRequest) XXX_Size() int {
	return xxx_messageInfo_ListDisksRequest.Size(m)
}
func (m *ListDisksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDisksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDisksRequest proto.InternalMessageInfo

func (m *ListDisksRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListDisksRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDisksRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListDisksRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListDisksResponse struct {
	// List of Disk resources.
	Disks []*Disk `protobuf:"bytes,1,rep,name=disks,proto3" json:"disks,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListDisksRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListDisksRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDisksResponse) Reset()         { *m = ListDisksResponse{} }
func (m *ListDisksResponse) String() string { return proto.CompactTextString(m) }
func (*ListDisksResponse) ProtoMessage()    {}
func (*ListDisksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_disk_service_314d5b4ba085ca45, []int{2}
}
func (m *ListDisksResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDisksResponse.Unmarshal(m, b)
}
func (m *ListDisksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDisksResponse.Marshal(b, m, deterministic)
}
func (dst *ListDisksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDisksResponse.Merge(dst, src)
}
func (m *ListDisksResponse) XXX_Size() int {
	return xxx_messageInfo_ListDisksResponse.Size(m)
}
func (m *ListDisksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDisksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDisksResponse proto.InternalMessageInfo

func (m *ListDisksResponse) GetDisks() []*Disk {
	if m != nil {
		return m.Disks
	}
	return nil
}

func (m *ListDisksResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateDiskRequest struct {
	// ID of the folder to create a disk in.
	// To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the disk.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the disk.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ID of the disk type.
	// To get a list of available disk types use the [yandex.cloud.compute.v1.DiskTypeService.List] request.
	TypeId string `protobuf:"bytes,5,opt,name=type_id,json=typeId,proto3" json:"type_id,omitempty"`
	// ID of the availability zone where the disk resides.
	// To get a list of available zones use the [yandex.cloud.compute.v1.ZoneService.List] request.
	ZoneId string `protobuf:"bytes,6,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Size of the disk, specified in bytes.
	// If the disk was created from a image, this value should be more than the
	// [yandex.cloud.compute.v1.Image.min_disk_size] value.
	Size int64 `protobuf:"varint,7,opt,name=size,proto3" json:"size,omitempty"`
	// Types that are valid to be assigned to Source:
	//	*CreateDiskRequest_ImageId
	//	*CreateDiskRequest_SnapshotId
	Source               isCreateDiskRequest_Source `protobuf_oneof:"source"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *CreateDiskRequest) Reset()         { *m = CreateDiskRequest{} }
func (m *CreateDiskRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDiskRequest) ProtoMessage()    {}
func (*CreateDiskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_disk_service_314d5b4ba085ca45, []int{3}
}
func (m *CreateDiskRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDiskRequest.Unmarshal(m, b)
}
func (m *CreateDiskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDiskRequest.Marshal(b, m, deterministic)
}
func (dst *CreateDiskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDiskRequest.Merge(dst, src)
}
func (m *CreateDiskRequest) XXX_Size() int {
	return xxx_messageInfo_CreateDiskRequest.Size(m)
}
func (m *CreateDiskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDiskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDiskRequest proto.InternalMessageInfo

func (m *CreateDiskRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateDiskRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateDiskRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateDiskRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CreateDiskRequest) GetTypeId() string {
	if m != nil {
		return m.TypeId
	}
	return ""
}

func (m *CreateDiskRequest) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *CreateDiskRequest) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

type isCreateDiskRequest_Source interface {
	isCreateDiskRequest_Source()
}

type CreateDiskRequest_ImageId struct {
	ImageId string `protobuf:"bytes,8,opt,name=image_id,json=imageId,proto3,oneof"`
}

type CreateDiskRequest_SnapshotId struct {
	SnapshotId string `protobuf:"bytes,9,opt,name=snapshot_id,json=snapshotId,proto3,oneof"`
}

func (*CreateDiskRequest_ImageId) isCreateDiskRequest_Source() {}

func (*CreateDiskRequest_SnapshotId) isCreateDiskRequest_Source() {}

func (m *CreateDiskRequest) GetSource() isCreateDiskRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *CreateDiskRequest) GetImageId() string {
	if x, ok := m.GetSource().(*CreateDiskRequest_ImageId); ok {
		return x.ImageId
	}
	return ""
}

func (m *CreateDiskRequest) GetSnapshotId() string {
	if x, ok := m.GetSource().(*CreateDiskRequest_SnapshotId); ok {
		return x.SnapshotId
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CreateDiskRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CreateDiskRequest_OneofMarshaler, _CreateDiskRequest_OneofUnmarshaler, _CreateDiskRequest_OneofSizer, []interface{}{
		(*CreateDiskRequest_ImageId)(nil),
		(*CreateDiskRequest_SnapshotId)(nil),
	}
}

func _CreateDiskRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CreateDiskRequest)
	// source
	switch x := m.Source.(type) {
	case *CreateDiskRequest_ImageId:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.ImageId)
	case *CreateDiskRequest_SnapshotId:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.SnapshotId)
	case nil:
	default:
		return fmt.Errorf("CreateDiskRequest.Source has unexpected type %T", x)
	}
	return nil
}

func _CreateDiskRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CreateDiskRequest)
	switch tag {
	case 8: // source.image_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Source = &CreateDiskRequest_ImageId{x}
		return true, err
	case 9: // source.snapshot_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Source = &CreateDiskRequest_SnapshotId{x}
		return true, err
	default:
		return false, nil
	}
}

func _CreateDiskRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CreateDiskRequest)
	// source
	switch x := m.Source.(type) {
	case *CreateDiskRequest_ImageId:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.ImageId)))
		n += len(x.ImageId)
	case *CreateDiskRequest_SnapshotId:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.SnapshotId)))
		n += len(x.SnapshotId)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type CreateDiskMetadata struct {
	// ID of the disk that is being created.
	DiskId               string   `protobuf:"bytes,1,opt,name=disk_id,json=diskId,proto3" json:"disk_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateDiskMetadata) Reset()         { *m = CreateDiskMetadata{} }
func (m *CreateDiskMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateDiskMetadata) ProtoMessage()    {}
func (*CreateDiskMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_disk_service_314d5b4ba085ca45, []int{4}
}
func (m *CreateDiskMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDiskMetadata.Unmarshal(m, b)
}
func (m *CreateDiskMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDiskMetadata.Marshal(b, m, deterministic)
}
func (dst *CreateDiskMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDiskMetadata.Merge(dst, src)
}
func (m *CreateDiskMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateDiskMetadata.Size(m)
}
func (m *CreateDiskMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDiskMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDiskMetadata proto.InternalMessageInfo

func (m *CreateDiskMetadata) GetDiskId() string {
	if m != nil {
		return m.DiskId
	}
	return ""
}

type UpdateDiskRequest struct {
	// ID of the Disk resource to update.
	// To get the disk ID use a [DiskService.List] request.
	DiskId string `protobuf:"bytes,1,opt,name=disk_id,json=diskId,proto3" json:"disk_id,omitempty"`
	// Field mask that specifies which fields of the Disk resource are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the disk.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the disk.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	//
	// Existing set of `labels` is completely replaced by the provided set.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Size of the disk, specified in bytes.
	Size                 int64    `protobuf:"varint,6,opt,name=size,proto3" json:"size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateDiskRequest) Reset()         { *m = UpdateDiskRequest{} }
func (m *UpdateDiskRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateDiskRequest) ProtoMessage()    {}
func (*UpdateDiskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_disk_service_314d5b4ba085ca45, []int{5}
}
func (m *UpdateDiskRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDiskRequest.Unmarshal(m, b)
}
func (m *UpdateDiskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDiskRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateDiskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDiskRequest.Merge(dst, src)
}
func (m *UpdateDiskRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateDiskRequest.Size(m)
}
func (m *UpdateDiskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDiskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDiskRequest proto.InternalMessageInfo

func (m *UpdateDiskRequest) GetDiskId() string {
	if m != nil {
		return m.DiskId
	}
	return ""
}

func (m *UpdateDiskRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateDiskRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateDiskRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateDiskRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *UpdateDiskRequest) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

type UpdateDiskMetadata struct {
	// ID of the Disk resource that is being updated.
	DiskId               string   `protobuf:"bytes,1,opt,name=disk_id,json=diskId,proto3" json:"disk_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateDiskMetadata) Reset()         { *m = UpdateDiskMetadata{} }
func (m *UpdateDiskMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateDiskMetadata) ProtoMessage()    {}
func (*UpdateDiskMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_disk_service_314d5b4ba085ca45, []int{6}
}
func (m *UpdateDiskMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDiskMetadata.Unmarshal(m, b)
}
func (m *UpdateDiskMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDiskMetadata.Marshal(b, m, deterministic)
}
func (dst *UpdateDiskMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDiskMetadata.Merge(dst, src)
}
func (m *UpdateDiskMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateDiskMetadata.Size(m)
}
func (m *UpdateDiskMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDiskMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDiskMetadata proto.InternalMessageInfo

func (m *UpdateDiskMetadata) GetDiskId() string {
	if m != nil {
		return m.DiskId
	}
	return ""
}

type DeleteDiskRequest struct {
	// ID of the disk to delete.
	// To get the disk ID use a [DiskService.List] request.
	DiskId               string   `protobuf:"bytes,1,opt,name=disk_id,json=diskId,proto3" json:"disk_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDiskRequest) Reset()         { *m = DeleteDiskRequest{} }
func (m *DeleteDiskRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDiskRequest) ProtoMessage()    {}
func (*DeleteDiskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_disk_service_314d5b4ba085ca45, []int{7}
}
func (m *DeleteDiskRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDiskRequest.Unmarshal(m, b)
}
func (m *DeleteDiskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDiskRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteDiskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDiskRequest.Merge(dst, src)
}
func (m *DeleteDiskRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDiskRequest.Size(m)
}
func (m *DeleteDiskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDiskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDiskRequest proto.InternalMessageInfo

func (m *DeleteDiskRequest) GetDiskId() string {
	if m != nil {
		return m.DiskId
	}
	return ""
}

type DeleteDiskMetadata struct {
	// ID of the disk that is being deleted.
	DiskId               string   `protobuf:"bytes,1,opt,name=disk_id,json=diskId,proto3" json:"disk_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDiskMetadata) Reset()         { *m = DeleteDiskMetadata{} }
func (m *DeleteDiskMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteDiskMetadata) ProtoMessage()    {}
func (*DeleteDiskMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_disk_service_314d5b4ba085ca45, []int{8}
}
func (m *DeleteDiskMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDiskMetadata.Unmarshal(m, b)
}
func (m *DeleteDiskMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDiskMetadata.Marshal(b, m, deterministic)
}
func (dst *DeleteDiskMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDiskMetadata.Merge(dst, src)
}
func (m *DeleteDiskMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteDiskMetadata.Size(m)
}
func (m *DeleteDiskMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDiskMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDiskMetadata proto.InternalMessageInfo

func (m *DeleteDiskMetadata) GetDiskId() string {
	if m != nil {
		return m.DiskId
	}
	return ""
}

type ListDiskOperationsRequest struct {
	// ID of the Disk resource to list operations for.
	DiskId string `protobuf:"bytes,1,opt,name=disk_id,json=diskId,proto3" json:"disk_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListDiskOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListDiskOperationsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDiskOperationsRequest) Reset()         { *m = ListDiskOperationsRequest{} }
func (m *ListDiskOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDiskOperationsRequest) ProtoMessage()    {}
func (*ListDiskOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_disk_service_314d5b4ba085ca45, []int{9}
}
func (m *ListDiskOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDiskOperationsRequest.Unmarshal(m, b)
}
func (m *ListDiskOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDiskOperationsRequest.Marshal(b, m, deterministic)
}
func (dst *ListDiskOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDiskOperationsRequest.Merge(dst, src)
}
func (m *ListDiskOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListDiskOperationsRequest.Size(m)
}
func (m *ListDiskOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDiskOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDiskOperationsRequest proto.InternalMessageInfo

func (m *ListDiskOperationsRequest) GetDiskId() string {
	if m != nil {
		return m.DiskId
	}
	return ""
}

func (m *ListDiskOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDiskOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListDiskOperationsResponse struct {
	// List of operations for the specified disk.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListDiskOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListDiskOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDiskOperationsResponse) Reset()         { *m = ListDiskOperationsResponse{} }
func (m *ListDiskOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDiskOperationsResponse) ProtoMessage()    {}
func (*ListDiskOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_disk_service_314d5b4ba085ca45, []int{10}
}
func (m *ListDiskOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDiskOperationsResponse.Unmarshal(m, b)
}
func (m *ListDiskOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDiskOperationsResponse.Marshal(b, m, deterministic)
}
func (dst *ListDiskOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDiskOperationsResponse.Merge(dst, src)
}
func (m *ListDiskOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListDiskOperationsResponse.Size(m)
}
func (m *ListDiskOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDiskOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDiskOperationsResponse proto.InternalMessageInfo

func (m *ListDiskOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListDiskOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetDiskRequest)(nil), "yandex.cloud.compute.v1.GetDiskRequest")
	proto.RegisterType((*ListDisksRequest)(nil), "yandex.cloud.compute.v1.ListDisksRequest")
	proto.RegisterType((*ListDisksResponse)(nil), "yandex.cloud.compute.v1.ListDisksResponse")
	proto.RegisterType((*CreateDiskRequest)(nil), "yandex.cloud.compute.v1.CreateDiskRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.CreateDiskRequest.LabelsEntry")
	proto.RegisterType((*CreateDiskMetadata)(nil), "yandex.cloud.compute.v1.CreateDiskMetadata")
	proto.RegisterType((*UpdateDiskRequest)(nil), "yandex.cloud.compute.v1.UpdateDiskRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.UpdateDiskRequest.LabelsEntry")
	proto.RegisterType((*UpdateDiskMetadata)(nil), "yandex.cloud.compute.v1.UpdateDiskMetadata")
	proto.RegisterType((*DeleteDiskRequest)(nil), "yandex.cloud.compute.v1.DeleteDiskRequest")
	proto.RegisterType((*DeleteDiskMetadata)(nil), "yandex.cloud.compute.v1.DeleteDiskMetadata")
	proto.RegisterType((*ListDiskOperationsRequest)(nil), "yandex.cloud.compute.v1.ListDiskOperationsRequest")
	proto.RegisterType((*ListDiskOperationsResponse)(nil), "yandex.cloud.compute.v1.ListDiskOperationsResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DiskServiceClient is the client API for DiskService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DiskServiceClient interface {
	// Returns the specified Disk resource.
	//
	// To get the list of available Disk resources, make a [List] request.
	Get(ctx context.Context, in *GetDiskRequest, opts ...grpc.CallOption) (*Disk, error)
	// Retrieves the list of Disk resources in the specified folder.
	List(ctx context.Context, in *ListDisksRequest, opts ...grpc.CallOption) (*ListDisksResponse, error)
	// Creates a disk in the specified folder.
	//
	// You can create an empty disk or restore it from a snapshot or an image.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Create(ctx context.Context, in *CreateDiskRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified disk.
	Update(ctx context.Context, in *UpdateDiskRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified disk.
	//
	// Deleting a disk removes its data permanently and is irreversible. However, deleting a disk does not delete
	// any snapshots or images previously made from the disk. You must delete snapshots and images separately.
	//
	// It is not possible to delete a disk that is attached to an instance.
	Delete(ctx context.Context, in *DeleteDiskRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists operations for the specified disk.
	ListOperations(ctx context.Context, in *ListDiskOperationsRequest, opts ...grpc.CallOption) (*ListDiskOperationsResponse, error)
}

type diskServiceClient struct {
	cc *grpc.ClientConn
}

func NewDiskServiceClient(cc *grpc.ClientConn) DiskServiceClient {
	return &diskServiceClient{cc}
}

func (c *diskServiceClient) Get(ctx context.Context, in *GetDiskRequest, opts ...grpc.CallOption) (*Disk, error) {
	out := new(Disk)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.DiskService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *diskServiceClient) List(ctx context.Context, in *ListDisksRequest, opts ...grpc.CallOption) (*ListDisksResponse, error) {
	out := new(ListDisksResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.DiskService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *diskServiceClient) Create(ctx context.Context, in *CreateDiskRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.DiskService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *diskServiceClient) Update(ctx context.Context, in *UpdateDiskRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.DiskService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *diskServiceClient) Delete(ctx context.Context, in *DeleteDiskRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.DiskService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *diskServiceClient) ListOperations(ctx context.Context, in *ListDiskOperationsRequest, opts ...grpc.CallOption) (*ListDiskOperationsResponse, error) {
	out := new(ListDiskOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.DiskService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DiskServiceServer is the server API for DiskService service.
type DiskServiceServer interface {
	// Returns the specified Disk resource.
	//
	// To get the list of available Disk resources, make a [List] request.
	Get(context.Context, *GetDiskRequest) (*Disk, error)
	// Retrieves the list of Disk resources in the specified folder.
	List(context.Context, *ListDisksRequest) (*ListDisksResponse, error)
	// Creates a disk in the specified folder.
	//
	// You can create an empty disk or restore it from a snapshot or an image.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Create(context.Context, *CreateDiskRequest) (*operation.Operation, error)
	// Updates the specified disk.
	Update(context.Context, *UpdateDiskRequest) (*operation.Operation, error)
	// Deletes the specified disk.
	//
	// Deleting a disk removes its data permanently and is irreversible. However, deleting a disk does not delete
	// any snapshots or images previously made from the disk. You must delete snapshots and images separately.
	//
	// It is not possible to delete a disk that is attached to an instance.
	Delete(context.Context, *DeleteDiskRequest) (*operation.Operation, error)
	// Lists operations for the specified disk.
	ListOperations(context.Context, *ListDiskOperationsRequest) (*ListDiskOperationsResponse, error)
}

func RegisterDiskServiceServer(s *grpc.Server, srv DiskServiceServer) {
	s.RegisterService(&_DiskService_serviceDesc, srv)
}

func _DiskService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DiskServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.DiskService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DiskServiceServer).Get(ctx, req.(*GetDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DiskService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDisksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DiskServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.DiskService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DiskServiceServer).List(ctx, req.(*ListDisksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DiskService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DiskServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.DiskService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DiskServiceServer).Create(ctx, req.(*CreateDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DiskService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DiskServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.DiskService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DiskServiceServer).Update(ctx, req.(*UpdateDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DiskService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DiskServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.DiskService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DiskServiceServer).Delete(ctx, req.(*DeleteDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DiskService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDiskOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DiskServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.DiskService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DiskServiceServer).ListOperations(ctx, req.(*ListDiskOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DiskService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.compute.v1.DiskService",
	HandlerType: (*DiskServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _DiskService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _DiskService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _DiskService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _DiskService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _DiskService_Delete_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _DiskService_ListOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/compute/v1/disk_service.proto",
}

func init() {
	proto.RegisterFile("yandex/cloud/compute/v1/disk_service.proto", fileDescriptor_disk_service_314d5b4ba085ca45)
}

var fileDescriptor_disk_service_314d5b4ba085ca45 = []byte{
	// 1084 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0xcf, 0x73, 0xdb, 0x44,
	0x14, 0x46, 0xb1, 0xa2, 0xd8, 0xcf, 0x50, 0x92, 0x85, 0x52, 0x47, 0x90, 0x99, 0x44, 0x4c, 0xd3,
	0xd4, 0x45, 0x92, 0x65, 0x3b, 0xa6, 0x49, 0xdb, 0x61, 0x70, 0x13, 0x8a, 0x67, 0xda, 0x81, 0x51,
	0xe1, 0x42, 0xa6, 0x93, 0x51, 0xac, 0x8d, 0xab, 0xb1, 0x2c, 0x09, 0xad, 0xec, 0x89, 0x5d, 0x7a,
	0xe9, 0x85, 0x99, 0x70, 0xe0, 0xd0, 0xe1, 0xc8, 0x1f, 0xc0, 0x70, 0xcb, 0xf0, 0x3f, 0x38, 0xc3,
	0xb1, 0x1c, 0xf8, 0x07, 0x38, 0x70, 0xee, 0xb1, 0x27, 0x66, 0x57, 0xf2, 0xef, 0x9f, 0xa1, 0x70,
	0x93, 0xf4, 0xbe, 0xb7, 0xfa, 0xf6, 0xdb, 0xef, 0xbd, 0xb7, 0x90, 0x6e, 0x1a, 0x8e, 0x89, 0x4f,
	0xd4, 0xb2, 0xed, 0xd6, 0x4d, 0xb5, 0xec, 0xd6, 0xbc, 0x7a, 0x80, 0xd5, 0x86, 0xa6, 0x9a, 0x16,
	0xa9, 0x1e, 0x12, 0xec, 0x37, 0xac, 0x32, 0x56, 0x3c, 0xdf, 0x0d, 0x5c, 0x74, 0x25, 0xc4, 0x2a,
	0x0c, 0xab, 0x44, 0x58, 0xa5, 0xa1, 0x89, 0x1f, 0x54, 0x5c, 0xb7, 0x62, 0x63, 0xd5, 0xf0, 0x2c,
	0xd5, 0x70, 0x1c, 0x37, 0x30, 0x02, 0xcb, 0x75, 0x48, 0x98, 0x26, 0xae, 0x47, 0x51, 0xf6, 0x76,
	0x54, 0x3f, 0x56, 0x8f, 0x2d, 0x6c, 0x9b, 0x87, 0x35, 0x83, 0x54, 0x23, 0x84, 0x18, 0x91, 0xa0,
	0xf9, 0xae, 0x87, 0x7d, 0x96, 0x1e, 0xc5, 0xa4, 0x69, 0x04, 0x23, 0xcc, 0xe6, 0x00, 0xa6, 0xbb,
	0xc2, 0xc8, 0x5a, 0x6b, 0x03, 0xb8, 0x86, 0x61, 0x5b, 0x66, 0x5f, 0x58, 0xfa, 0x18, 0x2e, 0xdd,
	0xc3, 0xc1, 0x9e, 0x45, 0xaa, 0x3a, 0xfe, 0xb6, 0x8e, 0x49, 0x80, 0xae, 0xc2, 0x12, 0xd3, 0xc1,
	0x32, 0x53, 0xdc, 0x3a, 0xb7, 0x95, 0x28, 0xbe, 0xf9, 0x77, 0x5b, 0xe3, 0x4e, 0xcf, 0x35, 0xfe,
	0xf6, 0x9d, 0xed, 0x8c, 0x2e, 0xd0, 0x60, 0xc9, 0x94, 0x7e, 0xe3, 0x60, 0xf9, 0xbe, 0x45, 0x58,
	0x2a, 0xe9, 0xe4, 0x5e, 0x87, 0xc4, 0xb1, 0x6b, 0x9b, 0xd8, 0x9f, 0x94, 0x1d, 0x0f, 0xc3, 0x25,
	0x13, 0x5d, 0x83, 0x84, 0x67, 0x54, 0xf0, 0x21, 0xb1, 0x5a, 0x38, 0xb5, 0xb0, 0xce, 0x6d, 0xc5,
	0x8a, 0xf0, 0xaa, 0xad, 0x09, 0xb7, 0xef, 0x68, 0x99, 0x4c, 0x46, 0x8f, 0xd3, 0xe0, 0x43, 0xab,
	0x85, 0xd1, 0x16, 0x00, 0x03, 0x06, 0x6e, 0x15, 0x3b, 0xa9, 0x18, 0x5b, 0x34, 0x71, 0x7a, 0xae,
	0x2d, 0x32, 0xa4, 0xce, 0x56, 0xf9, 0x8a, 0xc6, 0x90, 0x04, 0xc2, 0xb1, 0x65, 0x07, 0xd8, 0x4f,
	0xf1, 0x0c, 0x05, 0xa7, 0xe7, 0xdd, 0xf5, 0xa2, 0x88, 0xe4, 0xc1, 0x4a, 0x1f, 0x6b, 0xe2, 0xb9,
	0x0e, 0xc1, 0x28, 0x07, 0x8b, 0x74, 0x57, 0x24, 0xc5, 0xad, 0xc7, 0xb6, 0x92, 0xd9, 0x35, 0x65,
	0xc2, 0xa1, 0x2b, 0x4c, 0xa7, 0x10, 0x8b, 0x36, 0xe1, 0x6d, 0x07, 0x9f, 0x04, 0x87, 0x7d, 0xe4,
	0xe8, 0x36, 0x12, 0xfa, 0x5b, 0xf4, 0xf3, 0x97, 0x1d, 0x56, 0xd2, 0xef, 0x3c, 0xac, 0xdc, 0xf5,
	0xb1, 0x11, 0xe0, 0x7e, 0x95, 0x2f, 0xa0, 0xd4, 0x36, 0xf0, 0x8e, 0x51, 0x0b, 0x45, 0x4a, 0x14,
	0x37, 0x5e, 0xb6, 0xb5, 0xb5, 0xef, 0x0e, 0x0c, 0xb9, 0xf5, 0xe8, 0x40, 0x36, 0xe4, 0x56, 0x46,
	0xde, 0x79, 0xf4, 0x44, 0xfb, 0xa8, 0xa0, 0x3d, 0x3d, 0x88, 0xde, 0x74, 0x06, 0x47, 0x37, 0x20,
	0x69, 0x62, 0x52, 0xf6, 0x2d, 0x8f, 0x1e, 0xf7, 0xa0, 0x70, 0xd9, 0xed, 0x82, 0xde, 0x1f, 0x45,
	0x3f, 0x72, 0x20, 0xd8, 0xc6, 0x11, 0xb6, 0x49, 0x8a, 0x67, 0x1a, 0x14, 0x26, 0x6a, 0x30, 0xb2,
	0x17, 0xe5, 0x3e, 0x4b, 0xdc, 0x77, 0x02, 0xbf, 0x59, 0xfc, 0xe4, 0x65, 0x5b, 0x4b, 0x1e, 0xc8,
	0x87, 0x19, 0x79, 0x87, 0x52, 0x4c, 0x3f, 0x63, 0xfb, 0x29, 0xe4, 0xc3, 0x7d, 0x15, 0x72, 0x67,
	0xe7, 0x9a, 0x20, 0xf2, 0x9a, 0xcc, 0x9e, 0x10, 0x5a, 0x8e, 0x36, 0xd2, 0xc5, 0xeb, 0x11, 0x0d,
	0xb4, 0x01, 0x4b, 0x41, 0xd3, 0xc3, 0x54, 0x9e, 0x45, 0x46, 0x3d, 0xde, 0xb3, 0x20, 0x0d, 0x94,
	0x4c, 0xea, 0xd4, 0x96, 0xeb, 0x30, 0x88, 0x30, 0xce, 0xa9, 0x34, 0x58, 0x32, 0x91, 0x06, 0x3c,
	0x33, 0xd9, 0x12, 0x33, 0xd9, 0x1a, 0xc5, 0xbc, 0x6a, 0x6b, 0x97, 0xf3, 0xda, 0x4e, 0x3e, 0x97,
	0xc9, 0xcb, 0xf9, 0xdc, 0xce, 0xcd, 0x4c, 0xbe, 0xb0, 0xad, 0x69, 0x5a, 0x26, 0xaf, 0x33, 0x28,
	0xba, 0x0a, 0x71, 0xab, 0x46, 0xcf, 0xd5, 0x32, 0x53, 0xf1, 0xc1, 0xbf, 0x7f, 0xfe, 0x86, 0xbe,
	0xc4, 0x62, 0x25, 0x93, 0x4a, 0x4c, 0x1c, 0xc3, 0x23, 0x8f, 0xdd, 0x80, 0x22, 0x13, 0x23, 0x48,
	0xe8, 0x84, 0x4b, 0xa6, 0xb8, 0x03, 0xc9, 0x3e, 0xa1, 0xd0, 0x32, 0xc4, 0xaa, 0xb8, 0x19, 0x1e,
	0xbd, 0x4e, 0x1f, 0xd1, 0xbb, 0xb0, 0xd8, 0x30, 0xec, 0x7a, 0x74, 0xd0, 0x7a, 0xf8, 0xb2, 0xbb,
	0x70, 0x93, 0x2b, 0xc6, 0x41, 0x20, 0x6e, 0xdd, 0x2f, 0x63, 0x49, 0x06, 0xd4, 0xd3, 0xff, 0x01,
	0x0e, 0x0c, 0xd3, 0x08, 0x0c, 0x74, 0x65, 0xa8, 0x64, 0xbb, 0x45, 0xfa, 0x67, 0x0c, 0x56, 0xbe,
	0xf6, 0xcc, 0x21, 0xef, 0xcd, 0x57, 0xe1, 0xe8, 0x16, 0x24, 0xeb, 0x2c, 0x97, 0xb5, 0x2d, 0xc6,
	0x2a, 0x99, 0x15, 0x95, 0xb0, 0xb3, 0x29, 0x9d, 0xce, 0xa6, 0x7c, 0x46, 0x3b, 0xdb, 0x03, 0x83,
	0x54, 0x75, 0x08, 0xe1, 0xf4, 0xb9, 0x6b, 0xda, 0xd8, 0x6b, 0x99, 0x96, 0x9f, 0xd7, 0xb4, 0x8b,
	0x33, 0x4c, 0x3b, 0x22, 0xc2, 0xff, 0x63, 0x5a, 0x39, 0xb2, 0x9a, 0xc0, 0xac, 0xb6, 0x3a, 0xc3,
	0x66, 0xaf, 0x61, 0x09, 0x6a, 0x84, 0xde, 0x9e, 0x66, 0x1b, 0x61, 0x17, 0x56, 0xf6, 0xb0, 0x8d,
	0xff, 0x8d, 0x0f, 0xe8, 0xaf, 0x7a, 0xb9, 0xb3, 0x7f, 0xf5, 0x13, 0x07, 0xab, 0x9d, 0x16, 0xfb,
	0x45, 0x67, 0x18, 0x91, 0x0b, 0x7a, 0xef, 0xbf, 0x9f, 0x0e, 0xd2, 0xf7, 0x1c, 0x88, 0xe3, 0x78,
	0x45, 0x33, 0xe0, 0x53, 0x80, 0xee, 0xe8, 0xec, 0x0c, 0x82, 0x8d, 0x41, 0x3f, 0xf5, 0x46, 0x6b,
	0x37, 0x5f, 0xef, 0x4b, 0x9a, 0x77, 0x22, 0x64, 0x7f, 0x58, 0x82, 0x24, 0x65, 0xf1, 0x30, 0xbc,
	0x69, 0x20, 0x1f, 0x62, 0xf7, 0x70, 0x80, 0xae, 0x4d, 0x74, 0xef, 0xe0, 0x84, 0x16, 0xa7, 0xcf,
	0x27, 0xe9, 0xc3, 0x67, 0x7f, 0xfc, 0xf5, 0x7c, 0x61, 0x0d, 0xbd, 0x3f, 0x7c, 0x73, 0x20, 0xea,
	0x93, 0x48, 0xfb, 0xa7, 0xe8, 0x04, 0x78, 0x2a, 0x06, 0xba, 0x3e, 0x71, 0xad, 0xe1, 0xe1, 0x2e,
	0xa6, 0xe7, 0x81, 0x86, 0x6a, 0x4a, 0xab, 0x8c, 0xc3, 0x3b, 0x68, 0x65, 0x84, 0x03, 0x7a, 0xce,
	0x81, 0x10, 0xf6, 0x30, 0x94, 0x9e, 0x7f, 0xc8, 0x88, 0xb3, 0xcf, 0x42, 0xda, 0x3d, 0x7b, 0x91,
	0x16, 0xc7, 0x36, 0x48, 0x9e, 0xbe, 0x31, 0x4a, 0xef, 0x49, 0xa3, 0x94, 0x76, 0xb9, 0x34, 0xfa,
	0x99, 0x03, 0x21, 0x2c, 0xa8, 0x29, 0xac, 0x46, 0xba, 0xc8, 0x3c, 0xac, 0xf6, 0x42, 0x56, 0x63,
	0xaa, 0xb5, 0xc7, 0x6a, 0x3d, 0x3b, 0xed, 0xb0, 0x28, 0xbf, 0x5f, 0x39, 0x10, 0xc2, 0x2a, 0x9c,
	0xc2, 0x6f, 0xa4, 0xc4, 0xe7, 0xe1, 0xa7, 0x9f, 0xbd, 0x48, 0xdf, 0x18, 0x5b, 0xe2, 0x97, 0x87,
	0x5b, 0xfd, 0x7e, 0xcd, 0x0b, 0x9a, 0xa1, 0xbb, 0xd2, 0x53, 0xdd, 0xf5, 0x0b, 0x07, 0x97, 0xa8,
	0x29, 0x7a, 0x75, 0x86, 0xb2, 0x33, 0xdd, 0x33, 0xd2, 0x2c, 0xc4, 0xdc, 0x85, 0x72, 0x22, 0xeb,
	0x29, 0x8c, 0xe0, 0x16, 0xda, 0x9c, 0x42, 0xb0, 0x77, 0x4b, 0x26, 0xc5, 0xfd, 0x6f, 0xee, 0x56,
	0xac, 0xe0, 0x71, 0xfd, 0x88, 0xae, 0xaf, 0x86, 0x3f, 0x94, 0xc3, 0xdb, 0x72, 0xc5, 0x95, 0x2b,
	0xd8, 0x61, 0xdb, 0x57, 0x27, 0x5c, 0xc9, 0x6f, 0x45, 0x8f, 0x47, 0x02, 0x83, 0xe5, 0xfe, 0x09,
	0x00, 0x00, 0xff, 0xff, 0x64, 0xb4, 0x34, 0x53, 0x5d, 0x0c, 0x00, 0x00,
}
