// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/containerregistry/v1/registry_service.proto

package containerregistry // import "github.com/yandex-cloud/go-genproto/yandex/cloud/containerregistry/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/yandex-cloud/go-genproto/yandex/api"
import operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
import _ "github.com/yandex-cloud/go-genproto/yandex/cloud/validation"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type GetRegistryRequest struct {
	// ID of the Registry resource to return.
	//
	// To get the registry ID use a [RegistryService.List] request.
	RegistryId           string   `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetRegistryRequest) Reset()         { *m = GetRegistryRequest{} }
func (m *GetRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*GetRegistryRequest) ProtoMessage()    {}
func (*GetRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_registry_service_a571e9cda88c3d56, []int{0}
}
func (m *GetRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetRegistryRequest.Unmarshal(m, b)
}
func (m *GetRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetRegistryRequest.Marshal(b, m, deterministic)
}
func (dst *GetRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRegistryRequest.Merge(dst, src)
}
func (m *GetRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_GetRegistryRequest.Size(m)
}
func (m *GetRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetRegistryRequest proto.InternalMessageInfo

func (m *GetRegistryRequest) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

type ListRegistriesRequest struct {
	// ID of the folder to list registries in.
	//
	// To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListRegistriesResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListRegistriesResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on [Registry.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. Value or a list of values to compare against the values of the field.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRegistriesRequest) Reset()         { *m = ListRegistriesRequest{} }
func (m *ListRegistriesRequest) String() string { return proto.CompactTextString(m) }
func (*ListRegistriesRequest) ProtoMessage()    {}
func (*ListRegistriesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_registry_service_a571e9cda88c3d56, []int{1}
}
func (m *ListRegistriesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRegistriesRequest.Unmarshal(m, b)
}
func (m *ListRegistriesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRegistriesRequest.Marshal(b, m, deterministic)
}
func (dst *ListRegistriesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRegistriesRequest.Merge(dst, src)
}
func (m *ListRegistriesRequest) XXX_Size() int {
	return xxx_messageInfo_ListRegistriesRequest.Size(m)
}
func (m *ListRegistriesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRegistriesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListRegistriesRequest proto.InternalMessageInfo

func (m *ListRegistriesRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListRegistriesRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListRegistriesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListRegistriesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListRegistriesResponse struct {
	// List of Registry resources.
	Registries []*Registry `protobuf:"bytes,1,rep,name=registries,proto3" json:"registries,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListRegistriesRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListRegistriesRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRegistriesResponse) Reset()         { *m = ListRegistriesResponse{} }
func (m *ListRegistriesResponse) String() string { return proto.CompactTextString(m) }
func (*ListRegistriesResponse) ProtoMessage()    {}
func (*ListRegistriesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_registry_service_a571e9cda88c3d56, []int{2}
}
func (m *ListRegistriesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRegistriesResponse.Unmarshal(m, b)
}
func (m *ListRegistriesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRegistriesResponse.Marshal(b, m, deterministic)
}
func (dst *ListRegistriesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRegistriesResponse.Merge(dst, src)
}
func (m *ListRegistriesResponse) XXX_Size() int {
	return xxx_messageInfo_ListRegistriesResponse.Size(m)
}
func (m *ListRegistriesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRegistriesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListRegistriesResponse proto.InternalMessageInfo

func (m *ListRegistriesResponse) GetRegistries() []*Registry {
	if m != nil {
		return m.Registries
	}
	return nil
}

func (m *ListRegistriesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateRegistryRequest struct {
	// ID of the folder to create a registry in.
	//
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the registry.
	//
	// There may be only one registry per folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels               map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateRegistryRequest) Reset()         { *m = CreateRegistryRequest{} }
func (m *CreateRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*CreateRegistryRequest) ProtoMessage()    {}
func (*CreateRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_registry_service_a571e9cda88c3d56, []int{3}
}
func (m *CreateRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateRegistryRequest.Unmarshal(m, b)
}
func (m *CreateRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateRegistryRequest.Marshal(b, m, deterministic)
}
func (dst *CreateRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateRegistryRequest.Merge(dst, src)
}
func (m *CreateRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_CreateRegistryRequest.Size(m)
}
func (m *CreateRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateRegistryRequest proto.InternalMessageInfo

func (m *CreateRegistryRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateRegistryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateRegistryRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type CreateRegistryMetadata struct {
	// ID of the registry that is being created.
	RegistryId           string   `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateRegistryMetadata) Reset()         { *m = CreateRegistryMetadata{} }
func (m *CreateRegistryMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateRegistryMetadata) ProtoMessage()    {}
func (*CreateRegistryMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_registry_service_a571e9cda88c3d56, []int{4}
}
func (m *CreateRegistryMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateRegistryMetadata.Unmarshal(m, b)
}
func (m *CreateRegistryMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateRegistryMetadata.Marshal(b, m, deterministic)
}
func (dst *CreateRegistryMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateRegistryMetadata.Merge(dst, src)
}
func (m *CreateRegistryMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateRegistryMetadata.Size(m)
}
func (m *CreateRegistryMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateRegistryMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateRegistryMetadata proto.InternalMessageInfo

func (m *CreateRegistryMetadata) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

type UpdateRegistryRequest struct {
	// ID of the Registry resource to update.
	//
	// To get the registry ID use a [RegistryService.List] request.
	RegistryId string `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	// Field mask that specifies which fields of the Registry resource are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the registry.
	//
	// There may be only one registry per folder.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Resource labels as `key:value` pairs.
	//
	// Existing set of `labels` is completely replaced by the provided set.
	Labels               map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateRegistryRequest) Reset()         { *m = UpdateRegistryRequest{} }
func (m *UpdateRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateRegistryRequest) ProtoMessage()    {}
func (*UpdateRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_registry_service_a571e9cda88c3d56, []int{5}
}
func (m *UpdateRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateRegistryRequest.Unmarshal(m, b)
}
func (m *UpdateRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateRegistryRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateRegistryRequest.Merge(dst, src)
}
func (m *UpdateRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateRegistryRequest.Size(m)
}
func (m *UpdateRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateRegistryRequest proto.InternalMessageInfo

func (m *UpdateRegistryRequest) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

func (m *UpdateRegistryRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateRegistryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateRegistryRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type UpdateRegistryMetadata struct {
	// ID of the Registry resource that is being updated.
	RegistryId           string   `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateRegistryMetadata) Reset()         { *m = UpdateRegistryMetadata{} }
func (m *UpdateRegistryMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateRegistryMetadata) ProtoMessage()    {}
func (*UpdateRegistryMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_registry_service_a571e9cda88c3d56, []int{6}
}
func (m *UpdateRegistryMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateRegistryMetadata.Unmarshal(m, b)
}
func (m *UpdateRegistryMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateRegistryMetadata.Marshal(b, m, deterministic)
}
func (dst *UpdateRegistryMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateRegistryMetadata.Merge(dst, src)
}
func (m *UpdateRegistryMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateRegistryMetadata.Size(m)
}
func (m *UpdateRegistryMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateRegistryMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateRegistryMetadata proto.InternalMessageInfo

func (m *UpdateRegistryMetadata) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

type DeleteRegistryRequest struct {
	// ID of the registry to delete.
	RegistryId           string   `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteRegistryRequest) Reset()         { *m = DeleteRegistryRequest{} }
func (m *DeleteRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteRegistryRequest) ProtoMessage()    {}
func (*DeleteRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_registry_service_a571e9cda88c3d56, []int{7}
}
func (m *DeleteRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteRegistryRequest.Unmarshal(m, b)
}
func (m *DeleteRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteRegistryRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteRegistryRequest.Merge(dst, src)
}
func (m *DeleteRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteRegistryRequest.Size(m)
}
func (m *DeleteRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteRegistryRequest proto.InternalMessageInfo

func (m *DeleteRegistryRequest) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

type DeleteRegistryMetadata struct {
	// ID of the registry that is being deleted.
	RegistryId           string   `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteRegistryMetadata) Reset()         { *m = DeleteRegistryMetadata{} }
func (m *DeleteRegistryMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteRegistryMetadata) ProtoMessage()    {}
func (*DeleteRegistryMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_registry_service_a571e9cda88c3d56, []int{8}
}
func (m *DeleteRegistryMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteRegistryMetadata.Unmarshal(m, b)
}
func (m *DeleteRegistryMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteRegistryMetadata.Marshal(b, m, deterministic)
}
func (dst *DeleteRegistryMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteRegistryMetadata.Merge(dst, src)
}
func (m *DeleteRegistryMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteRegistryMetadata.Size(m)
}
func (m *DeleteRegistryMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteRegistryMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteRegistryMetadata proto.InternalMessageInfo

func (m *DeleteRegistryMetadata) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

func init() {
	proto.RegisterType((*GetRegistryRequest)(nil), "yandex.cloud.containerregistry.v1.GetRegistryRequest")
	proto.RegisterType((*ListRegistriesRequest)(nil), "yandex.cloud.containerregistry.v1.ListRegistriesRequest")
	proto.RegisterType((*ListRegistriesResponse)(nil), "yandex.cloud.containerregistry.v1.ListRegistriesResponse")
	proto.RegisterType((*CreateRegistryRequest)(nil), "yandex.cloud.containerregistry.v1.CreateRegistryRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.containerregistry.v1.CreateRegistryRequest.LabelsEntry")
	proto.RegisterType((*CreateRegistryMetadata)(nil), "yandex.cloud.containerregistry.v1.CreateRegistryMetadata")
	proto.RegisterType((*UpdateRegistryRequest)(nil), "yandex.cloud.containerregistry.v1.UpdateRegistryRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.containerregistry.v1.UpdateRegistryRequest.LabelsEntry")
	proto.RegisterType((*UpdateRegistryMetadata)(nil), "yandex.cloud.containerregistry.v1.UpdateRegistryMetadata")
	proto.RegisterType((*DeleteRegistryRequest)(nil), "yandex.cloud.containerregistry.v1.DeleteRegistryRequest")
	proto.RegisterType((*DeleteRegistryMetadata)(nil), "yandex.cloud.containerregistry.v1.DeleteRegistryMetadata")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// RegistryServiceClient is the client API for RegistryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RegistryServiceClient interface {
	// Returns the specified Registry resource.
	//
	// To get the list of available Registry resources, make a [List] request.
	Get(ctx context.Context, in *GetRegistryRequest, opts ...grpc.CallOption) (*Registry, error)
	// Retrieves the list of Registry resources in the specified folder.
	List(ctx context.Context, in *ListRegistriesRequest, opts ...grpc.CallOption) (*ListRegistriesResponse, error)
	// Creates a registry in the specified folder.
	Create(ctx context.Context, in *CreateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified registry.
	Update(ctx context.Context, in *UpdateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified registry.
	Delete(ctx context.Context, in *DeleteRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type registryServiceClient struct {
	cc *grpc.ClientConn
}

func NewRegistryServiceClient(cc *grpc.ClientConn) RegistryServiceClient {
	return &registryServiceClient{cc}
}

func (c *registryServiceClient) Get(ctx context.Context, in *GetRegistryRequest, opts ...grpc.CallOption) (*Registry, error) {
	out := new(Registry)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) List(ctx context.Context, in *ListRegistriesRequest, opts ...grpc.CallOption) (*ListRegistriesResponse, error) {
	out := new(ListRegistriesResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) Create(ctx context.Context, in *CreateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) Update(ctx context.Context, in *UpdateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) Delete(ctx context.Context, in *DeleteRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RegistryServiceServer is the server API for RegistryService service.
type RegistryServiceServer interface {
	// Returns the specified Registry resource.
	//
	// To get the list of available Registry resources, make a [List] request.
	Get(context.Context, *GetRegistryRequest) (*Registry, error)
	// Retrieves the list of Registry resources in the specified folder.
	List(context.Context, *ListRegistriesRequest) (*ListRegistriesResponse, error)
	// Creates a registry in the specified folder.
	Create(context.Context, *CreateRegistryRequest) (*operation.Operation, error)
	// Updates the specified registry.
	Update(context.Context, *UpdateRegistryRequest) (*operation.Operation, error)
	// Deletes the specified registry.
	Delete(context.Context, *DeleteRegistryRequest) (*operation.Operation, error)
}

func RegisterRegistryServiceServer(s *grpc.Server, srv RegistryServiceServer) {
	s.RegisterService(&_RegistryService_serviceDesc, srv)
}

func _RegistryService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).Get(ctx, req.(*GetRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRegistriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).List(ctx, req.(*ListRegistriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).Create(ctx, req.(*CreateRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).Update(ctx, req.(*UpdateRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).Delete(ctx, req.(*DeleteRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RegistryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.containerregistry.v1.RegistryService",
	HandlerType: (*RegistryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _RegistryService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _RegistryService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _RegistryService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _RegistryService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _RegistryService_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/containerregistry/v1/registry_service.proto",
}

func init() {
	proto.RegisterFile("yandex/cloud/containerregistry/v1/registry_service.proto", fileDescriptor_registry_service_a571e9cda88c3d56)
}

var fileDescriptor_registry_service_a571e9cda88c3d56 = []byte{
	// 885 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x96, 0xcf, 0x8f, 0xdb, 0x44,
	0x14, 0xc7, 0xe5, 0x75, 0x6a, 0x36, 0x2f, 0xa0, 0x56, 0x23, 0x52, 0x45, 0x16, 0x15, 0xbb, 0x46,
	0x5a, 0xb6, 0x01, 0xdb, 0xf1, 0xb6, 0xbb, 0x6c, 0xfa, 0x43, 0x48, 0xe9, 0x2f, 0x55, 0xb4, 0x02,
	0xb9, 0x20, 0x04, 0xab, 0x2a, 0xcc, 0xae, 0x27, 0x61, 0x88, 0x63, 0x07, 0x7b, 0x12, 0x35, 0x29,
	0xbd, 0xf4, 0xb8, 0x12, 0x27, 0xc4, 0x91, 0x0b, 0x07, 0xfe, 0x80, 0xbd, 0xed, 0x5f, 0x90, 0x5c,
	0x29, 0xfc, 0x09, 0x1c, 0x38, 0xf7, 0xc8, 0x09, 0x79, 0xc6, 0x4e, 0xe3, 0x8d, 0xa3, 0x38, 0xe5,
	0xc2, 0x6d, 0xec, 0xf7, 0xde, 0xd7, 0x9f, 0x37, 0x6f, 0xde, 0x1b, 0xc3, 0xfe, 0x10, 0x7b, 0x0e,
	0x79, 0x62, 0x1e, 0xb9, 0x7e, 0xdf, 0x31, 0x8f, 0x7c, 0x8f, 0x61, 0xea, 0x91, 0x20, 0x20, 0x6d,
	0x1a, 0xb2, 0x60, 0x68, 0x0e, 0x2c, 0x33, 0x59, 0x37, 0x43, 0x12, 0x0c, 0xe8, 0x11, 0x31, 0x7a,
	0x81, 0xcf, 0x7c, 0xb4, 0x29, 0x22, 0x0d, 0x1e, 0x69, 0xcc, 0x45, 0x1a, 0x03, 0x4b, 0x55, 0x63,
	0x71, 0xdc, 0xa3, 0xa6, 0xdf, 0x23, 0x01, 0x66, 0xd4, 0xf7, 0x44, 0xb8, 0x5a, 0xcb, 0xff, 0xe1,
	0x38, 0x62, 0x2b, 0x15, 0x31, 0xd5, 0x9b, 0x53, 0xbe, 0x94, 0xf2, 0x1b, 0x60, 0x97, 0x3a, 0xb3,
	0xe6, 0x8d, 0xb6, 0xef, 0xb7, 0x5d, 0x62, 0xf2, 0xa7, 0xc3, 0x7e, 0xcb, 0x6c, 0x51, 0xe2, 0x3a,
	0xcd, 0x2e, 0x0e, 0x3b, 0xb1, 0xc7, 0x3b, 0xb1, 0x47, 0x84, 0x8d, 0x3d, 0xcf, 0x67, 0x3c, 0x3c,
	0x14, 0x56, 0xed, 0x16, 0xa0, 0x7b, 0x84, 0xd9, 0x31, 0x9b, 0x4d, 0xbe, 0xef, 0x93, 0x90, 0x21,
	0x1d, 0x4a, 0xd3, 0x7d, 0xa2, 0x4e, 0x45, 0xda, 0x90, 0xb6, 0x8b, 0x8d, 0x37, 0xff, 0x1e, 0x5b,
	0xd2, 0xf1, 0xc4, 0x2a, 0xdc, 0xb8, 0xb9, 0x5b, 0xb3, 0x21, 0x71, 0xb8, 0xef, 0x68, 0xa7, 0x12,
	0x94, 0x1f, 0xd0, 0x30, 0x91, 0xa1, 0x24, 0x4c, 0x84, 0x2e, 0x43, 0xb1, 0xe5, 0xbb, 0x0e, 0x09,
	0x16, 0xc9, 0xac, 0x0b, 0xf3, 0x7d, 0x07, 0xbd, 0x0f, 0xc5, 0x1e, 0x6e, 0x93, 0x66, 0x48, 0x47,
	0xa4, 0xb2, 0xb6, 0x21, 0x6d, 0xcb, 0x0d, 0xf8, 0x67, 0x6c, 0x29, 0x37, 0x6e, 0x5a, 0xb5, 0x5a,
	0xcd, 0x5e, 0x8f, 0x8c, 0x8f, 0xe8, 0x88, 0xa0, 0x6d, 0x00, 0xee, 0xc8, 0xfc, 0x0e, 0xf1, 0x2a,
	0x32, 0x17, 0x2d, 0x1e, 0x4f, 0xac, 0x73, 0xdc, 0xd3, 0xe6, 0x2a, 0x9f, 0x47, 0x36, 0xa4, 0x81,
	0xd2, 0xa2, 0x2e, 0x23, 0x41, 0xa5, 0xc0, 0xbd, 0xe0, 0x78, 0x32, 0xd5, 0x8b, 0x2d, 0xda, 0x8f,
	0x12, 0x5c, 0x3c, 0xcb, 0x1e, 0xf6, 0x7c, 0x2f, 0x24, 0xe8, 0x13, 0x48, 0x92, 0xa4, 0x24, 0xac,
	0x48, 0x1b, 0xf2, 0x76, 0x69, 0xe7, 0x03, 0x63, 0xe9, 0x41, 0x31, 0xa6, 0xbb, 0x39, 0x13, 0x8e,
	0xb6, 0xe0, 0xbc, 0x47, 0x9e, 0xb0, 0xe6, 0x0c, 0x7a, 0x94, 0x64, 0xd1, 0x7e, 0x2b, 0x7a, 0xfd,
	0x59, 0xc2, 0xac, 0xfd, 0xb9, 0x06, 0xe5, 0x5b, 0x01, 0xc1, 0x8c, 0x9c, 0x2d, 0xca, 0x0a, 0x7b,
	0xb9, 0x0b, 0x05, 0x0f, 0x77, 0xc5, 0x36, 0x16, 0x1b, 0x9b, 0x2f, 0xc7, 0xd6, 0xa5, 0x1f, 0x0e,
	0xb0, 0x3e, 0x7a, 0x7c, 0xa0, 0x63, 0x7d, 0x54, 0xd3, 0xeb, 0x8f, 0x9f, 0x5a, 0x1f, 0xee, 0x59,
	0xcf, 0x0e, 0xe2, 0x27, 0x9b, 0xbb, 0xa3, 0x5f, 0x24, 0x50, 0x5c, 0x7c, 0x48, 0xdc, 0xb0, 0x22,
	0xf3, 0x6c, 0x6f, 0xe7, 0xc8, 0x36, 0x13, 0xd6, 0x78, 0xc0, 0x65, 0xee, 0x78, 0x2c, 0x18, 0x36,
	0x3e, 0x7e, 0x39, 0xb6, 0x4a, 0x07, 0x7a, 0xb3, 0xa6, 0xd7, 0x23, 0x86, 0xea, 0x73, 0x0e, 0xbc,
	0x77, 0x55, 0x80, 0xef, 0x5d, 0x39, 0x99, 0x58, 0x8a, 0x5a, 0xb0, 0x74, 0xbe, 0x42, 0xe8, 0x42,
	0x4c, 0x3a, 0xf5, 0xb7, 0x63, 0x28, 0xb5, 0x0e, 0xa5, 0x19, 0x5d, 0x74, 0x01, 0xe4, 0x0e, 0x19,
	0x8a, 0xad, 0xb0, 0xa3, 0x25, 0x7a, 0x1b, 0xce, 0x0d, 0xb0, 0xdb, 0x8f, 0x13, 0xb7, 0xc5, 0xc3,
	0xb5, 0xb5, 0x7d, 0x49, 0xab, 0xc3, 0xc5, 0x34, 0xe8, 0x43, 0xc2, 0xb0, 0x83, 0x19, 0x46, 0xef,
	0x66, 0x9c, 0xf5, 0xd4, 0xe9, 0xfe, 0x59, 0x86, 0xf2, 0x17, 0x3d, 0x27, 0xa3, 0x22, 0xab, 0xb5,
	0x09, 0xba, 0x0e, 0xa5, 0x3e, 0xd7, 0xe1, 0xed, 0xc9, 0x19, 0x4b, 0x3b, 0xaa, 0x21, 0xfa, 0xd3,
	0x48, 0x3a, 0xd8, 0xb8, 0x1b, 0x75, 0xf0, 0x43, 0x1c, 0x76, 0x6c, 0x10, 0xee, 0xd1, 0x7a, 0x5a,
	0x52, 0xf9, 0xb5, 0x4b, 0x5a, 0xc8, 0x5d, 0xd2, 0xcc, 0x6c, 0xff, 0x8f, 0x25, 0x4d, 0x83, 0xe6,
	0x2f, 0xe9, 0x5d, 0x28, 0xdf, 0x26, 0x2e, 0xf9, 0xaf, 0x15, 0x8d, 0x10, 0xd2, 0x3a, 0xb9, 0x11,
	0x76, 0x4e, 0xdf, 0x80, 0xf3, 0x49, 0xd4, 0x23, 0x71, 0x15, 0xa1, 0x5f, 0x25, 0x90, 0xef, 0x11,
	0x86, 0x76, 0x73, 0xd4, 0x68, 0x7e, 0x6a, 0xab, 0xab, 0xcc, 0x26, 0xed, 0xa3, 0xe7, 0x7f, 0xfc,
	0xf5, 0xd3, 0x9a, 0x85, 0xcc, 0x57, 0xb7, 0x95, 0x9e, 0x71, 0x5d, 0x51, 0x12, 0x9a, 0x4f, 0x67,
	0x32, 0x79, 0x86, 0x7e, 0x93, 0xa0, 0x10, 0x0d, 0x4c, 0xb4, 0x9f, 0xe3, 0x73, 0x99, 0xb7, 0x82,
	0x5a, 0x7f, 0x8d, 0x48, 0x31, 0x93, 0xb5, 0xcb, 0x1c, 0xfb, 0x3d, 0xb4, 0xb9, 0x14, 0x1b, 0x9d,
	0x4a, 0xa0, 0x88, 0x9e, 0xcf, 0x85, 0x9a, 0x39, 0xc7, 0xd4, 0xcd, 0x74, 0xe4, 0xab, 0xdb, 0xf9,
	0xd3, 0x64, 0xa5, 0xd9, 0x27, 0x2f, 0xaa, 0xda, 0xc2, 0xf1, 0xb2, 0x9e, 0xbc, 0xe1, 0xe0, 0x5b,
	0xda, 0x72, 0xf0, 0x6b, 0x52, 0x15, 0x8d, 0x25, 0x50, 0xc4, 0xe1, 0xce, 0xc5, 0x9e, 0xd9, 0xb0,
	0x79, 0xd8, 0xbf, 0x11, 0xec, 0x0b, 0xfa, 0x28, 0xcd, 0x7e, 0x75, 0x67, 0xd5, 0xb3, 0x12, 0x65,
	0xf2, 0xbb, 0x04, 0x8a, 0xe8, 0x91, 0x5c, 0x99, 0x64, 0xb6, 0x65, 0x9e, 0x4c, 0xbe, 0x3b, 0x79,
	0x51, 0x35, 0x17, 0xb6, 0x63, 0xf9, 0xec, 0x90, 0xbd, 0xd3, 0xed, 0x31, 0x91, 0x96, 0x55, 0x5d,
	0x35, 0xad, 0xc6, 0x57, 0x5f, 0x7f, 0xd9, 0xa6, 0xec, 0xdb, 0xfe, 0xa1, 0x71, 0xe4, 0x77, 0x4d,
	0x81, 0xa6, 0x8b, 0x1f, 0xb4, 0xb6, 0xaf, 0xb7, 0x89, 0xc7, 0x3f, 0x63, 0x2e, 0xfd, 0x27, 0xbc,
	0x3e, 0xf7, 0xf2, 0x50, 0xe1, 0xa1, 0x57, 0xfe, 0x0d, 0x00, 0x00, 0xff, 0xff, 0xbe, 0x24, 0x8d,
	0x20, 0xca, 0x0a, 0x00, 0x00,
}
