// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/iam/v1/service_account_service.proto

package iam // import "github.com/yandex-cloud/go-genproto/yandex/cloud/iam/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/yandex-cloud/go-genproto/yandex/api"
import access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
import operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
import _ "github.com/yandex-cloud/go-genproto/yandex/cloud/validation"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type GetServiceAccountRequest struct {
	// ID of the ServiceAccount resource to return.
	// To get the service account ID, use a [ServiceAccountService.List] request.
	ServiceAccountId     string   `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetServiceAccountRequest) Reset()         { *m = GetServiceAccountRequest{} }
func (m *GetServiceAccountRequest) String() string { return proto.CompactTextString(m) }
func (*GetServiceAccountRequest) ProtoMessage()    {}
func (*GetServiceAccountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_account_service_4c6626479d4f1223, []int{0}
}
func (m *GetServiceAccountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServiceAccountRequest.Unmarshal(m, b)
}
func (m *GetServiceAccountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServiceAccountRequest.Marshal(b, m, deterministic)
}
func (dst *GetServiceAccountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServiceAccountRequest.Merge(dst, src)
}
func (m *GetServiceAccountRequest) XXX_Size() int {
	return xxx_messageInfo_GetServiceAccountRequest.Size(m)
}
func (m *GetServiceAccountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServiceAccountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetServiceAccountRequest proto.InternalMessageInfo

func (m *GetServiceAccountRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

type ListServiceAccountsRequest struct {
	// ID of the folder to list service accounts in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListServiceAccountsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token]
	// to the [ListServiceAccountsResponse.next_page_token]
	// returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on the [ServiceAccount.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9]$`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServiceAccountsRequest) Reset()         { *m = ListServiceAccountsRequest{} }
func (m *ListServiceAccountsRequest) String() string { return proto.CompactTextString(m) }
func (*ListServiceAccountsRequest) ProtoMessage()    {}
func (*ListServiceAccountsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_account_service_4c6626479d4f1223, []int{1}
}
func (m *ListServiceAccountsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServiceAccountsRequest.Unmarshal(m, b)
}
func (m *ListServiceAccountsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServiceAccountsRequest.Marshal(b, m, deterministic)
}
func (dst *ListServiceAccountsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServiceAccountsRequest.Merge(dst, src)
}
func (m *ListServiceAccountsRequest) XXX_Size() int {
	return xxx_messageInfo_ListServiceAccountsRequest.Size(m)
}
func (m *ListServiceAccountsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServiceAccountsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListServiceAccountsRequest proto.InternalMessageInfo

func (m *ListServiceAccountsRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListServiceAccountsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListServiceAccountsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListServiceAccountsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListServiceAccountsResponse struct {
	// List of ServiceAccount resources.
	ServiceAccounts []*ServiceAccount `protobuf:"bytes,1,rep,name=service_accounts,json=serviceAccounts,proto3" json:"service_accounts,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListServiceAccountsRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListServiceAccountsRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServiceAccountsResponse) Reset()         { *m = ListServiceAccountsResponse{} }
func (m *ListServiceAccountsResponse) String() string { return proto.CompactTextString(m) }
func (*ListServiceAccountsResponse) ProtoMessage()    {}
func (*ListServiceAccountsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_account_service_4c6626479d4f1223, []int{2}
}
func (m *ListServiceAccountsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServiceAccountsResponse.Unmarshal(m, b)
}
func (m *ListServiceAccountsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServiceAccountsResponse.Marshal(b, m, deterministic)
}
func (dst *ListServiceAccountsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServiceAccountsResponse.Merge(dst, src)
}
func (m *ListServiceAccountsResponse) XXX_Size() int {
	return xxx_messageInfo_ListServiceAccountsResponse.Size(m)
}
func (m *ListServiceAccountsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServiceAccountsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListServiceAccountsResponse proto.InternalMessageInfo

func (m *ListServiceAccountsResponse) GetServiceAccounts() []*ServiceAccount {
	if m != nil {
		return m.ServiceAccounts
	}
	return nil
}

func (m *ListServiceAccountsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateServiceAccountRequest struct {
	// ID of the folder to create a service account in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the service account.
	// The name must be unique within the cloud.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the service account.
	Description          string   `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateServiceAccountRequest) Reset()         { *m = CreateServiceAccountRequest{} }
func (m *CreateServiceAccountRequest) String() string { return proto.CompactTextString(m) }
func (*CreateServiceAccountRequest) ProtoMessage()    {}
func (*CreateServiceAccountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_account_service_4c6626479d4f1223, []int{3}
}
func (m *CreateServiceAccountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateServiceAccountRequest.Unmarshal(m, b)
}
func (m *CreateServiceAccountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateServiceAccountRequest.Marshal(b, m, deterministic)
}
func (dst *CreateServiceAccountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateServiceAccountRequest.Merge(dst, src)
}
func (m *CreateServiceAccountRequest) XXX_Size() int {
	return xxx_messageInfo_CreateServiceAccountRequest.Size(m)
}
func (m *CreateServiceAccountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateServiceAccountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateServiceAccountRequest proto.InternalMessageInfo

func (m *CreateServiceAccountRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateServiceAccountRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateServiceAccountRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

type CreateServiceAccountMetadata struct {
	// ID of the service account that is being created.
	ServiceAccountId     string   `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateServiceAccountMetadata) Reset()         { *m = CreateServiceAccountMetadata{} }
func (m *CreateServiceAccountMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateServiceAccountMetadata) ProtoMessage()    {}
func (*CreateServiceAccountMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_account_service_4c6626479d4f1223, []int{4}
}
func (m *CreateServiceAccountMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateServiceAccountMetadata.Unmarshal(m, b)
}
func (m *CreateServiceAccountMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateServiceAccountMetadata.Marshal(b, m, deterministic)
}
func (dst *CreateServiceAccountMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateServiceAccountMetadata.Merge(dst, src)
}
func (m *CreateServiceAccountMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateServiceAccountMetadata.Size(m)
}
func (m *CreateServiceAccountMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateServiceAccountMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateServiceAccountMetadata proto.InternalMessageInfo

func (m *CreateServiceAccountMetadata) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

type UpdateServiceAccountRequest struct {
	// ID of the ServiceAccount resource to update.
	// To get the service account ID, use a [ServiceAccountService.List] request.
	ServiceAccountId string `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Field mask that specifies which fields of the ServiceAccount resource are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the service account.
	// The name must be unique within the cloud.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the service account.
	Description          string   `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateServiceAccountRequest) Reset()         { *m = UpdateServiceAccountRequest{} }
func (m *UpdateServiceAccountRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateServiceAccountRequest) ProtoMessage()    {}
func (*UpdateServiceAccountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_account_service_4c6626479d4f1223, []int{5}
}
func (m *UpdateServiceAccountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateServiceAccountRequest.Unmarshal(m, b)
}
func (m *UpdateServiceAccountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateServiceAccountRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateServiceAccountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateServiceAccountRequest.Merge(dst, src)
}
func (m *UpdateServiceAccountRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateServiceAccountRequest.Size(m)
}
func (m *UpdateServiceAccountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateServiceAccountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateServiceAccountRequest proto.InternalMessageInfo

func (m *UpdateServiceAccountRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *UpdateServiceAccountRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateServiceAccountRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateServiceAccountRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

type UpdateServiceAccountMetadata struct {
	// ID of the ServiceAccount resource that is being updated.
	ServiceAccountId     string   `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateServiceAccountMetadata) Reset()         { *m = UpdateServiceAccountMetadata{} }
func (m *UpdateServiceAccountMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateServiceAccountMetadata) ProtoMessage()    {}
func (*UpdateServiceAccountMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_account_service_4c6626479d4f1223, []int{6}
}
func (m *UpdateServiceAccountMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateServiceAccountMetadata.Unmarshal(m, b)
}
func (m *UpdateServiceAccountMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateServiceAccountMetadata.Marshal(b, m, deterministic)
}
func (dst *UpdateServiceAccountMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateServiceAccountMetadata.Merge(dst, src)
}
func (m *UpdateServiceAccountMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateServiceAccountMetadata.Size(m)
}
func (m *UpdateServiceAccountMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateServiceAccountMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateServiceAccountMetadata proto.InternalMessageInfo

func (m *UpdateServiceAccountMetadata) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

type DeleteServiceAccountRequest struct {
	// ID of the service account to delete.
	// To get the service account ID, use a [ServiceAccountService.List] request.
	ServiceAccountId     string   `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteServiceAccountRequest) Reset()         { *m = DeleteServiceAccountRequest{} }
func (m *DeleteServiceAccountRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteServiceAccountRequest) ProtoMessage()    {}
func (*DeleteServiceAccountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_account_service_4c6626479d4f1223, []int{7}
}
func (m *DeleteServiceAccountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteServiceAccountRequest.Unmarshal(m, b)
}
func (m *DeleteServiceAccountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteServiceAccountRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteServiceAccountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteServiceAccountRequest.Merge(dst, src)
}
func (m *DeleteServiceAccountRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteServiceAccountRequest.Size(m)
}
func (m *DeleteServiceAccountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteServiceAccountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteServiceAccountRequest proto.InternalMessageInfo

func (m *DeleteServiceAccountRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

type DeleteServiceAccountMetadata struct {
	// ID of the service account that is being deleted.
	ServiceAccountId     string   `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteServiceAccountMetadata) Reset()         { *m = DeleteServiceAccountMetadata{} }
func (m *DeleteServiceAccountMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteServiceAccountMetadata) ProtoMessage()    {}
func (*DeleteServiceAccountMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_account_service_4c6626479d4f1223, []int{8}
}
func (m *DeleteServiceAccountMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteServiceAccountMetadata.Unmarshal(m, b)
}
func (m *DeleteServiceAccountMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteServiceAccountMetadata.Marshal(b, m, deterministic)
}
func (dst *DeleteServiceAccountMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteServiceAccountMetadata.Merge(dst, src)
}
func (m *DeleteServiceAccountMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteServiceAccountMetadata.Size(m)
}
func (m *DeleteServiceAccountMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteServiceAccountMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteServiceAccountMetadata proto.InternalMessageInfo

func (m *DeleteServiceAccountMetadata) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

type ListServiceAccountOperationsRequest struct {
	// ID of the ServiceAccount resource to list operations for.
	ServiceAccountId string `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListServiceAccountOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token]
	// to the [ListServiceAccountOperationsResponse.next_page_token]
	// returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServiceAccountOperationsRequest) Reset()         { *m = ListServiceAccountOperationsRequest{} }
func (m *ListServiceAccountOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListServiceAccountOperationsRequest) ProtoMessage()    {}
func (*ListServiceAccountOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_account_service_4c6626479d4f1223, []int{9}
}
func (m *ListServiceAccountOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServiceAccountOperationsRequest.Unmarshal(m, b)
}
func (m *ListServiceAccountOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServiceAccountOperationsRequest.Marshal(b, m, deterministic)
}
func (dst *ListServiceAccountOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServiceAccountOperationsRequest.Merge(dst, src)
}
func (m *ListServiceAccountOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListServiceAccountOperationsRequest.Size(m)
}
func (m *ListServiceAccountOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServiceAccountOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListServiceAccountOperationsRequest proto.InternalMessageInfo

func (m *ListServiceAccountOperationsRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *ListServiceAccountOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListServiceAccountOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListServiceAccountOperationsResponse struct {
	// List of operations for the specified service account.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListServiceAccountOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListServiceAccountOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServiceAccountOperationsResponse) Reset()         { *m = ListServiceAccountOperationsResponse{} }
func (m *ListServiceAccountOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListServiceAccountOperationsResponse) ProtoMessage()    {}
func (*ListServiceAccountOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_account_service_4c6626479d4f1223, []int{10}
}
func (m *ListServiceAccountOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServiceAccountOperationsResponse.Unmarshal(m, b)
}
func (m *ListServiceAccountOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServiceAccountOperationsResponse.Marshal(b, m, deterministic)
}
func (dst *ListServiceAccountOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServiceAccountOperationsResponse.Merge(dst, src)
}
func (m *ListServiceAccountOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListServiceAccountOperationsResponse.Size(m)
}
func (m *ListServiceAccountOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServiceAccountOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListServiceAccountOperationsResponse proto.InternalMessageInfo

func (m *ListServiceAccountOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListServiceAccountOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetServiceAccountRequest)(nil), "yandex.cloud.iam.v1.GetServiceAccountRequest")
	proto.RegisterType((*ListServiceAccountsRequest)(nil), "yandex.cloud.iam.v1.ListServiceAccountsRequest")
	proto.RegisterType((*ListServiceAccountsResponse)(nil), "yandex.cloud.iam.v1.ListServiceAccountsResponse")
	proto.RegisterType((*CreateServiceAccountRequest)(nil), "yandex.cloud.iam.v1.CreateServiceAccountRequest")
	proto.RegisterType((*CreateServiceAccountMetadata)(nil), "yandex.cloud.iam.v1.CreateServiceAccountMetadata")
	proto.RegisterType((*UpdateServiceAccountRequest)(nil), "yandex.cloud.iam.v1.UpdateServiceAccountRequest")
	proto.RegisterType((*UpdateServiceAccountMetadata)(nil), "yandex.cloud.iam.v1.UpdateServiceAccountMetadata")
	proto.RegisterType((*DeleteServiceAccountRequest)(nil), "yandex.cloud.iam.v1.DeleteServiceAccountRequest")
	proto.RegisterType((*DeleteServiceAccountMetadata)(nil), "yandex.cloud.iam.v1.DeleteServiceAccountMetadata")
	proto.RegisterType((*ListServiceAccountOperationsRequest)(nil), "yandex.cloud.iam.v1.ListServiceAccountOperationsRequest")
	proto.RegisterType((*ListServiceAccountOperationsResponse)(nil), "yandex.cloud.iam.v1.ListServiceAccountOperationsResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ServiceAccountServiceClient is the client API for ServiceAccountService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ServiceAccountServiceClient interface {
	// Returns the specified ServiceAccount resource.
	//
	// To get the list of available ServiceAccount resources, use a [List] request.
	Get(ctx context.Context, in *GetServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error)
	// Retrieves the list of ServiceAccount resources in the specified folder.
	List(ctx context.Context, in *ListServiceAccountsRequest, opts ...grpc.CallOption) (*ListServiceAccountsResponse, error)
	// Creates a service account in the specified folder.
	Create(ctx context.Context, in *CreateServiceAccountRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified service account.
	Update(ctx context.Context, in *UpdateServiceAccountRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified service account.
	Delete(ctx context.Context, in *DeleteServiceAccountRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists access bindings for the specified service account.
	ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the service account.
	SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates access bindings for the specified service account.
	UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists operations for the specified service account.
	ListOperations(ctx context.Context, in *ListServiceAccountOperationsRequest, opts ...grpc.CallOption) (*ListServiceAccountOperationsResponse, error)
}

type serviceAccountServiceClient struct {
	cc *grpc.ClientConn
}

func NewServiceAccountServiceClient(cc *grpc.ClientConn) ServiceAccountServiceClient {
	return &serviceAccountServiceClient{cc}
}

func (c *serviceAccountServiceClient) Get(ctx context.Context, in *GetServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error) {
	out := new(ServiceAccount)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ServiceAccountService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceAccountServiceClient) List(ctx context.Context, in *ListServiceAccountsRequest, opts ...grpc.CallOption) (*ListServiceAccountsResponse, error) {
	out := new(ListServiceAccountsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ServiceAccountService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceAccountServiceClient) Create(ctx context.Context, in *CreateServiceAccountRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ServiceAccountService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceAccountServiceClient) Update(ctx context.Context, in *UpdateServiceAccountRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ServiceAccountService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceAccountServiceClient) Delete(ctx context.Context, in *DeleteServiceAccountRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ServiceAccountService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceAccountServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	out := new(access.ListAccessBindingsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ServiceAccountService/ListAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceAccountServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ServiceAccountService/SetAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceAccountServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ServiceAccountService/UpdateAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceAccountServiceClient) ListOperations(ctx context.Context, in *ListServiceAccountOperationsRequest, opts ...grpc.CallOption) (*ListServiceAccountOperationsResponse, error) {
	out := new(ListServiceAccountOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ServiceAccountService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ServiceAccountServiceServer is the server API for ServiceAccountService service.
type ServiceAccountServiceServer interface {
	// Returns the specified ServiceAccount resource.
	//
	// To get the list of available ServiceAccount resources, use a [List] request.
	Get(context.Context, *GetServiceAccountRequest) (*ServiceAccount, error)
	// Retrieves the list of ServiceAccount resources in the specified folder.
	List(context.Context, *ListServiceAccountsRequest) (*ListServiceAccountsResponse, error)
	// Creates a service account in the specified folder.
	Create(context.Context, *CreateServiceAccountRequest) (*operation.Operation, error)
	// Updates the specified service account.
	Update(context.Context, *UpdateServiceAccountRequest) (*operation.Operation, error)
	// Deletes the specified service account.
	Delete(context.Context, *DeleteServiceAccountRequest) (*operation.Operation, error)
	// Lists access bindings for the specified service account.
	ListAccessBindings(context.Context, *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the service account.
	SetAccessBindings(context.Context, *access.SetAccessBindingsRequest) (*operation.Operation, error)
	// Updates access bindings for the specified service account.
	UpdateAccessBindings(context.Context, *access.UpdateAccessBindingsRequest) (*operation.Operation, error)
	// Lists operations for the specified service account.
	ListOperations(context.Context, *ListServiceAccountOperationsRequest) (*ListServiceAccountOperationsResponse, error)
}

func RegisterServiceAccountServiceServer(s *grpc.Server, srv ServiceAccountServiceServer) {
	s.RegisterService(&_ServiceAccountService_serviceDesc, srv)
}

func _ServiceAccountService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ServiceAccountService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).Get(ctx, req.(*GetServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceAccountService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ServiceAccountService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).List(ctx, req.(*ListServiceAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceAccountService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ServiceAccountService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).Create(ctx, req.(*CreateServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceAccountService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ServiceAccountService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).Update(ctx, req.(*UpdateServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceAccountService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ServiceAccountService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).Delete(ctx, req.(*DeleteServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceAccountService_ListAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.ListAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).ListAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ServiceAccountService/ListAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).ListAccessBindings(ctx, req.(*access.ListAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceAccountService_SetAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.SetAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).SetAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ServiceAccountService/SetAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).SetAccessBindings(ctx, req.(*access.SetAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceAccountService_UpdateAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.UpdateAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).UpdateAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ServiceAccountService/UpdateAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).UpdateAccessBindings(ctx, req.(*access.UpdateAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceAccountService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceAccountOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ServiceAccountService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).ListOperations(ctx, req.(*ListServiceAccountOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ServiceAccountService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.iam.v1.ServiceAccountService",
	HandlerType: (*ServiceAccountServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _ServiceAccountService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ServiceAccountService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _ServiceAccountService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _ServiceAccountService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ServiceAccountService_Delete_Handler,
		},
		{
			MethodName: "ListAccessBindings",
			Handler:    _ServiceAccountService_ListAccessBindings_Handler,
		},
		{
			MethodName: "SetAccessBindings",
			Handler:    _ServiceAccountService_SetAccessBindings_Handler,
		},
		{
			MethodName: "UpdateAccessBindings",
			Handler:    _ServiceAccountService_UpdateAccessBindings_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _ServiceAccountService_ListOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/iam/v1/service_account_service.proto",
}

func init() {
	proto.RegisterFile("yandex/cloud/iam/v1/service_account_service.proto", fileDescriptor_service_account_service_4c6626479d4f1223)
}

var fileDescriptor_service_account_service_4c6626479d4f1223 = []byte{
	// 1016 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0x5d, 0x6f, 0xdb, 0x54,
	0x18, 0xd6, 0x59, 0x43, 0xb4, 0xbc, 0x65, 0x1f, 0x1c, 0x98, 0x08, 0x6e, 0x27, 0x82, 0x0b, 0xa3,
	0x0b, 0x8d, 0x1d, 0x07, 0xba, 0x2d, 0xfd, 0xd0, 0x68, 0xf8, 0x98, 0x26, 0x6d, 0x80, 0xdc, 0x81,
	0x04, 0xd5, 0x14, 0x9d, 0xda, 0xa7, 0xe1, 0xa8, 0x89, 0x1d, 0x7c, 0x9c, 0x6a, 0xeb, 0x98, 0x90,
	0x90, 0xb8, 0xe9, 0x0d, 0x42, 0x88, 0xff, 0x81, 0x0a, 0x12, 0x77, 0x5c, 0xd2, 0x5e, 0x70, 0x55,
	0xfe, 0x02, 0x42, 0xbb, 0x86, 0x3b, 0x2e, 0x10, 0xf2, 0x39, 0x4e, 0x5a, 0x3b, 0x76, 0xea, 0x74,
	0xdb, 0x55, 0x6b, 0xbf, 0x1f, 0xe7, 0x79, 0x9e, 0xf3, 0x9e, 0xe7, 0xc4, 0x60, 0xdc, 0x27, 0x8e,
	0x4d, 0xef, 0xe9, 0x56, 0xdb, 0xed, 0xd9, 0x3a, 0x23, 0x1d, 0x7d, 0xcb, 0xd0, 0x39, 0xf5, 0xb6,
	0x98, 0x45, 0x9b, 0xc4, 0xb2, 0xdc, 0x9e, 0xe3, 0x37, 0xc3, 0x67, 0xad, 0xeb, 0xb9, 0xbe, 0x8b,
	0x9f, 0x97, 0x25, 0x9a, 0x28, 0xd1, 0x18, 0xe9, 0x68, 0x5b, 0x86, 0x32, 0xdd, 0x72, 0xdd, 0x56,
	0x9b, 0xea, 0xa4, 0xcb, 0x74, 0xe2, 0x38, 0xae, 0x4f, 0x7c, 0xe6, 0x3a, 0x5c, 0x96, 0x28, 0xa5,
	0x30, 0x2a, 0x9e, 0xd6, 0x7b, 0x1b, 0xfa, 0x06, 0xa3, 0x6d, 0xbb, 0xd9, 0x21, 0x7c, 0x33, 0xcc,
	0x50, 0x42, 0x1c, 0x41, 0xbd, 0xdb, 0xa5, 0x9e, 0x28, 0x0f, 0x63, 0x97, 0x33, 0x60, 0xec, 0x2f,
	0x14, 0x49, 0x25, 0x96, 0x45, 0x39, 0x0f, 0xff, 0x84, 0x19, 0x97, 0x22, 0x19, 0x83, 0xa5, 0x86,
	0x16, 0xbd, 0x18, 0xc9, 0xdb, 0x22, 0x6d, 0x66, 0x1f, 0x09, 0xab, 0x9f, 0x40, 0xf1, 0x06, 0xf5,
	0x57, 0x25, 0x88, 0x15, 0x89, 0xc1, 0xa4, 0x5f, 0xf4, 0x28, 0xf7, 0xf1, 0x02, 0xe0, 0xb8, 0x82,
	0xcc, 0x2e, 0xa2, 0x12, 0x9a, 0x2d, 0x34, 0x9e, 0x7d, 0xb4, 0x67, 0xa0, 0x9d, 0x7d, 0x23, 0xb7,
	0xb4, 0x3c, 0x5f, 0x35, 0xcf, 0xf3, 0x48, 0x83, 0x9b, 0xb6, 0xfa, 0x2b, 0x02, 0xe5, 0x16, 0xe3,
	0xb1, 0xce, 0xbc, 0xdf, 0xfa, 0x32, 0x14, 0x36, 0xdc, 0xb6, 0x4d, 0xbd, 0xb4, 0x8e, 0xa7, 0x65,
	0xf8, 0xa6, 0x8d, 0x5f, 0x87, 0x42, 0x97, 0xb4, 0x68, 0x93, 0xb3, 0x6d, 0x5a, 0x3c, 0x55, 0x42,
	0xb3, 0x13, 0x0d, 0xf8, 0x77, 0xcf, 0xc8, 0x2f, 0x2d, 0x1b, 0xd5, 0x6a, 0xd5, 0x3c, 0x1d, 0x04,
	0x57, 0xd9, 0x36, 0xc5, 0xb3, 0x00, 0x22, 0xd1, 0x77, 0x37, 0xa9, 0x53, 0x9c, 0x10, 0x4d, 0x0b,
	0x3b, 0xfb, 0xc6, 0x33, 0x22, 0xd3, 0x14, 0x5d, 0xee, 0x04, 0x31, 0xac, 0x42, 0x7e, 0x83, 0xb5,
	0x7d, 0xea, 0x15, 0x73, 0x22, 0x0b, 0x76, 0xf6, 0x07, 0xfd, 0xc2, 0x88, 0xfa, 0x03, 0x82, 0xa9,
	0x44, 0x02, 0xbc, 0xeb, 0x3a, 0x9c, 0xe2, 0x0f, 0xe0, 0x7c, 0x4c, 0x1c, 0x5e, 0x44, 0xa5, 0x89,
	0xd9, 0xc9, 0xda, 0x8c, 0x96, 0x30, 0x58, 0x5a, 0x4c, 0xe2, 0x73, 0x51, 0xc5, 0x38, 0xbe, 0x04,
	0xe7, 0x1c, 0x7a, 0xcf, 0x6f, 0x1e, 0xa1, 0x10, 0x90, 0x2d, 0x98, 0x67, 0x82, 0xd7, 0x1f, 0xf5,
	0xb1, 0xab, 0x3f, 0x22, 0x98, 0x7a, 0xc7, 0xa3, 0xc4, 0xa7, 0xc9, 0x9b, 0x36, 0x86, 0xb2, 0x75,
	0xc8, 0x39, 0xa4, 0x23, 0x45, 0x2d, 0x34, 0x5e, 0x0b, 0xb2, 0xfe, 0xde, 0x33, 0x2e, 0x7e, 0xb9,
	0x46, 0x2a, 0xdb, 0x77, 0xd7, 0x2a, 0xa4, 0xb2, 0x5d, 0xad, 0xd4, 0xef, 0x3e, 0x30, 0xe6, 0xae,
	0x18, 0x0f, 0xd7, 0xc2, 0x27, 0x53, 0x94, 0xe0, 0x37, 0x60, 0xd2, 0xa6, 0xdc, 0xf2, 0x58, 0x37,
	0x98, 0xa5, 0xa8, 0xd8, 0xb5, 0xf9, 0x2b, 0xe6, 0xd1, 0xa8, 0x7a, 0x0b, 0xa6, 0x93, 0x10, 0xdf,
	0xa6, 0x3e, 0xb1, 0x89, 0x4f, 0xf0, 0x5c, 0xfa, 0x9c, 0x25, 0x4c, 0xd6, 0x7f, 0x08, 0xa6, 0x3e,
	0xee, 0xda, 0xa9, 0x02, 0x3c, 0xc6, 0xd4, 0xe2, 0x45, 0x98, 0xec, 0x89, 0xd6, 0xe2, 0x48, 0x0b,
	0x61, 0x26, 0x6b, 0x8a, 0x26, 0x4f, 0xbd, 0xd6, 0x3f, 0xf5, 0xda, 0xfb, 0xc1, 0xa9, 0xbf, 0x4d,
	0xf8, 0xa6, 0x09, 0x32, 0x3d, 0xf8, 0x7f, 0x20, 0xe7, 0xc4, 0x63, 0xcb, 0x99, 0x3b, 0x4e, 0xce,
	0x24, 0xfe, 0x27, 0x94, 0xf3, 0x53, 0x98, 0x7a, 0x97, 0xb6, 0xe9, 0x53, 0x50, 0x33, 0x00, 0x9a,
	0xd4, 0xfa, 0x84, 0x40, 0x7f, 0x46, 0x30, 0x33, 0x7c, 0x20, 0x3f, 0xec, 0xdb, 0x1d, 0x7f, 0x12,
	0xfb, 0xff, 0xe4, 0xbd, 0x46, 0xfd, 0x0e, 0xc1, 0xab, 0xa3, 0x61, 0x87, 0x86, 0xb2, 0x02, 0x30,
	0xf0, 0xee, 0xbe, 0x95, 0xbc, 0x12, 0xb5, 0x92, 0x43, 0x6f, 0x1f, 0xd4, 0x9b, 0x47, 0x8a, 0xb2,
	0x7a, 0x48, 0xed, 0xd1, 0x19, 0xb8, 0x10, 0xc5, 0x13, 0x3e, 0xe1, 0x6f, 0x11, 0x4c, 0xdc, 0xa0,
	0x3e, 0xae, 0x24, 0x7a, 0x58, 0xda, 0x4d, 0xa1, 0x64, 0xb1, 0x3c, 0xf5, 0xad, 0xaf, 0xff, 0xf8,
	0xf3, 0xfb, 0x53, 0x1a, 0x9e, 0x8b, 0x5d, 0x7d, 0x7d, 0x0b, 0xd4, 0x1f, 0x0c, 0xef, 0xdb, 0x43,
	0xbc, 0x83, 0x20, 0x17, 0xe8, 0x87, 0xf5, 0xc4, 0x35, 0xd2, 0xef, 0x18, 0xa5, 0x9a, 0xbd, 0x40,
	0x6e, 0x81, 0xfa, 0xb2, 0x40, 0xf8, 0x12, 0x7e, 0x31, 0x05, 0x21, 0xfe, 0x09, 0x41, 0x5e, 0x5a,
	0x19, 0x4e, 0xee, 0x3e, 0xc2, 0x99, 0x95, 0xe3, 0x37, 0x53, 0xbd, 0xb3, 0x7b, 0x50, 0xd6, 0x8e,
	0x71, 0xcb, 0xb3, 0xd1, 0xf7, 0x02, 0xf2, 0xb4, 0x9a, 0x06, 0x79, 0x01, 0x95, 0xf1, 0x3e, 0x82,
	0xbc, 0x74, 0x8c, 0x14, 0xd4, 0x23, 0xec, 0x34, 0x0b, 0x6a, 0x26, 0x51, 0x8f, 0x34, 0xa5, 0x24,
	0xd4, 0x46, 0x6d, 0xac, 0x51, 0x08, 0xa8, 0xfc, 0x8e, 0x20, 0x2f, 0x3d, 0x25, 0x85, 0xca, 0x08,
	0x2f, 0xcb, 0x42, 0xa5, 0xb3, 0x7b, 0x50, 0x9e, 0x3f, 0xc6, 0xb6, 0x2e, 0xc4, 0xaf, 0x83, 0xf7,
	0x3a, 0x5d, 0xff, 0xbe, 0x1c, 0xee, 0xf2, 0x78, 0xc3, 0xfd, 0x0b, 0x02, 0x1c, 0x0c, 0xe4, 0x8a,
	0xf8, 0x65, 0xd7, 0x60, 0x8e, 0xcd, 0x9c, 0x16, 0xc7, 0x5a, 0x14, 0x68, 0xf8, 0xbb, 0x6f, 0x38,
	0xb1, 0x4f, 0x4c, 0xcf, 0x9c, 0x1f, 0x0e, 0xfa, 0xdb, 0x02, 0xed, 0x02, 0xbe, 0x96, 0x8a, 0xd6,
	0xa3, 0xdc, 0xed, 0x79, 0x16, 0x15, 0xc2, 0xb7, 0x87, 0x21, 0xfe, 0x85, 0xe0, 0xb9, 0x55, 0x1a,
	0x7f, 0x5b, 0x49, 0x04, 0x32, 0x94, 0x37, 0xc6, 0x86, 0x7c, 0xb5, 0x7b, 0x50, 0xae, 0x43, 0x29,
	0xad, 0x53, 0x96, 0x4d, 0x59, 0x52, 0xaf, 0x66, 0xa3, 0xc9, 0xe3, 0xdd, 0x83, 0x89, 0xfb, 0x07,
	0xc1, 0x0b, 0x72, 0xb2, 0x63, 0x5c, 0xab, 0x89, 0x5c, 0x93, 0x52, 0xc7, 0xa0, 0xfb, 0x0d, 0xda,
	0x3d, 0x28, 0x2f, 0xc1, 0xcc, 0x88, 0x6e, 0x59, 0x28, 0x5f, 0x57, 0x17, 0xb2, 0x51, 0xee, 0x25,
	0x2c, 0x10, 0xb0, 0xfe, 0x0d, 0xc1, 0xd9, 0x60, 0x7e, 0x0e, 0xef, 0x29, 0x7c, 0x2d, 0xa3, 0x9d,
	0x0e, 0xdd, 0xc8, 0x4a, 0xfd, 0x04, 0x95, 0xe1, 0xa0, 0x5e, 0x17, 0x74, 0xea, 0xf8, 0xea, 0x38,
	0xc7, 0xea, 0xf0, 0x1b, 0x88, 0x37, 0x96, 0x3f, 0x5b, 0x6c, 0x31, 0xff, 0xf3, 0xde, 0xba, 0x66,
	0xb9, 0x1d, 0x5d, 0xe2, 0xa8, 0xc8, 0x6f, 0xa1, 0x96, 0x5b, 0x69, 0x51, 0x47, 0xa8, 0xa7, 0x27,
	0x7c, 0x99, 0x2d, 0x32, 0xd2, 0x59, 0xcf, 0x8b, 0xf0, 0x9b, 0xff, 0x07, 0x00, 0x00, 0xff, 0xff,
	0x12, 0x75, 0xb8, 0x07, 0x5f, 0x0e, 0x00, 0x00,
}
