// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/mdb/mongodb/v1/cluster.proto

package mongodb // import "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/mongodb/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/mongodb/v1/config"
import timeofday "google.golang.org/genproto/googleapis/type/timeofday"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Deployment environment.
type Cluster_Environment int32

const (
	Cluster_ENVIRONMENT_UNSPECIFIED Cluster_Environment = 0
	// Stable environment with a conservative update policy:
	// only hotfixes are applied during regular maintenance.
	Cluster_PRODUCTION Cluster_Environment = 1
	// Environment with more aggressive update policy: new versions
	// are rolled out irrespective of backward compatibility.
	Cluster_PRESTABLE Cluster_Environment = 2
)

var Cluster_Environment_name = map[int32]string{
	0: "ENVIRONMENT_UNSPECIFIED",
	1: "PRODUCTION",
	2: "PRESTABLE",
}
var Cluster_Environment_value = map[string]int32{
	"ENVIRONMENT_UNSPECIFIED": 0,
	"PRODUCTION":              1,
	"PRESTABLE":               2,
}

func (x Cluster_Environment) String() string {
	return proto.EnumName(Cluster_Environment_name, int32(x))
}
func (Cluster_Environment) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_68852b663fb163d9, []int{0, 0}
}

type Cluster_Health int32

const (
	// State of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN).
	Cluster_HEALTH_UNKNOWN Cluster_Health = 0
	// Cluster is alive and well ([Host.health] for every host in the cluster is ALIVE).
	Cluster_ALIVE Cluster_Health = 1
	// Cluster is inoperable ([Host.health] for every host in the cluster is DEAD).
	Cluster_DEAD Cluster_Health = 2
	// Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE).
	Cluster_DEGRADED Cluster_Health = 3
)

var Cluster_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
	3: "DEGRADED",
}
var Cluster_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
	"DEGRADED":       3,
}

func (x Cluster_Health) String() string {
	return proto.EnumName(Cluster_Health_name, int32(x))
}
func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_68852b663fb163d9, []int{0, 1}
}

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

var Cluster_Status_name = map[int32]string{
	0: "STATUS_UNKNOWN",
	1: "CREATING",
	2: "RUNNING",
	3: "ERROR",
	4: "UPDATING",
	5: "STOPPING",
	6: "STOPPED",
	7: "STARTING",
}
var Cluster_Status_value = map[string]int32{
	"STATUS_UNKNOWN": 0,
	"CREATING":       1,
	"RUNNING":        2,
	"ERROR":          3,
	"UPDATING":       4,
	"STOPPING":       5,
	"STOPPED":        6,
	"STARTING":       7,
}

func (x Cluster_Status) String() string {
	return proto.EnumName(Cluster_Status_name, int32(x))
}
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_68852b663fb163d9, []int{0, 2}
}

type Host_Type int32

const (
	Host_TYPE_UNSPECIFIED Host_Type = 0
	Host_MONGOD           Host_Type = 1
	Host_MONGOS           Host_Type = 2
	Host_MONGOCFG         Host_Type = 3
)

var Host_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "MONGOD",
	2: "MONGOS",
	3: "MONGOCFG",
}
var Host_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"MONGOD":           1,
	"MONGOS":           2,
	"MONGOCFG":         3,
}

func (x Host_Type) String() string {
	return proto.EnumName(Host_Type_name, int32(x))
}
func (Host_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_68852b663fb163d9, []int{5, 0}
}

type Host_Role int32

const (
	// Role of the host in the cluster is unknown.
	Host_ROLE_UNKNOWN Host_Role = 0
	// Host is the primary MongoDB server in the cluster.
	Host_PRIMARY Host_Role = 1
	// Host is a secondary MongoDB server in the cluster.
	Host_SECONDARY Host_Role = 2
)

var Host_Role_name = map[int32]string{
	0: "ROLE_UNKNOWN",
	1: "PRIMARY",
	2: "SECONDARY",
}
var Host_Role_value = map[string]int32{
	"ROLE_UNKNOWN": 0,
	"PRIMARY":      1,
	"SECONDARY":    2,
}

func (x Host_Role) String() string {
	return proto.EnumName(Host_Role_name, int32(x))
}
func (Host_Role) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_68852b663fb163d9, []int{5, 1}
}

type Host_Health int32

const (
	// Health of the host is unknown.
	Host_HEALTH_UNKNOWN Host_Health = 0
	// The host is performing all its functions normally.
	Host_ALIVE Host_Health = 1
	// The host is inoperable, and cannot perform any of its essential functions.
	Host_DEAD Host_Health = 2
	// The host is degraded, and can perform only some of its essential functions.
	Host_DEGRADED Host_Health = 3
)

var Host_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
	3: "DEGRADED",
}
var Host_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
	"DEGRADED":       3,
}

func (x Host_Health) String() string {
	return proto.EnumName(Host_Health_name, int32(x))
}
func (Host_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_68852b663fb163d9, []int{5, 2}
}

type Service_Type int32

const (
	Service_TYPE_UNSPECIFIED Service_Type = 0
	// The host is running a mongod daemon.
	Service_MONGOD Service_Type = 1
	// The host is running a mongos daemon.
	Service_MONGOS Service_Type = 2
	// The host is running a MongoDB config server.
	Service_MONGOCFG Service_Type = 3
)

var Service_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "MONGOD",
	2: "MONGOS",
	3: "MONGOCFG",
}
var Service_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"MONGOD":           1,
	"MONGOS":           2,
	"MONGOCFG":         3,
}

func (x Service_Type) String() string {
	return proto.EnumName(Service_Type_name, int32(x))
}
func (Service_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_68852b663fb163d9, []int{6, 0}
}

type Service_Health int32

const (
	// Health of the server is unknown.
	Service_HEALTH_UNKNOWN Service_Health = 0
	// The server is working normally.
	Service_ALIVE Service_Health = 1
	// The server is dead or unresponsive.
	Service_DEAD Service_Health = 2
)

var Service_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
}
var Service_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
}

func (x Service_Health) String() string {
	return proto.EnumName(Service_Health_name, int32(x))
}
func (Service_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_68852b663fb163d9, []int{6, 1}
}

// A MongoDB Cluster resource. For more information, see the
// [Cluster](/docs/managed-mongodb/concepts) section in the Developer's Guide.
type Cluster struct {
	// ID of the MongoDB cluster.
	// This ID is assigned by MDB at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the MongoDB cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the MongoDB cluster.
	// The name is unique within the folder. 1-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the MongoDB cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the MongoDB cluster as `` key:value `` pairs. Maximum 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the MongoDB cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Environment" json:"environment,omitempty"`
	// Description of monitoring systems relevant to the MongoDB cluster.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the MongoDB cluster.
	Config *ClusterConfig `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	// ID of the network that the cluster belongs to.
	NetworkId string `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Aggregated cluster health.
	Health Cluster_Health `protobuf:"varint,11,opt,name=health,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Health" json:"health,omitempty"`
	// Current state of the cluster.
	Status Cluster_Status `protobuf:"varint,12,opt,name=status,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Status" json:"status,omitempty"`
	// Indicates current sharding status of the cluster.
	Sharded              bool     `protobuf:"varint,13,opt,name=sharded,proto3" json:"sharded,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Cluster) Reset()         { *m = Cluster{} }
func (m *Cluster) String() string { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()    {}
func (*Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_68852b663fb163d9, []int{0}
}
func (m *Cluster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Cluster.Unmarshal(m, b)
}
func (m *Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Cluster.Marshal(b, m, deterministic)
}
func (dst *Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster.Merge(dst, src)
}
func (m *Cluster) XXX_Size() int {
	return xxx_messageInfo_Cluster.Size(m)
}
func (m *Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster proto.InternalMessageInfo

func (m *Cluster) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Cluster) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *Cluster) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Cluster) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Cluster) GetEnvironment() Cluster_Environment {
	if m != nil {
		return m.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (m *Cluster) GetMonitoring() []*Monitoring {
	if m != nil {
		return m.Monitoring
	}
	return nil
}

func (m *Cluster) GetConfig() *ClusterConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Cluster) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *Cluster) GetHealth() Cluster_Health {
	if m != nil {
		return m.Health
	}
	return Cluster_HEALTH_UNKNOWN
}

func (m *Cluster) GetStatus() Cluster_Status {
	if m != nil {
		return m.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (m *Cluster) GetSharded() bool {
	if m != nil {
		return m.Sharded
	}
	return false
}

// Monitoring system.
type Monitoring struct {
	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system charts for the MongoDB cluster.
	Link                 string   `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Monitoring) Reset()         { *m = Monitoring{} }
func (m *Monitoring) String() string { return proto.CompactTextString(m) }
func (*Monitoring) ProtoMessage()    {}
func (*Monitoring) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_68852b663fb163d9, []int{1}
}
func (m *Monitoring) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Monitoring.Unmarshal(m, b)
}
func (m *Monitoring) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Monitoring.Marshal(b, m, deterministic)
}
func (dst *Monitoring) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Monitoring.Merge(dst, src)
}
func (m *Monitoring) XXX_Size() int {
	return xxx_messageInfo_Monitoring.Size(m)
}
func (m *Monitoring) XXX_DiscardUnknown() {
	xxx_messageInfo_Monitoring.DiscardUnknown(m)
}

var xxx_messageInfo_Monitoring proto.InternalMessageInfo

func (m *Monitoring) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Monitoring) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Monitoring) GetLink() string {
	if m != nil {
		return m.Link
	}
	return ""
}

type ClusterConfig struct {
	// Version of MongoDB server software.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Configuration for MongoDB servers in the cluster.
	//
	// Types that are valid to be assigned to Mongodb:
	//	*ClusterConfig_Mongodb_3_6
	Mongodb isClusterConfig_Mongodb `protobuf_oneof:"mongodb"`
	// Start time for the daily backup in UTC timezone
	BackupWindowStart    *timeofday.TimeOfDay `protobuf:"bytes,3,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ClusterConfig) Reset()         { *m = ClusterConfig{} }
func (m *ClusterConfig) String() string { return proto.CompactTextString(m) }
func (*ClusterConfig) ProtoMessage()    {}
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_68852b663fb163d9, []int{2}
}
func (m *ClusterConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterConfig.Unmarshal(m, b)
}
func (m *ClusterConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterConfig.Marshal(b, m, deterministic)
}
func (dst *ClusterConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterConfig.Merge(dst, src)
}
func (m *ClusterConfig) XXX_Size() int {
	return xxx_messageInfo_ClusterConfig.Size(m)
}
func (m *ClusterConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterConfig proto.InternalMessageInfo

func (m *ClusterConfig) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

type isClusterConfig_Mongodb interface {
	isClusterConfig_Mongodb()
}

type ClusterConfig_Mongodb_3_6 struct {
	Mongodb_3_6 *Mongodb3_6 `protobuf:"bytes,2,opt,name=mongodb_3_6,json=mongodb36,proto3,oneof"`
}

func (*ClusterConfig_Mongodb_3_6) isClusterConfig_Mongodb() {}

func (m *ClusterConfig) GetMongodb() isClusterConfig_Mongodb {
	if m != nil {
		return m.Mongodb
	}
	return nil
}

func (m *ClusterConfig) GetMongodb_3_6() *Mongodb3_6 {
	if x, ok := m.GetMongodb().(*ClusterConfig_Mongodb_3_6); ok {
		return x.Mongodb_3_6
	}
	return nil
}

func (m *ClusterConfig) GetBackupWindowStart() *timeofday.TimeOfDay {
	if m != nil {
		return m.BackupWindowStart
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ClusterConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ClusterConfig_OneofMarshaler, _ClusterConfig_OneofUnmarshaler, _ClusterConfig_OneofSizer, []interface{}{
		(*ClusterConfig_Mongodb_3_6)(nil),
	}
}

func _ClusterConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ClusterConfig)
	// mongodb
	switch x := m.Mongodb.(type) {
	case *ClusterConfig_Mongodb_3_6:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Mongodb_3_6); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ClusterConfig.Mongodb has unexpected type %T", x)
	}
	return nil
}

func _ClusterConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ClusterConfig)
	switch tag {
	case 2: // mongodb.mongodb_3_6
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mongodb3_6)
		err := b.DecodeMessage(msg)
		m.Mongodb = &ClusterConfig_Mongodb_3_6{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ClusterConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ClusterConfig)
	// mongodb
	switch x := m.Mongodb.(type) {
	case *ClusterConfig_Mongodb_3_6:
		s := proto.Size(x.Mongodb_3_6)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type Mongodb3_6 struct {
	// Configuration and resource allocation for a MongoDB 3.6 cluster.
	Mongod               *Mongodb3_6_Mongod   `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	Mongocfg             *Mongodb3_6_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	Mongos               *Mongodb3_6_Mongos   `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Mongodb3_6) Reset()         { *m = Mongodb3_6{} }
func (m *Mongodb3_6) String() string { return proto.CompactTextString(m) }
func (*Mongodb3_6) ProtoMessage()    {}
func (*Mongodb3_6) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_68852b663fb163d9, []int{3}
}
func (m *Mongodb3_6) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb3_6.Unmarshal(m, b)
}
func (m *Mongodb3_6) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb3_6.Marshal(b, m, deterministic)
}
func (dst *Mongodb3_6) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb3_6.Merge(dst, src)
}
func (m *Mongodb3_6) XXX_Size() int {
	return xxx_messageInfo_Mongodb3_6.Size(m)
}
func (m *Mongodb3_6) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb3_6.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb3_6 proto.InternalMessageInfo

func (m *Mongodb3_6) GetMongod() *Mongodb3_6_Mongod {
	if m != nil {
		return m.Mongod
	}
	return nil
}

func (m *Mongodb3_6) GetMongocfg() *Mongodb3_6_MongoCfg {
	if m != nil {
		return m.Mongocfg
	}
	return nil
}

func (m *Mongodb3_6) GetMongos() *Mongodb3_6_Mongos {
	if m != nil {
		return m.Mongos
	}
	return nil
}

type Mongodb3_6_Mongod struct {
	// Configuration of a MongoDB 3.6 server.
	Config *config.MongodConfigSet3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to MongoDB hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Mongodb3_6_Mongod) Reset()         { *m = Mongodb3_6_Mongod{} }
func (m *Mongodb3_6_Mongod) String() string { return proto.CompactTextString(m) }
func (*Mongodb3_6_Mongod) ProtoMessage()    {}
func (*Mongodb3_6_Mongod) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_68852b663fb163d9, []int{3, 0}
}
func (m *Mongodb3_6_Mongod) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb3_6_Mongod.Unmarshal(m, b)
}
func (m *Mongodb3_6_Mongod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb3_6_Mongod.Marshal(b, m, deterministic)
}
func (dst *Mongodb3_6_Mongod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb3_6_Mongod.Merge(dst, src)
}
func (m *Mongodb3_6_Mongod) XXX_Size() int {
	return xxx_messageInfo_Mongodb3_6_Mongod.Size(m)
}
func (m *Mongodb3_6_Mongod) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb3_6_Mongod.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb3_6_Mongod proto.InternalMessageInfo

func (m *Mongodb3_6_Mongod) GetConfig() *config.MongodConfigSet3_6 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Mongodb3_6_Mongod) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Mongodb3_6_MongoCfg struct {
	Config *config.MongoCfgConfigSet3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Mongodb3_6_MongoCfg) Reset()         { *m = Mongodb3_6_MongoCfg{} }
func (m *Mongodb3_6_MongoCfg) String() string { return proto.CompactTextString(m) }
func (*Mongodb3_6_MongoCfg) ProtoMessage()    {}
func (*Mongodb3_6_MongoCfg) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_68852b663fb163d9, []int{3, 1}
}
func (m *Mongodb3_6_MongoCfg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb3_6_MongoCfg.Unmarshal(m, b)
}
func (m *Mongodb3_6_MongoCfg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb3_6_MongoCfg.Marshal(b, m, deterministic)
}
func (dst *Mongodb3_6_MongoCfg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb3_6_MongoCfg.Merge(dst, src)
}
func (m *Mongodb3_6_MongoCfg) XXX_Size() int {
	return xxx_messageInfo_Mongodb3_6_MongoCfg.Size(m)
}
func (m *Mongodb3_6_MongoCfg) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb3_6_MongoCfg.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb3_6_MongoCfg proto.InternalMessageInfo

func (m *Mongodb3_6_MongoCfg) GetConfig() *config.MongoCfgConfigSet3_6 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Mongodb3_6_MongoCfg) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Mongodb3_6_Mongos struct {
	Config *config.MongosConfigSet3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Mongodb3_6_Mongos) Reset()         { *m = Mongodb3_6_Mongos{} }
func (m *Mongodb3_6_Mongos) String() string { return proto.CompactTextString(m) }
func (*Mongodb3_6_Mongos) ProtoMessage()    {}
func (*Mongodb3_6_Mongos) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_68852b663fb163d9, []int{3, 2}
}
func (m *Mongodb3_6_Mongos) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb3_6_Mongos.Unmarshal(m, b)
}
func (m *Mongodb3_6_Mongos) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb3_6_Mongos.Marshal(b, m, deterministic)
}
func (dst *Mongodb3_6_Mongos) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb3_6_Mongos.Merge(dst, src)
}
func (m *Mongodb3_6_Mongos) XXX_Size() int {
	return xxx_messageInfo_Mongodb3_6_Mongos.Size(m)
}
func (m *Mongodb3_6_Mongos) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb3_6_Mongos.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb3_6_Mongos proto.InternalMessageInfo

func (m *Mongodb3_6_Mongos) GetConfig() *config.MongosConfigSet3_6 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Mongodb3_6_Mongos) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Shard struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	ClusterId            string   `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Shard) Reset()         { *m = Shard{} }
func (m *Shard) String() string { return proto.CompactTextString(m) }
func (*Shard) ProtoMessage()    {}
func (*Shard) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_68852b663fb163d9, []int{4}
}
func (m *Shard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Shard.Unmarshal(m, b)
}
func (m *Shard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Shard.Marshal(b, m, deterministic)
}
func (dst *Shard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Shard.Merge(dst, src)
}
func (m *Shard) XXX_Size() int {
	return xxx_messageInfo_Shard.Size(m)
}
func (m *Shard) XXX_DiscardUnknown() {
	xxx_messageInfo_Shard.DiscardUnknown(m)
}

var xxx_messageInfo_Shard proto.InternalMessageInfo

func (m *Shard) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Shard) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type Host struct {
	// Name of the MongoDB host. The host name is assigned by MDB at creation time, and cannot be changed.
	// 1-63 characters long.
	//
	// The name is unique across all existing MDB hosts in Yandex.Cloud, as it defines the FQDN of the host.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the MongoDB host. The ID is assigned by MDB at creation time.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the availability zone where the MongoDB host resides.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Resources allocated to the MongoDB host.
	Resources *Resources `protobuf:"bytes,4,opt,name=resources,proto3" json:"resources,omitempty"`
	// Role of the host in the cluster.
	Role Host_Role `protobuf:"varint,5,opt,name=role,proto3,enum=yandex.cloud.mdb.mongodb.v1.Host_Role" json:"role,omitempty"`
	// Status code of the aggregated health of the host.
	Health Host_Health `protobuf:"varint,6,opt,name=health,proto3,enum=yandex.cloud.mdb.mongodb.v1.Host_Health" json:"health,omitempty"`
	// Services provided by the host.
	Services []*Service `protobuf:"bytes,7,rep,name=services,proto3" json:"services,omitempty"`
	// ID of the subnet that the host belongs to.
	SubnetId string `protobuf:"bytes,8,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Flag showing public IP assignment status to this host.
	AssignPublicIp bool `protobuf:"varint,9,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	// Shard which this host belongs to.
	ShardName string `protobuf:"bytes,10,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	// Host type
	Type                 Host_Type `protobuf:"varint,11,opt,name=type,proto3,enum=yandex.cloud.mdb.mongodb.v1.Host_Type" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Host) Reset()         { *m = Host{} }
func (m *Host) String() string { return proto.CompactTextString(m) }
func (*Host) ProtoMessage()    {}
func (*Host) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_68852b663fb163d9, []int{5}
}
func (m *Host) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Host.Unmarshal(m, b)
}
func (m *Host) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Host.Marshal(b, m, deterministic)
}
func (dst *Host) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Host.Merge(dst, src)
}
func (m *Host) XXX_Size() int {
	return xxx_messageInfo_Host.Size(m)
}
func (m *Host) XXX_DiscardUnknown() {
	xxx_messageInfo_Host.DiscardUnknown(m)
}

var xxx_messageInfo_Host proto.InternalMessageInfo

func (m *Host) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Host) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *Host) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *Host) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Host) GetRole() Host_Role {
	if m != nil {
		return m.Role
	}
	return Host_ROLE_UNKNOWN
}

func (m *Host) GetHealth() Host_Health {
	if m != nil {
		return m.Health
	}
	return Host_HEALTH_UNKNOWN
}

func (m *Host) GetServices() []*Service {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *Host) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *Host) GetAssignPublicIp() bool {
	if m != nil {
		return m.AssignPublicIp
	}
	return false
}

func (m *Host) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

func (m *Host) GetType() Host_Type {
	if m != nil {
		return m.Type
	}
	return Host_TYPE_UNSPECIFIED
}

type Service struct {
	// Type of the service provided by the host.
	Type Service_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.mdb.mongodb.v1.Service_Type" json:"type,omitempty"`
	// Status code of server availability.
	Health               Service_Health `protobuf:"varint,2,opt,name=health,proto3,enum=yandex.cloud.mdb.mongodb.v1.Service_Health" json:"health,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Service) Reset()         { *m = Service{} }
func (m *Service) String() string { return proto.CompactTextString(m) }
func (*Service) ProtoMessage()    {}
func (*Service) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_68852b663fb163d9, []int{6}
}
func (m *Service) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Service.Unmarshal(m, b)
}
func (m *Service) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Service.Marshal(b, m, deterministic)
}
func (dst *Service) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Service.Merge(dst, src)
}
func (m *Service) XXX_Size() int {
	return xxx_messageInfo_Service.Size(m)
}
func (m *Service) XXX_DiscardUnknown() {
	xxx_messageInfo_Service.DiscardUnknown(m)
}

var xxx_messageInfo_Service proto.InternalMessageInfo

func (m *Service) GetType() Service_Type {
	if m != nil {
		return m.Type
	}
	return Service_TYPE_UNSPECIFIED
}

func (m *Service) GetHealth() Service_Health {
	if m != nil {
		return m.Health
	}
	return Service_HEALTH_UNKNOWN
}

type Resources struct {
	// ID of the preset for computational resources available to a host (CPU, memory etc.).
	// All available presets are listed in the [documentation](/docs/managed-mongodb/concepts/instance-types).
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	// Volume of the storage available to a host, in bytes.
	DiskSize int64 `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	// Type of the storage environment for the host.
	// Possible values:
	// * network-hdd — network HDD drive,
	// * network-nvme — network SSD drive,
	// * local-nvme — local SSD storage.
	DiskTypeId           string   `protobuf:"bytes,3,opt,name=disk_type_id,json=diskTypeId,proto3" json:"disk_type_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Resources) Reset()         { *m = Resources{} }
func (m *Resources) String() string { return proto.CompactTextString(m) }
func (*Resources) ProtoMessage()    {}
func (*Resources) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_68852b663fb163d9, []int{7}
}
func (m *Resources) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Resources.Unmarshal(m, b)
}
func (m *Resources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Resources.Marshal(b, m, deterministic)
}
func (dst *Resources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resources.Merge(dst, src)
}
func (m *Resources) XXX_Size() int {
	return xxx_messageInfo_Resources.Size(m)
}
func (m *Resources) XXX_DiscardUnknown() {
	xxx_messageInfo_Resources.DiscardUnknown(m)
}

var xxx_messageInfo_Resources proto.InternalMessageInfo

func (m *Resources) GetResourcePresetId() string {
	if m != nil {
		return m.ResourcePresetId
	}
	return ""
}

func (m *Resources) GetDiskSize() int64 {
	if m != nil {
		return m.DiskSize
	}
	return 0
}

func (m *Resources) GetDiskTypeId() string {
	if m != nil {
		return m.DiskTypeId
	}
	return ""
}

func init() {
	proto.RegisterType((*Cluster)(nil), "yandex.cloud.mdb.mongodb.v1.Cluster")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.mongodb.v1.Cluster.LabelsEntry")
	proto.RegisterType((*Monitoring)(nil), "yandex.cloud.mdb.mongodb.v1.Monitoring")
	proto.RegisterType((*ClusterConfig)(nil), "yandex.cloud.mdb.mongodb.v1.ClusterConfig")
	proto.RegisterType((*Mongodb3_6)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb3_6")
	proto.RegisterType((*Mongodb3_6_Mongod)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongod")
	proto.RegisterType((*Mongodb3_6_MongoCfg)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoCfg")
	proto.RegisterType((*Mongodb3_6_Mongos)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongos")
	proto.RegisterType((*Shard)(nil), "yandex.cloud.mdb.mongodb.v1.Shard")
	proto.RegisterType((*Host)(nil), "yandex.cloud.mdb.mongodb.v1.Host")
	proto.RegisterType((*Service)(nil), "yandex.cloud.mdb.mongodb.v1.Service")
	proto.RegisterType((*Resources)(nil), "yandex.cloud.mdb.mongodb.v1.Resources")
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Cluster_Environment", Cluster_Environment_name, Cluster_Environment_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Cluster_Health", Cluster_Health_name, Cluster_Health_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Cluster_Status", Cluster_Status_name, Cluster_Status_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Host_Type", Host_Type_name, Host_Type_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Host_Role", Host_Role_name, Host_Role_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Host_Health", Host_Health_name, Host_Health_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Service_Type", Service_Type_name, Service_Type_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Service_Health", Service_Health_name, Service_Health_value)
}

func init() {
	proto.RegisterFile("yandex/cloud/mdb/mongodb/v1/cluster.proto", fileDescriptor_cluster_68852b663fb163d9)
}

var fileDescriptor_cluster_68852b663fb163d9 = []byte{
	// 1265 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0xcd, 0x6e, 0xdb, 0x46,
	0x10, 0x0e, 0xf5, 0x43, 0x89, 0x23, 0xc7, 0x60, 0xb7, 0x41, 0x43, 0xd8, 0x08, 0x6a, 0x08, 0x45,
	0xab, 0xb4, 0x0d, 0x95, 0xc4, 0x85, 0x91, 0xb8, 0x28, 0x1a, 0x59, 0xa4, 0x6d, 0xa2, 0x36, 0x25,
	0x2c, 0xe5, 0x04, 0xe9, 0x85, 0xa0, 0xc4, 0x95, 0x4c, 0x58, 0x22, 0x05, 0x2e, 0xe5, 0x44, 0x39,
	0xf7, 0x39, 0x7a, 0xe8, 0x3b, 0xf4, 0x19, 0x7a, 0xee, 0xa9, 0xaf, 0x53, 0xec, 0x0f, 0x65, 0xc5,
	0x6d, 0x15, 0x39, 0x4d, 0x6e, 0xbb, 0xb3, 0xf3, 0x7d, 0x9c, 0x9f, 0x9d, 0x99, 0x25, 0xdc, 0x9f,
	0x07, 0x71, 0x48, 0x5e, 0x37, 0x07, 0xe3, 0x64, 0x16, 0x36, 0x27, 0x61, 0xbf, 0x39, 0x49, 0xe2,
	0x51, 0x12, 0xf6, 0x9b, 0x97, 0x8f, 0x9a, 0x83, 0xf1, 0x8c, 0x66, 0x24, 0x35, 0xa7, 0x69, 0x92,
	0x25, 0x68, 0x5b, 0xa8, 0x9a, 0x5c, 0xd5, 0x9c, 0x84, 0x7d, 0x53, 0xaa, 0x9a, 0x97, 0x8f, 0xb6,
	0x3e, 0x1f, 0x25, 0xc9, 0x68, 0x4c, 0x9a, 0x5c, 0xb5, 0x3f, 0x1b, 0x36, 0xb3, 0x68, 0x42, 0x68,
	0x16, 0x4c, 0xa6, 0x02, 0xbd, 0xb5, 0x2d, 0x15, 0xb2, 0xf9, 0x94, 0xf0, 0xc3, 0x64, 0x18, 0x06,
	0x73, 0x79, 0xb8, 0xbb, 0xd2, 0x8a, 0x24, 0x1e, 0x46, 0xa3, 0x5c, 0xb2, 0xeb, 0xef, 0x09, 0x50,
	0xfd, 0xaf, 0x0a, 0x54, 0xda, 0xc2, 0x42, 0xb4, 0x09, 0x85, 0x28, 0x34, 0x94, 0x1d, 0xa5, 0xa1,
	0xe1, 0x42, 0x14, 0xa2, 0x6d, 0xd0, 0x86, 0xc9, 0x38, 0x24, 0xa9, 0x1f, 0x85, 0x46, 0x81, 0x8b,
	0xab, 0x42, 0xe0, 0x84, 0xe8, 0x29, 0xc0, 0x20, 0x25, 0x41, 0x46, 0x42, 0x3f, 0xc8, 0x8c, 0xe2,
	0x8e, 0xd2, 0xa8, 0x3d, 0xde, 0x32, 0x85, 0x7d, 0x66, 0xee, 0x80, 0xd9, 0xcb, 0x1d, 0xc0, 0x9a,
	0xd4, 0x6e, 0x65, 0x08, 0x41, 0x29, 0x0e, 0x26, 0xc4, 0x28, 0x71, 0x4a, 0xbe, 0x46, 0x3b, 0x50,
	0x0b, 0x09, 0x1d, 0xa4, 0xd1, 0x34, 0x8b, 0x92, 0xd8, 0x28, 0xf3, 0xa3, 0x65, 0x11, 0x3a, 0x06,
	0x75, 0x1c, 0xf4, 0xc9, 0x98, 0x1a, 0xea, 0x4e, 0xb1, 0x51, 0x7b, 0xfc, 0xd0, 0x5c, 0x11, 0x4a,
	0x53, 0xfa, 0x64, 0x9e, 0x70, 0x88, 0x1d, 0x67, 0xe9, 0x1c, 0x4b, 0x3c, 0xc2, 0x50, 0x23, 0xf1,
	0x65, 0x94, 0x26, 0xf1, 0x84, 0xc4, 0x99, 0x51, 0xd9, 0x51, 0x1a, 0x9b, 0x6b, 0xd2, 0xd9, 0x57,
	0x38, 0xbc, 0x4c, 0x82, 0x8e, 0x00, 0x26, 0x49, 0x1c, 0x65, 0x49, 0x1a, 0xc5, 0x23, 0xa3, 0xca,
	0x2d, 0xfc, 0x6a, 0x25, 0xe5, 0xe9, 0x42, 0x1d, 0x2f, 0x41, 0xd1, 0x01, 0xa8, 0x22, 0x57, 0x86,
	0xc6, 0x63, 0xfa, 0xf5, 0x3a, 0x76, 0xb5, 0x39, 0x02, 0x4b, 0x24, 0xba, 0x07, 0x10, 0x93, 0xec,
	0x55, 0x92, 0x5e, 0xb0, 0xcc, 0x01, 0x8f, 0xa5, 0x26, 0x25, 0x4e, 0x88, 0xda, 0xa0, 0x9e, 0x93,
	0x60, 0x9c, 0x9d, 0x1b, 0x35, 0xee, 0xfa, 0x37, 0x6b, 0xb9, 0x7e, 0xcc, 0x21, 0x58, 0x42, 0x19,
	0x09, 0xcd, 0x82, 0x6c, 0x46, 0x8d, 0x8d, 0x1b, 0x90, 0x78, 0x1c, 0x82, 0x25, 0x14, 0x19, 0x50,
	0xa1, 0xe7, 0x41, 0x1a, 0x92, 0xd0, 0xb8, 0xbd, 0xa3, 0x34, 0xaa, 0x38, 0xdf, 0x6e, 0x3d, 0x85,
	0xda, 0x52, 0xea, 0x90, 0x0e, 0xc5, 0x0b, 0x32, 0x97, 0x77, 0x93, 0x2d, 0xd1, 0x1d, 0x28, 0x5f,
	0x06, 0xe3, 0x19, 0x91, 0x17, 0x53, 0x6c, 0xf6, 0x0b, 0x4f, 0x94, 0xba, 0x03, 0xb5, 0xa5, 0x34,
	0xa1, 0x6d, 0xb8, 0x6b, 0xbb, 0xcf, 0x1d, 0xdc, 0x71, 0x4f, 0x6d, 0xb7, 0xe7, 0x9f, 0xb9, 0x5e,
	0xd7, 0x6e, 0x3b, 0x87, 0x8e, 0x6d, 0xe9, 0xb7, 0xd0, 0x26, 0x40, 0x17, 0x77, 0xac, 0xb3, 0x76,
	0xcf, 0xe9, 0xb8, 0xba, 0x82, 0x6e, 0x83, 0xd6, 0xc5, 0xb6, 0xd7, 0x6b, 0x1d, 0x9c, 0xd8, 0x7a,
	0xa1, 0xfe, 0x23, 0xa8, 0xc2, 0x6d, 0x84, 0x60, 0xf3, 0xd8, 0x6e, 0x9d, 0xf4, 0x8e, 0xfd, 0x33,
	0xf7, 0x27, 0xb7, 0xf3, 0xc2, 0xd5, 0x6f, 0x21, 0x0d, 0xca, 0xad, 0x13, 0xe7, 0xb9, 0xad, 0x2b,
	0xa8, 0x0a, 0x25, 0xcb, 0x6e, 0x59, 0x7a, 0x01, 0x6d, 0x40, 0xd5, 0xb2, 0x8f, 0x70, 0xcb, 0xb2,
	0x2d, 0xbd, 0x58, 0x9f, 0x83, 0x2a, 0x5c, 0x66, 0x04, 0x5e, 0xaf, 0xd5, 0x3b, 0xf3, 0x96, 0x08,
	0x36, 0xa0, 0xda, 0xc6, 0x76, 0xab, 0xe7, 0xb8, 0x47, 0xba, 0x82, 0x6a, 0x50, 0xc1, 0x67, 0xae,
	0xcb, 0x36, 0x05, 0xc6, 0x6d, 0x63, 0xdc, 0xc1, 0x7a, 0x91, 0x69, 0x9d, 0x75, 0x2d, 0xa1, 0x55,
	0x62, 0x3b, 0xaf, 0xd7, 0xe9, 0x76, 0xd9, 0xae, 0xcc, 0x30, 0x7c, 0x67, 0x5b, 0xba, 0x2a, 0x8e,
	0x5a, 0x98, 0x2b, 0x56, 0xea, 0xcf, 0x01, 0xae, 0xae, 0xd8, 0xa2, 0xe6, 0x94, 0xff, 0xae, 0xb9,
	0xc2, 0x3f, 0x6b, 0x0e, 0x41, 0x69, 0x1c, 0xc5, 0x17, 0xbc, 0xbc, 0x35, 0xcc, 0xd7, 0xf5, 0x3f,
	0x14, 0xb8, 0xfd, 0xd6, 0xb5, 0x63, 0x59, 0xbc, 0x24, 0x29, 0x65, 0x1c, 0x82, 0x3e, 0xdf, 0x22,
	0x07, 0x6a, 0xf2, 0x12, 0xf8, 0xbb, 0xfe, 0x1e, 0xff, 0xc2, 0x1a, 0x65, 0x21, 0x3b, 0xd4, 0xf1,
	0x2d, 0xac, 0xe5, 0xfd, 0x6a, 0x0f, 0x1d, 0xc2, 0xa7, 0xfd, 0x60, 0x70, 0x31, 0x9b, 0xfa, 0xaf,
	0xa2, 0x38, 0x4c, 0x5e, 0xf9, 0x34, 0x0b, 0xd2, 0xbc, 0xf1, 0x7c, 0x96, 0x37, 0x1e, 0xd6, 0x18,
	0x79, 0xd3, 0xe9, 0x0c, 0xad, 0x60, 0x8e, 0x3f, 0x11, 0x90, 0x17, 0x1c, 0xe1, 0x31, 0xc0, 0x81,
	0x06, 0x15, 0x49, 0x5a, 0xff, 0xb3, 0xcc, 0x43, 0x24, 0x3f, 0x87, 0x0e, 0x41, 0x15, 0x27, 0xdc,
	0x8b, 0xda, 0x63, 0x73, 0x4d, 0x3b, 0xe5, 0x12, 0x4b, 0x34, 0x3a, 0x81, 0x2a, 0x5f, 0x0d, 0x86,
	0x23, 0xe9, 0xf1, 0xc3, 0x1b, 0x31, 0xb5, 0x87, 0x23, 0xbc, 0x60, 0x58, 0x58, 0x45, 0xa5, 0xab,
	0x37, 0xb3, 0x8a, 0x4a, 0xab, 0xe8, 0xd6, 0xaf, 0x0a, 0xa8, 0xe2, 0x14, 0xb9, 0x8b, 0x16, 0x23,
	0x1c, 0xdd, 0x5b, 0x49, 0x29, 0x54, 0x25, 0xb3, 0xc8, 0xb8, 0x47, 0xb2, 0x5d, 0x7f, 0x6f, 0xd1,
	0x6e, 0x2c, 0xd0, 0x52, 0x42, 0x93, 0x59, 0x3a, 0x20, 0x54, 0x7a, 0xfc, 0xe5, 0x4a, 0x4a, 0x9c,
	0x6b, 0xe3, 0x2b, 0xe0, 0xd6, 0x6f, 0x0a, 0x54, 0x73, 0xff, 0x51, 0xf7, 0x9a, 0x89, 0x4f, 0xd6,
	0x36, 0xb1, 0x3d, 0x1c, 0x7d, 0x44, 0x23, 0x17, 0x51, 0xa4, 0xff, 0x23, 0x8a, 0xf4, 0xe3, 0x19,
	0x58, 0xdf, 0x87, 0xb2, 0xc7, 0x5a, 0xe8, 0xbf, 0x16, 0xfc, 0x3d, 0x00, 0xf9, 0x1a, 0xb9, 0x9a,
	0xe8, 0x9a, 0x94, 0x38, 0x61, 0xfd, 0xf7, 0x32, 0x94, 0x8e, 0x13, 0x9a, 0xbd, 0x07, 0x16, 0xdd,
	0x85, 0xca, 0x9b, 0x24, 0x26, 0xec, 0x4c, 0x34, 0x0b, 0x95, 0x6d, 0x9d, 0xf0, 0x6d, 0xb7, 0x4a,
	0xef, 0xe9, 0x16, 0xda, 0x87, 0x52, 0x9a, 0x8c, 0x09, 0x7f, 0x17, 0x6c, 0xbe, 0x83, 0x80, 0xb9,
	0x60, 0xe2, 0x64, 0x4c, 0x30, 0xc7, 0xa0, 0x67, 0x8b, 0x71, 0xa7, 0x72, 0x74, 0xe3, 0xdd, 0xe8,
	0x6b, 0xb3, 0xee, 0x19, 0x54, 0x29, 0x49, 0x2f, 0x23, 0xe6, 0x42, 0x85, 0x8f, 0xf6, 0x2f, 0x56,
	0x72, 0x78, 0x42, 0x19, 0x2f, 0x50, 0xec, 0x29, 0x45, 0x67, 0xfd, 0x98, 0x64, 0x2c, 0x40, 0x55,
	0xf1, 0x94, 0x12, 0x02, 0x27, 0x44, 0x0d, 0xd0, 0x03, 0x4a, 0xa3, 0x51, 0xec, 0x4f, 0x67, 0xfd,
	0x71, 0x34, 0xf0, 0xa3, 0x29, 0x1f, 0xfe, 0x55, 0xbc, 0x29, 0xe4, 0x5d, 0x2e, 0x76, 0xa6, 0x2c,
	0x09, 0x7c, 0x40, 0xfa, 0x3c, 0x3d, 0x72, 0xb0, 0x73, 0x89, 0xcb, 0x72, 0xb4, 0x0f, 0x25, 0xd6,
	0x00, 0xe5, 0x58, 0x5f, 0x23, 0x4a, 0xbd, 0xf9, 0x94, 0x60, 0x8e, 0xa9, 0x1f, 0x40, 0x89, 0xed,
	0xd0, 0x1d, 0xd0, 0x7b, 0x2f, 0xbb, 0xf6, 0xb5, 0x39, 0x09, 0xa0, 0x9e, 0x76, 0xdc, 0xa3, 0x8e,
	0xa5, 0x2b, 0x8b, 0xb5, 0x27, 0xa6, 0x1d, 0x5f, 0xb7, 0x0f, 0x8f, 0xf4, 0x62, 0xfd, 0x3b, 0x28,
	0xb1, 0xb8, 0x23, 0x1d, 0x36, 0x70, 0xe7, 0xc4, 0x5e, 0x9a, 0x74, 0x35, 0xa8, 0x74, 0xb1, 0x73,
	0xda, 0xc2, 0x2f, 0xc5, 0x90, 0xf5, 0xec, 0x76, 0xc7, 0xb5, 0xd8, 0xf6, 0x03, 0x0c, 0xd9, 0x5f,
	0x0a, 0x50, 0x91, 0x21, 0x47, 0x3f, 0xc8, 0x10, 0x28, 0x3c, 0x04, 0xf7, 0xd7, 0x49, 0xd3, 0x52,
	0x14, 0x96, 0x9e, 0x46, 0x85, 0x35, 0x5e, 0x35, 0x39, 0xc1, 0xdb, 0xd7, 0xe5, 0x83, 0x84, 0xf2,
	0xd1, 0x8d, 0x83, 0x52, 0x7f, 0x0d, 0xda, 0xa2, 0x76, 0xd0, 0xb7, 0x80, 0xf2, 0xea, 0xf1, 0xa7,
	0x29, 0xa1, 0xe2, 0xe6, 0x89, 0x82, 0xd6, 0xf3, 0x93, 0x2e, 0x3f, 0x70, 0xf8, 0x4b, 0x3f, 0x8c,
	0xe8, 0x85, 0x4f, 0xa3, 0x37, 0xe2, 0x41, 0x55, 0xc4, 0x55, 0x26, 0xf0, 0xa2, 0x37, 0xec, 0x99,
	0xb0, 0xc1, 0x0f, 0x59, 0x80, 0xae, 0xea, 0x1b, 0x98, 0x8c, 0xb9, 0xe9, 0x84, 0x07, 0xce, 0xcf,
	0x47, 0xa3, 0x28, 0x3b, 0x9f, 0xf5, 0xcd, 0x41, 0x32, 0x69, 0x8a, 0x88, 0x3d, 0x10, 0xbf, 0x21,
	0xa3, 0xe4, 0xc1, 0x88, 0xc4, 0xfc, 0x7f, 0xa0, 0xb9, 0xe2, 0xff, 0xe4, 0x7b, 0xb9, 0xec, 0xab,
	0x5c, 0x75, 0xf7, 0xef, 0x00, 0x00, 0x00, 0xff, 0xff, 0x96, 0x62, 0xe6, 0xaf, 0x53, 0x0d, 0x00,
	0x00,
}
