// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/mdb/postgresql/v1/cluster.proto

package postgresql // import "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/postgresql/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/postgresql/v1/config"
import timeofday "google.golang.org/genproto/googleapis/type/timeofday"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type Cluster_Environment int32

const (
	Cluster_ENVIRONMENT_UNSPECIFIED Cluster_Environment = 0
	// Stable environment with a conservative update policy:
	// only hotfixes are applied during regular maintenance.
	Cluster_PRODUCTION Cluster_Environment = 1
	// Environment with more aggressive update policy: new versions
	// are rolled out irrespective of backward compatibility.
	Cluster_PRESTABLE Cluster_Environment = 2
)

var Cluster_Environment_name = map[int32]string{
	0: "ENVIRONMENT_UNSPECIFIED",
	1: "PRODUCTION",
	2: "PRESTABLE",
}
var Cluster_Environment_value = map[string]int32{
	"ENVIRONMENT_UNSPECIFIED": 0,
	"PRODUCTION":              1,
	"PRESTABLE":               2,
}

func (x Cluster_Environment) String() string {
	return proto.EnumName(Cluster_Environment_name, int32(x))
}
func (Cluster_Environment) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_75c4156e122d92ad, []int{0, 0}
}

type Cluster_Health int32

const (
	// State of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN).
	Cluster_HEALTH_UNKNOWN Cluster_Health = 0
	// Cluster is alive and well ([Host.health] for every host in the cluster is ALIVE).
	Cluster_ALIVE Cluster_Health = 1
	// Cluster is inoperable ([Host.health] for every host in the cluster is DEAD).
	Cluster_DEAD Cluster_Health = 2
	// Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE).
	Cluster_DEGRADED Cluster_Health = 3
)

var Cluster_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
	3: "DEGRADED",
}
var Cluster_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
	"DEGRADED":       3,
}

func (x Cluster_Health) String() string {
	return proto.EnumName(Cluster_Health_name, int32(x))
}
func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_75c4156e122d92ad, []int{0, 1}
}

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

var Cluster_Status_name = map[int32]string{
	0: "STATUS_UNKNOWN",
	1: "CREATING",
	2: "RUNNING",
	3: "ERROR",
	4: "UPDATING",
	5: "STOPPING",
	6: "STOPPED",
	7: "STARTING",
}
var Cluster_Status_value = map[string]int32{
	"STATUS_UNKNOWN": 0,
	"CREATING":       1,
	"RUNNING":        2,
	"ERROR":          3,
	"UPDATING":       4,
	"STOPPING":       5,
	"STOPPED":        6,
	"STARTING":       7,
}

func (x Cluster_Status) String() string {
	return proto.EnumName(Cluster_Status_name, int32(x))
}
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_75c4156e122d92ad, []int{0, 2}
}

type ConnectionPoolerConfig_PoolingMode int32

const (
	ConnectionPoolerConfig_POOLING_MODE_UNSPECIFIED ConnectionPoolerConfig_PoolingMode = 0
	// Session pooling mode.
	ConnectionPoolerConfig_SESSION ConnectionPoolerConfig_PoolingMode = 1
	// Transaction pooling mode.
	ConnectionPoolerConfig_TRANSACTION ConnectionPoolerConfig_PoolingMode = 2
	// Statement pooling mode.
	ConnectionPoolerConfig_STATEMENT ConnectionPoolerConfig_PoolingMode = 3
)

var ConnectionPoolerConfig_PoolingMode_name = map[int32]string{
	0: "POOLING_MODE_UNSPECIFIED",
	1: "SESSION",
	2: "TRANSACTION",
	3: "STATEMENT",
}
var ConnectionPoolerConfig_PoolingMode_value = map[string]int32{
	"POOLING_MODE_UNSPECIFIED": 0,
	"SESSION":                  1,
	"TRANSACTION":              2,
	"STATEMENT":                3,
}

func (x ConnectionPoolerConfig_PoolingMode) String() string {
	return proto.EnumName(ConnectionPoolerConfig_PoolingMode_name, int32(x))
}
func (ConnectionPoolerConfig_PoolingMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_75c4156e122d92ad, []int{3, 0}
}

type Host_Role int32

const (
	// Role of the host in the cluster is unknown.
	Host_ROLE_UNKNOWN Host_Role = 0
	// Host is the master PostgreSQL server in the cluster.
	Host_MASTER Host_Role = 1
	// Host is a replica (standby) PostgreSQL server in the cluster.
	Host_REPLICA Host_Role = 2
)

var Host_Role_name = map[int32]string{
	0: "ROLE_UNKNOWN",
	1: "MASTER",
	2: "REPLICA",
}
var Host_Role_value = map[string]int32{
	"ROLE_UNKNOWN": 0,
	"MASTER":       1,
	"REPLICA":      2,
}

func (x Host_Role) String() string {
	return proto.EnumName(Host_Role_name, int32(x))
}
func (Host_Role) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_75c4156e122d92ad, []int{4, 0}
}

type Host_ReplicaType int32

const (
	Host_REPLICA_TYPE_UNKNOWN Host_ReplicaType = 0
	Host_ASYNC                Host_ReplicaType = 1
	Host_SYNC                 Host_ReplicaType = 2
)

var Host_ReplicaType_name = map[int32]string{
	0: "REPLICA_TYPE_UNKNOWN",
	1: "ASYNC",
	2: "SYNC",
}
var Host_ReplicaType_value = map[string]int32{
	"REPLICA_TYPE_UNKNOWN": 0,
	"ASYNC":                1,
	"SYNC":                 2,
}

func (x Host_ReplicaType) String() string {
	return proto.EnumName(Host_ReplicaType_name, int32(x))
}
func (Host_ReplicaType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_75c4156e122d92ad, []int{4, 1}
}

type Host_Health int32

const (
	// Health of the host is unknown.
	Host_HEALTH_UNKNOWN Host_Health = 0
	// The host is performing all its functions normally.
	Host_ALIVE Host_Health = 1
	// The host is inoperable, and cannot perform any of its essential functions.
	Host_DEAD Host_Health = 2
	// The host is degraded, and can perform only some of its essential functions.
	Host_DEGRADED Host_Health = 3
)

var Host_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
	3: "DEGRADED",
}
var Host_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
	"DEGRADED":       3,
}

func (x Host_Health) String() string {
	return proto.EnumName(Host_Health_name, int32(x))
}
func (Host_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_75c4156e122d92ad, []int{4, 2}
}

type Service_Type int32

const (
	Service_TYPE_UNSPECIFIED Service_Type = 0
	// The host is a PostgreSQL server.
	Service_POSTGRESQL Service_Type = 1
	// The host is a PgBouncer server.
	Service_POOLER Service_Type = 2
)

var Service_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "POSTGRESQL",
	2: "POOLER",
}
var Service_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"POSTGRESQL":       1,
	"POOLER":           2,
}

func (x Service_Type) String() string {
	return proto.EnumName(Service_Type_name, int32(x))
}
func (Service_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_75c4156e122d92ad, []int{6, 0}
}

type Service_Health int32

const (
	// Health of the server is unknown.
	Service_HEALTH_UNKNOWN Service_Health = 0
	// The server is working normally.
	Service_ALIVE Service_Health = 1
	// The server is dead or unresponsive.
	Service_DEAD Service_Health = 2
)

var Service_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
}
var Service_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
}

func (x Service_Health) String() string {
	return proto.EnumName(Service_Health_name, int32(x))
}
func (Service_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_75c4156e122d92ad, []int{6, 1}
}

// A PostgreSQL Cluster resource. For more information, see
// the [Concepts](/docs/managed-postgresql/concepts) section of the documentation.
type Cluster struct {
	// ID of the PostgreSQL cluster.
	// This ID is assigned by MDB at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the PostgreSQL cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the PostgreSQL cluster.
	// The name is unique within the folder. 1-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the PostgreSQL cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the PostgreSQL cluster as `` key:value `` pairs.
	// Maximum 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the PostgreSQL cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.postgresql.v1.Cluster_Environment" json:"environment,omitempty"`
	// Description of monitoring systems relevant to the PostgreSQL cluster.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the PostgreSQL cluster.
	Config *ClusterConfig `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	// ID of the network that the cluster belongs to.
	NetworkId string `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Aggregated cluster health.
	Health Cluster_Health `protobuf:"varint,11,opt,name=health,proto3,enum=yandex.cloud.mdb.postgresql.v1.Cluster_Health" json:"health,omitempty"`
	// Current state of the cluster.
	Status               Cluster_Status `protobuf:"varint,12,opt,name=status,proto3,enum=yandex.cloud.mdb.postgresql.v1.Cluster_Status" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Cluster) Reset()         { *m = Cluster{} }
func (m *Cluster) String() string { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()    {}
func (*Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_75c4156e122d92ad, []int{0}
}
func (m *Cluster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Cluster.Unmarshal(m, b)
}
func (m *Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Cluster.Marshal(b, m, deterministic)
}
func (dst *Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster.Merge(dst, src)
}
func (m *Cluster) XXX_Size() int {
	return xxx_messageInfo_Cluster.Size(m)
}
func (m *Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster proto.InternalMessageInfo

func (m *Cluster) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Cluster) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *Cluster) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Cluster) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Cluster) GetEnvironment() Cluster_Environment {
	if m != nil {
		return m.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (m *Cluster) GetMonitoring() []*Monitoring {
	if m != nil {
		return m.Monitoring
	}
	return nil
}

func (m *Cluster) GetConfig() *ClusterConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Cluster) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *Cluster) GetHealth() Cluster_Health {
	if m != nil {
		return m.Health
	}
	return Cluster_HEALTH_UNKNOWN
}

func (m *Cluster) GetStatus() Cluster_Status {
	if m != nil {
		return m.Status
	}
	return Cluster_STATUS_UNKNOWN
}

// Monitoring system.
type Monitoring struct {
	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system charts for the PostgreSQL cluster.
	Link                 string   `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Monitoring) Reset()         { *m = Monitoring{} }
func (m *Monitoring) String() string { return proto.CompactTextString(m) }
func (*Monitoring) ProtoMessage()    {}
func (*Monitoring) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_75c4156e122d92ad, []int{1}
}
func (m *Monitoring) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Monitoring.Unmarshal(m, b)
}
func (m *Monitoring) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Monitoring.Marshal(b, m, deterministic)
}
func (dst *Monitoring) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Monitoring.Merge(dst, src)
}
func (m *Monitoring) XXX_Size() int {
	return xxx_messageInfo_Monitoring.Size(m)
}
func (m *Monitoring) XXX_DiscardUnknown() {
	xxx_messageInfo_Monitoring.DiscardUnknown(m)
}

var xxx_messageInfo_Monitoring proto.InternalMessageInfo

func (m *Monitoring) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Monitoring) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Monitoring) GetLink() string {
	if m != nil {
		return m.Link
	}
	return ""
}

type ClusterConfig struct {
	// Version of PostgreSQL server software.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Configuration for PostgreSQL servers in the cluster.
	//
	// Types that are valid to be assigned to PostgresqlConfig:
	//	*ClusterConfig_PostgresqlConfig_9_6
	//	*ClusterConfig_PostgresqlConfig_10
	//	*ClusterConfig_PostgresqlConfig_11
	PostgresqlConfig isClusterConfig_PostgresqlConfig `protobuf_oneof:"postgresql_config"`
	// Configuration of the connection pooler.
	PoolerConfig *ConnectionPoolerConfig `protobuf:"bytes,4,opt,name=pooler_config,json=poolerConfig,proto3" json:"pooler_config,omitempty"`
	// Resources allocated to PostgreSQL hosts.
	Resources *Resources `protobuf:"bytes,5,opt,name=resources,proto3" json:"resources,omitempty"`
	// Configuration setting which enables/disables autofailover in cluster.
	Autofailover *wrappers.BoolValue `protobuf:"bytes,6,opt,name=autofailover,proto3" json:"autofailover,omitempty"`
	// Start time for the daily backup in UTC timezone
	BackupWindowStart    *timeofday.TimeOfDay `protobuf:"bytes,7,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ClusterConfig) Reset()         { *m = ClusterConfig{} }
func (m *ClusterConfig) String() string { return proto.CompactTextString(m) }
func (*ClusterConfig) ProtoMessage()    {}
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_75c4156e122d92ad, []int{2}
}
func (m *ClusterConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterConfig.Unmarshal(m, b)
}
func (m *ClusterConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterConfig.Marshal(b, m, deterministic)
}
func (dst *ClusterConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterConfig.Merge(dst, src)
}
func (m *ClusterConfig) XXX_Size() int {
	return xxx_messageInfo_ClusterConfig.Size(m)
}
func (m *ClusterConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterConfig proto.InternalMessageInfo

func (m *ClusterConfig) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

type isClusterConfig_PostgresqlConfig interface {
	isClusterConfig_PostgresqlConfig()
}

type ClusterConfig_PostgresqlConfig_9_6 struct {
	PostgresqlConfig_9_6 *config.PostgresqlConfigSet9_6 `protobuf:"bytes,2,opt,name=postgresql_config_9_6,json=postgresqlConfig96,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_10 struct {
	PostgresqlConfig_10 *config.PostgresqlConfigSet10 `protobuf:"bytes,3,opt,name=postgresql_config_10,json=postgresqlConfig10,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_11 struct {
	PostgresqlConfig_11 *config.PostgresqlConfigSet11 `protobuf:"bytes,8,opt,name=postgresql_config_11,json=postgresqlConfig11,proto3,oneof"`
}

func (*ClusterConfig_PostgresqlConfig_9_6) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_10) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_11) isClusterConfig_PostgresqlConfig() {}

func (m *ClusterConfig) GetPostgresqlConfig() isClusterConfig_PostgresqlConfig {
	if m != nil {
		return m.PostgresqlConfig
	}
	return nil
}

func (m *ClusterConfig) GetPostgresqlConfig_9_6() *config.PostgresqlConfigSet9_6 {
	if x, ok := m.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_9_6); ok {
		return x.PostgresqlConfig_9_6
	}
	return nil
}

func (m *ClusterConfig) GetPostgresqlConfig_10() *config.PostgresqlConfigSet10 {
	if x, ok := m.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_10); ok {
		return x.PostgresqlConfig_10
	}
	return nil
}

func (m *ClusterConfig) GetPostgresqlConfig_11() *config.PostgresqlConfigSet11 {
	if x, ok := m.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_11); ok {
		return x.PostgresqlConfig_11
	}
	return nil
}

func (m *ClusterConfig) GetPoolerConfig() *ConnectionPoolerConfig {
	if m != nil {
		return m.PoolerConfig
	}
	return nil
}

func (m *ClusterConfig) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *ClusterConfig) GetAutofailover() *wrappers.BoolValue {
	if m != nil {
		return m.Autofailover
	}
	return nil
}

func (m *ClusterConfig) GetBackupWindowStart() *timeofday.TimeOfDay {
	if m != nil {
		return m.BackupWindowStart
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ClusterConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ClusterConfig_OneofMarshaler, _ClusterConfig_OneofUnmarshaler, _ClusterConfig_OneofSizer, []interface{}{
		(*ClusterConfig_PostgresqlConfig_9_6)(nil),
		(*ClusterConfig_PostgresqlConfig_10)(nil),
		(*ClusterConfig_PostgresqlConfig_11)(nil),
	}
}

func _ClusterConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ClusterConfig)
	// postgresql_config
	switch x := m.PostgresqlConfig.(type) {
	case *ClusterConfig_PostgresqlConfig_9_6:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PostgresqlConfig_9_6); err != nil {
			return err
		}
	case *ClusterConfig_PostgresqlConfig_10:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PostgresqlConfig_10); err != nil {
			return err
		}
	case *ClusterConfig_PostgresqlConfig_11:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PostgresqlConfig_11); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ClusterConfig.PostgresqlConfig has unexpected type %T", x)
	}
	return nil
}

func _ClusterConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ClusterConfig)
	switch tag {
	case 2: // postgresql_config.postgresql_config_9_6
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(config.PostgresqlConfigSet9_6)
		err := b.DecodeMessage(msg)
		m.PostgresqlConfig = &ClusterConfig_PostgresqlConfig_9_6{msg}
		return true, err
	case 3: // postgresql_config.postgresql_config_10
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(config.PostgresqlConfigSet10)
		err := b.DecodeMessage(msg)
		m.PostgresqlConfig = &ClusterConfig_PostgresqlConfig_10{msg}
		return true, err
	case 8: // postgresql_config.postgresql_config_11
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(config.PostgresqlConfigSet11)
		err := b.DecodeMessage(msg)
		m.PostgresqlConfig = &ClusterConfig_PostgresqlConfig_11{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ClusterConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ClusterConfig)
	// postgresql_config
	switch x := m.PostgresqlConfig.(type) {
	case *ClusterConfig_PostgresqlConfig_9_6:
		s := proto.Size(x.PostgresqlConfig_9_6)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ClusterConfig_PostgresqlConfig_10:
		s := proto.Size(x.PostgresqlConfig_10)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ClusterConfig_PostgresqlConfig_11:
		s := proto.Size(x.PostgresqlConfig_11)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type ConnectionPoolerConfig struct {
	// Mode that the connection pooler is working in.
	// See descriptions of all modes in the [documentation for PgBouncer](https://pgbouncer.github.io/usage).
	PoolingMode          ConnectionPoolerConfig_PoolingMode `protobuf:"varint,1,opt,name=pooling_mode,json=poolingMode,proto3,enum=yandex.cloud.mdb.postgresql.v1.ConnectionPoolerConfig_PoolingMode" json:"pooling_mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *ConnectionPoolerConfig) Reset()         { *m = ConnectionPoolerConfig{} }
func (m *ConnectionPoolerConfig) String() string { return proto.CompactTextString(m) }
func (*ConnectionPoolerConfig) ProtoMessage()    {}
func (*ConnectionPoolerConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_75c4156e122d92ad, []int{3}
}
func (m *ConnectionPoolerConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConnectionPoolerConfig.Unmarshal(m, b)
}
func (m *ConnectionPoolerConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConnectionPoolerConfig.Marshal(b, m, deterministic)
}
func (dst *ConnectionPoolerConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectionPoolerConfig.Merge(dst, src)
}
func (m *ConnectionPoolerConfig) XXX_Size() int {
	return xxx_messageInfo_ConnectionPoolerConfig.Size(m)
}
func (m *ConnectionPoolerConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectionPoolerConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectionPoolerConfig proto.InternalMessageInfo

func (m *ConnectionPoolerConfig) GetPoolingMode() ConnectionPoolerConfig_PoolingMode {
	if m != nil {
		return m.PoolingMode
	}
	return ConnectionPoolerConfig_POOLING_MODE_UNSPECIFIED
}

type Host struct {
	// Name of the PostgreSQL host. The host name is assigned by MDB at creation time, and cannot be changed.
	// 1-63 characters long.
	//
	// The name is unique across all existing MDB hosts in Yandex.Cloud, as it defines the FQDN of the host.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the PostgreSQL host. The ID is assigned by MDB at creation time.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the availability zone where the PostgreSQL host resides.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Resources allocated to the PostgreSQL host.
	Resources *Resources `protobuf:"bytes,4,opt,name=resources,proto3" json:"resources,omitempty"`
	// Role of the host in the cluster.
	Role Host_Role `protobuf:"varint,5,opt,name=role,proto3,enum=yandex.cloud.mdb.postgresql.v1.Host_Role" json:"role,omitempty"`
	// Status code of the aggregated health of the host.
	Health Host_Health `protobuf:"varint,6,opt,name=health,proto3,enum=yandex.cloud.mdb.postgresql.v1.Host_Health" json:"health,omitempty"`
	// Services provided by the host.
	Services []*Service `protobuf:"bytes,7,rep,name=services,proto3" json:"services,omitempty"`
	// ID of the subnet that the host belongs to.
	SubnetId string `protobuf:"bytes,8,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Name of the host to be used as the replication source for cascading replication.
	ReplicationSource string `protobuf:"bytes,9,opt,name=replication_source,json=replicationSource,proto3" json:"replication_source,omitempty"`
	// Priority of the host as a replica. Higher value means higher priority.
	//
	// The host with the highest priority is the synchronous replica. All others are asynchronous.
	// The synchronous replica replaces the master when needed.
	//
	// When a replica becomes the master, its priority is ignored.
	Priority *wrappers.Int64Value `protobuf:"bytes,10,opt,name=priority,proto3" json:"priority,omitempty"`
	// Configuration of a PostgreSQL server for the host.
	Config *HostConfig `protobuf:"bytes,11,opt,name=config,proto3" json:"config,omitempty"`
	// Flag showing public IP assignment status to this host.
	AssignPublicIp       bool             `protobuf:"varint,12,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	ReplicaType          Host_ReplicaType `protobuf:"varint,13,opt,name=replica_type,json=replicaType,proto3,enum=yandex.cloud.mdb.postgresql.v1.Host_ReplicaType" json:"replica_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Host) Reset()         { *m = Host{} }
func (m *Host) String() string { return proto.CompactTextString(m) }
func (*Host) ProtoMessage()    {}
func (*Host) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_75c4156e122d92ad, []int{4}
}
func (m *Host) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Host.Unmarshal(m, b)
}
func (m *Host) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Host.Marshal(b, m, deterministic)
}
func (dst *Host) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Host.Merge(dst, src)
}
func (m *Host) XXX_Size() int {
	return xxx_messageInfo_Host.Size(m)
}
func (m *Host) XXX_DiscardUnknown() {
	xxx_messageInfo_Host.DiscardUnknown(m)
}

var xxx_messageInfo_Host proto.InternalMessageInfo

func (m *Host) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Host) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *Host) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *Host) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Host) GetRole() Host_Role {
	if m != nil {
		return m.Role
	}
	return Host_ROLE_UNKNOWN
}

func (m *Host) GetHealth() Host_Health {
	if m != nil {
		return m.Health
	}
	return Host_HEALTH_UNKNOWN
}

func (m *Host) GetServices() []*Service {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *Host) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *Host) GetReplicationSource() string {
	if m != nil {
		return m.ReplicationSource
	}
	return ""
}

func (m *Host) GetPriority() *wrappers.Int64Value {
	if m != nil {
		return m.Priority
	}
	return nil
}

func (m *Host) GetConfig() *HostConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Host) GetAssignPublicIp() bool {
	if m != nil {
		return m.AssignPublicIp
	}
	return false
}

func (m *Host) GetReplicaType() Host_ReplicaType {
	if m != nil {
		return m.ReplicaType
	}
	return Host_REPLICA_TYPE_UNKNOWN
}

type HostConfig struct {
	// Configuration of a PostgreSQL server for the host.
	//
	// Types that are valid to be assigned to PostgresqlConfig:
	//	*HostConfig_PostgresqlConfig_9_6
	//	*HostConfig_PostgresqlConfig_10
	//	*HostConfig_PostgresqlConfig_11
	PostgresqlConfig     isHostConfig_PostgresqlConfig `protobuf_oneof:"postgresql_config"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *HostConfig) Reset()         { *m = HostConfig{} }
func (m *HostConfig) String() string { return proto.CompactTextString(m) }
func (*HostConfig) ProtoMessage()    {}
func (*HostConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_75c4156e122d92ad, []int{5}
}
func (m *HostConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HostConfig.Unmarshal(m, b)
}
func (m *HostConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HostConfig.Marshal(b, m, deterministic)
}
func (dst *HostConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HostConfig.Merge(dst, src)
}
func (m *HostConfig) XXX_Size() int {
	return xxx_messageInfo_HostConfig.Size(m)
}
func (m *HostConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_HostConfig.DiscardUnknown(m)
}

var xxx_messageInfo_HostConfig proto.InternalMessageInfo

type isHostConfig_PostgresqlConfig interface {
	isHostConfig_PostgresqlConfig()
}

type HostConfig_PostgresqlConfig_9_6 struct {
	PostgresqlConfig_9_6 *config.PostgresqlHostConfig9_6 `protobuf:"bytes,1,opt,name=postgresql_config_9_6,json=postgresqlConfig96,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_10 struct {
	PostgresqlConfig_10 *config.PostgresqlHostConfig10 `protobuf:"bytes,2,opt,name=postgresql_config_10,json=postgresqlConfig10,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_11 struct {
	PostgresqlConfig_11 *config.PostgresqlHostConfig11 `protobuf:"bytes,3,opt,name=postgresql_config_11,json=postgresqlConfig11,proto3,oneof"`
}

func (*HostConfig_PostgresqlConfig_9_6) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_10) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_11) isHostConfig_PostgresqlConfig() {}

func (m *HostConfig) GetPostgresqlConfig() isHostConfig_PostgresqlConfig {
	if m != nil {
		return m.PostgresqlConfig
	}
	return nil
}

func (m *HostConfig) GetPostgresqlConfig_9_6() *config.PostgresqlHostConfig9_6 {
	if x, ok := m.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_9_6); ok {
		return x.PostgresqlConfig_9_6
	}
	return nil
}

func (m *HostConfig) GetPostgresqlConfig_10() *config.PostgresqlHostConfig10 {
	if x, ok := m.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_10); ok {
		return x.PostgresqlConfig_10
	}
	return nil
}

func (m *HostConfig) GetPostgresqlConfig_11() *config.PostgresqlHostConfig11 {
	if x, ok := m.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_11); ok {
		return x.PostgresqlConfig_11
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HostConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HostConfig_OneofMarshaler, _HostConfig_OneofUnmarshaler, _HostConfig_OneofSizer, []interface{}{
		(*HostConfig_PostgresqlConfig_9_6)(nil),
		(*HostConfig_PostgresqlConfig_10)(nil),
		(*HostConfig_PostgresqlConfig_11)(nil),
	}
}

func _HostConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HostConfig)
	// postgresql_config
	switch x := m.PostgresqlConfig.(type) {
	case *HostConfig_PostgresqlConfig_9_6:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PostgresqlConfig_9_6); err != nil {
			return err
		}
	case *HostConfig_PostgresqlConfig_10:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PostgresqlConfig_10); err != nil {
			return err
		}
	case *HostConfig_PostgresqlConfig_11:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PostgresqlConfig_11); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("HostConfig.PostgresqlConfig has unexpected type %T", x)
	}
	return nil
}

func _HostConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HostConfig)
	switch tag {
	case 1: // postgresql_config.postgresql_config_9_6
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(config.PostgresqlHostConfig9_6)
		err := b.DecodeMessage(msg)
		m.PostgresqlConfig = &HostConfig_PostgresqlConfig_9_6{msg}
		return true, err
	case 2: // postgresql_config.postgresql_config_10
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(config.PostgresqlHostConfig10)
		err := b.DecodeMessage(msg)
		m.PostgresqlConfig = &HostConfig_PostgresqlConfig_10{msg}
		return true, err
	case 3: // postgresql_config.postgresql_config_11
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(config.PostgresqlHostConfig11)
		err := b.DecodeMessage(msg)
		m.PostgresqlConfig = &HostConfig_PostgresqlConfig_11{msg}
		return true, err
	default:
		return false, nil
	}
}

func _HostConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HostConfig)
	// postgresql_config
	switch x := m.PostgresqlConfig.(type) {
	case *HostConfig_PostgresqlConfig_9_6:
		s := proto.Size(x.PostgresqlConfig_9_6)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *HostConfig_PostgresqlConfig_10:
		s := proto.Size(x.PostgresqlConfig_10)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *HostConfig_PostgresqlConfig_11:
		s := proto.Size(x.PostgresqlConfig_11)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type Service struct {
	// Type of the service provided by the host.
	Type Service_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.mdb.postgresql.v1.Service_Type" json:"type,omitempty"`
	// Status code of server availability.
	Health               Service_Health `protobuf:"varint,2,opt,name=health,proto3,enum=yandex.cloud.mdb.postgresql.v1.Service_Health" json:"health,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Service) Reset()         { *m = Service{} }
func (m *Service) String() string { return proto.CompactTextString(m) }
func (*Service) ProtoMessage()    {}
func (*Service) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_75c4156e122d92ad, []int{6}
}
func (m *Service) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Service.Unmarshal(m, b)
}
func (m *Service) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Service.Marshal(b, m, deterministic)
}
func (dst *Service) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Service.Merge(dst, src)
}
func (m *Service) XXX_Size() int {
	return xxx_messageInfo_Service.Size(m)
}
func (m *Service) XXX_DiscardUnknown() {
	xxx_messageInfo_Service.DiscardUnknown(m)
}

var xxx_messageInfo_Service proto.InternalMessageInfo

func (m *Service) GetType() Service_Type {
	if m != nil {
		return m.Type
	}
	return Service_TYPE_UNSPECIFIED
}

func (m *Service) GetHealth() Service_Health {
	if m != nil {
		return m.Health
	}
	return Service_HEALTH_UNKNOWN
}

type Resources struct {
	// ID of the preset for computational resources available to a host (CPU, memory etc.).
	// All available presets are listed in the [documentation](/docs/managed-postgresql/concepts/instance-types).
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	// Volume of the storage available to a host, in bytes.
	DiskSize int64 `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	// Type of the storage environment for the host.
	// Possible values:
	// * network-hdd — network HDD drive,
	// * network-nvme — network SSD drive,
	// * local-nvme — local SSD storage.
	DiskTypeId           string   `protobuf:"bytes,3,opt,name=disk_type_id,json=diskTypeId,proto3" json:"disk_type_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Resources) Reset()         { *m = Resources{} }
func (m *Resources) String() string { return proto.CompactTextString(m) }
func (*Resources) ProtoMessage()    {}
func (*Resources) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_75c4156e122d92ad, []int{7}
}
func (m *Resources) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Resources.Unmarshal(m, b)
}
func (m *Resources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Resources.Marshal(b, m, deterministic)
}
func (dst *Resources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resources.Merge(dst, src)
}
func (m *Resources) XXX_Size() int {
	return xxx_messageInfo_Resources.Size(m)
}
func (m *Resources) XXX_DiscardUnknown() {
	xxx_messageInfo_Resources.DiscardUnknown(m)
}

var xxx_messageInfo_Resources proto.InternalMessageInfo

func (m *Resources) GetResourcePresetId() string {
	if m != nil {
		return m.ResourcePresetId
	}
	return ""
}

func (m *Resources) GetDiskSize() int64 {
	if m != nil {
		return m.DiskSize
	}
	return 0
}

func (m *Resources) GetDiskTypeId() string {
	if m != nil {
		return m.DiskTypeId
	}
	return ""
}

func init() {
	proto.RegisterType((*Cluster)(nil), "yandex.cloud.mdb.postgresql.v1.Cluster")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.postgresql.v1.Cluster.LabelsEntry")
	proto.RegisterType((*Monitoring)(nil), "yandex.cloud.mdb.postgresql.v1.Monitoring")
	proto.RegisterType((*ClusterConfig)(nil), "yandex.cloud.mdb.postgresql.v1.ClusterConfig")
	proto.RegisterType((*ConnectionPoolerConfig)(nil), "yandex.cloud.mdb.postgresql.v1.ConnectionPoolerConfig")
	proto.RegisterType((*Host)(nil), "yandex.cloud.mdb.postgresql.v1.Host")
	proto.RegisterType((*HostConfig)(nil), "yandex.cloud.mdb.postgresql.v1.HostConfig")
	proto.RegisterType((*Service)(nil), "yandex.cloud.mdb.postgresql.v1.Service")
	proto.RegisterType((*Resources)(nil), "yandex.cloud.mdb.postgresql.v1.Resources")
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.Cluster_Environment", Cluster_Environment_name, Cluster_Environment_value)
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.Cluster_Health", Cluster_Health_name, Cluster_Health_value)
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.Cluster_Status", Cluster_Status_name, Cluster_Status_value)
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.ConnectionPoolerConfig_PoolingMode", ConnectionPoolerConfig_PoolingMode_name, ConnectionPoolerConfig_PoolingMode_value)
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.Host_Role", Host_Role_name, Host_Role_value)
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.Host_ReplicaType", Host_ReplicaType_name, Host_ReplicaType_value)
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.Host_Health", Host_Health_name, Host_Health_value)
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.Service_Type", Service_Type_name, Service_Type_value)
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.Service_Health", Service_Health_name, Service_Health_value)
}

func init() {
	proto.RegisterFile("yandex/cloud/mdb/postgresql/v1/cluster.proto", fileDescriptor_cluster_75c4156e122d92ad)
}

var fileDescriptor_cluster_75c4156e122d92ad = []byte{
	// 1492 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0xcd, 0x57, 0xdb, 0xc6,
	0x16, 0x8f, 0x3f, 0xf0, 0xc7, 0x95, 0xe1, 0x29, 0x13, 0x5e, 0xa2, 0x03, 0x2f, 0x79, 0x1c, 0x6f,
	0x1e, 0x2f, 0x2f, 0xc8, 0xd8, 0x79, 0x87, 0x86, 0x36, 0x49, 0x6b, 0x6c, 0x05, 0xd4, 0x18, 0xdb,
	0x1d, 0x19, 0xd2, 0xb4, 0x0b, 0x1d, 0xd9, 0x1a, 0x8c, 0x0e, 0xb2, 0x46, 0x91, 0x64, 0x88, 0xb3,
	0xea, 0x1f, 0xd7, 0x7d, 0xd7, 0xdd, 0xf4, 0x2f, 0xe9, 0xa2, 0x67, 0x66, 0x84, 0x6d, 0x3e, 0x1c,
	0x0c, 0xe9, 0x4e, 0x73, 0xef, 0xfd, 0xdd, 0x99, 0xb9, 0x5f, 0xbf, 0x11, 0x3c, 0x1b, 0x59, 0x9e,
	0x4d, 0x3e, 0x96, 0x7a, 0x2e, 0x1d, 0xda, 0xa5, 0x81, 0xdd, 0x2d, 0xf9, 0x34, 0x8c, 0xfa, 0x01,
	0x09, 0x3f, 0xb8, 0xa5, 0xd3, 0x72, 0xa9, 0xe7, 0x0e, 0xc3, 0x88, 0x04, 0xaa, 0x1f, 0xd0, 0x88,
	0xa2, 0x27, 0xc2, 0x5a, 0xe5, 0xd6, 0xea, 0xc0, 0xee, 0xaa, 0x13, 0x6b, 0xf5, 0xb4, 0xbc, 0xf2,
	0xef, 0x3e, 0xa5, 0x7d, 0x97, 0x94, 0xb8, 0x75, 0x77, 0x78, 0x54, 0x8a, 0x9c, 0x01, 0x09, 0x23,
	0x6b, 0xe0, 0x0b, 0x07, 0x2b, 0x4f, 0x2e, 0x1b, 0x9c, 0x05, 0x96, 0xef, 0x93, 0x20, 0x8c, 0xf5,
	0xab, 0xb1, 0x3e, 0x1a, 0xf9, 0x84, 0x83, 0xe9, 0x91, 0x6d, 0x8d, 0x62, 0xe5, 0xf6, 0x4d, 0x67,
	0xa5, 0xde, 0x91, 0xd3, 0x9f, 0x12, 0x6e, 0x9b, 0x5b, 0x31, 0xf4, 0xc5, 0x6d, 0xa1, 0xe5, 0xcd,
	0x3b, 0x23, 0xcb, 0x31, 0xf2, 0xf9, 0x7c, 0xc8, 0x63, 0x1a, 0x46, 0x93, 0x83, 0x56, 0xe6, 0x07,
	0x8d, 0x8f, 0x78, 0x1b, 0x4c, 0x7c, 0xb8, 0xe2, 0x6f, 0x59, 0xc8, 0xd6, 0x44, 0x6e, 0xd1, 0x12,
	0x24, 0x1d, 0x5b, 0x49, 0xac, 0x25, 0xd6, 0xf3, 0x38, 0xe9, 0xd8, 0x68, 0x15, 0xf2, 0x47, 0xd4,
	0xb5, 0x49, 0x60, 0x3a, 0xb6, 0x92, 0xe4, 0xe2, 0x9c, 0x10, 0xe8, 0x36, 0xda, 0x06, 0xe8, 0x05,
	0xc4, 0x8a, 0x88, 0x6d, 0x5a, 0x91, 0x92, 0x5a, 0x4b, 0xac, 0x4b, 0x95, 0x15, 0x55, 0xa4, 0x4d,
	0x3d, 0x4f, 0xab, 0xda, 0x39, 0xcf, 0x3b, 0xce, 0xc7, 0xd6, 0xd5, 0x08, 0x21, 0x48, 0x7b, 0xd6,
	0x80, 0x28, 0x69, 0xee, 0x92, 0x7f, 0xa3, 0x35, 0x90, 0x6c, 0x12, 0xf6, 0x02, 0xc7, 0x8f, 0x1c,
	0xea, 0x29, 0x0b, 0x5c, 0x35, 0x2d, 0x42, 0x6f, 0x21, 0xe3, 0x5a, 0x5d, 0xe2, 0x86, 0x4a, 0x66,
	0x2d, 0xb5, 0x2e, 0x55, 0x9e, 0xab, 0x9f, 0x2f, 0x42, 0x35, 0xbe, 0x96, 0xda, 0xe0, 0x28, 0xcd,
	0x8b, 0x82, 0x11, 0x8e, 0x5d, 0xa0, 0x03, 0x90, 0x88, 0x77, 0xea, 0x04, 0xd4, 0x1b, 0x10, 0x2f,
	0x52, 0xb2, 0x6b, 0x89, 0xf5, 0xa5, 0xf9, 0x3d, 0x6a, 0x13, 0x28, 0x9e, 0xf6, 0x83, 0xbe, 0x07,
	0x18, 0x50, 0xcf, 0x89, 0x68, 0xe0, 0x78, 0x7d, 0x25, 0xc7, 0xcf, 0xf9, 0xf4, 0x26, 0xaf, 0xfb,
	0x63, 0x04, 0x9e, 0x42, 0x23, 0x0d, 0x32, 0x22, 0x61, 0x4a, 0x9e, 0x07, 0x77, 0x63, 0xce, 0xd3,
	0xd5, 0x38, 0x08, 0xc7, 0x60, 0xf4, 0x18, 0xc0, 0x23, 0xd1, 0x19, 0x0d, 0x4e, 0x58, 0x16, 0x81,
	0xc7, 0x35, 0x1f, 0x4b, 0x74, 0x1b, 0xbd, 0x81, 0xcc, 0x31, 0xb1, 0xdc, 0xe8, 0x58, 0x91, 0x78,
	0x0c, 0xd4, 0x79, 0x63, 0xb0, 0xc7, 0x51, 0x38, 0x46, 0x33, 0x3f, 0x61, 0x64, 0x45, 0xc3, 0x50,
	0x29, 0xdc, 0xce, 0x8f, 0xc1, 0x51, 0x38, 0x46, 0xaf, 0x6c, 0x83, 0x34, 0x95, 0x2f, 0x24, 0x43,
	0xea, 0x84, 0x8c, 0xe2, 0x9a, 0x64, 0x9f, 0x68, 0x19, 0x16, 0x4e, 0x2d, 0x77, 0x48, 0xe2, 0x82,
	0x14, 0x8b, 0xaf, 0x93, 0x2f, 0x12, 0x45, 0x1d, 0xa4, 0xa9, 0xc4, 0xa0, 0x55, 0x78, 0xa4, 0x35,
	0x0f, 0x75, 0xdc, 0x6a, 0xee, 0x6b, 0xcd, 0x8e, 0x79, 0xd0, 0x34, 0xda, 0x5a, 0x4d, 0x7f, 0xa3,
	0x6b, 0x75, 0xf9, 0x1e, 0x5a, 0x02, 0x68, 0xe3, 0x56, 0xfd, 0xa0, 0xd6, 0xd1, 0x5b, 0x4d, 0x39,
	0x81, 0x16, 0x21, 0xdf, 0xc6, 0x9a, 0xd1, 0xa9, 0xee, 0x34, 0x34, 0x39, 0x59, 0xfc, 0x16, 0x32,
	0xe2, 0x7e, 0x08, 0xc1, 0xd2, 0x9e, 0x56, 0x6d, 0x74, 0xf6, 0xcc, 0x83, 0xe6, 0xdb, 0x66, 0xeb,
	0x5d, 0x53, 0xbe, 0x87, 0xf2, 0xb0, 0x50, 0x6d, 0xe8, 0x87, 0x9a, 0x9c, 0x40, 0x39, 0x48, 0xd7,
	0xb5, 0x6a, 0x5d, 0x4e, 0xa2, 0x02, 0xe4, 0xea, 0xda, 0x2e, 0xae, 0xd6, 0xb5, 0xba, 0x9c, 0x2a,
	0x8e, 0x20, 0x23, 0x2e, 0xc6, 0x1c, 0x18, 0x9d, 0x6a, 0xe7, 0xc0, 0x98, 0x72, 0x50, 0x80, 0x5c,
	0x0d, 0x6b, 0xd5, 0x8e, 0xde, 0xdc, 0x95, 0x13, 0x48, 0x82, 0x2c, 0x3e, 0x68, 0x36, 0xd9, 0x22,
	0xc9, 0x7c, 0x6b, 0x18, 0xb7, 0xb0, 0x9c, 0x62, 0x56, 0x07, 0xed, 0xba, 0xb0, 0x4a, 0xb3, 0x95,
	0xd1, 0x69, 0xb5, 0xdb, 0x6c, 0xb5, 0xc0, 0x30, 0x7c, 0xa5, 0xd5, 0xe5, 0x8c, 0x50, 0x55, 0x31,
	0x37, 0xcc, 0x16, 0x0f, 0x01, 0x26, 0x15, 0x35, 0xee, 0xb5, 0xc4, 0xec, 0x5e, 0x4b, 0x5e, 0xed,
	0x35, 0x04, 0x69, 0xd7, 0xf1, 0x4e, 0x78, 0x5b, 0xe7, 0x31, 0xff, 0x2e, 0xfe, 0xba, 0x00, 0x8b,
	0x17, 0x4a, 0x0c, 0x29, 0x90, 0x3d, 0x25, 0x41, 0xc8, 0x7c, 0x08, 0xf7, 0xe7, 0x4b, 0x14, 0xc0,
	0x3f, 0x27, 0xd9, 0x36, 0x45, 0x25, 0x9a, 0xdb, 0xe6, 0x16, 0xdf, 0x4b, 0xaa, 0xbc, 0xba, 0xa9,
	0x38, 0x04, 0x42, 0x6d, 0x8f, 0x85, 0x62, 0x47, 0x83, 0xb0, 0x09, 0xb9, 0x77, 0x0f, 0x23, 0xff,
	0x92, 0x66, 0x7b, 0x0b, 0xf9, 0xb0, 0x7c, 0x75, 0xcf, 0xf2, 0x66, 0x3c, 0x9a, 0x5e, 0xde, 0x7d,
	0xcb, 0xf2, 0xe6, 0x75, 0x3b, 0x96, 0x37, 0x67, 0xec, 0x58, 0x56, 0x72, 0x5f, 0xbc, 0x63, 0xf9,
	0xda, 0x1d, 0xcb, 0xe8, 0x67, 0x58, 0xf4, 0x29, 0x75, 0x49, 0x10, 0xef, 0xc6, 0x47, 0xa8, 0x54,
	0xd9, 0xba, 0xb1, 0xd9, 0xa8, 0xe7, 0x91, 0x1e, 0x4b, 0x6d, 0x9b, 0xc3, 0xe3, 0x19, 0x51, 0xf0,
	0xa7, 0x56, 0x68, 0x17, 0xf2, 0x01, 0x09, 0xe9, 0x30, 0xe8, 0x91, 0x90, 0x0f, 0x60, 0xa9, 0xf2,
	0xdf, 0x9b, 0x1c, 0xe3, 0x73, 0x00, 0x9e, 0x60, 0xd1, 0x6b, 0x28, 0x58, 0xc3, 0x88, 0x1e, 0x59,
	0x8e, 0x4b, 0x4f, 0x49, 0xa0, 0x64, 0x66, 0x90, 0xc3, 0x0e, 0xa5, 0xee, 0x21, 0x6b, 0x5f, 0x7c,
	0xc1, 0x1e, 0xbd, 0x81, 0x07, 0x5d, 0xab, 0x77, 0x32, 0xf4, 0xcd, 0x33, 0xc7, 0xb3, 0xe9, 0x99,
	0x19, 0x46, 0x56, 0x20, 0x86, 0xb4, 0x54, 0x79, 0x78, 0xee, 0x86, 0x3d, 0x0d, 0x38, 0xbf, 0xb4,
	0x8e, 0xea, 0xd6, 0x08, 0xdf, 0x17, 0x90, 0x77, 0x1c, 0x61, 0x30, 0xc0, 0xce, 0x03, 0xb8, 0x7f,
	0x25, 0x3f, 0xc5, 0xdf, 0x13, 0xf0, 0xf0, 0xfa, 0x70, 0x20, 0x02, 0x3c, 0x20, 0x8e, 0xd7, 0x37,
	0x07, 0xd4, 0x16, 0x3d, 0xb3, 0x54, 0xd9, 0xb9, 0x5b, 0x70, 0xd5, 0xb6, 0x70, 0xb5, 0x4f, 0x6d,
	0x82, 0x25, 0x7f, 0xb2, 0x28, 0xfe, 0x08, 0xd2, 0x94, 0x0e, 0xfd, 0x0b, 0x94, 0x76, 0xab, 0xd5,
	0xd0, 0x9b, 0xbb, 0xe6, 0x7e, 0xab, 0xae, 0x5d, 0x1a, 0x54, 0xac, 0xd1, 0x35, 0xc3, 0x10, 0x53,
	0xea, 0x1f, 0x20, 0x75, 0x70, 0xb5, 0x69, 0x54, 0xc5, 0xd8, 0x4a, 0xb2, 0xb1, 0xc5, 0x86, 0x8b,
	0xc6, 0x26, 0x9c, 0x9c, 0x2a, 0xfe, 0x91, 0x81, 0xf4, 0x1e, 0x0d, 0xa3, 0x6b, 0xbb, 0xfe, 0x31,
	0x40, 0xfc, 0x88, 0x9b, 0xd0, 0x79, 0x3e, 0x96, 0xe8, 0x36, 0x7a, 0x04, 0xd9, 0x4f, 0xd4, 0x23,
	0x4c, 0x27, 0xba, 0x3e, 0xc3, 0x96, 0xba, 0x7d, 0xb1, 0x2c, 0xd2, 0x5f, 0x50, 0x16, 0xaf, 0x20,
	0x1d, 0x50, 0x97, 0xf0, 0xd2, 0x5a, 0xba, 0xd9, 0x07, 0xbb, 0x88, 0x8a, 0xa9, 0x4b, 0x30, 0x87,
	0xa1, 0xda, 0x98, 0xa9, 0x32, 0xdc, 0xc1, 0xff, 0xe6, 0x72, 0x70, 0x89, 0xa6, 0x6a, 0x90, 0x0b,
	0x49, 0x70, 0xea, 0xb0, 0xbb, 0x64, 0x39, 0x3d, 0xff, 0xe7, 0x26, 0x37, 0x86, 0xb0, 0xc7, 0x63,
	0x20, 0x7b, 0x17, 0x85, 0xc3, 0xae, 0x47, 0x22, 0x16, 0xac, 0x9c, 0x78, 0x17, 0x09, 0x81, 0x6e,
	0xa3, 0x0d, 0x40, 0x01, 0xf1, 0x5d, 0xa7, 0x67, 0xb1, 0x8a, 0x30, 0xc5, 0xe5, 0x39, 0x85, 0xe7,
	0xf1, 0xfd, 0x29, 0x8d, 0xc1, 0x15, 0xe8, 0x2b, 0xc8, 0xf9, 0x81, 0x43, 0x03, 0x27, 0x1a, 0x71,
	0x72, 0x96, 0x2a, 0xab, 0x57, 0xfa, 0x44, 0xf7, 0xa2, 0xad, 0xff, 0x8b, 0x46, 0x19, 0x1b, 0xa3,
	0x9d, 0xf1, 0xf3, 0x40, 0xe2, 0xb0, 0xa7, 0xf3, 0x84, 0xe3, 0xd2, 0xdb, 0x60, 0x1d, 0x64, 0x2b,
	0x0c, 0x9d, 0xbe, 0x67, 0xfa, 0xc3, 0xae, 0xeb, 0xf4, 0x4c, 0xc7, 0xe7, 0xf4, 0x9d, 0xc3, 0x4b,
	0x42, 0xde, 0xe6, 0x62, 0xdd, 0x47, 0x06, 0x14, 0xe2, 0xb3, 0x9b, 0xac, 0xef, 0x94, 0x45, 0x9e,
	0x82, 0xcd, 0xf9, 0x72, 0x28, 0x80, 0x9d, 0x91, 0x4f, 0xb0, 0x14, 0x4c, 0x16, 0xc5, 0x32, 0xa4,
	0x59, 0x7e, 0x91, 0x0c, 0x05, 0xdc, 0x6a, 0x68, 0x53, 0x04, 0x09, 0x90, 0xd9, 0xaf, 0x1a, 0x1d,
	0x0d, 0xc7, 0xf4, 0xa8, 0xb5, 0x1b, 0x7a, 0xad, 0x2a, 0x27, 0x8b, 0x2f, 0x41, 0x9a, 0x72, 0x87,
	0x14, 0x58, 0x8e, 0x75, 0x66, 0xe7, 0x7d, 0x5b, 0xbb, 0xc4, 0xd1, 0xc6, 0xfb, 0x66, 0x4d, 0x70,
	0x34, 0xff, 0xfa, 0x1b, 0x68, 0xfd, 0xcf, 0x24, 0xc0, 0x24, 0x8e, 0x28, 0x9c, 0x45, 0x73, 0x09,
	0x9e, 0x92, 0xd7, 0xb7, 0x66, 0x80, 0x89, 0xef, 0xd9, 0x3c, 0xf7, 0x61, 0x06, 0xcf, 0xdd, 0x95,
	0x5a, 0x27, 0x7b, 0xce, 0x24, 0xba, 0x0f, 0x33, 0x88, 0x2e, 0xf5, 0xe5, 0x5b, 0xce, 0x60, 0xba,
	0xeb, 0x67, 0xf7, 0x2f, 0x49, 0xc8, 0xc6, 0xed, 0x88, 0xbe, 0x83, 0x34, 0xaf, 0x44, 0x31, 0xa4,
	0x9f, 0xcd, 0xd9, 0xc5, 0x2a, 0xaf, 0x42, 0x8e, 0x9c, 0x7a, 0xfa, 0x26, 0xe7, 0x7b, 0xb2, 0x9e,
	0xfb, 0xb8, 0x38, 0x53, 0x8a, 0x2f, 0x20, 0xcd, 0x8b, 0x71, 0x19, 0xe4, 0xb8, 0x08, 0x2f, 0xbf,
	0x34, 0x5b, 0x46, 0x67, 0x17, 0x6b, 0xc6, 0x0f, 0x0d, 0x39, 0xc1, 0x4a, 0x9b, 0x8d, 0x7b, 0x0d,
	0xcb, 0xc9, 0x62, 0xf9, 0xd6, 0xf5, 0x58, 0xfc, 0x08, 0xf9, 0xf1, 0x70, 0x45, 0xcf, 0xd8, 0xac,
	0x11, 0x0b, 0xd3, 0x0f, 0x48, 0x28, 0x26, 0x92, 0x18, 0xfa, 0xf2, 0xb9, 0xa6, 0xcd, 0x15, 0x3a,
	0xff, 0x9d, 0xb3, 0x9d, 0xf0, 0xc4, 0x0c, 0x9d, 0x4f, 0xe2, 0xf5, 0x9c, 0xc2, 0x39, 0x26, 0x30,
	0x9c, 0x4f, 0xec, 0x4d, 0x58, 0xe0, 0x4a, 0x16, 0x99, 0x09, 0x07, 0x00, 0x93, 0xb1, 0xcb, 0xe9,
	0xf6, 0x4e, 0xeb, 0xa7, 0xfd, 0xbe, 0x13, 0x1d, 0x0f, 0xbb, 0x6a, 0x8f, 0x0e, 0x4a, 0x22, 0x54,
	0x1b, 0xe2, 0x57, 0xb3, 0x4f, 0x37, 0xfa, 0xc4, 0xe3, 0xf3, 0xaa, 0xf4, 0xf9, 0x7f, 0xd0, 0x6f,
	0x26, 0xab, 0x6e, 0x86, 0x03, 0x9e, 0xff, 0x15, 0x00, 0x00, 0xff, 0xff, 0xb8, 0x40, 0xd9, 0x92,
	0x7b, 0x10, 0x00, 0x00,
}
