// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/mdb/postgresql/v1/cluster_service.proto

package postgresql // import "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/postgresql/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import _ "github.com/yandex-cloud/go-genproto/yandex/api"
import config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/postgresql/v1/config"
import operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
import _ "github.com/yandex-cloud/go-genproto/yandex/cloud/validation"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import timeofday "google.golang.org/genproto/googleapis/type/timeofday"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type ListClusterLogsRequest_ServiceType int32

const (
	ListClusterLogsRequest_SERVICE_TYPE_UNSPECIFIED ListClusterLogsRequest_ServiceType = 0
	// Logs of PostgreSQL activity.
	ListClusterLogsRequest_POSTGRESQL ListClusterLogsRequest_ServiceType = 1
	// Logs of connection pooler activity.
	ListClusterLogsRequest_POOLER ListClusterLogsRequest_ServiceType = 2
)

var ListClusterLogsRequest_ServiceType_name = map[int32]string{
	0: "SERVICE_TYPE_UNSPECIFIED",
	1: "POSTGRESQL",
	2: "POOLER",
}
var ListClusterLogsRequest_ServiceType_value = map[string]int32{
	"SERVICE_TYPE_UNSPECIFIED": 0,
	"POSTGRESQL":               1,
	"POOLER":                   2,
}

func (x ListClusterLogsRequest_ServiceType) String() string {
	return proto.EnumName(ListClusterLogsRequest_ServiceType_name, int32(x))
}
func (ListClusterLogsRequest_ServiceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{20, 0}
}

type GetClusterRequest struct {
	// ID of the PostgreSQL Cluster resource to return.
	// To get the cluster ID use a [ClusterService.List] request.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetClusterRequest) Reset()         { *m = GetClusterRequest{} }
func (m *GetClusterRequest) String() string { return proto.CompactTextString(m) }
func (*GetClusterRequest) ProtoMessage()    {}
func (*GetClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{0}
}
func (m *GetClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetClusterRequest.Unmarshal(m, b)
}
func (m *GetClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetClusterRequest.Marshal(b, m, deterministic)
}
func (dst *GetClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetClusterRequest.Merge(dst, src)
}
func (m *GetClusterRequest) XXX_Size() int {
	return xxx_messageInfo_GetClusterRequest.Size(m)
}
func (m *GetClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetClusterRequest proto.InternalMessageInfo

func (m *GetClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type ListClustersRequest struct {
	// ID of the folder to list PostgreSQL clusters in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClustersResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the [ListClustersResponse.next_page_token]
	// returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can only use filtering with the [Cluster.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Мust be 1-63 characters long and match the regular expression `^[a-zA-Z0-9_-]+$`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersRequest) Reset()         { *m = ListClustersRequest{} }
func (m *ListClustersRequest) String() string { return proto.CompactTextString(m) }
func (*ListClustersRequest) ProtoMessage()    {}
func (*ListClustersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{1}
}
func (m *ListClustersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersRequest.Unmarshal(m, b)
}
func (m *ListClustersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersRequest.Marshal(b, m, deterministic)
}
func (dst *ListClustersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersRequest.Merge(dst, src)
}
func (m *ListClustersRequest) XXX_Size() int {
	return xxx_messageInfo_ListClustersRequest.Size(m)
}
func (m *ListClustersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersRequest proto.InternalMessageInfo

func (m *ListClustersRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListClustersRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClustersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListClustersRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListClustersResponse struct {
	// List of PostgreSQL Cluster resources.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClustersRequest.page_size], use the [next_page_token] as the value
	// for the [ListClustersRequest.page_token] parameter in the next list request. Each subsequent
	// list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersResponse) Reset()         { *m = ListClustersResponse{} }
func (m *ListClustersResponse) String() string { return proto.CompactTextString(m) }
func (*ListClustersResponse) ProtoMessage()    {}
func (*ListClustersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{2}
}
func (m *ListClustersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersResponse.Unmarshal(m, b)
}
func (m *ListClustersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersResponse.Marshal(b, m, deterministic)
}
func (dst *ListClustersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersResponse.Merge(dst, src)
}
func (m *ListClustersResponse) XXX_Size() int {
	return xxx_messageInfo_ListClustersResponse.Size(m)
}
func (m *ListClustersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersResponse proto.InternalMessageInfo

func (m *ListClustersResponse) GetClusters() []*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *ListClustersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateClusterRequest struct {
	// ID of the folder to create the PostgreSQL cluster in.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the PostgreSQL cluster. The name must be unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the PostgreSQL cluster.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the PostgreSQL cluster as `` key:value `` pairs. Maximum 64 per resource.
	// For example, "project": "mvp" or "source": "dictionary".
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the PostgreSQL cluster.
	Environment Cluster_Environment `protobuf:"varint,5,opt,name=environment,proto3,enum=yandex.cloud.mdb.postgresql.v1.Cluster_Environment" json:"environment,omitempty"`
	// Configuration and resources for hosts that should be created for the PostgreSQL cluster.
	ConfigSpec *ConfigSpec `protobuf:"bytes,6,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	// Descriptions of databases to be created in the PostgreSQL cluster.
	DatabaseSpecs []*DatabaseSpec `protobuf:"bytes,7,rep,name=database_specs,json=databaseSpecs,proto3" json:"database_specs,omitempty"`
	// Descriptions of database users to be created in the PostgreSQL cluster.
	UserSpecs []*UserSpec `protobuf:"bytes,8,rep,name=user_specs,json=userSpecs,proto3" json:"user_specs,omitempty"`
	// Individual configurations for hosts that should be created for the PostgreSQL cluster.
	HostSpecs []*HostSpec `protobuf:"bytes,9,rep,name=host_specs,json=hostSpecs,proto3" json:"host_specs,omitempty"`
	// ID of the network to create the cluster in.
	NetworkId            string   `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateClusterRequest) Reset()         { *m = CreateClusterRequest{} }
func (m *CreateClusterRequest) String() string { return proto.CompactTextString(m) }
func (*CreateClusterRequest) ProtoMessage()    {}
func (*CreateClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{3}
}
func (m *CreateClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClusterRequest.Unmarshal(m, b)
}
func (m *CreateClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClusterRequest.Marshal(b, m, deterministic)
}
func (dst *CreateClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClusterRequest.Merge(dst, src)
}
func (m *CreateClusterRequest) XXX_Size() int {
	return xxx_messageInfo_CreateClusterRequest.Size(m)
}
func (m *CreateClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClusterRequest proto.InternalMessageInfo

func (m *CreateClusterRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateClusterRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateClusterRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CreateClusterRequest) GetEnvironment() Cluster_Environment {
	if m != nil {
		return m.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (m *CreateClusterRequest) GetConfigSpec() *ConfigSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

func (m *CreateClusterRequest) GetDatabaseSpecs() []*DatabaseSpec {
	if m != nil {
		return m.DatabaseSpecs
	}
	return nil
}

func (m *CreateClusterRequest) GetUserSpecs() []*UserSpec {
	if m != nil {
		return m.UserSpecs
	}
	return nil
}

func (m *CreateClusterRequest) GetHostSpecs() []*HostSpec {
	if m != nil {
		return m.HostSpecs
	}
	return nil
}

func (m *CreateClusterRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

type CreateClusterMetadata struct {
	// ID of the PostgreSQL cluster that is being created.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateClusterMetadata) Reset()         { *m = CreateClusterMetadata{} }
func (m *CreateClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateClusterMetadata) ProtoMessage()    {}
func (*CreateClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{4}
}
func (m *CreateClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClusterMetadata.Unmarshal(m, b)
}
func (m *CreateClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClusterMetadata.Marshal(b, m, deterministic)
}
func (dst *CreateClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClusterMetadata.Merge(dst, src)
}
func (m *CreateClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateClusterMetadata.Size(m)
}
func (m *CreateClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClusterMetadata proto.InternalMessageInfo

func (m *CreateClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type UpdateClusterRequest struct {
	// ID of the PostgreSQL Cluster resource to update.
	// To get the PostgreSQL cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Field mask that specifies which fields of the PostgreSQL Cluster resource should be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// New description of the PostgreSQL cluster.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the PostgreSQL cluster as `` key:value `` pairs. Maximum 64 per resource.
	// For example, "project": "mvp" or "source": "dictionary".
	//
	// The new set of labels will completely replace the old ones. To add a label, request the current
	// set with the [ClusterService.Get] method, then send an [ClusterService.Update] request with the new label added to the set.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// New configuration and resources for hosts in the cluster.
	ConfigSpec           *ConfigSpec `protobuf:"bytes,5,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	Name                 string      `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *UpdateClusterRequest) Reset()         { *m = UpdateClusterRequest{} }
func (m *UpdateClusterRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterRequest) ProtoMessage()    {}
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{5}
}
func (m *UpdateClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterRequest.Unmarshal(m, b)
}
func (m *UpdateClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterRequest.Merge(dst, src)
}
func (m *UpdateClusterRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterRequest.Size(m)
}
func (m *UpdateClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterRequest proto.InternalMessageInfo

func (m *UpdateClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateClusterRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateClusterRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateClusterRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *UpdateClusterRequest) GetConfigSpec() *ConfigSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

func (m *UpdateClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type UpdateClusterMetadata struct {
	// ID of the PostgreSQL Cluster resource that is being updated.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateClusterMetadata) Reset()         { *m = UpdateClusterMetadata{} }
func (m *UpdateClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterMetadata) ProtoMessage()    {}
func (*UpdateClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{6}
}
func (m *UpdateClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterMetadata.Unmarshal(m, b)
}
func (m *UpdateClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterMetadata.Marshal(b, m, deterministic)
}
func (dst *UpdateClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterMetadata.Merge(dst, src)
}
func (m *UpdateClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterMetadata.Size(m)
}
func (m *UpdateClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterMetadata proto.InternalMessageInfo

func (m *UpdateClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type DeleteClusterRequest struct {
	// ID of the PostgreSQL cluster to delete.
	// To get the PostgreSQL cluster ID, use a [ClusterService.List] request.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterRequest) Reset()         { *m = DeleteClusterRequest{} }
func (m *DeleteClusterRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterRequest) ProtoMessage()    {}
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{7}
}
func (m *DeleteClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterRequest.Unmarshal(m, b)
}
func (m *DeleteClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterRequest.Merge(dst, src)
}
func (m *DeleteClusterRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterRequest.Size(m)
}
func (m *DeleteClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterRequest proto.InternalMessageInfo

func (m *DeleteClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type DeleteClusterMetadata struct {
	// ID of the PostgreSQL cluster that is being deleted.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterMetadata) Reset()         { *m = DeleteClusterMetadata{} }
func (m *DeleteClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterMetadata) ProtoMessage()    {}
func (*DeleteClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{8}
}
func (m *DeleteClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterMetadata.Unmarshal(m, b)
}
func (m *DeleteClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterMetadata.Marshal(b, m, deterministic)
}
func (dst *DeleteClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterMetadata.Merge(dst, src)
}
func (m *DeleteClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterMetadata.Size(m)
}
func (m *DeleteClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterMetadata proto.InternalMessageInfo

func (m *DeleteClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StartClusterRequest struct {
	// Required. ID of the PostgreSQL cluster to start.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartClusterRequest) Reset()         { *m = StartClusterRequest{} }
func (m *StartClusterRequest) String() string { return proto.CompactTextString(m) }
func (*StartClusterRequest) ProtoMessage()    {}
func (*StartClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{9}
}
func (m *StartClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartClusterRequest.Unmarshal(m, b)
}
func (m *StartClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartClusterRequest.Marshal(b, m, deterministic)
}
func (dst *StartClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartClusterRequest.Merge(dst, src)
}
func (m *StartClusterRequest) XXX_Size() int {
	return xxx_messageInfo_StartClusterRequest.Size(m)
}
func (m *StartClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartClusterRequest proto.InternalMessageInfo

func (m *StartClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StartClusterMetadata struct {
	// Required. ID of the PostgreSQL cluster.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartClusterMetadata) Reset()         { *m = StartClusterMetadata{} }
func (m *StartClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*StartClusterMetadata) ProtoMessage()    {}
func (*StartClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{10}
}
func (m *StartClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartClusterMetadata.Unmarshal(m, b)
}
func (m *StartClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartClusterMetadata.Marshal(b, m, deterministic)
}
func (dst *StartClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartClusterMetadata.Merge(dst, src)
}
func (m *StartClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_StartClusterMetadata.Size(m)
}
func (m *StartClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StartClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StartClusterMetadata proto.InternalMessageInfo

func (m *StartClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StopClusterRequest struct {
	// Required. ID of the PostgreSQL cluster to stop.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopClusterRequest) Reset()         { *m = StopClusterRequest{} }
func (m *StopClusterRequest) String() string { return proto.CompactTextString(m) }
func (*StopClusterRequest) ProtoMessage()    {}
func (*StopClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{11}
}
func (m *StopClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopClusterRequest.Unmarshal(m, b)
}
func (m *StopClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopClusterRequest.Marshal(b, m, deterministic)
}
func (dst *StopClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopClusterRequest.Merge(dst, src)
}
func (m *StopClusterRequest) XXX_Size() int {
	return xxx_messageInfo_StopClusterRequest.Size(m)
}
func (m *StopClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StopClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StopClusterRequest proto.InternalMessageInfo

func (m *StopClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StopClusterMetadata struct {
	// Required. ID of the PostgreSQL cluster.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopClusterMetadata) Reset()         { *m = StopClusterMetadata{} }
func (m *StopClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*StopClusterMetadata) ProtoMessage()    {}
func (*StopClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{12}
}
func (m *StopClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopClusterMetadata.Unmarshal(m, b)
}
func (m *StopClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopClusterMetadata.Marshal(b, m, deterministic)
}
func (dst *StopClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopClusterMetadata.Merge(dst, src)
}
func (m *StopClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_StopClusterMetadata.Size(m)
}
func (m *StopClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StopClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StopClusterMetadata proto.InternalMessageInfo

func (m *StopClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type MoveClusterRequest struct {
	// ID of the PostgreSQL cluster to move.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the destination folder.
	DestinationFolderId  string   `protobuf:"bytes,2,opt,name=destination_folder_id,json=destinationFolderId,proto3" json:"destination_folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MoveClusterRequest) Reset()         { *m = MoveClusterRequest{} }
func (m *MoveClusterRequest) String() string { return proto.CompactTextString(m) }
func (*MoveClusterRequest) ProtoMessage()    {}
func (*MoveClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{13}
}
func (m *MoveClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MoveClusterRequest.Unmarshal(m, b)
}
func (m *MoveClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MoveClusterRequest.Marshal(b, m, deterministic)
}
func (dst *MoveClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MoveClusterRequest.Merge(dst, src)
}
func (m *MoveClusterRequest) XXX_Size() int {
	return xxx_messageInfo_MoveClusterRequest.Size(m)
}
func (m *MoveClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MoveClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MoveClusterRequest proto.InternalMessageInfo

func (m *MoveClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *MoveClusterRequest) GetDestinationFolderId() string {
	if m != nil {
		return m.DestinationFolderId
	}
	return ""
}

type MoveClusterMetadata struct {
	// ID of the PostgreSQL cluster being moved.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the source folder.
	SourceFolderId string `protobuf:"bytes,2,opt,name=source_folder_id,json=sourceFolderId,proto3" json:"source_folder_id,omitempty"`
	// ID of the destnation folder.
	DestinationFolderId  string   `protobuf:"bytes,3,opt,name=destination_folder_id,json=destinationFolderId,proto3" json:"destination_folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MoveClusterMetadata) Reset()         { *m = MoveClusterMetadata{} }
func (m *MoveClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*MoveClusterMetadata) ProtoMessage()    {}
func (*MoveClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{14}
}
func (m *MoveClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MoveClusterMetadata.Unmarshal(m, b)
}
func (m *MoveClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MoveClusterMetadata.Marshal(b, m, deterministic)
}
func (dst *MoveClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MoveClusterMetadata.Merge(dst, src)
}
func (m *MoveClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_MoveClusterMetadata.Size(m)
}
func (m *MoveClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_MoveClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_MoveClusterMetadata proto.InternalMessageInfo

func (m *MoveClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *MoveClusterMetadata) GetSourceFolderId() string {
	if m != nil {
		return m.SourceFolderId
	}
	return ""
}

func (m *MoveClusterMetadata) GetDestinationFolderId() string {
	if m != nil {
		return m.DestinationFolderId
	}
	return ""
}

type BackupClusterRequest struct {
	// ID of the PostgreSQL cluster to back up.
	// To get the PostgreSQL cluster ID, use a [ClusterService.List] request.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BackupClusterRequest) Reset()         { *m = BackupClusterRequest{} }
func (m *BackupClusterRequest) String() string { return proto.CompactTextString(m) }
func (*BackupClusterRequest) ProtoMessage()    {}
func (*BackupClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{15}
}
func (m *BackupClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BackupClusterRequest.Unmarshal(m, b)
}
func (m *BackupClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BackupClusterRequest.Marshal(b, m, deterministic)
}
func (dst *BackupClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupClusterRequest.Merge(dst, src)
}
func (m *BackupClusterRequest) XXX_Size() int {
	return xxx_messageInfo_BackupClusterRequest.Size(m)
}
func (m *BackupClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BackupClusterRequest proto.InternalMessageInfo

func (m *BackupClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type BackupClusterMetadata struct {
	// ID of the PostgreSQL cluster that is being backed up.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BackupClusterMetadata) Reset()         { *m = BackupClusterMetadata{} }
func (m *BackupClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*BackupClusterMetadata) ProtoMessage()    {}
func (*BackupClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{16}
}
func (m *BackupClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BackupClusterMetadata.Unmarshal(m, b)
}
func (m *BackupClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BackupClusterMetadata.Marshal(b, m, deterministic)
}
func (dst *BackupClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupClusterMetadata.Merge(dst, src)
}
func (m *BackupClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_BackupClusterMetadata.Size(m)
}
func (m *BackupClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_BackupClusterMetadata proto.InternalMessageInfo

func (m *BackupClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type RestoreClusterRequest struct {
	// ID of the backup to create a cluster from.
	// To get the backup ID, use a [ClusterService.ListBackups] request.
	BackupId string `protobuf:"bytes,1,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	// Timestamp of the moment to which the PostgreSQL cluster should be restored.
	Time *timestamp.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Flag that indicates whether a database should be restored to the first backup point
	// available just after the timestamp specified in the [time] field instead of just before.
	//
	// Possible values:
	// * false (default) — the restore point refers to the first backup moment before [time].
	// * true — the restore point refers to the first backup point after [time].
	TimeInclusive bool `protobuf:"varint,3,opt,name=time_inclusive,json=timeInclusive,proto3" json:"time_inclusive,omitempty"`
	// Name of the new PostgreSQL cluster. The name must be unique within the folder.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the new PostgreSQL cluster.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the PostgreSQL cluster as `` key:value `` pairs. Maximum 64 per resource.
	// For example, "project": "mvp" or "source": "dictionary".
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the new PostgreSQL cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.postgresql.v1.Cluster_Environment" json:"environment,omitempty"`
	// Configuration for the PostgreSQL cluster to be created.
	ConfigSpec *ConfigSpec `protobuf:"bytes,8,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	// Configurations for PostgreSQL hosts that should be created for
	// the cluster that is being created from the backup.
	HostSpecs []*HostSpec `protobuf:"bytes,9,rep,name=host_specs,json=hostSpecs,proto3" json:"host_specs,omitempty"`
	// ID of the network to create the PostgreSQL cluster in.
	NetworkId            string   `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RestoreClusterRequest) Reset()         { *m = RestoreClusterRequest{} }
func (m *RestoreClusterRequest) String() string { return proto.CompactTextString(m) }
func (*RestoreClusterRequest) ProtoMessage()    {}
func (*RestoreClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{17}
}
func (m *RestoreClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestoreClusterRequest.Unmarshal(m, b)
}
func (m *RestoreClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestoreClusterRequest.Marshal(b, m, deterministic)
}
func (dst *RestoreClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestoreClusterRequest.Merge(dst, src)
}
func (m *RestoreClusterRequest) XXX_Size() int {
	return xxx_messageInfo_RestoreClusterRequest.Size(m)
}
func (m *RestoreClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RestoreClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RestoreClusterRequest proto.InternalMessageInfo

func (m *RestoreClusterRequest) GetBackupId() string {
	if m != nil {
		return m.BackupId
	}
	return ""
}

func (m *RestoreClusterRequest) GetTime() *timestamp.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

func (m *RestoreClusterRequest) GetTimeInclusive() bool {
	if m != nil {
		return m.TimeInclusive
	}
	return false
}

func (m *RestoreClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RestoreClusterRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *RestoreClusterRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *RestoreClusterRequest) GetEnvironment() Cluster_Environment {
	if m != nil {
		return m.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (m *RestoreClusterRequest) GetConfigSpec() *ConfigSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

func (m *RestoreClusterRequest) GetHostSpecs() []*HostSpec {
	if m != nil {
		return m.HostSpecs
	}
	return nil
}

func (m *RestoreClusterRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

type RestoreClusterMetadata struct {
	// ID of the new PostgreSQL cluster that is being created from a backup.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the backup that is being used for creating a cluster.
	BackupId             string   `protobuf:"bytes,2,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RestoreClusterMetadata) Reset()         { *m = RestoreClusterMetadata{} }
func (m *RestoreClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*RestoreClusterMetadata) ProtoMessage()    {}
func (*RestoreClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{18}
}
func (m *RestoreClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestoreClusterMetadata.Unmarshal(m, b)
}
func (m *RestoreClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestoreClusterMetadata.Marshal(b, m, deterministic)
}
func (dst *RestoreClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestoreClusterMetadata.Merge(dst, src)
}
func (m *RestoreClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_RestoreClusterMetadata.Size(m)
}
func (m *RestoreClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_RestoreClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_RestoreClusterMetadata proto.InternalMessageInfo

func (m *RestoreClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *RestoreClusterMetadata) GetBackupId() string {
	if m != nil {
		return m.BackupId
	}
	return ""
}

type LogRecord struct {
	// Log record timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	Timestamp *timestamp.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Contents of the log record.
	Message              map[string]string `protobuf:"bytes,2,rep,name=message,proto3" json:"message,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *LogRecord) Reset()         { *m = LogRecord{} }
func (m *LogRecord) String() string { return proto.CompactTextString(m) }
func (*LogRecord) ProtoMessage()    {}
func (*LogRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{19}
}
func (m *LogRecord) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogRecord.Unmarshal(m, b)
}
func (m *LogRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogRecord.Marshal(b, m, deterministic)
}
func (dst *LogRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogRecord.Merge(dst, src)
}
func (m *LogRecord) XXX_Size() int {
	return xxx_messageInfo_LogRecord.Size(m)
}
func (m *LogRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_LogRecord.DiscardUnknown(m)
}

var xxx_messageInfo_LogRecord proto.InternalMessageInfo

func (m *LogRecord) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *LogRecord) GetMessage() map[string]string {
	if m != nil {
		return m.Message
	}
	return nil
}

type ListClusterLogsRequest struct {
	// ID of the PostgreSQL cluster to request logs for.
	// To get the PostgreSQL cluster ID use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Columns from the logs table to request.
	// If no columns are specified, entire log records are returned.
	ColumnFilter []string `protobuf:"bytes,2,rep,name=column_filter,json=columnFilter,proto3" json:"column_filter,omitempty"`
	// Type of the service to request logs about.
	ServiceType ListClusterLogsRequest_ServiceType `protobuf:"varint,3,opt,name=service_type,json=serviceType,proto3,enum=yandex.cloud.mdb.postgresql.v1.ListClusterLogsRequest_ServiceType" json:"service_type,omitempty"`
	// Start timestamp for the logs request, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	FromTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=from_time,json=fromTime,proto3" json:"from_time,omitempty"`
	// End timestamp for the logs request, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	ToTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=to_time,json=toTime,proto3" json:"to_time,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClusterLogsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,6,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListClusterLogsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Always return `next_page_token`, even if current page is empty.
	AlwaysNextPageToken  bool     `protobuf:"varint,8,opt,name=always_next_page_token,json=alwaysNextPageToken,proto3" json:"always_next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterLogsRequest) Reset()         { *m = ListClusterLogsRequest{} }
func (m *ListClusterLogsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterLogsRequest) ProtoMessage()    {}
func (*ListClusterLogsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{20}
}
func (m *ListClusterLogsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterLogsRequest.Unmarshal(m, b)
}
func (m *ListClusterLogsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterLogsRequest.Marshal(b, m, deterministic)
}
func (dst *ListClusterLogsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterLogsRequest.Merge(dst, src)
}
func (m *ListClusterLogsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterLogsRequest.Size(m)
}
func (m *ListClusterLogsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterLogsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterLogsRequest proto.InternalMessageInfo

func (m *ListClusterLogsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterLogsRequest) GetColumnFilter() []string {
	if m != nil {
		return m.ColumnFilter
	}
	return nil
}

func (m *ListClusterLogsRequest) GetServiceType() ListClusterLogsRequest_ServiceType {
	if m != nil {
		return m.ServiceType
	}
	return ListClusterLogsRequest_SERVICE_TYPE_UNSPECIFIED
}

func (m *ListClusterLogsRequest) GetFromTime() *timestamp.Timestamp {
	if m != nil {
		return m.FromTime
	}
	return nil
}

func (m *ListClusterLogsRequest) GetToTime() *timestamp.Timestamp {
	if m != nil {
		return m.ToTime
	}
	return nil
}

func (m *ListClusterLogsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterLogsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListClusterLogsRequest) GetAlwaysNextPageToken() bool {
	if m != nil {
		return m.AlwaysNextPageToken
	}
	return false
}

type ListClusterLogsResponse struct {
	// Requested log records.
	Logs []*LogRecord `protobuf:"bytes,1,rep,name=logs,proto3" json:"logs,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterLogsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterLogsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterLogsResponse) Reset()         { *m = ListClusterLogsResponse{} }
func (m *ListClusterLogsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterLogsResponse) ProtoMessage()    {}
func (*ListClusterLogsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{21}
}
func (m *ListClusterLogsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterLogsResponse.Unmarshal(m, b)
}
func (m *ListClusterLogsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterLogsResponse.Marshal(b, m, deterministic)
}
func (dst *ListClusterLogsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterLogsResponse.Merge(dst, src)
}
func (m *ListClusterLogsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterLogsResponse.Size(m)
}
func (m *ListClusterLogsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterLogsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterLogsResponse proto.InternalMessageInfo

func (m *ListClusterLogsResponse) GetLogs() []*LogRecord {
	if m != nil {
		return m.Logs
	}
	return nil
}

func (m *ListClusterLogsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListClusterOperationsRequest struct {
	// ID of the PostgreSQL Cluster resource to list operations for.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClusterOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.  To get the next page of results, set [page_token] to the [ListClusterOperationsResponse.next_page_token]
	// returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterOperationsRequest) Reset()         { *m = ListClusterOperationsRequest{} }
func (m *ListClusterOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterOperationsRequest) ProtoMessage()    {}
func (*ListClusterOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{22}
}
func (m *ListClusterOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterOperationsRequest.Unmarshal(m, b)
}
func (m *ListClusterOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterOperationsRequest.Marshal(b, m, deterministic)
}
func (dst *ListClusterOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterOperationsRequest.Merge(dst, src)
}
func (m *ListClusterOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterOperationsRequest.Size(m)
}
func (m *ListClusterOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterOperationsRequest proto.InternalMessageInfo

func (m *ListClusterOperationsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterOperationsResponse struct {
	// List of Operation resources for the specified PostgreSQL cluster.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterOperationsResponse) Reset()         { *m = ListClusterOperationsResponse{} }
func (m *ListClusterOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterOperationsResponse) ProtoMessage()    {}
func (*ListClusterOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{23}
}
func (m *ListClusterOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterOperationsResponse.Unmarshal(m, b)
}
func (m *ListClusterOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterOperationsResponse.Marshal(b, m, deterministic)
}
func (dst *ListClusterOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterOperationsResponse.Merge(dst, src)
}
func (m *ListClusterOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterOperationsResponse.Size(m)
}
func (m *ListClusterOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterOperationsResponse proto.InternalMessageInfo

func (m *ListClusterOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListClusterOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListClusterBackupsRequest struct {
	// ID of the PostgreSQL cluster.
	// To get the PostgreSQL cluster ID use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClusterBackupsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.  To get the next page of results, set [page_token] to the [ListClusterBackupsResponse.next_page_token]
	// returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterBackupsRequest) Reset()         { *m = ListClusterBackupsRequest{} }
func (m *ListClusterBackupsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterBackupsRequest) ProtoMessage()    {}
func (*ListClusterBackupsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{24}
}
func (m *ListClusterBackupsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterBackupsRequest.Unmarshal(m, b)
}
func (m *ListClusterBackupsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterBackupsRequest.Marshal(b, m, deterministic)
}
func (dst *ListClusterBackupsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterBackupsRequest.Merge(dst, src)
}
func (m *ListClusterBackupsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterBackupsRequest.Size(m)
}
func (m *ListClusterBackupsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterBackupsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterBackupsRequest proto.InternalMessageInfo

func (m *ListClusterBackupsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterBackupsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterBackupsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterBackupsResponse struct {
	// List of PostgreSQL Backup resources.
	Backups []*Backup `protobuf:"bytes,1,rep,name=backups,proto3" json:"backups,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterBackupsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterBackupsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterBackupsResponse) Reset()         { *m = ListClusterBackupsResponse{} }
func (m *ListClusterBackupsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterBackupsResponse) ProtoMessage()    {}
func (*ListClusterBackupsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{25}
}
func (m *ListClusterBackupsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterBackupsResponse.Unmarshal(m, b)
}
func (m *ListClusterBackupsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterBackupsResponse.Marshal(b, m, deterministic)
}
func (dst *ListClusterBackupsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterBackupsResponse.Merge(dst, src)
}
func (m *ListClusterBackupsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterBackupsResponse.Size(m)
}
func (m *ListClusterBackupsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterBackupsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterBackupsResponse proto.InternalMessageInfo

func (m *ListClusterBackupsResponse) GetBackups() []*Backup {
	if m != nil {
		return m.Backups
	}
	return nil
}

func (m *ListClusterBackupsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListClusterHostsRequest struct {
	// ID of the PostgreSQL cluster.
	// To get the PostgreSQL cluster ID use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClusterHostsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.  To get the next page of results, set [page_token] to the [ListClusterHostsResponse.next_page_token]
	// returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterHostsRequest) Reset()         { *m = ListClusterHostsRequest{} }
func (m *ListClusterHostsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterHostsRequest) ProtoMessage()    {}
func (*ListClusterHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{26}
}
func (m *ListClusterHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterHostsRequest.Unmarshal(m, b)
}
func (m *ListClusterHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterHostsRequest.Marshal(b, m, deterministic)
}
func (dst *ListClusterHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterHostsRequest.Merge(dst, src)
}
func (m *ListClusterHostsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterHostsRequest.Size(m)
}
func (m *ListClusterHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterHostsRequest proto.InternalMessageInfo

func (m *ListClusterHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterHostsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterHostsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterHostsResponse struct {
	// List of Host resources.
	Hosts []*Host `protobuf:"bytes,1,rep,name=hosts,proto3" json:"hosts,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterHostsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterHostsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterHostsResponse) Reset()         { *m = ListClusterHostsResponse{} }
func (m *ListClusterHostsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterHostsResponse) ProtoMessage()    {}
func (*ListClusterHostsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{27}
}
func (m *ListClusterHostsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterHostsResponse.Unmarshal(m, b)
}
func (m *ListClusterHostsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterHostsResponse.Marshal(b, m, deterministic)
}
func (dst *ListClusterHostsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterHostsResponse.Merge(dst, src)
}
func (m *ListClusterHostsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterHostsResponse.Size(m)
}
func (m *ListClusterHostsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterHostsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterHostsResponse proto.InternalMessageInfo

func (m *ListClusterHostsResponse) GetHosts() []*Host {
	if m != nil {
		return m.Hosts
	}
	return nil
}

func (m *ListClusterHostsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type AddClusterHostsRequest struct {
	// ID of the PostgreSQL cluster to add hosts to.
	// To get the PostgreSQL cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Configurations for PostgreSQL hosts that should be added to the cluster.
	HostSpecs            []*HostSpec `protobuf:"bytes,2,rep,name=host_specs,json=hostSpecs,proto3" json:"host_specs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *AddClusterHostsRequest) Reset()         { *m = AddClusterHostsRequest{} }
func (m *AddClusterHostsRequest) String() string { return proto.CompactTextString(m) }
func (*AddClusterHostsRequest) ProtoMessage()    {}
func (*AddClusterHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{28}
}
func (m *AddClusterHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddClusterHostsRequest.Unmarshal(m, b)
}
func (m *AddClusterHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddClusterHostsRequest.Marshal(b, m, deterministic)
}
func (dst *AddClusterHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddClusterHostsRequest.Merge(dst, src)
}
func (m *AddClusterHostsRequest) XXX_Size() int {
	return xxx_messageInfo_AddClusterHostsRequest.Size(m)
}
func (m *AddClusterHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddClusterHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddClusterHostsRequest proto.InternalMessageInfo

func (m *AddClusterHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *AddClusterHostsRequest) GetHostSpecs() []*HostSpec {
	if m != nil {
		return m.HostSpecs
	}
	return nil
}

type AddClusterHostsMetadata struct {
	// ID of the PostgreSQL cluster to which the hosts are being added.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Names of hosts that are being added to the cluster.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddClusterHostsMetadata) Reset()         { *m = AddClusterHostsMetadata{} }
func (m *AddClusterHostsMetadata) String() string { return proto.CompactTextString(m) }
func (*AddClusterHostsMetadata) ProtoMessage()    {}
func (*AddClusterHostsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{29}
}
func (m *AddClusterHostsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddClusterHostsMetadata.Unmarshal(m, b)
}
func (m *AddClusterHostsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddClusterHostsMetadata.Marshal(b, m, deterministic)
}
func (dst *AddClusterHostsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddClusterHostsMetadata.Merge(dst, src)
}
func (m *AddClusterHostsMetadata) XXX_Size() int {
	return xxx_messageInfo_AddClusterHostsMetadata.Size(m)
}
func (m *AddClusterHostsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_AddClusterHostsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_AddClusterHostsMetadata proto.InternalMessageInfo

func (m *AddClusterHostsMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *AddClusterHostsMetadata) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type DeleteClusterHostsRequest struct {
	// ID of the PostgreSQL cluster to remove hosts from.
	// To get the PostgreSQL cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Names of hosts to delete.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterHostsRequest) Reset()         { *m = DeleteClusterHostsRequest{} }
func (m *DeleteClusterHostsRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterHostsRequest) ProtoMessage()    {}
func (*DeleteClusterHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{30}
}
func (m *DeleteClusterHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterHostsRequest.Unmarshal(m, b)
}
func (m *DeleteClusterHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterHostsRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteClusterHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterHostsRequest.Merge(dst, src)
}
func (m *DeleteClusterHostsRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterHostsRequest.Size(m)
}
func (m *DeleteClusterHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterHostsRequest proto.InternalMessageInfo

func (m *DeleteClusterHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteClusterHostsRequest) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type DeleteClusterHostsMetadata struct {
	// ID of the PostgreSQL cluster to remove hosts from.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Names of hosts that are being deleted.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterHostsMetadata) Reset()         { *m = DeleteClusterHostsMetadata{} }
func (m *DeleteClusterHostsMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterHostsMetadata) ProtoMessage()    {}
func (*DeleteClusterHostsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{31}
}
func (m *DeleteClusterHostsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterHostsMetadata.Unmarshal(m, b)
}
func (m *DeleteClusterHostsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterHostsMetadata.Marshal(b, m, deterministic)
}
func (dst *DeleteClusterHostsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterHostsMetadata.Merge(dst, src)
}
func (m *DeleteClusterHostsMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterHostsMetadata.Size(m)
}
func (m *DeleteClusterHostsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterHostsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterHostsMetadata proto.InternalMessageInfo

func (m *DeleteClusterHostsMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteClusterHostsMetadata) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type UpdateClusterHostsRequest struct {
	// ID of the PostgreSQL cluster to update hosts in.
	// To get the PostgreSQL cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// New configurations to apply to hosts.
	UpdateHostSpecs      []*UpdateHostSpec `protobuf:"bytes,2,rep,name=update_host_specs,json=updateHostSpecs,proto3" json:"update_host_specs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateClusterHostsRequest) Reset()         { *m = UpdateClusterHostsRequest{} }
func (m *UpdateClusterHostsRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterHostsRequest) ProtoMessage()    {}
func (*UpdateClusterHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{32}
}
func (m *UpdateClusterHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterHostsRequest.Unmarshal(m, b)
}
func (m *UpdateClusterHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterHostsRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateClusterHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterHostsRequest.Merge(dst, src)
}
func (m *UpdateClusterHostsRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterHostsRequest.Size(m)
}
func (m *UpdateClusterHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterHostsRequest proto.InternalMessageInfo

func (m *UpdateClusterHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateClusterHostsRequest) GetUpdateHostSpecs() []*UpdateHostSpec {
	if m != nil {
		return m.UpdateHostSpecs
	}
	return nil
}

type UpdateClusterHostsMetadata struct {
	// ID of the PostgreSQL cluster to update hosts in.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Names of hosts that are being updated.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateClusterHostsMetadata) Reset()         { *m = UpdateClusterHostsMetadata{} }
func (m *UpdateClusterHostsMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterHostsMetadata) ProtoMessage()    {}
func (*UpdateClusterHostsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{33}
}
func (m *UpdateClusterHostsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterHostsMetadata.Unmarshal(m, b)
}
func (m *UpdateClusterHostsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterHostsMetadata.Marshal(b, m, deterministic)
}
func (dst *UpdateClusterHostsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterHostsMetadata.Merge(dst, src)
}
func (m *UpdateClusterHostsMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterHostsMetadata.Size(m)
}
func (m *UpdateClusterHostsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterHostsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterHostsMetadata proto.InternalMessageInfo

func (m *UpdateClusterHostsMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateClusterHostsMetadata) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type UpdateHostSpec struct {
	// Name of the host to update.
	// To get the PostgreSQL host name, use a [ClusterService.ListHosts] request.
	HostName string `protobuf:"bytes,1,opt,name=host_name,json=hostName,proto3" json:"host_name,omitempty"`
	// [Host.name] of the host to be used as the replication source (for cascading replication).
	// To get the PostgreSQL host name, use a [ClusterService.ListHosts] request.
	ReplicationSource string `protobuf:"bytes,2,opt,name=replication_source,json=replicationSource,proto3" json:"replication_source,omitempty"`
	// The host with the highest priority is the synchronous replica. All others are asynchronous.
	// The synchronous replica replaces the master when needed.
	//
	// When a replica becomes the master, its priority is ignored.
	Priority *wrappers.Int64Value `protobuf:"bytes,3,opt,name=priority,proto3" json:"priority,omitempty"`
	// Configuration of a PostgreSQL server for the host.
	ConfigSpec           *ConfigHostSpec `protobuf:"bytes,4,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *UpdateHostSpec) Reset()         { *m = UpdateHostSpec{} }
func (m *UpdateHostSpec) String() string { return proto.CompactTextString(m) }
func (*UpdateHostSpec) ProtoMessage()    {}
func (*UpdateHostSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{34}
}
func (m *UpdateHostSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateHostSpec.Unmarshal(m, b)
}
func (m *UpdateHostSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateHostSpec.Marshal(b, m, deterministic)
}
func (dst *UpdateHostSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateHostSpec.Merge(dst, src)
}
func (m *UpdateHostSpec) XXX_Size() int {
	return xxx_messageInfo_UpdateHostSpec.Size(m)
}
func (m *UpdateHostSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateHostSpec.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateHostSpec proto.InternalMessageInfo

func (m *UpdateHostSpec) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

func (m *UpdateHostSpec) GetReplicationSource() string {
	if m != nil {
		return m.ReplicationSource
	}
	return ""
}

func (m *UpdateHostSpec) GetPriority() *wrappers.Int64Value {
	if m != nil {
		return m.Priority
	}
	return nil
}

func (m *UpdateHostSpec) GetConfigSpec() *ConfigHostSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

type HostSpec struct {
	// ID of the availability zone where the host resides.
	// To get a list of available zones, use the [yandex.cloud.compute.v1.ZoneService.List] request.
	ZoneId string `protobuf:"bytes,1,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// ID of the subnet that the host should belong to. This subnet should be a part
	// of the network that the cluster belongs to.
	// The ID of the network is set in the field [Cluster.network_id].
	SubnetId string `protobuf:"bytes,2,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Whether the host should get a public IP address on creation.
	//
	// After a host has been created, this setting cannot be changed. To remove an assigned public IP, or to assign
	// a public IP to a host without one, recreate the host with [assign_public_ip] set as needed.
	//
	// Possible values:
	// * false — don't assign a public IP to the host.
	// * true — the host should have a public IP address.
	AssignPublicIp bool `protobuf:"varint,3,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	// [Host.name] of the host to be used as the replication source (for cascading replication).
	ReplicationSource string `protobuf:"bytes,4,opt,name=replication_source,json=replicationSource,proto3" json:"replication_source,omitempty"`
	// Priority of the host as a replica. A higher value corresponds to higher priority.
	//
	// The host with the highest priority is the synchronous replica. All others are asynchronous.
	// The synchronous replica replaces the master when needed.
	//
	// When a replica becomes the master, its priority is ignored.
	Priority *wrappers.Int64Value `protobuf:"bytes,5,opt,name=priority,proto3" json:"priority,omitempty"`
	// Configuration of a PostgreSQL server for the host.
	ConfigSpec           *ConfigHostSpec `protobuf:"bytes,6,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *HostSpec) Reset()         { *m = HostSpec{} }
func (m *HostSpec) String() string { return proto.CompactTextString(m) }
func (*HostSpec) ProtoMessage()    {}
func (*HostSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{35}
}
func (m *HostSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HostSpec.Unmarshal(m, b)
}
func (m *HostSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HostSpec.Marshal(b, m, deterministic)
}
func (dst *HostSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HostSpec.Merge(dst, src)
}
func (m *HostSpec) XXX_Size() int {
	return xxx_messageInfo_HostSpec.Size(m)
}
func (m *HostSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_HostSpec.DiscardUnknown(m)
}

var xxx_messageInfo_HostSpec proto.InternalMessageInfo

func (m *HostSpec) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *HostSpec) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *HostSpec) GetAssignPublicIp() bool {
	if m != nil {
		return m.AssignPublicIp
	}
	return false
}

func (m *HostSpec) GetReplicationSource() string {
	if m != nil {
		return m.ReplicationSource
	}
	return ""
}

func (m *HostSpec) GetPriority() *wrappers.Int64Value {
	if m != nil {
		return m.Priority
	}
	return nil
}

func (m *HostSpec) GetConfigSpec() *ConfigHostSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

type ConfigSpec struct {
	// Version of PostgreSQL used in the cluster.
	// Possible values:
	// * 9.6
	// * 10
	// * 11
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Configuration of a PostgreSQL cluster.
	//
	// Types that are valid to be assigned to PostgresqlConfig:
	//	*ConfigSpec_PostgresqlConfig_9_6
	//	*ConfigSpec_PostgresqlConfig_10
	//	*ConfigSpec_PostgresqlConfig_11
	PostgresqlConfig isConfigSpec_PostgresqlConfig `protobuf_oneof:"postgresql_config"`
	// Configuration of the connection pooler.
	PoolerConfig *ConnectionPoolerConfig `protobuf:"bytes,4,opt,name=pooler_config,json=poolerConfig,proto3" json:"pooler_config,omitempty"`
	// Resources allocated to PostgreSQL hosts.
	Resources *Resources `protobuf:"bytes,5,opt,name=resources,proto3" json:"resources,omitempty"`
	// Configuration setting which enables/disables autofailover in cluster.
	Autofailover *wrappers.BoolValue `protobuf:"bytes,6,opt,name=autofailover,proto3" json:"autofailover,omitempty"`
	// Start time for the daily backup in UTC timezone
	BackupWindowStart    *timeofday.TimeOfDay `protobuf:"bytes,8,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ConfigSpec) Reset()         { *m = ConfigSpec{} }
func (m *ConfigSpec) String() string { return proto.CompactTextString(m) }
func (*ConfigSpec) ProtoMessage()    {}
func (*ConfigSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{36}
}
func (m *ConfigSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigSpec.Unmarshal(m, b)
}
func (m *ConfigSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigSpec.Marshal(b, m, deterministic)
}
func (dst *ConfigSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigSpec.Merge(dst, src)
}
func (m *ConfigSpec) XXX_Size() int {
	return xxx_messageInfo_ConfigSpec.Size(m)
}
func (m *ConfigSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigSpec proto.InternalMessageInfo

func (m *ConfigSpec) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

type isConfigSpec_PostgresqlConfig interface {
	isConfigSpec_PostgresqlConfig()
}

type ConfigSpec_PostgresqlConfig_9_6 struct {
	PostgresqlConfig_9_6 *config.PostgresqlConfig9_6 `protobuf:"bytes,2,opt,name=postgresql_config_9_6,json=postgresqlConfig96,proto3,oneof"`
}

type ConfigSpec_PostgresqlConfig_10 struct {
	PostgresqlConfig_10 *config.PostgresqlConfig10 `protobuf:"bytes,3,opt,name=postgresql_config_10,json=postgresqlConfig10,proto3,oneof"`
}

type ConfigSpec_PostgresqlConfig_11 struct {
	PostgresqlConfig_11 *config.PostgresqlConfig11 `protobuf:"bytes,7,opt,name=postgresql_config_11,json=postgresqlConfig11,proto3,oneof"`
}

func (*ConfigSpec_PostgresqlConfig_9_6) isConfigSpec_PostgresqlConfig() {}

func (*ConfigSpec_PostgresqlConfig_10) isConfigSpec_PostgresqlConfig() {}

func (*ConfigSpec_PostgresqlConfig_11) isConfigSpec_PostgresqlConfig() {}

func (m *ConfigSpec) GetPostgresqlConfig() isConfigSpec_PostgresqlConfig {
	if m != nil {
		return m.PostgresqlConfig
	}
	return nil
}

func (m *ConfigSpec) GetPostgresqlConfig_9_6() *config.PostgresqlConfig9_6 {
	if x, ok := m.GetPostgresqlConfig().(*ConfigSpec_PostgresqlConfig_9_6); ok {
		return x.PostgresqlConfig_9_6
	}
	return nil
}

func (m *ConfigSpec) GetPostgresqlConfig_10() *config.PostgresqlConfig10 {
	if x, ok := m.GetPostgresqlConfig().(*ConfigSpec_PostgresqlConfig_10); ok {
		return x.PostgresqlConfig_10
	}
	return nil
}

func (m *ConfigSpec) GetPostgresqlConfig_11() *config.PostgresqlConfig11 {
	if x, ok := m.GetPostgresqlConfig().(*ConfigSpec_PostgresqlConfig_11); ok {
		return x.PostgresqlConfig_11
	}
	return nil
}

func (m *ConfigSpec) GetPoolerConfig() *ConnectionPoolerConfig {
	if m != nil {
		return m.PoolerConfig
	}
	return nil
}

func (m *ConfigSpec) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *ConfigSpec) GetAutofailover() *wrappers.BoolValue {
	if m != nil {
		return m.Autofailover
	}
	return nil
}

func (m *ConfigSpec) GetBackupWindowStart() *timeofday.TimeOfDay {
	if m != nil {
		return m.BackupWindowStart
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ConfigSpec) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ConfigSpec_OneofMarshaler, _ConfigSpec_OneofUnmarshaler, _ConfigSpec_OneofSizer, []interface{}{
		(*ConfigSpec_PostgresqlConfig_9_6)(nil),
		(*ConfigSpec_PostgresqlConfig_10)(nil),
		(*ConfigSpec_PostgresqlConfig_11)(nil),
	}
}

func _ConfigSpec_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ConfigSpec)
	// postgresql_config
	switch x := m.PostgresqlConfig.(type) {
	case *ConfigSpec_PostgresqlConfig_9_6:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PostgresqlConfig_9_6); err != nil {
			return err
		}
	case *ConfigSpec_PostgresqlConfig_10:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PostgresqlConfig_10); err != nil {
			return err
		}
	case *ConfigSpec_PostgresqlConfig_11:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PostgresqlConfig_11); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ConfigSpec.PostgresqlConfig has unexpected type %T", x)
	}
	return nil
}

func _ConfigSpec_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ConfigSpec)
	switch tag {
	case 2: // postgresql_config.postgresql_config_9_6
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(config.PostgresqlConfig9_6)
		err := b.DecodeMessage(msg)
		m.PostgresqlConfig = &ConfigSpec_PostgresqlConfig_9_6{msg}
		return true, err
	case 3: // postgresql_config.postgresql_config_10
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(config.PostgresqlConfig10)
		err := b.DecodeMessage(msg)
		m.PostgresqlConfig = &ConfigSpec_PostgresqlConfig_10{msg}
		return true, err
	case 7: // postgresql_config.postgresql_config_11
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(config.PostgresqlConfig11)
		err := b.DecodeMessage(msg)
		m.PostgresqlConfig = &ConfigSpec_PostgresqlConfig_11{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ConfigSpec_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ConfigSpec)
	// postgresql_config
	switch x := m.PostgresqlConfig.(type) {
	case *ConfigSpec_PostgresqlConfig_9_6:
		s := proto.Size(x.PostgresqlConfig_9_6)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ConfigSpec_PostgresqlConfig_10:
		s := proto.Size(x.PostgresqlConfig_10)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ConfigSpec_PostgresqlConfig_11:
		s := proto.Size(x.PostgresqlConfig_11)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type ConfigHostSpec struct {
	// Types that are valid to be assigned to PostgresqlConfig:
	//	*ConfigHostSpec_PostgresqlConfig_9_6
	//	*ConfigHostSpec_PostgresqlConfig_10
	//	*ConfigHostSpec_PostgresqlConfig_11
	PostgresqlConfig     isConfigHostSpec_PostgresqlConfig `protobuf_oneof:"postgresql_config"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *ConfigHostSpec) Reset()         { *m = ConfigHostSpec{} }
func (m *ConfigHostSpec) String() string { return proto.CompactTextString(m) }
func (*ConfigHostSpec) ProtoMessage()    {}
func (*ConfigHostSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_ed180847cbf9a03f, []int{37}
}
func (m *ConfigHostSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigHostSpec.Unmarshal(m, b)
}
func (m *ConfigHostSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigHostSpec.Marshal(b, m, deterministic)
}
func (dst *ConfigHostSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigHostSpec.Merge(dst, src)
}
func (m *ConfigHostSpec) XXX_Size() int {
	return xxx_messageInfo_ConfigHostSpec.Size(m)
}
func (m *ConfigHostSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigHostSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigHostSpec proto.InternalMessageInfo

type isConfigHostSpec_PostgresqlConfig interface {
	isConfigHostSpec_PostgresqlConfig()
}

type ConfigHostSpec_PostgresqlConfig_9_6 struct {
	PostgresqlConfig_9_6 *config.PostgresqlHostConfig9_6 `protobuf:"bytes,1,opt,name=postgresql_config_9_6,json=postgresqlConfig96,proto3,oneof"`
}

type ConfigHostSpec_PostgresqlConfig_10 struct {
	PostgresqlConfig_10 *config.PostgresqlHostConfig10 `protobuf:"bytes,2,opt,name=postgresql_config_10,json=postgresqlConfig10,proto3,oneof"`
}

type ConfigHostSpec_PostgresqlConfig_11 struct {
	PostgresqlConfig_11 *config.PostgresqlHostConfig11 `protobuf:"bytes,3,opt,name=postgresql_config_11,json=postgresqlConfig11,proto3,oneof"`
}

func (*ConfigHostSpec_PostgresqlConfig_9_6) isConfigHostSpec_PostgresqlConfig() {}

func (*ConfigHostSpec_PostgresqlConfig_10) isConfigHostSpec_PostgresqlConfig() {}

func (*ConfigHostSpec_PostgresqlConfig_11) isConfigHostSpec_PostgresqlConfig() {}

func (m *ConfigHostSpec) GetPostgresqlConfig() isConfigHostSpec_PostgresqlConfig {
	if m != nil {
		return m.PostgresqlConfig
	}
	return nil
}

func (m *ConfigHostSpec) GetPostgresqlConfig_9_6() *config.PostgresqlHostConfig9_6 {
	if x, ok := m.GetPostgresqlConfig().(*ConfigHostSpec_PostgresqlConfig_9_6); ok {
		return x.PostgresqlConfig_9_6
	}
	return nil
}

func (m *ConfigHostSpec) GetPostgresqlConfig_10() *config.PostgresqlHostConfig10 {
	if x, ok := m.GetPostgresqlConfig().(*ConfigHostSpec_PostgresqlConfig_10); ok {
		return x.PostgresqlConfig_10
	}
	return nil
}

func (m *ConfigHostSpec) GetPostgresqlConfig_11() *config.PostgresqlHostConfig11 {
	if x, ok := m.GetPostgresqlConfig().(*ConfigHostSpec_PostgresqlConfig_11); ok {
		return x.PostgresqlConfig_11
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ConfigHostSpec) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ConfigHostSpec_OneofMarshaler, _ConfigHostSpec_OneofUnmarshaler, _ConfigHostSpec_OneofSizer, []interface{}{
		(*ConfigHostSpec_PostgresqlConfig_9_6)(nil),
		(*ConfigHostSpec_PostgresqlConfig_10)(nil),
		(*ConfigHostSpec_PostgresqlConfig_11)(nil),
	}
}

func _ConfigHostSpec_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ConfigHostSpec)
	// postgresql_config
	switch x := m.PostgresqlConfig.(type) {
	case *ConfigHostSpec_PostgresqlConfig_9_6:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PostgresqlConfig_9_6); err != nil {
			return err
		}
	case *ConfigHostSpec_PostgresqlConfig_10:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PostgresqlConfig_10); err != nil {
			return err
		}
	case *ConfigHostSpec_PostgresqlConfig_11:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PostgresqlConfig_11); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ConfigHostSpec.PostgresqlConfig has unexpected type %T", x)
	}
	return nil
}

func _ConfigHostSpec_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ConfigHostSpec)
	switch tag {
	case 1: // postgresql_config.postgresql_config_9_6
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(config.PostgresqlHostConfig9_6)
		err := b.DecodeMessage(msg)
		m.PostgresqlConfig = &ConfigHostSpec_PostgresqlConfig_9_6{msg}
		return true, err
	case 2: // postgresql_config.postgresql_config_10
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(config.PostgresqlHostConfig10)
		err := b.DecodeMessage(msg)
		m.PostgresqlConfig = &ConfigHostSpec_PostgresqlConfig_10{msg}
		return true, err
	case 3: // postgresql_config.postgresql_config_11
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(config.PostgresqlHostConfig11)
		err := b.DecodeMessage(msg)
		m.PostgresqlConfig = &ConfigHostSpec_PostgresqlConfig_11{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ConfigHostSpec_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ConfigHostSpec)
	// postgresql_config
	switch x := m.PostgresqlConfig.(type) {
	case *ConfigHostSpec_PostgresqlConfig_9_6:
		s := proto.Size(x.PostgresqlConfig_9_6)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ConfigHostSpec_PostgresqlConfig_10:
		s := proto.Size(x.PostgresqlConfig_10)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ConfigHostSpec_PostgresqlConfig_11:
		s := proto.Size(x.PostgresqlConfig_11)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*GetClusterRequest)(nil), "yandex.cloud.mdb.postgresql.v1.GetClusterRequest")
	proto.RegisterType((*ListClustersRequest)(nil), "yandex.cloud.mdb.postgresql.v1.ListClustersRequest")
	proto.RegisterType((*ListClustersResponse)(nil), "yandex.cloud.mdb.postgresql.v1.ListClustersResponse")
	proto.RegisterType((*CreateClusterRequest)(nil), "yandex.cloud.mdb.postgresql.v1.CreateClusterRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.postgresql.v1.CreateClusterRequest.LabelsEntry")
	proto.RegisterType((*CreateClusterMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.CreateClusterMetadata")
	proto.RegisterType((*UpdateClusterRequest)(nil), "yandex.cloud.mdb.postgresql.v1.UpdateClusterRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.postgresql.v1.UpdateClusterRequest.LabelsEntry")
	proto.RegisterType((*UpdateClusterMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.UpdateClusterMetadata")
	proto.RegisterType((*DeleteClusterRequest)(nil), "yandex.cloud.mdb.postgresql.v1.DeleteClusterRequest")
	proto.RegisterType((*DeleteClusterMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.DeleteClusterMetadata")
	proto.RegisterType((*StartClusterRequest)(nil), "yandex.cloud.mdb.postgresql.v1.StartClusterRequest")
	proto.RegisterType((*StartClusterMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.StartClusterMetadata")
	proto.RegisterType((*StopClusterRequest)(nil), "yandex.cloud.mdb.postgresql.v1.StopClusterRequest")
	proto.RegisterType((*StopClusterMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.StopClusterMetadata")
	proto.RegisterType((*MoveClusterRequest)(nil), "yandex.cloud.mdb.postgresql.v1.MoveClusterRequest")
	proto.RegisterType((*MoveClusterMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.MoveClusterMetadata")
	proto.RegisterType((*BackupClusterRequest)(nil), "yandex.cloud.mdb.postgresql.v1.BackupClusterRequest")
	proto.RegisterType((*BackupClusterMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.BackupClusterMetadata")
	proto.RegisterType((*RestoreClusterRequest)(nil), "yandex.cloud.mdb.postgresql.v1.RestoreClusterRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.postgresql.v1.RestoreClusterRequest.LabelsEntry")
	proto.RegisterType((*RestoreClusterMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.RestoreClusterMetadata")
	proto.RegisterType((*LogRecord)(nil), "yandex.cloud.mdb.postgresql.v1.LogRecord")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.postgresql.v1.LogRecord.MessageEntry")
	proto.RegisterType((*ListClusterLogsRequest)(nil), "yandex.cloud.mdb.postgresql.v1.ListClusterLogsRequest")
	proto.RegisterType((*ListClusterLogsResponse)(nil), "yandex.cloud.mdb.postgresql.v1.ListClusterLogsResponse")
	proto.RegisterType((*ListClusterOperationsRequest)(nil), "yandex.cloud.mdb.postgresql.v1.ListClusterOperationsRequest")
	proto.RegisterType((*ListClusterOperationsResponse)(nil), "yandex.cloud.mdb.postgresql.v1.ListClusterOperationsResponse")
	proto.RegisterType((*ListClusterBackupsRequest)(nil), "yandex.cloud.mdb.postgresql.v1.ListClusterBackupsRequest")
	proto.RegisterType((*ListClusterBackupsResponse)(nil), "yandex.cloud.mdb.postgresql.v1.ListClusterBackupsResponse")
	proto.RegisterType((*ListClusterHostsRequest)(nil), "yandex.cloud.mdb.postgresql.v1.ListClusterHostsRequest")
	proto.RegisterType((*ListClusterHostsResponse)(nil), "yandex.cloud.mdb.postgresql.v1.ListClusterHostsResponse")
	proto.RegisterType((*AddClusterHostsRequest)(nil), "yandex.cloud.mdb.postgresql.v1.AddClusterHostsRequest")
	proto.RegisterType((*AddClusterHostsMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.AddClusterHostsMetadata")
	proto.RegisterType((*DeleteClusterHostsRequest)(nil), "yandex.cloud.mdb.postgresql.v1.DeleteClusterHostsRequest")
	proto.RegisterType((*DeleteClusterHostsMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.DeleteClusterHostsMetadata")
	proto.RegisterType((*UpdateClusterHostsRequest)(nil), "yandex.cloud.mdb.postgresql.v1.UpdateClusterHostsRequest")
	proto.RegisterType((*UpdateClusterHostsMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.UpdateClusterHostsMetadata")
	proto.RegisterType((*UpdateHostSpec)(nil), "yandex.cloud.mdb.postgresql.v1.UpdateHostSpec")
	proto.RegisterType((*HostSpec)(nil), "yandex.cloud.mdb.postgresql.v1.HostSpec")
	proto.RegisterType((*ConfigSpec)(nil), "yandex.cloud.mdb.postgresql.v1.ConfigSpec")
	proto.RegisterType((*ConfigHostSpec)(nil), "yandex.cloud.mdb.postgresql.v1.ConfigHostSpec")
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.ListClusterLogsRequest_ServiceType", ListClusterLogsRequest_ServiceType_name, ListClusterLogsRequest_ServiceType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ClusterServiceClient is the client API for ClusterService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ClusterServiceClient interface {
	// Returns the specified PostgreSQL Cluster resource.
	//
	// To get the list of available PostgreSQL Cluster resources, make a [List] request.
	Get(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Retrieves the list of PostgreSQL Cluster resources that belong
	// to the specified folder.
	List(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Creates a PostgreSQL cluster in the specified folder.
	Create(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified PostgreSQL cluster.
	Update(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified PostgreSQL cluster.
	Delete(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Start the specified PostgreSQL cluster.
	Start(ctx context.Context, in *StartClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Stop the specified PostgreSQL cluster.
	Stop(ctx context.Context, in *StopClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Moves the specified PostgreSQL cluster to the specified folder.
	Move(ctx context.Context, in *MoveClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Creates a backup for the specified PostgreSQL cluster.
	Backup(ctx context.Context, in *BackupClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Creates a new PostgreSQL cluster using the specified backup.
	Restore(ctx context.Context, in *RestoreClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Retrieves logs for the specified PostgreSQL cluster.
	// For more information about logs, see the [Logs](/docs/managed-postgresql/concepts/logs) section in the documentation.
	ListLogs(ctx context.Context, in *ListClusterLogsRequest, opts ...grpc.CallOption) (*ListClusterLogsResponse, error)
	// Retrieves the list of Operation resources for the specified cluster.
	ListOperations(ctx context.Context, in *ListClusterOperationsRequest, opts ...grpc.CallOption) (*ListClusterOperationsResponse, error)
	// Retrieves the list of available backups for the specified PostgreSQL cluster.
	ListBackups(ctx context.Context, in *ListClusterBackupsRequest, opts ...grpc.CallOption) (*ListClusterBackupsResponse, error)
	// Retrieves a list of hosts for the specified cluster.
	ListHosts(ctx context.Context, in *ListClusterHostsRequest, opts ...grpc.CallOption) (*ListClusterHostsResponse, error)
	// Creates new hosts for a cluster.
	AddHosts(ctx context.Context, in *AddClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified hosts for a cluster.
	DeleteHosts(ctx context.Context, in *DeleteClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified hosts.
	UpdateHosts(ctx context.Context, in *UpdateClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type clusterServiceClient struct {
	cc *grpc.ClientConn
}

func NewClusterServiceClient(cc *grpc.ClientConn) ClusterServiceClient {
	return &clusterServiceClient{cc}
}

func (c *clusterServiceClient) Get(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) List(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Create(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Update(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Delete(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Start(ctx context.Context, in *StartClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/Start", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Stop(ctx context.Context, in *StopClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/Stop", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Move(ctx context.Context, in *MoveClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/Move", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Backup(ctx context.Context, in *BackupClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/Backup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Restore(ctx context.Context, in *RestoreClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/Restore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListLogs(ctx context.Context, in *ListClusterLogsRequest, opts ...grpc.CallOption) (*ListClusterLogsResponse, error) {
	out := new(ListClusterLogsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/ListLogs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListOperations(ctx context.Context, in *ListClusterOperationsRequest, opts ...grpc.CallOption) (*ListClusterOperationsResponse, error) {
	out := new(ListClusterOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListBackups(ctx context.Context, in *ListClusterBackupsRequest, opts ...grpc.CallOption) (*ListClusterBackupsResponse, error) {
	out := new(ListClusterBackupsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/ListBackups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListHosts(ctx context.Context, in *ListClusterHostsRequest, opts ...grpc.CallOption) (*ListClusterHostsResponse, error) {
	out := new(ListClusterHostsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/ListHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) AddHosts(ctx context.Context, in *AddClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/AddHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) DeleteHosts(ctx context.Context, in *DeleteClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/DeleteHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) UpdateHosts(ctx context.Context, in *UpdateClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/UpdateHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClusterServiceServer is the server API for ClusterService service.
type ClusterServiceServer interface {
	// Returns the specified PostgreSQL Cluster resource.
	//
	// To get the list of available PostgreSQL Cluster resources, make a [List] request.
	Get(context.Context, *GetClusterRequest) (*Cluster, error)
	// Retrieves the list of PostgreSQL Cluster resources that belong
	// to the specified folder.
	List(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Creates a PostgreSQL cluster in the specified folder.
	Create(context.Context, *CreateClusterRequest) (*operation.Operation, error)
	// Updates the specified PostgreSQL cluster.
	Update(context.Context, *UpdateClusterRequest) (*operation.Operation, error)
	// Deletes the specified PostgreSQL cluster.
	Delete(context.Context, *DeleteClusterRequest) (*operation.Operation, error)
	// Start the specified PostgreSQL cluster.
	Start(context.Context, *StartClusterRequest) (*operation.Operation, error)
	// Stop the specified PostgreSQL cluster.
	Stop(context.Context, *StopClusterRequest) (*operation.Operation, error)
	// Moves the specified PostgreSQL cluster to the specified folder.
	Move(context.Context, *MoveClusterRequest) (*operation.Operation, error)
	// Creates a backup for the specified PostgreSQL cluster.
	Backup(context.Context, *BackupClusterRequest) (*operation.Operation, error)
	// Creates a new PostgreSQL cluster using the specified backup.
	Restore(context.Context, *RestoreClusterRequest) (*operation.Operation, error)
	// Retrieves logs for the specified PostgreSQL cluster.
	// For more information about logs, see the [Logs](/docs/managed-postgresql/concepts/logs) section in the documentation.
	ListLogs(context.Context, *ListClusterLogsRequest) (*ListClusterLogsResponse, error)
	// Retrieves the list of Operation resources for the specified cluster.
	ListOperations(context.Context, *ListClusterOperationsRequest) (*ListClusterOperationsResponse, error)
	// Retrieves the list of available backups for the specified PostgreSQL cluster.
	ListBackups(context.Context, *ListClusterBackupsRequest) (*ListClusterBackupsResponse, error)
	// Retrieves a list of hosts for the specified cluster.
	ListHosts(context.Context, *ListClusterHostsRequest) (*ListClusterHostsResponse, error)
	// Creates new hosts for a cluster.
	AddHosts(context.Context, *AddClusterHostsRequest) (*operation.Operation, error)
	// Deletes the specified hosts for a cluster.
	DeleteHosts(context.Context, *DeleteClusterHostsRequest) (*operation.Operation, error)
	// Updates the specified hosts.
	UpdateHosts(context.Context, *UpdateClusterHostsRequest) (*operation.Operation, error)
}

func RegisterClusterServiceServer(s *grpc.Server, srv ClusterServiceServer) {
	s.RegisterService(&_ClusterService_serviceDesc, srv)
}

func _ClusterService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Get(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).List(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Create(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Update(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Delete(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Start_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Start(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/Start",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Start(ctx, req.(*StartClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Stop_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Stop(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/Stop",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Stop(ctx, req.(*StopClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Move_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Move(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/Move",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Move(ctx, req.(*MoveClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Backup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BackupClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Backup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/Backup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Backup(ctx, req.(*BackupClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Restore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Restore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/Restore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Restore(ctx, req.(*RestoreClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListLogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterLogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListLogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/ListLogs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListLogs(ctx, req.(*ListClusterLogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListOperations(ctx, req.(*ListClusterOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/ListBackups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListBackups(ctx, req.(*ListClusterBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/ListHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListHosts(ctx, req.(*ListClusterHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_AddHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddClusterHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).AddHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/AddHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).AddHosts(ctx, req.(*AddClusterHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_DeleteHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).DeleteHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/DeleteHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).DeleteHosts(ctx, req.(*DeleteClusterHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_UpdateHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).UpdateHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/UpdateHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).UpdateHosts(ctx, req.(*UpdateClusterHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.mdb.postgresql.v1.ClusterService",
	HandlerType: (*ClusterServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _ClusterService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ClusterService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _ClusterService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _ClusterService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ClusterService_Delete_Handler,
		},
		{
			MethodName: "Start",
			Handler:    _ClusterService_Start_Handler,
		},
		{
			MethodName: "Stop",
			Handler:    _ClusterService_Stop_Handler,
		},
		{
			MethodName: "Move",
			Handler:    _ClusterService_Move_Handler,
		},
		{
			MethodName: "Backup",
			Handler:    _ClusterService_Backup_Handler,
		},
		{
			MethodName: "Restore",
			Handler:    _ClusterService_Restore_Handler,
		},
		{
			MethodName: "ListLogs",
			Handler:    _ClusterService_ListLogs_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _ClusterService_ListOperations_Handler,
		},
		{
			MethodName: "ListBackups",
			Handler:    _ClusterService_ListBackups_Handler,
		},
		{
			MethodName: "ListHosts",
			Handler:    _ClusterService_ListHosts_Handler,
		},
		{
			MethodName: "AddHosts",
			Handler:    _ClusterService_AddHosts_Handler,
		},
		{
			MethodName: "DeleteHosts",
			Handler:    _ClusterService_DeleteHosts_Handler,
		},
		{
			MethodName: "UpdateHosts",
			Handler:    _ClusterService_UpdateHosts_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/mdb/postgresql/v1/cluster_service.proto",
}

func init() {
	proto.RegisterFile("yandex/cloud/mdb/postgresql/v1/cluster_service.proto", fileDescriptor_cluster_service_ed180847cbf9a03f)
}

var fileDescriptor_cluster_service_ed180847cbf9a03f = []byte{
	// 2686 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5a, 0x4f, 0x6f, 0x1b, 0xd7,
	0x11, 0xcf, 0x4a, 0x14, 0x45, 0x0e, 0x6d, 0xc6, 0x7e, 0x92, 0x1d, 0x86, 0x89, 0x1d, 0x99, 0x4d,
	0x62, 0x99, 0x31, 0xff, 0x4a, 0xa6, 0x4d, 0xc5, 0x76, 0x6c, 0xca, 0xb2, 0x23, 0x54, 0xb2, 0x94,
	0x95, 0x9c, 0x20, 0x31, 0x0c, 0x62, 0xc9, 0x7d, 0xa2, 0x17, 0x22, 0x77, 0xd7, 0xbb, 0x4b, 0x39,
	0x72, 0x91, 0x22, 0x4d, 0x80, 0x1e, 0x7c, 0x2a, 0x5a, 0xa0, 0x45, 0xd2, 0xa2, 0x9f, 0xa0, 0x97,
	0xea, 0xd0, 0x14, 0x41, 0x91, 0x43, 0x2e, 0x76, 0x2f, 0x2d, 0xa0, 0x7c, 0x85, 0x1c, 0x7a, 0x28,
	0x7a, 0xc8, 0xb1, 0xa7, 0xe2, 0xfd, 0x59, 0x72, 0x57, 0x24, 0xb5, 0xbb, 0xa4, 0x8d, 0xe6, 0x24,
	0xee, 0x7b, 0x6f, 0x66, 0x7e, 0x33, 0x6f, 0xde, 0xbc, 0x99, 0x79, 0x82, 0xf9, 0x5d, 0x49, 0x95,
	0xf1, 0xc7, 0xb9, 0x7a, 0x53, 0x6b, 0xcb, 0xb9, 0x96, 0x5c, 0xcb, 0xe9, 0x9a, 0x69, 0x35, 0x0c,
	0x6c, 0x3e, 0x68, 0xe6, 0x76, 0x0a, 0xb9, 0x7a, 0xb3, 0x6d, 0x5a, 0xd8, 0xa8, 0x9a, 0xd8, 0xd8,
	0x51, 0xea, 0x38, 0xab, 0x1b, 0x9a, 0xa5, 0xa1, 0xd3, 0x8c, 0x2a, 0x4b, 0xa9, 0xb2, 0x2d, 0xb9,
	0x96, 0xed, 0x52, 0x65, 0x77, 0x0a, 0xc9, 0x57, 0x1b, 0x9a, 0xd6, 0x68, 0xe2, 0x9c, 0xa4, 0x2b,
	0x39, 0x49, 0x55, 0x35, 0x4b, 0xb2, 0x14, 0x4d, 0x35, 0x19, 0x75, 0x72, 0x86, 0xcf, 0xd2, 0xaf,
	0x5a, 0x7b, 0x2b, 0xb7, 0xa5, 0xe0, 0xa6, 0x5c, 0x6d, 0x49, 0xe6, 0x36, 0x5f, 0xf1, 0xda, 0xc1,
	0x15, 0x96, 0xd2, 0xc2, 0xa6, 0x25, 0xb5, 0x74, 0xbe, 0xe0, 0xf4, 0xc1, 0x05, 0x0f, 0x0d, 0x49,
	0xd7, 0xb1, 0x61, 0x8b, 0x78, 0x85, 0xcf, 0x5b, 0xbb, 0x3a, 0xa6, 0xc4, 0xda, 0x96, 0x2c, 0xed,
	0xf2, 0xc9, 0x24, 0xd7, 0x99, 0xa0, 0xd3, 0x74, 0x6c, 0x50, 0x70, 0x7c, 0xee, 0x4d, 0x97, 0x3d,
	0x3a, 0xb3, 0x3d, 0xeb, 0x4e, 0xb9, 0xd6, 0xed, 0x48, 0x4d, 0x45, 0x76, 0x4e, 0xbf, 0xe5, 0x61,
	0xd6, 0x9a, 0x54, 0xdf, 0x6e, 0xdb, 0xca, 0x9c, 0xf7, 0xb7, 0x07, 0x7c, 0x75, 0xc6, 0x63, 0xb5,
	0x2c, 0x59, 0x52, 0x4d, 0x32, 0xf9, 0x56, 0x25, 0xcf, 0x79, 0x2c, 0x6f, 0x9b, 0x1d, 0xce, 0x65,
	0x2f, 0x1c, 0x9a, 0xba, 0xa5, 0x34, 0x1c, 0x83, 0xe5, 0x6a, 0x89, 0x93, 0x5e, 0x0a, 0x4a, 0x5a,
	0xc8, 0x0f, 0x4d, 0x59, 0xe0, 0x94, 0x73, 0xfe, 0x28, 0xef, 0x6b, 0xa6, 0xd5, 0x05, 0x5a, 0xf4,
	0x4f, 0xd4, 0x81, 0x18, 0x84, 0x86, 0x83, 0x4b, 0x5d, 0x83, 0xe3, 0xb7, 0xb0, 0xb5, 0xc8, 0x76,
	0x4e, 0xc4, 0x0f, 0xda, 0xd8, 0xb4, 0xd0, 0x5b, 0x00, 0xf6, 0x79, 0x52, 0xe4, 0x84, 0x30, 0x23,
	0xcc, 0x46, 0x2b, 0x47, 0xfe, 0xf5, 0xa4, 0x20, 0x3c, 0x7e, 0x5a, 0x08, 0x5d, 0xbe, 0x72, 0x21,
	0x2f, 0x46, 0xf9, 0xfc, 0xb2, 0x9c, 0xfa, 0x4a, 0x80, 0xa9, 0x15, 0xc5, 0xb4, 0x79, 0x98, 0x36,
	0x93, 0x73, 0x10, 0xdd, 0xd2, 0x9a, 0xf2, 0x60, 0x1e, 0x11, 0x36, 0xbd, 0x2c, 0xa3, 0xb3, 0x10,
	0xd5, 0xa5, 0x06, 0xae, 0x9a, 0xca, 0x23, 0x9c, 0x18, 0x9b, 0x11, 0x66, 0xc7, 0x2b, 0xf0, 0xdf,
	0x27, 0x85, 0xf0, 0xe5, 0x2b, 0x85, 0x7c, 0x3e, 0x2f, 0x46, 0xc8, 0xe4, 0x86, 0xf2, 0x08, 0xa3,
	0x59, 0x00, 0xba, 0xd0, 0xd2, 0xb6, 0xb1, 0x9a, 0x18, 0xa7, 0x4c, 0xa3, 0x8f, 0x9f, 0x16, 0x26,
	0xe8, 0x4a, 0x91, 0x72, 0xd9, 0x24, 0x73, 0x28, 0x05, 0xe1, 0x2d, 0xa5, 0x69, 0x61, 0x23, 0x11,
	0xa2, 0xab, 0xe0, 0xf1, 0xd3, 0x0e, 0x3f, 0x3e, 0x93, 0xfa, 0x5c, 0x80, 0x69, 0x37, 0x72, 0x53,
	0xd7, 0x54, 0x13, 0xa3, 0x45, 0x88, 0x70, 0xfd, 0xcc, 0x84, 0x30, 0x33, 0x3e, 0x1b, 0x2b, 0x9e,
	0xcd, 0x1e, 0x1e, 0x49, 0xb2, 0xb6, 0x05, 0x3b, 0x84, 0xe8, 0x4d, 0x78, 0x51, 0xc5, 0x1f, 0x5b,
	0x55, 0x07, 0x60, 0xa2, 0x5a, 0x54, 0x3c, 0x4a, 0x86, 0xd7, 0x6d, 0xa4, 0xa9, 0x7f, 0x86, 0x61,
	0x7a, 0xd1, 0xc0, 0x92, 0x85, 0x0f, 0xec, 0x42, 0x00, 0x03, 0x16, 0x21, 0xa4, 0x4a, 0x2d, 0x66,
	0xbb, 0x68, 0xe5, 0x34, 0x59, 0xf5, 0xc3, 0x93, 0x42, 0xfc, 0xae, 0x94, 0x79, 0x74, 0x3d, 0xf3,
	0x51, 0x3e, 0x53, 0xae, 0x66, 0xee, 0xa5, 0x19, 0x5d, 0x69, 0x4e, 0xa4, 0x6b, 0xd1, 0x5b, 0x10,
	0x93, 0xb1, 0x59, 0x37, 0x14, 0x9d, 0xc4, 0x03, 0xb7, 0x31, 0x8b, 0x17, 0x4a, 0xa2, 0x73, 0x16,
	0x7d, 0x21, 0x40, 0xb8, 0x29, 0xd5, 0x70, 0xd3, 0x4c, 0x84, 0xa8, 0x41, 0xae, 0x79, 0x1a, 0xa4,
	0x8f, 0x4a, 0xd9, 0x15, 0xca, 0x62, 0x49, 0xb5, 0x8c, 0xdd, 0xca, 0x3b, 0x3f, 0x3c, 0x29, 0xc4,
	0xee, 0x66, 0xaa, 0xf9, 0x4c, 0x59, 0xca, 0x3c, 0xba, 0x97, 0xfe, 0x8c, 0xc1, 0x9b, 0xb7, 0x61,
	0xee, 0x3d, 0x2d, 0x84, 0x93, 0xf6, 0x2f, 0x84, 0x8e, 0x11, 0x65, 0xee, 0x39, 0xd6, 0x8b, 0x1c,
	0x10, 0xba, 0x0b, 0x31, 0xac, 0xee, 0x28, 0x86, 0xa6, 0xb6, 0xb0, 0x6a, 0x25, 0x26, 0x66, 0x84,
	0xd9, 0x78, 0x71, 0xce, 0xe7, 0x86, 0x65, 0x97, 0xba, 0xa4, 0x95, 0x10, 0x31, 0x9c, 0xe8, 0xe4,
	0x86, 0xde, 0x83, 0x18, 0x3b, 0x36, 0x55, 0x53, 0xc7, 0xf5, 0x44, 0x78, 0x46, 0x98, 0x8d, 0x15,
	0xd3, 0x9e, 0xcc, 0x29, 0xc9, 0x86, 0x8e, 0xeb, 0x9c, 0x27, 0xd4, 0x3b, 0x23, 0xe8, 0x43, 0x88,
	0xdb, 0xb1, 0x8f, 0x32, 0x35, 0x13, 0x93, 0xd4, 0xa4, 0xe7, 0xbd, 0xb8, 0xde, 0xe0, 0x54, 0x0e,
	0xbe, 0x47, 0x65, 0xc7, 0x98, 0x89, 0x56, 0x01, 0x48, 0x9c, 0xe4, 0x6c, 0x23, 0x94, 0xed, 0xac,
	0x17, 0xdb, 0x3b, 0x26, 0x36, 0x1c, 0x2c, 0xa3, 0x6d, 0xfe, 0x4d, 0xd9, 0x91, 0x60, 0xc1, 0xd9,
	0x45, 0xfd, 0xb1, 0x7b, 0x57, 0x33, 0x2d, 0x27, 0xbb, 0xfb, 0xfc, 0xdb, 0x24, 0x61, 0x45, 0xc5,
	0xd6, 0x43, 0xcd, 0xd8, 0x26, 0x1e, 0x0d, 0xfd, 0xc2, 0x0a, 0x9f, 0x5f, 0x96, 0x93, 0x65, 0x88,
	0x39, 0xbc, 0x05, 0x1d, 0x83, 0xf1, 0x6d, 0xbc, 0xcb, 0x8e, 0x81, 0x48, 0x7e, 0xa2, 0x69, 0x98,
	0xd8, 0x91, 0x9a, 0x6d, 0xee, 0xf4, 0x22, 0xfb, 0x58, 0x18, 0xbb, 0x24, 0xa4, 0x4a, 0x70, 0xc2,
	0xe5, 0x7d, 0xab, 0xd8, 0x92, 0x88, 0x9d, 0xd0, 0xa9, 0xde, 0xb8, 0xe6, 0x8c, 0x64, 0xbf, 0x08,
	0xc1, 0xf4, 0x1d, 0x5d, 0xee, 0x3d, 0x89, 0x41, 0xe2, 0x21, 0x7a, 0x1b, 0x62, 0x6d, 0xca, 0x84,
	0x26, 0x0a, 0x14, 0x5d, 0xac, 0x98, 0xcc, 0xb2, 0x8b, 0x3e, 0x6b, 0x27, 0x02, 0xd9, 0x9b, 0x24,
	0x97, 0x58, 0x95, 0xcc, 0x6d, 0x11, 0xd8, 0x72, 0xf2, 0xfb, 0x79, 0x1f, 0xca, 0x7e, 0xda, 0x3d,
	0x9f, 0x43, 0xf9, 0x53, 0xf7, 0xb9, 0x99, 0x08, 0x7a, 0x6e, 0x5c, 0x27, 0x26, 0xcb, 0xc3, 0x5b,
	0x98, 0x9a, 0x23, 0xe9, 0x15, 0xda, 0x46, 0xf4, 0x1d, 0x97, 0x91, 0xfc, 0xfa, 0xce, 0x22, 0x4c,
	0xdf, 0xc0, 0x4d, 0x3c, 0x92, 0xeb, 0x10, 0xe1, 0x2e, 0x26, 0x7e, 0x85, 0x57, 0x60, 0x6a, 0xc3,
	0x92, 0x8c, 0x91, 0xae, 0xf1, 0x0b, 0x30, 0xed, 0xe4, 0xe1, 0x57, 0xf4, 0x75, 0x40, 0x1b, 0x96,
	0xa6, 0x8f, 0x22, 0x79, 0x9e, 0xa0, 0xef, 0xb0, 0xf0, 0x2b, 0xf8, 0x73, 0x01, 0xd0, 0xaa, 0xb6,
	0x33, 0xd2, 0x51, 0xbd, 0x06, 0x27, 0x64, 0x6c, 0x5a, 0x8a, 0x4a, 0x53, 0xe2, 0x6a, 0xf7, 0xb6,
	0x1d, 0xeb, 0x43, 0x37, 0xe5, 0x58, 0x7a, 0x93, 0x5f, 0xbc, 0xa9, 0x5f, 0x0b, 0x30, 0xe5, 0x40,
	0xe1, 0x13, 0x3c, 0x9a, 0x85, 0x63, 0xa6, 0xd6, 0x36, 0xea, 0xf8, 0xa0, 0x4c, 0x31, 0xce, 0xc6,
	0x6f, 0x76, 0x6f, 0xf6, 0x01, 0x10, 0x69, 0x68, 0xe8, 0x0f, 0x6a, 0x11, 0xa6, 0x2b, 0x34, 0x6f,
	0x1f, 0xd1, 0x17, 0x5d, 0x4c, 0xfc, 0xee, 0xcb, 0x0f, 0x13, 0x70, 0x42, 0xc4, 0xa6, 0xa5, 0x19,
	0x07, 0xb7, 0xe6, 0x0c, 0x44, 0x59, 0x39, 0xd1, 0x95, 0xce, 0xae, 0x88, 0x08, 0x1b, 0x5e, 0x96,
	0xd1, 0x3c, 0x84, 0x48, 0x11, 0x34, 0x30, 0x68, 0x6e, 0xda, 0xe5, 0x15, 0xa7, 0xa4, 0xab, 0xd1,
	0x1b, 0x10, 0x27, 0x7f, 0xab, 0x8a, 0x4a, 0x60, 0x28, 0x3b, 0x98, 0x1a, 0x27, 0x22, 0x1e, 0x25,
	0xa3, 0xcb, 0xf6, 0x60, 0x27, 0x49, 0x0a, 0x0d, 0x9f, 0x24, 0x4d, 0x1c, 0x1a, 0x8f, 0xbf, 0xec,
	0xc6, 0xe3, 0x30, 0x8d, 0xc7, 0xd7, 0xbd, 0xe2, 0x5d, 0x5f, 0x43, 0x3d, 0x9f, 0x80, 0x7c, 0xc7,
	0x9d, 0x25, 0x4d, 0x0e, 0x9d, 0x25, 0xb9, 0xf3, 0xa3, 0x03, 0x71, 0x3e, 0x32, 0x52, 0x9c, 0x5f,
	0x1b, 0x29, 0xdf, 0x08, 0x7f, 0xf6, 0xb4, 0x30, 0x76, 0x35, 0xff, 0xff, 0xc8, 0x38, 0x36, 0xe1,
	0xa4, 0x7b, 0x2b, 0xfd, 0x06, 0x82, 0x57, 0x9c, 0x67, 0x82, 0xb1, 0xed, 0x9c, 0x86, 0xd4, 0x77,
	0x02, 0x44, 0x57, 0xb4, 0x86, 0x88, 0xeb, 0x9a, 0x21, 0xa3, 0x4b, 0x10, 0xed, 0x74, 0x17, 0x28,
	0xa3, 0x43, 0x0f, 0x88, 0xd8, 0x5d, 0x8c, 0xd6, 0x61, 0xb2, 0x85, 0x4d, 0x53, 0x6a, 0x10, 0xe4,
	0xc4, 0xa6, 0x25, 0x2f, 0x9b, 0x76, 0xa4, 0x66, 0x57, 0x19, 0x21, 0x35, 0x89, 0x68, 0xb3, 0x49,
	0x2e, 0xc0, 0x11, 0xe7, 0x44, 0x20, 0x5b, 0xfd, 0x2a, 0x04, 0x27, 0x1d, 0x55, 0xd7, 0x8a, 0xd6,
	0x30, 0x87, 0x0a, 0xde, 0x3f, 0x81, 0xa3, 0x75, 0xad, 0xd9, 0x6e, 0xa9, 0x55, 0x5e, 0xe8, 0x11,
	0xdd, 0xa2, 0xe2, 0x11, 0x36, 0x78, 0x93, 0x8e, 0x21, 0x0c, 0x47, 0x78, 0x47, 0xa8, 0x6a, 0xed,
	0xea, 0x2c, 0x30, 0xc4, 0x8b, 0x15, 0x4f, 0xfd, 0xfb, 0xe2, 0xcb, 0x6e, 0x30, 0x56, 0x9b, 0xbb,
	0x3a, 0x16, 0x63, 0x66, 0xf7, 0x03, 0x5d, 0x84, 0xe8, 0x96, 0xa1, 0xb5, 0xaa, 0x34, 0x78, 0x85,
	0x3c, 0xf7, 0x26, 0x42, 0x16, 0x93, 0x4f, 0x34, 0x07, 0x93, 0x96, 0xc6, 0xc8, 0x26, 0x3c, 0xc9,
	0xc2, 0x96, 0x46, 0x89, 0x5c, 0xe5, 0x72, 0xd8, 0x77, 0xb9, 0x3c, 0x79, 0x48, 0xb9, 0x3c, 0x07,
	0x27, 0xa5, 0xe6, 0x43, 0x69, 0xd7, 0xac, 0x1e, 0xac, 0x59, 0x23, 0x34, 0x94, 0x4e, 0xb1, 0xd9,
	0xdb, 0xae, 0xca, 0xf5, 0x16, 0xc4, 0x1c, 0x16, 0x41, 0xaf, 0x42, 0x62, 0x63, 0x49, 0x7c, 0x7f,
	0x79, 0x71, 0xa9, 0xba, 0xf9, 0xe1, 0xfa, 0x52, 0xf5, 0xce, 0xed, 0x8d, 0xf5, 0xa5, 0xc5, 0xe5,
	0x9b, 0xcb, 0x4b, 0x37, 0x8e, 0xbd, 0x80, 0xe2, 0x00, 0xeb, 0x6b, 0x1b, 0x9b, 0xb7, 0xc4, 0xa5,
	0x8d, 0xf7, 0x56, 0x8e, 0x09, 0x08, 0x20, 0xbc, 0xbe, 0xb6, 0xb6, 0xb2, 0x24, 0x1e, 0x1b, 0x4b,
	0x7d, 0x2a, 0xc0, 0x4b, 0x3d, 0x26, 0xe7, 0xb5, 0xf8, 0x15, 0x08, 0x35, 0xb5, 0x86, 0x5d, 0x87,
	0x9f, 0xf3, 0xed, 0xb9, 0x22, 0x25, 0xf3, 0x5d, 0x85, 0xff, 0x51, 0x80, 0x57, 0x1d, 0x10, 0xd6,
	0xec, 0x36, 0xda, 0x70, 0xbe, 0xf9, 0xec, 0x1b, 0x1a, 0xa9, 0xc7, 0x02, 0x9c, 0x1a, 0x00, 0x90,
	0x5b, 0xea, 0x3a, 0x40, 0xa7, 0xfb, 0x67, 0xdb, 0xeb, 0x8c, 0xdb, 0x5e, 0xdd, 0xee, 0x60, 0x87,
	0x5e, 0x74, 0x10, 0xf9, 0xb6, 0xd6, 0xef, 0x05, 0x78, 0xd9, 0x01, 0x86, 0x25, 0x0a, 0x3f, 0x1a,
	0x53, 0xfd, 0x52, 0x80, 0x64, 0x3f, 0x74, 0xdc, 0x4e, 0xd7, 0x60, 0x92, 0x85, 0x58, 0xdb, 0x48,
	0x6f, 0x7a, 0x39, 0x15, 0xe3, 0x20, 0xda, 0x64, 0xbe, 0xcd, 0xf4, 0x85, 0xdb, 0xaf, 0xc9, 0x4d,
	0xf5, 0xa3, 0x31, 0xd2, 0xcf, 0x21, 0xd1, 0x0b, 0x8d, 0x5b, 0x68, 0x01, 0x26, 0xc8, 0x1d, 0x6a,
	0xdb, 0xe7, 0x75, 0x3f, 0x57, 0xb0, 0xc8, 0x48, 0x7c, 0xdb, 0xe6, 0xb7, 0x02, 0x9c, 0xbc, 0x2e,
	0xcb, 0x23, 0x9b, 0xc6, 0x9d, 0x33, 0x8c, 0x8d, 0x9c, 0x33, 0xa4, 0x3e, 0x80, 0x97, 0x0e, 0xe0,
	0xf2, 0x7b, 0x99, 0x9f, 0xe2, 0x50, 0x48, 0xe6, 0x68, 0xf2, 0xeb, 0x88, 0x32, 0xbe, 0x4d, 0x06,
	0x52, 0x1f, 0xc3, 0xcb, 0xae, 0xea, 0x6e, 0x78, 0x9d, 0xb3, 0xbd, 0x82, 0x2a, 0x2f, 0x32, 0x4d,
	0xec, 0xd4, 0x74, 0xce, 0x29, 0xf9, 0x23, 0x48, 0xf6, 0x4a, 0x7e, 0x46, 0x5a, 0xfd, 0x49, 0x80,
	0x97, 0x5d, 0x15, 0xf3, 0xf0, 0x6a, 0xd5, 0xe0, 0x38, 0xef, 0x9c, 0xf4, 0xec, 0x68, 0xd6, 0x5f,
	0x67, 0xa3, 0x67, 0x5f, 0x5f, 0x6c, 0xbb, 0xc6, 0xa9, 0x29, 0x7a, 0xd1, 0x3e, 0x23, 0x53, 0xfc,
	0x5b, 0x80, 0xb8, 0x1b, 0x07, 0xa9, 0x79, 0x3a, 0x14, 0xee, 0x9a, 0xc7, 0x26, 0x43, 0x19, 0x40,
	0x06, 0xd6, 0x9b, 0x4a, 0x9d, 0x55, 0x78, 0xac, 0xfe, 0xe3, 0x67, 0xe6, 0xb8, 0x63, 0x66, 0x83,
	0x4e, 0xa0, 0x8b, 0x10, 0xd1, 0x0d, 0x45, 0x33, 0x14, 0x6b, 0x97, 0x9e, 0xef, 0x58, 0xf1, 0x95,
	0x9e, 0x94, 0x61, 0x59, 0xb5, 0x4a, 0xf3, 0xef, 0x93, 0x8c, 0x4b, 0xec, 0x2c, 0x46, 0x6b, 0xee,
	0x4c, 0x9d, 0x65, 0x29, 0x59, 0x7f, 0x99, 0xba, 0xad, 0x8f, 0x33, 0x5b, 0x4f, 0x7d, 0x35, 0x06,
	0x11, 0x87, 0xa2, 0x93, 0x8f, 0x34, 0x15, 0x77, 0x77, 0x39, 0xd2, 0xd9, 0xe1, 0x30, 0x99, 0x58,
	0x96, 0xd1, 0x1b, 0x10, 0x35, 0xdb, 0x35, 0x15, 0x5b, 0xdd, 0x0a, 0xbb, 0xbb, 0x28, 0xc2, 0xa6,
	0x58, 0x6d, 0x2c, 0x99, 0xa6, 0xd2, 0x50, 0xab, 0x7a, 0xbb, 0xd6, 0x54, 0xea, 0x55, 0x45, 0xe7,
	0xf5, 0x5c, 0x9c, 0x8d, 0xaf, 0xd3, 0xe1, 0x65, 0x7d, 0x80, 0xe5, 0x42, 0x7e, 0x2c, 0x37, 0x31,
	0x82, 0xe5, 0xc2, 0x23, 0x5b, 0xee, 0xaf, 0x13, 0x00, 0xdd, 0x12, 0x08, 0x25, 0x60, 0x72, 0x07,
	0x1b, 0x26, 0x29, 0x30, 0x99, 0xcb, 0xd9, 0x9f, 0x48, 0x83, 0x13, 0x5d, 0xa6, 0x55, 0x0e, 0xa2,
	0x5c, 0x2d, 0xf1, 0x02, 0x79, 0xc1, 0x0b, 0x03, 0xa3, 0xc8, 0xae, 0x77, 0x06, 0x99, 0xd4, 0x72,
	0xb5, 0xf4, 0xee, 0x0b, 0x22, 0xd2, 0x0f, 0x0e, 0x97, 0x50, 0x0b, 0xa6, 0x7b, 0x05, 0x16, 0xf2,
	0xdc, 0xd3, 0xca, 0x43, 0xca, 0x2b, 0xe4, 0xfb, 0x89, 0x2b, 0xe4, 0x07, 0x88, 0x2b, 0xd0, 0x54,
	0x75, 0x04, 0x71, 0x85, 0xbe, 0xe2, 0x0a, 0xe8, 0x2e, 0x1c, 0xd5, 0x35, 0xad, 0x89, 0x0d, 0x2e,
	0x8a, 0x1f, 0x82, 0x92, 0x8f, 0xad, 0x54, 0x71, 0x9d, 0xb8, 0xd2, 0x3a, 0x25, 0x67, 0x0c, 0xc5,
	0x23, 0xba, 0xe3, 0x0b, 0xdd, 0x82, 0xa8, 0x81, 0x99, 0x0f, 0x9a, 0xdc, 0xbf, 0xce, 0xf9, 0xa8,
	0xff, 0x19, 0x81, 0xd8, 0xa5, 0x45, 0x57, 0xe1, 0x88, 0xd4, 0xb6, 0xb4, 0x2d, 0x49, 0x69, 0x6a,
	0x3b, 0xd8, 0xe0, 0xfe, 0xd6, 0x5b, 0x18, 0x54, 0x34, 0xad, 0xc9, 0x5c, 0xd5, 0xb5, 0x1e, 0xdd,
	0x84, 0x29, 0x5e, 0x53, 0x3e, 0x54, 0x54, 0x59, 0x7b, 0x58, 0x35, 0x2d, 0xc9, 0xb0, 0x78, 0x69,
	0x7e, 0xd2, 0x66, 0x43, 0xca, 0x21, 0x5a, 0x5b, 0xac, 0x6d, 0xdd, 0x90, 0x76, 0xc5, 0xe3, 0x8c,
	0xe4, 0x03, 0x4a, 0x41, 0x1b, 0x81, 0x95, 0x29, 0x38, 0xde, 0xb3, 0x39, 0xa9, 0x4f, 0xc7, 0x21,
	0xee, 0xf6, 0x6c, 0x64, 0x0e, 0x72, 0x52, 0x56, 0xa4, 0x5e, 0x0d, 0xbc, 0x8b, 0x84, 0xb3, 0x97,
	0xa3, 0x3e, 0x18, 0xe0, 0xa8, 0xec, 0x60, 0x5c, 0x19, 0x41, 0xe6, 0x40, 0x67, 0x7d, 0x30, 0xc0,
	0x59, 0xc7, 0x47, 0x17, 0x39, 0xc0, 0x61, 0xfb, 0x6e, 0x41, 0xf1, 0x0f, 0x49, 0x88, 0xf3, 0xdb,
	0x8b, 0x97, 0x5f, 0xe8, 0x77, 0x02, 0x8c, 0xdf, 0xc2, 0x16, 0x2a, 0x78, 0x81, 0xe8, 0x79, 0xeb,
	0x4d, 0xfa, 0x7d, 0xd9, 0x4c, 0xcd, 0x7f, 0xf6, 0xdd, 0xf7, 0xbf, 0x19, 0xcb, 0xa2, 0xf3, 0xb9,
	0x96, 0xa4, 0x4a, 0x0d, 0x2c, 0x67, 0xfa, 0xbe, 0xfe, 0x9b, 0xb9, 0x9f, 0x75, 0xaf, 0xd0, 0x4f,
	0xd0, 0x97, 0x02, 0x84, 0x48, 0x9e, 0x89, 0xe6, 0x02, 0xd4, 0xdc, 0x76, 0xfa, 0x90, 0x9c, 0x0f,
	0x46, 0xc4, 0xd2, 0xd7, 0xd4, 0x59, 0x8a, 0xf4, 0x0c, 0x7a, 0xcd, 0x03, 0x29, 0xfa, 0xb3, 0x00,
	0x61, 0xf6, 0x52, 0x84, 0xe6, 0x87, 0x79, 0xcf, 0x4c, 0x7a, 0x97, 0x57, 0xa9, 0xdb, 0x7b, 0xfb,
	0xe9, 0x99, 0x41, 0x0f, 0x52, 0x93, 0x7c, 0x80, 0x02, 0x7e, 0x3d, 0xe5, 0x05, 0x78, 0x41, 0x48,
	0xa3, 0x6f, 0x04, 0x08, 0xb3, 0x24, 0xc3, 0x1b, 0x73, 0xbf, 0xe7, 0x1e, 0x3f, 0x98, 0xef, 0x32,
	0xcc, 0xfd, 0x1f, 0x42, 0x5c, 0x98, 0x0b, 0xc5, 0x40, 0xee, 0x40, 0x14, 0xf8, 0xbb, 0x00, 0x61,
	0x96, 0x8d, 0x7a, 0x2b, 0xd0, 0xef, 0x49, 0xc5, 0x8f, 0x02, 0x5b, 0x7b, 0xfb, 0xe9, 0xec, 0xa0,
	0xc7, 0x94, 0x13, 0x07, 0x03, 0xe9, 0x52, 0x4b, 0xb7, 0x76, 0x99, 0x77, 0xa7, 0x83, 0x79, 0xf7,
	0x37, 0x02, 0x4c, 0xd0, 0x60, 0xe9, 0xed, 0xde, 0x7d, 0x1e, 0x68, 0xfc, 0x68, 0x72, 0x6f, 0x6f,
	0x3f, 0xfd, 0xda, 0x80, 0xa7, 0x19, 0xd7, 0x4e, 0xcc, 0xa7, 0x8a, 0x81, 0x76, 0x82, 0x5e, 0x0a,
	0xe8, 0x6b, 0x01, 0x42, 0x1b, 0x96, 0xa6, 0xa3, 0xa2, 0x37, 0xfe, 0x83, 0xaf, 0x3c, 0x7e, 0x3d,
	0xe9, 0x74, 0xff, 0xf7, 0x1d, 0x17, 0xfa, 0xb9, 0x54, 0x21, 0x20, 0x7a, 0x4d, 0xa7, 0xe0, 0x57,
	0xb5, 0x1d, 0xec, 0x0d, 0xbe, 0xf7, 0xa1, 0x28, 0x00, 0xf8, 0x7e, 0xef, 0x3b, 0x23, 0x81, 0x6f,
	0x11, 0xcc, 0xdf, 0x0a, 0x10, 0x66, 0x7d, 0x05, 0xef, 0x63, 0xd0, 0xef, 0x35, 0xc7, 0x8f, 0x02,
	0x55, 0x76, 0x8e, 0xfb, 0xbf, 0xe3, 0xb8, 0x54, 0xb8, 0x90, 0x9a, 0x0b, 0xa4, 0x02, 0xcb, 0x16,
	0xd0, 0xdf, 0x04, 0x98, 0xe4, 0x8d, 0x6f, 0x74, 0x61, 0xa8, 0xc7, 0x0e, 0x3f, 0x6a, 0x7c, 0xb0,
	0xb7, 0x9f, 0x3e, 0x33, 0xb0, 0xc3, 0xee, 0xd2, 0xe3, 0x7c, 0xea, 0xac, 0x57, 0x0c, 0x35, 0x18,
	0x1b, 0x12, 0x8a, 0xfe, 0x22, 0x40, 0x84, 0xdc, 0x20, 0x2b, 0x5a, 0xc3, 0x44, 0xa5, 0xe1, 0x9a,
	0xc2, 0xc9, 0x8b, 0x81, 0xe9, 0xf8, 0x35, 0x55, 0x66, 0xce, 0x83, 0x82, 0x39, 0x0f, 0xed, 0x6a,
	0xfe, 0x43, 0x80, 0x38, 0x61, 0xdb, 0xed, 0x02, 0xa2, 0xcb, 0x01, 0x60, 0xf4, 0x74, 0x37, 0x93,
	0x57, 0x86, 0xa4, 0xe6, 0xaa, 0xbc, 0x43, 0x55, 0x29, 0xa3, 0x8b, 0x41, 0x54, 0xc9, 0x39, 0x1a,
	0x8f, 0xdf, 0x0a, 0x10, 0x23, 0x22, 0x78, 0xaf, 0x0e, 0x95, 0x03, 0xe0, 0x71, 0x77, 0x1f, 0x93,
	0x0b, 0xc3, 0x90, 0x72, 0x3d, 0x2e, 0x53, 0x3d, 0x4a, 0x68, 0x3e, 0x90, 0x1e, 0x76, 0x5b, 0xf0,
	0x6b, 0x01, 0xa2, 0x84, 0x39, 0xed, 0x29, 0xa0, 0x20, 0x7e, 0xe1, 0xec, 0x99, 0x24, 0x2f, 0x05,
	0x27, 0xe4, 0xf0, 0x17, 0xd8, 0x4d, 0x80, 0x02, 0xdd, 0x04, 0x39, 0xd6, 0xb7, 0xfb, 0x5e, 0x80,
	0xc8, 0x75, 0x59, 0x66, 0xd8, 0x3d, 0xcf, 0x42, 0xff, 0xce, 0x9d, 0x9f, 0xc3, 0xfc, 0xc9, 0xde,
	0x7e, 0x3a, 0x3f, 0xb8, 0xc5, 0x76, 0xc8, 0xe5, 0xbc, 0x98, 0xba, 0x1a, 0x5c, 0xaf, 0x85, 0x9a,
	0x64, 0xd5, 0xef, 0xb3, 0xec, 0x8b, 0x1c, 0xf9, 0xff, 0x08, 0x10, 0x63, 0x69, 0x01, 0xd3, 0xb4,
	0x1c, 0x28, 0x05, 0x09, 0xaa, 0xec, 0xa7, 0xc2, 0xde, 0x7e, 0x7a, 0xee, 0xd0, 0xee, 0xdb, 0xf3,
	0x51, 0x98, 0x09, 0xb4, 0x15, 0xee, 0x36, 0xa5, 0x7c, 0x28, 0x3c, 0xb0, 0x99, 0x17, 0x44, 0xe1,
	0x43, 0x7a, 0x6c, 0xcf, 0x47, 0x61, 0x26, 0x70, 0x41, 0x48, 0x57, 0xd6, 0x3e, 0x5a, 0x6d, 0x28,
	0xd6, 0xfd, 0x76, 0x2d, 0x5b, 0xd7, 0x5a, 0x39, 0x86, 0x38, 0xc3, 0xfe, 0x25, 0xb6, 0xa1, 0x65,
	0x1a, 0x58, 0xa5, 0x82, 0x73, 0x87, 0xff, 0xaf, 0xec, 0xdb, 0xdd, 0xaf, 0x5a, 0x98, 0x12, 0xcc,
	0xfd, 0x2f, 0x00, 0x00, 0xff, 0xff, 0xdc, 0x4b, 0x0b, 0xe0, 0x83, 0x2e, 0x00, 0x00,
}
