// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/operation/operation.proto

package operation // import "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import any "github.com/golang/protobuf/ptypes/any"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import status "google.golang.org/genproto/googleapis/rpc/status"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// An Operation resource. For more information, see [Operation](/docs/api-design-guide/concepts/operation).
type Operation struct {
	// ID of the operation.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Description of the operation. 0-256 characters long.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// ID of the user or service account who initiated the operation.
	CreatedBy string `protobuf:"bytes,4,opt,name=created_by,json=createdBy,proto3" json:"created_by,omitempty"`
	// The time when the Operation resource was last modified.
	// This value is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	ModifiedAt *timestamp.Timestamp `protobuf:"bytes,5,opt,name=modified_at,json=modifiedAt,proto3" json:"modified_at,omitempty"`
	// If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is available.
	Done bool `protobuf:"varint,6,opt,name=done,proto3" json:"done,omitempty"`
	// Service-specific metadata associated with the operation.
	// It typically contains the ID of the target resource that the operation is performed on.
	// Any method that returns a long-running operation should document the metadata type, if any.
	Metadata *any.Any `protobuf:"bytes,7,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// The operation result.
	// If `done == false` and there was no failure detected, neither `error` nor `response` is set.
	// If `done == false` and there was a failure detected, `error` is set.
	// If `done == true`, exactly one of `error` or `response` is set.
	//
	// Types that are valid to be assigned to Result:
	//	*Operation_Error
	//	*Operation_Response
	Result               isOperation_Result `protobuf_oneof:"result"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Operation) Reset()         { *m = Operation{} }
func (m *Operation) String() string { return proto.CompactTextString(m) }
func (*Operation) ProtoMessage()    {}
func (*Operation) Descriptor() ([]byte, []int) {
	return fileDescriptor_operation_fa9f2af44e01a2d7, []int{0}
}
func (m *Operation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Operation.Unmarshal(m, b)
}
func (m *Operation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Operation.Marshal(b, m, deterministic)
}
func (dst *Operation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Operation.Merge(dst, src)
}
func (m *Operation) XXX_Size() int {
	return xxx_messageInfo_Operation.Size(m)
}
func (m *Operation) XXX_DiscardUnknown() {
	xxx_messageInfo_Operation.DiscardUnknown(m)
}

var xxx_messageInfo_Operation proto.InternalMessageInfo

func (m *Operation) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Operation) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Operation) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Operation) GetCreatedBy() string {
	if m != nil {
		return m.CreatedBy
	}
	return ""
}

func (m *Operation) GetModifiedAt() *timestamp.Timestamp {
	if m != nil {
		return m.ModifiedAt
	}
	return nil
}

func (m *Operation) GetDone() bool {
	if m != nil {
		return m.Done
	}
	return false
}

func (m *Operation) GetMetadata() *any.Any {
	if m != nil {
		return m.Metadata
	}
	return nil
}

type isOperation_Result interface {
	isOperation_Result()
}

type Operation_Error struct {
	Error *status.Status `protobuf:"bytes,8,opt,name=error,proto3,oneof"`
}

type Operation_Response struct {
	Response *any.Any `protobuf:"bytes,9,opt,name=response,proto3,oneof"`
}

func (*Operation_Error) isOperation_Result() {}

func (*Operation_Response) isOperation_Result() {}

func (m *Operation) GetResult() isOperation_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *Operation) GetError() *status.Status {
	if x, ok := m.GetResult().(*Operation_Error); ok {
		return x.Error
	}
	return nil
}

func (m *Operation) GetResponse() *any.Any {
	if x, ok := m.GetResult().(*Operation_Response); ok {
		return x.Response
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Operation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Operation_OneofMarshaler, _Operation_OneofUnmarshaler, _Operation_OneofSizer, []interface{}{
		(*Operation_Error)(nil),
		(*Operation_Response)(nil),
	}
}

func _Operation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Operation)
	// result
	switch x := m.Result.(type) {
	case *Operation_Error:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Error); err != nil {
			return err
		}
	case *Operation_Response:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Response); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Operation.Result has unexpected type %T", x)
	}
	return nil
}

func _Operation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Operation)
	switch tag {
	case 8: // result.error
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(status.Status)
		err := b.DecodeMessage(msg)
		m.Result = &Operation_Error{msg}
		return true, err
	case 9: // result.response
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(any.Any)
		err := b.DecodeMessage(msg)
		m.Result = &Operation_Response{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Operation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Operation)
	// result
	switch x := m.Result.(type) {
	case *Operation_Error:
		s := proto.Size(x.Error)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Operation_Response:
		s := proto.Size(x.Response)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*Operation)(nil), "yandex.cloud.operation.Operation")
}

func init() {
	proto.RegisterFile("yandex/cloud/operation/operation.proto", fileDescriptor_operation_fa9f2af44e01a2d7)
}

var fileDescriptor_operation_fa9f2af44e01a2d7 = []byte{
	// 345 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x92, 0x4d, 0x4b, 0xeb, 0x40,
	0x14, 0x86, 0x9b, 0x7e, 0xdd, 0x64, 0x0a, 0x77, 0x31, 0x5c, 0xae, 0x63, 0x41, 0x0c, 0x2e, 0xa4,
	0x08, 0x9d, 0x48, 0x5d, 0x49, 0x57, 0x2d, 0x22, 0xdd, 0x09, 0xd1, 0x95, 0x1b, 0x99, 0x64, 0x4e,
	0xe3, 0x40, 0x93, 0x09, 0x93, 0x13, 0x30, 0x7b, 0x7f, 0xb8, 0x38, 0xd3, 0xa4, 0xe2, 0x07, 0xee,
	0x0e, 0xf3, 0x3e, 0xe7, 0x79, 0x61, 0x38, 0xe4, 0xbc, 0x11, 0x85, 0x84, 0x97, 0x28, 0xdd, 0xe9,
	0x5a, 0x46, 0xba, 0x04, 0x23, 0x50, 0xe9, 0xe2, 0x30, 0xf1, 0xd2, 0x68, 0xd4, 0xf4, 0xbf, 0xe3,
	0xb8, 0xe5, 0x78, 0x97, 0x4e, 0x8f, 0x33, 0xad, 0xb3, 0x1d, 0x44, 0x96, 0x4a, 0xea, 0x6d, 0x24,
	0x8a, 0xc6, 0xad, 0x4c, 0x8f, 0xf6, 0x91, 0x29, 0xd3, 0xa8, 0x42, 0x81, 0x75, 0xb5, 0x0f, 0x4e,
	0x3f, 0xef, 0xa0, 0xca, 0xa1, 0x42, 0x91, 0x97, 0x0e, 0x38, 0x7b, 0x1d, 0x90, 0xe0, 0xae, 0xad,
	0xa0, 0x7f, 0x49, 0x5f, 0x49, 0xe6, 0x85, 0xde, 0x2c, 0x88, 0xfb, 0x4a, 0xd2, 0x90, 0x4c, 0x24,
	0x54, 0xa9, 0x51, 0xe5, 0x7b, 0xcc, 0xfa, 0x36, 0xf8, 0xf8, 0x44, 0xaf, 0x09, 0x49, 0x0d, 0x08,
	0x04, 0xf9, 0x24, 0x90, 0x0d, 0x42, 0x6f, 0x36, 0x59, 0x4c, 0xb9, 0x6b, 0xe5, 0x6d, 0x2b, 0x7f,
	0x68, 0x5b, 0xe3, 0x60, 0x4f, 0xaf, 0x90, 0x9e, 0x1c, 0x56, 0x93, 0x86, 0x0d, 0xad, 0xbb, 0x8d,
	0xd7, 0x0d, 0x5d, 0x92, 0x49, 0xae, 0xa5, 0xda, 0x2a, 0xa7, 0x1e, 0xfd, 0xaa, 0x26, 0x2d, 0xbe,
	0x42, 0x4a, 0xc9, 0x50, 0xea, 0x02, 0xd8, 0x38, 0xf4, 0x66, 0x7e, 0x6c, 0x67, 0x7a, 0x49, 0xfc,
	0x1c, 0x50, 0x48, 0x81, 0x82, 0xfd, 0xb1, 0xb6, 0x7f, 0x5f, 0x6c, 0xab, 0xa2, 0x89, 0x3b, 0x8a,
	0x5e, 0x90, 0x11, 0x18, 0xa3, 0x0d, 0xf3, 0x2d, 0x4e, 0x5b, 0xdc, 0x94, 0x29, 0xbf, 0xb7, 0xdf,
	0xbc, 0xe9, 0xc5, 0x0e, 0xa1, 0x0b, 0xe2, 0x1b, 0xa8, 0x4a, 0x5d, 0x54, 0xc0, 0x82, 0x9f, 0xed,
	0x9b, 0x5e, 0xdc, 0x71, 0x6b, 0x9f, 0x8c, 0x0d, 0x54, 0xf5, 0x0e, 0xd7, 0xb7, 0x8f, 0x37, 0x99,
	0xc2, 0xe7, 0x3a, 0xe1, 0xa9, 0xce, 0x23, 0x77, 0x00, 0x73, 0x77, 0x28, 0x99, 0x9e, 0x67, 0x50,
	0x58, 0x47, 0xf4, 0xfd, 0x05, 0x2d, 0xbb, 0x29, 0x19, 0x5b, 0xee, 0xea, 0x2d, 0x00, 0x00, 0xff,
	0xff, 0x31, 0x4a, 0xd9, 0x89, 0x6c, 0x02, 0x00, 0x00,
}
