// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/resourcemanager/v1/folder_service.proto

package resourcemanager // import "github.com/yandex-cloud/go-genproto/yandex/cloud/resourcemanager/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/yandex-cloud/go-genproto/yandex/api"
import access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
import operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
import _ "github.com/yandex-cloud/go-genproto/yandex/cloud/validation"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type GetFolderRequest struct {
	// ID of the Folder resource to return.
	// To get the folder ID, use a [FolderService.List] request.
	FolderId             string   `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetFolderRequest) Reset()         { *m = GetFolderRequest{} }
func (m *GetFolderRequest) String() string { return proto.CompactTextString(m) }
func (*GetFolderRequest) ProtoMessage()    {}
func (*GetFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_folder_service_1b69e2b4ea1a512d, []int{0}
}
func (m *GetFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetFolderRequest.Unmarshal(m, b)
}
func (m *GetFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetFolderRequest.Marshal(b, m, deterministic)
}
func (dst *GetFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetFolderRequest.Merge(dst, src)
}
func (m *GetFolderRequest) XXX_Size() int {
	return xxx_messageInfo_GetFolderRequest.Size(m)
}
func (m *GetFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetFolderRequest proto.InternalMessageInfo

func (m *GetFolderRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

type ListFoldersRequest struct {
	// ID of the cloud to list folders in.
	// To get the cloud ID, use a [yandex.cloud.resourcemanager.v1.CloudService.List] request.
	CloudId string `protobuf:"bytes,1,opt,name=cloud_id,json=cloudId,proto3" json:"cloud_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListFoldersResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. Set [page_token]
	// to the [ListFoldersResponse.next_page_token]
	// returned by a previous list request to get the next page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on the [Folder.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9]$`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFoldersRequest) Reset()         { *m = ListFoldersRequest{} }
func (m *ListFoldersRequest) String() string { return proto.CompactTextString(m) }
func (*ListFoldersRequest) ProtoMessage()    {}
func (*ListFoldersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_folder_service_1b69e2b4ea1a512d, []int{1}
}
func (m *ListFoldersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFoldersRequest.Unmarshal(m, b)
}
func (m *ListFoldersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFoldersRequest.Marshal(b, m, deterministic)
}
func (dst *ListFoldersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFoldersRequest.Merge(dst, src)
}
func (m *ListFoldersRequest) XXX_Size() int {
	return xxx_messageInfo_ListFoldersRequest.Size(m)
}
func (m *ListFoldersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFoldersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFoldersRequest proto.InternalMessageInfo

func (m *ListFoldersRequest) GetCloudId() string {
	if m != nil {
		return m.CloudId
	}
	return ""
}

func (m *ListFoldersRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListFoldersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListFoldersRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListFoldersResponse struct {
	// List of Folder resources.
	Folders []*Folder `protobuf:"bytes,1,rep,name=folders,proto3" json:"folders,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListFoldersRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListFoldersRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFoldersResponse) Reset()         { *m = ListFoldersResponse{} }
func (m *ListFoldersResponse) String() string { return proto.CompactTextString(m) }
func (*ListFoldersResponse) ProtoMessage()    {}
func (*ListFoldersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_folder_service_1b69e2b4ea1a512d, []int{2}
}
func (m *ListFoldersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFoldersResponse.Unmarshal(m, b)
}
func (m *ListFoldersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFoldersResponse.Marshal(b, m, deterministic)
}
func (dst *ListFoldersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFoldersResponse.Merge(dst, src)
}
func (m *ListFoldersResponse) XXX_Size() int {
	return xxx_messageInfo_ListFoldersResponse.Size(m)
}
func (m *ListFoldersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFoldersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFoldersResponse proto.InternalMessageInfo

func (m *ListFoldersResponse) GetFolders() []*Folder {
	if m != nil {
		return m.Folders
	}
	return nil
}

func (m *ListFoldersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateFolderRequest struct {
	// ID of the cloud to create a folder in.
	// To get the cloud ID, use a [yandex.cloud.resourcemanager.v1.CloudService.List] request.
	CloudId string `protobuf:"bytes,1,opt,name=cloud_id,json=cloudId,proto3" json:"cloud_id,omitempty"`
	// Name of the folder.
	// The name must be unique within the cloud.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the folder.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `` key:value `` pairs.
	Labels               map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateFolderRequest) Reset()         { *m = CreateFolderRequest{} }
func (m *CreateFolderRequest) String() string { return proto.CompactTextString(m) }
func (*CreateFolderRequest) ProtoMessage()    {}
func (*CreateFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_folder_service_1b69e2b4ea1a512d, []int{3}
}
func (m *CreateFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFolderRequest.Unmarshal(m, b)
}
func (m *CreateFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFolderRequest.Marshal(b, m, deterministic)
}
func (dst *CreateFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFolderRequest.Merge(dst, src)
}
func (m *CreateFolderRequest) XXX_Size() int {
	return xxx_messageInfo_CreateFolderRequest.Size(m)
}
func (m *CreateFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFolderRequest proto.InternalMessageInfo

func (m *CreateFolderRequest) GetCloudId() string {
	if m != nil {
		return m.CloudId
	}
	return ""
}

func (m *CreateFolderRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateFolderRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateFolderRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type CreateFolderMetadata struct {
	// ID of the folder that is being created.
	FolderId             string   `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateFolderMetadata) Reset()         { *m = CreateFolderMetadata{} }
func (m *CreateFolderMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateFolderMetadata) ProtoMessage()    {}
func (*CreateFolderMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_folder_service_1b69e2b4ea1a512d, []int{4}
}
func (m *CreateFolderMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFolderMetadata.Unmarshal(m, b)
}
func (m *CreateFolderMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFolderMetadata.Marshal(b, m, deterministic)
}
func (dst *CreateFolderMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFolderMetadata.Merge(dst, src)
}
func (m *CreateFolderMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateFolderMetadata.Size(m)
}
func (m *CreateFolderMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFolderMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFolderMetadata proto.InternalMessageInfo

func (m *CreateFolderMetadata) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

type UpdateFolderRequest struct {
	// ID of the Folder resource to update.
	// To get the folder ID, use a [FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Field mask that specifies which fields of the Folder resource are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the folder.
	// The name must be unique within the cloud.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the folder.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `` key:value `` pairs.
	Labels               map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateFolderRequest) Reset()         { *m = UpdateFolderRequest{} }
func (m *UpdateFolderRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateFolderRequest) ProtoMessage()    {}
func (*UpdateFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_folder_service_1b69e2b4ea1a512d, []int{5}
}
func (m *UpdateFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateFolderRequest.Unmarshal(m, b)
}
func (m *UpdateFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateFolderRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateFolderRequest.Merge(dst, src)
}
func (m *UpdateFolderRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateFolderRequest.Size(m)
}
func (m *UpdateFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateFolderRequest proto.InternalMessageInfo

func (m *UpdateFolderRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *UpdateFolderRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateFolderRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateFolderRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateFolderRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type UpdateFolderMetadata struct {
	// ID of the Folder resource that is being updated.
	FolderId             string   `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateFolderMetadata) Reset()         { *m = UpdateFolderMetadata{} }
func (m *UpdateFolderMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateFolderMetadata) ProtoMessage()    {}
func (*UpdateFolderMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_folder_service_1b69e2b4ea1a512d, []int{6}
}
func (m *UpdateFolderMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateFolderMetadata.Unmarshal(m, b)
}
func (m *UpdateFolderMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateFolderMetadata.Marshal(b, m, deterministic)
}
func (dst *UpdateFolderMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateFolderMetadata.Merge(dst, src)
}
func (m *UpdateFolderMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateFolderMetadata.Size(m)
}
func (m *UpdateFolderMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateFolderMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateFolderMetadata proto.InternalMessageInfo

func (m *UpdateFolderMetadata) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

type DeleteFolderRequest struct {
	// ID of the folder to delete.
	// To get the folder ID, use a [FolderService.List] request.
	FolderId             string   `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteFolderRequest) Reset()         { *m = DeleteFolderRequest{} }
func (m *DeleteFolderRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteFolderRequest) ProtoMessage()    {}
func (*DeleteFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_folder_service_1b69e2b4ea1a512d, []int{7}
}
func (m *DeleteFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteFolderRequest.Unmarshal(m, b)
}
func (m *DeleteFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteFolderRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteFolderRequest.Merge(dst, src)
}
func (m *DeleteFolderRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteFolderRequest.Size(m)
}
func (m *DeleteFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteFolderRequest proto.InternalMessageInfo

func (m *DeleteFolderRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

type DeleteFolderMetadata struct {
	// ID of the folder that is being deleted.
	FolderId             string   `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteFolderMetadata) Reset()         { *m = DeleteFolderMetadata{} }
func (m *DeleteFolderMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteFolderMetadata) ProtoMessage()    {}
func (*DeleteFolderMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_folder_service_1b69e2b4ea1a512d, []int{8}
}
func (m *DeleteFolderMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteFolderMetadata.Unmarshal(m, b)
}
func (m *DeleteFolderMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteFolderMetadata.Marshal(b, m, deterministic)
}
func (dst *DeleteFolderMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteFolderMetadata.Merge(dst, src)
}
func (m *DeleteFolderMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteFolderMetadata.Size(m)
}
func (m *DeleteFolderMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteFolderMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteFolderMetadata proto.InternalMessageInfo

func (m *DeleteFolderMetadata) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

type ListFolderOperationsRequest struct {
	// ID of the Folder resource to list operations for.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListFolderOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. Set [page_token]
	// to the [ListFolderOperationsResponse.next_page_token]
	// returned by a previous list request to get the next page of results.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFolderOperationsRequest) Reset()         { *m = ListFolderOperationsRequest{} }
func (m *ListFolderOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListFolderOperationsRequest) ProtoMessage()    {}
func (*ListFolderOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_folder_service_1b69e2b4ea1a512d, []int{9}
}
func (m *ListFolderOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFolderOperationsRequest.Unmarshal(m, b)
}
func (m *ListFolderOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFolderOperationsRequest.Marshal(b, m, deterministic)
}
func (dst *ListFolderOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFolderOperationsRequest.Merge(dst, src)
}
func (m *ListFolderOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListFolderOperationsRequest.Size(m)
}
func (m *ListFolderOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFolderOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFolderOperationsRequest proto.InternalMessageInfo

func (m *ListFolderOperationsRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListFolderOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListFolderOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListFolderOperationsResponse struct {
	// List of operations for the specified folder.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListFolderOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListFolderOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFolderOperationsResponse) Reset()         { *m = ListFolderOperationsResponse{} }
func (m *ListFolderOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListFolderOperationsResponse) ProtoMessage()    {}
func (*ListFolderOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_folder_service_1b69e2b4ea1a512d, []int{10}
}
func (m *ListFolderOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFolderOperationsResponse.Unmarshal(m, b)
}
func (m *ListFolderOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFolderOperationsResponse.Marshal(b, m, deterministic)
}
func (dst *ListFolderOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFolderOperationsResponse.Merge(dst, src)
}
func (m *ListFolderOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListFolderOperationsResponse.Size(m)
}
func (m *ListFolderOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFolderOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFolderOperationsResponse proto.InternalMessageInfo

func (m *ListFolderOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListFolderOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetFolderRequest)(nil), "yandex.cloud.resourcemanager.v1.GetFolderRequest")
	proto.RegisterType((*ListFoldersRequest)(nil), "yandex.cloud.resourcemanager.v1.ListFoldersRequest")
	proto.RegisterType((*ListFoldersResponse)(nil), "yandex.cloud.resourcemanager.v1.ListFoldersResponse")
	proto.RegisterType((*CreateFolderRequest)(nil), "yandex.cloud.resourcemanager.v1.CreateFolderRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.resourcemanager.v1.CreateFolderRequest.LabelsEntry")
	proto.RegisterType((*CreateFolderMetadata)(nil), "yandex.cloud.resourcemanager.v1.CreateFolderMetadata")
	proto.RegisterType((*UpdateFolderRequest)(nil), "yandex.cloud.resourcemanager.v1.UpdateFolderRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.resourcemanager.v1.UpdateFolderRequest.LabelsEntry")
	proto.RegisterType((*UpdateFolderMetadata)(nil), "yandex.cloud.resourcemanager.v1.UpdateFolderMetadata")
	proto.RegisterType((*DeleteFolderRequest)(nil), "yandex.cloud.resourcemanager.v1.DeleteFolderRequest")
	proto.RegisterType((*DeleteFolderMetadata)(nil), "yandex.cloud.resourcemanager.v1.DeleteFolderMetadata")
	proto.RegisterType((*ListFolderOperationsRequest)(nil), "yandex.cloud.resourcemanager.v1.ListFolderOperationsRequest")
	proto.RegisterType((*ListFolderOperationsResponse)(nil), "yandex.cloud.resourcemanager.v1.ListFolderOperationsResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// FolderServiceClient is the client API for FolderService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FolderServiceClient interface {
	// Returns the specified Folder resource.
	//
	// To get the list of available Folder resources, make a [List] request.
	Get(ctx context.Context, in *GetFolderRequest, opts ...grpc.CallOption) (*Folder, error)
	// Retrieves the list of Folder resources in the specified cloud.
	List(ctx context.Context, in *ListFoldersRequest, opts ...grpc.CallOption) (*ListFoldersResponse, error)
	// Creates a folder in the specified cloud.
	Create(ctx context.Context, in *CreateFolderRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified folder.
	Update(ctx context.Context, in *UpdateFolderRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified folder.
	//
	// The method is temporarily unavailable.
	Delete(ctx context.Context, in *DeleteFolderRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists operations for the specified folder.
	ListOperations(ctx context.Context, in *ListFolderOperationsRequest, opts ...grpc.CallOption) (*ListFolderOperationsResponse, error)
	// Lists access bindings for the specified folder.
	ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the specified folder.
	SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates access bindings for the specified folder.
	UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type folderServiceClient struct {
	cc *grpc.ClientConn
}

func NewFolderServiceClient(cc *grpc.ClientConn) FolderServiceClient {
	return &folderServiceClient{cc}
}

func (c *folderServiceClient) Get(ctx context.Context, in *GetFolderRequest, opts ...grpc.CallOption) (*Folder, error) {
	out := new(Folder)
	err := c.cc.Invoke(ctx, "/yandex.cloud.resourcemanager.v1.FolderService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *folderServiceClient) List(ctx context.Context, in *ListFoldersRequest, opts ...grpc.CallOption) (*ListFoldersResponse, error) {
	out := new(ListFoldersResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.resourcemanager.v1.FolderService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *folderServiceClient) Create(ctx context.Context, in *CreateFolderRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.resourcemanager.v1.FolderService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *folderServiceClient) Update(ctx context.Context, in *UpdateFolderRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.resourcemanager.v1.FolderService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *folderServiceClient) Delete(ctx context.Context, in *DeleteFolderRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.resourcemanager.v1.FolderService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *folderServiceClient) ListOperations(ctx context.Context, in *ListFolderOperationsRequest, opts ...grpc.CallOption) (*ListFolderOperationsResponse, error) {
	out := new(ListFolderOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.resourcemanager.v1.FolderService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *folderServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	out := new(access.ListAccessBindingsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.resourcemanager.v1.FolderService/ListAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *folderServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.resourcemanager.v1.FolderService/SetAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *folderServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.resourcemanager.v1.FolderService/UpdateAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FolderServiceServer is the server API for FolderService service.
type FolderServiceServer interface {
	// Returns the specified Folder resource.
	//
	// To get the list of available Folder resources, make a [List] request.
	Get(context.Context, *GetFolderRequest) (*Folder, error)
	// Retrieves the list of Folder resources in the specified cloud.
	List(context.Context, *ListFoldersRequest) (*ListFoldersResponse, error)
	// Creates a folder in the specified cloud.
	Create(context.Context, *CreateFolderRequest) (*operation.Operation, error)
	// Updates the specified folder.
	Update(context.Context, *UpdateFolderRequest) (*operation.Operation, error)
	// Deletes the specified folder.
	//
	// The method is temporarily unavailable.
	Delete(context.Context, *DeleteFolderRequest) (*operation.Operation, error)
	// Lists operations for the specified folder.
	ListOperations(context.Context, *ListFolderOperationsRequest) (*ListFolderOperationsResponse, error)
	// Lists access bindings for the specified folder.
	ListAccessBindings(context.Context, *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the specified folder.
	SetAccessBindings(context.Context, *access.SetAccessBindingsRequest) (*operation.Operation, error)
	// Updates access bindings for the specified folder.
	UpdateAccessBindings(context.Context, *access.UpdateAccessBindingsRequest) (*operation.Operation, error)
}

func RegisterFolderServiceServer(s *grpc.Server, srv FolderServiceServer) {
	s.RegisterService(&_FolderService_serviceDesc, srv)
}

func _FolderService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FolderServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.resourcemanager.v1.FolderService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FolderServiceServer).Get(ctx, req.(*GetFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FolderService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFoldersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FolderServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.resourcemanager.v1.FolderService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FolderServiceServer).List(ctx, req.(*ListFoldersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FolderService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FolderServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.resourcemanager.v1.FolderService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FolderServiceServer).Create(ctx, req.(*CreateFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FolderService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FolderServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.resourcemanager.v1.FolderService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FolderServiceServer).Update(ctx, req.(*UpdateFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FolderService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FolderServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.resourcemanager.v1.FolderService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FolderServiceServer).Delete(ctx, req.(*DeleteFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FolderService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFolderOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FolderServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.resourcemanager.v1.FolderService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FolderServiceServer).ListOperations(ctx, req.(*ListFolderOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FolderService_ListAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.ListAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FolderServiceServer).ListAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.resourcemanager.v1.FolderService/ListAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FolderServiceServer).ListAccessBindings(ctx, req.(*access.ListAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FolderService_SetAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.SetAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FolderServiceServer).SetAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.resourcemanager.v1.FolderService/SetAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FolderServiceServer).SetAccessBindings(ctx, req.(*access.SetAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FolderService_UpdateAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.UpdateAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FolderServiceServer).UpdateAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.resourcemanager.v1.FolderService/UpdateAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FolderServiceServer).UpdateAccessBindings(ctx, req.(*access.UpdateAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _FolderService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.resourcemanager.v1.FolderService",
	HandlerType: (*FolderServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _FolderService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _FolderService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _FolderService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _FolderService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _FolderService_Delete_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _FolderService_ListOperations_Handler,
		},
		{
			MethodName: "ListAccessBindings",
			Handler:    _FolderService_ListAccessBindings_Handler,
		},
		{
			MethodName: "SetAccessBindings",
			Handler:    _FolderService_SetAccessBindings_Handler,
		},
		{
			MethodName: "UpdateAccessBindings",
			Handler:    _FolderService_UpdateAccessBindings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/resourcemanager/v1/folder_service.proto",
}

func init() {
	proto.RegisterFile("yandex/cloud/resourcemanager/v1/folder_service.proto", fileDescriptor_folder_service_1b69e2b4ea1a512d)
}

var fileDescriptor_folder_service_1b69e2b4ea1a512d = []byte{
	// 1110 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x57, 0xcf, 0x6f, 0xdb, 0x54,
	0x1c, 0xd7, 0x6b, 0xd2, 0xac, 0x79, 0xa1, 0x50, 0x5e, 0x87, 0x14, 0x79, 0xdd, 0xe8, 0x0c, 0xac,
	0x25, 0xcc, 0x76, 0x9c, 0xb4, 0x15, 0x69, 0x13, 0x75, 0x0d, 0xeb, 0xa6, 0x4a, 0x9b, 0x40, 0x2e,
	0xbd, 0x50, 0x4d, 0xd1, 0x6b, 0xfc, 0x1a, 0xac, 0x3a, 0x76, 0xf0, 0x73, 0xa2, 0xb5, 0x63, 0x12,
	0x9a, 0xb8, 0xd0, 0xeb, 0x0e, 0x08, 0xf1, 0x2f, 0x70, 0xaa, 0x38, 0x70, 0xd8, 0x11, 0xa9, 0x15,
	0xc7, 0xf2, 0x2f, 0x20, 0xc4, 0x81, 0xd3, 0x4e, 0x08, 0x09, 0x09, 0xf9, 0x3d, 0x3b, 0x75, 0x12,
	0xb7, 0x71, 0x0a, 0x87, 0x9d, 0xe2, 0xe7, 0xef, 0xaf, 0xcf, 0xf7, 0xc7, 0xfb, 0x7c, 0x1d, 0xb8,
	0xb0, 0x8f, 0x2d, 0x9d, 0x3c, 0x56, 0xea, 0xa6, 0xdd, 0xd6, 0x15, 0x87, 0x50, 0xbb, 0xed, 0xd4,
	0x49, 0x13, 0x5b, 0xb8, 0x41, 0x1c, 0xa5, 0xa3, 0x2a, 0xbb, 0xb6, 0xa9, 0x13, 0xa7, 0x46, 0x89,
	0xd3, 0x31, 0xea, 0x44, 0x6e, 0x39, 0xb6, 0x6b, 0xa3, 0xb7, 0xb9, 0x95, 0xcc, 0xac, 0xe4, 0x3e,
	0x2b, 0xb9, 0xa3, 0x0a, 0x33, 0x0d, 0xdb, 0x6e, 0x98, 0x44, 0xc1, 0x2d, 0x43, 0xc1, 0x96, 0x65,
	0xbb, 0xd8, 0x35, 0x6c, 0x8b, 0x72, 0x73, 0x61, 0xd6, 0x97, 0xb2, 0xd3, 0x4e, 0x7b, 0x57, 0xd9,
	0x35, 0x88, 0xa9, 0xd7, 0x9a, 0x98, 0xee, 0xf9, 0x1a, 0x82, 0x0f, 0xcb, 0xb3, 0xb7, 0x5b, 0xc4,
	0x61, 0xe6, 0xbe, 0xec, 0x76, 0x3c, 0xc8, 0x41, 0xac, 0x1e, 0x6d, 0x5c, 0xaf, 0x13, 0x4a, 0xfd,
	0x1f, 0x5f, 0xe3, 0x56, 0x8f, 0x46, 0x37, 0xda, 0x40, 0xdc, 0xeb, 0x3d, 0x7a, 0x1d, 0x6c, 0x1a,
	0x7a, 0x48, 0x2c, 0x56, 0xe0, 0xd4, 0x7d, 0xe2, 0xde, 0x63, 0xb1, 0x35, 0xf2, 0x45, 0x9b, 0x50,
	0x17, 0xbd, 0x0f, 0xd3, 0x7e, 0xfd, 0x0c, 0x3d, 0x0b, 0x66, 0xc1, 0x7c, 0xba, 0xfa, 0xda, 0x1f,
	0xc7, 0x2a, 0x38, 0x3c, 0x51, 0x93, 0xe5, 0xca, 0x62, 0x5e, 0x9b, 0xe0, 0xe2, 0x0d, 0x5d, 0xfc,
	0x11, 0x40, 0xf4, 0xc0, 0xa0, 0xbe, 0x03, 0x1a, 0x78, 0x98, 0x83, 0x13, 0x2c, 0xde, 0x79, 0x0e,
	0xae, 0x30, 0xe9, 0x86, 0x8e, 0xe6, 0x60, 0xba, 0x85, 0x1b, 0xa4, 0x46, 0x8d, 0x03, 0x92, 0x1d,
	0x9b, 0x05, 0xf3, 0x89, 0x2a, 0xfc, 0xfb, 0x58, 0x4d, 0x95, 0x2b, 0x6a, 0x3e, 0x9f, 0xd7, 0x26,
	0x3c, 0xe1, 0xa6, 0x71, 0x40, 0xd0, 0x3c, 0x84, 0x4c, 0xd1, 0xb5, 0xf7, 0x88, 0x95, 0x4d, 0x30,
	0x9f, 0xe9, 0xc3, 0x13, 0x75, 0x9c, 0x69, 0x6a, 0xcc, 0xcb, 0xa7, 0x9e, 0x0c, 0x89, 0x30, 0xb5,
	0x6b, 0x98, 0x2e, 0x71, 0xb2, 0x49, 0xa6, 0x05, 0x0f, 0x4f, 0xba, 0xfe, 0x7c, 0x89, 0xf8, 0x15,
	0x80, 0xd3, 0x3d, 0xb0, 0x69, 0xcb, 0xb6, 0x28, 0x41, 0x6b, 0xf0, 0x0a, 0x4f, 0x8d, 0x66, 0xc1,
	0x6c, 0x62, 0x3e, 0x53, 0x98, 0x93, 0x87, 0xcc, 0x8c, 0xec, 0x97, 0x2e, 0xb0, 0x43, 0xb7, 0xe0,
	0x1b, 0x16, 0x79, 0xec, 0xd6, 0x42, 0x68, 0xbd, 0xbc, 0xd2, 0xda, 0xa4, 0xf7, 0xfa, 0x93, 0x00,
	0xa6, 0xf8, 0xcf, 0x18, 0x9c, 0xfe, 0xc8, 0x21, 0xd8, 0x25, 0xbd, 0xc5, 0x8f, 0x5d, 0xba, 0x12,
	0x4c, 0x5a, 0xb8, 0xc9, 0xab, 0x96, 0xae, 0xbe, 0xe7, 0x29, 0xbd, 0x3c, 0x56, 0xaf, 0x7f, 0xb9,
	0x8d, 0xa5, 0x83, 0x47, 0xdb, 0x12, 0x96, 0x0e, 0xf2, 0x52, 0xe9, 0xd1, 0x13, 0xf5, 0xf6, 0x92,
	0xfa, 0x74, 0xdb, 0x3f, 0x69, 0xcc, 0x04, 0x7d, 0x00, 0x33, 0x3a, 0xa1, 0x75, 0xc7, 0x68, 0x79,
	0x93, 0xd0, 0x5b, 0xcd, 0xc2, 0xe2, 0x92, 0x16, 0x96, 0xa2, 0xef, 0x00, 0x4c, 0x99, 0x78, 0x87,
	0x98, 0x34, 0x9b, 0x64, 0x35, 0xb9, 0x33, 0xb4, 0x26, 0x11, 0x79, 0xc9, 0x0f, 0x98, 0x8b, 0x75,
	0xcb, 0x75, 0xf6, 0xab, 0xab, 0x2f, 0x8f, 0xd5, 0xcc, 0xb6, 0x54, 0xcb, 0x4b, 0x25, 0x0f, 0x6c,
	0xee, 0x19, 0x4b, 0x6e, 0x69, 0x81, 0x27, 0xb9, 0x54, 0x3c, 0x3a, 0x51, 0x53, 0x42, 0x52, 0x95,
	0xd8, 0x13, 0x42, 0x53, 0x7e, 0x4a, 0x5d, 0x7d, 0xcd, 0x07, 0x24, 0x94, 0x60, 0x26, 0xe4, 0x17,
	0x4d, 0xc1, 0xc4, 0x1e, 0xd9, 0xe7, 0x65, 0xd3, 0xbc, 0x47, 0x74, 0x15, 0x8e, 0x77, 0xb0, 0xd9,
	0xf6, 0xab, 0xa4, 0xf1, 0xc3, 0xf2, 0xd8, 0x87, 0x40, 0x2c, 0xc2, 0xab, 0x61, 0x98, 0x0f, 0x89,
	0x8b, 0x75, 0xec, 0x62, 0x74, 0x6d, 0x60, 0xf8, 0x43, 0xe3, 0xfe, 0x22, 0x01, 0xa7, 0xb7, 0x5a,
	0xfa, 0x40, 0xd3, 0xe2, 0xdf, 0x18, 0xb4, 0x02, 0x33, 0x6d, 0xe6, 0x81, 0x11, 0x07, 0xc3, 0x95,
	0x29, 0x08, 0x32, 0xe7, 0x16, 0x39, 0xe0, 0x16, 0xf9, 0x9e, 0xc7, 0x2d, 0x0f, 0x31, 0xdd, 0xd3,
	0x20, 0x57, 0xf7, 0x9e, 0xbb, 0x3d, 0x4f, 0xfc, 0xe7, 0x9e, 0x27, 0xe3, 0xf6, 0x7c, 0x3c, 0x66,
	0xcf, 0x23, 0xca, 0xf2, 0x2a, 0xf6, 0x3c, 0x0c, 0x33, 0x5e, 0xcf, 0xef, 0xc0, 0xe9, 0xbb, 0xc4,
	0x24, 0x97, 0x6f, 0xb9, 0x17, 0x36, 0xec, 0x21, 0x5e, 0xd8, 0xef, 0x01, 0xbc, 0x76, 0x46, 0x51,
	0x1f, 0x07, 0xac, 0x4e, 0x2f, 0x31, 0x72, 0xff, 0x3f, 0xc9, 0x8a, 0xdf, 0x00, 0x38, 0x13, 0x8d,
	0xae, 0xcb, 0xa4, 0xb0, 0xbb, 0x89, 0x02, 0x32, 0xbd, 0xd9, 0x3b, 0x44, 0x67, 0x9b, 0xaa, 0x6b,
	0xaf, 0x85, 0x8c, 0xe2, 0x32, 0x69, 0xe1, 0xf7, 0x49, 0x38, 0xc9, 0x71, 0x6c, 0xf2, 0x75, 0x8f,
	0x9e, 0x03, 0x98, 0xb8, 0x4f, 0x5c, 0xa4, 0x0e, 0x9d, 0xda, 0xfe, 0xdd, 0x27, 0xc4, 0x25, 0x7c,
	0x31, 0xff, 0xec, 0xd7, 0xdf, 0x9e, 0x8f, 0xe5, 0xd0, 0x7c, 0x77, 0x97, 0x4b, 0x03, 0xcb, 0x9c,
	0x2a, 0x4f, 0xba, 0x3d, 0x7a, 0x8a, 0xbe, 0x05, 0x30, 0xe9, 0xd5, 0x0c, 0x15, 0x87, 0xc6, 0x18,
	0x5c, 0xa9, 0xc2, 0xc2, 0x68, 0x46, 0xbc, 0x0d, 0xe2, 0xbb, 0x0c, 0xe5, 0x0d, 0x34, 0x73, 0x11,
	0x4a, 0xf4, 0x03, 0x80, 0x29, 0x4e, 0x86, 0x68, 0xe1, 0x32, 0xe4, 0x2e, 0x0c, 0xef, 0xac, 0xb8,
	0x71, 0x74, 0x9a, 0xbb, 0x71, 0x0e, 0xe7, 0xa6, 0xf8, 0x99, 0x61, 0xbd, 0x29, 0x5e, 0x88, 0x75,
	0x19, 0xe4, 0xd0, 0x4f, 0x00, 0xa6, 0xf8, 0x3d, 0x8e, 0x01, 0x37, 0x82, 0x97, 0xe2, 0xc0, 0xdd,
	0xe2, 0x70, 0x23, 0xe9, 0x22, 0x0c, 0x57, 0x2a, 0xc4, 0x1e, 0x00, 0x0f, 0xfa, 0xcf, 0x00, 0xa6,
	0x38, 0x17, 0xc4, 0x80, 0x1e, 0x41, 0x3b, 0x71, 0xa0, 0xe3, 0xa3, 0xd3, 0x9c, 0x74, 0x0e, 0xe5,
	0xbc, 0xd5, 0xbf, 0x67, 0xd6, 0x9b, 0x2d, 0x77, 0x9f, 0x8f, 0x72, 0x2e, 0xfe, 0x28, 0xff, 0x02,
	0xe0, 0xeb, 0xde, 0xb8, 0x9d, 0x5d, 0x7c, 0x54, 0x1e, 0x61, 0x3e, 0x07, 0xd8, 0x4c, 0xa8, 0x5c,
	0xd2, 0xda, 0x1f, 0xf3, 0x15, 0x96, 0xc1, 0x22, 0x2a, 0xc6, 0xcd, 0x40, 0x09, 0xf1, 0xcc, 0x0b,
	0xff, 0x1b, 0x76, 0x8d, 0x7d, 0x5e, 0x57, 0x0d, 0x4b, 0x37, 0xac, 0x06, 0x45, 0x72, 0x2f, 0x24,
	0xff, 0xe3, 0x7b, 0x50, 0x31, 0x48, 0x41, 0x89, 0xad, 0xef, 0x83, 0x5e, 0x67, 0xa0, 0x57, 0x51,
	0xe5, 0x62, 0xd0, 0x81, 0x90, 0x8d, 0x90, 0x39, 0x88, 0xf3, 0x4f, 0x00, 0xdf, 0xdc, 0x24, 0xfd,
	0x6f, 0xa5, 0x48, 0x34, 0x03, 0x7a, 0x23, 0x8c, 0xd5, 0xd7, 0xe0, 0xe8, 0x34, 0x57, 0x82, 0xb3,
	0xe7, 0xb9, 0x8a, 0x33, 0x63, 0x6b, 0x62, 0x79, 0x84, 0x64, 0x69, 0x7f, 0x08, 0xef, 0x06, 0xfd,
	0x05, 0x82, 0x5b, 0xd9, 0x97, 0x71, 0x3e, 0x32, 0xe3, 0x28, 0xd5, 0x11, 0x92, 0x3e, 0xf4, 0x92,
	0x2e, 0xc3, 0x77, 0x2e, 0xf0, 0x16, 0x27, 0xef, 0xbb, 0xe2, 0xea, 0x08, 0x79, 0xb7, 0x23, 0xa2,
	0x2c, 0x83, 0x5c, 0x75, 0xeb, 0xb3, 0xcd, 0x86, 0xe1, 0x7e, 0xde, 0xde, 0x91, 0xeb, 0x76, 0x53,
	0xe1, 0xd8, 0x25, 0xfe, 0xbf, 0xae, 0x61, 0x4b, 0x0d, 0x62, 0xb1, 0xc8, 0xca, 0x90, 0x3f, 0x9a,
	0x2b, 0x7d, 0xaf, 0x76, 0x52, 0xcc, 0xac, 0xf8, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x7f, 0xed,
	0x19, 0x34, 0x55, 0x0f, 0x00, 0x00,
}
