// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/vpc/v1/route_table_service.proto

package vpc // import "github.com/yandex-cloud/go-genproto/yandex/cloud/vpc/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/yandex-cloud/go-genproto/yandex/api"
import operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
import _ "github.com/yandex-cloud/go-genproto/yandex/cloud/validation"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type GetRouteTableRequest struct {
	// ID of the RouteTable resource to return.
	// To get the route table ID use a [RouteTableService.List] request.
	RouteTableId         string   `protobuf:"bytes,1,opt,name=route_table_id,json=routeTableId,proto3" json:"route_table_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetRouteTableRequest) Reset()         { *m = GetRouteTableRequest{} }
func (m *GetRouteTableRequest) String() string { return proto.CompactTextString(m) }
func (*GetRouteTableRequest) ProtoMessage()    {}
func (*GetRouteTableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_route_table_service_18dbfac795d82b53, []int{0}
}
func (m *GetRouteTableRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetRouteTableRequest.Unmarshal(m, b)
}
func (m *GetRouteTableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetRouteTableRequest.Marshal(b, m, deterministic)
}
func (dst *GetRouteTableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRouteTableRequest.Merge(dst, src)
}
func (m *GetRouteTableRequest) XXX_Size() int {
	return xxx_messageInfo_GetRouteTableRequest.Size(m)
}
func (m *GetRouteTableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRouteTableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetRouteTableRequest proto.InternalMessageInfo

func (m *GetRouteTableRequest) GetRouteTableId() string {
	if m != nil {
		return m.RouteTableId
	}
	return ""
}

type ListRouteTablesRequest struct {
	// ID of the folder that the route table belongs to.
	// To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListRouteTablesResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests. Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListRouteTablesResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on [RouteTable.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9]$`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRouteTablesRequest) Reset()         { *m = ListRouteTablesRequest{} }
func (m *ListRouteTablesRequest) String() string { return proto.CompactTextString(m) }
func (*ListRouteTablesRequest) ProtoMessage()    {}
func (*ListRouteTablesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_route_table_service_18dbfac795d82b53, []int{1}
}
func (m *ListRouteTablesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRouteTablesRequest.Unmarshal(m, b)
}
func (m *ListRouteTablesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRouteTablesRequest.Marshal(b, m, deterministic)
}
func (dst *ListRouteTablesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRouteTablesRequest.Merge(dst, src)
}
func (m *ListRouteTablesRequest) XXX_Size() int {
	return xxx_messageInfo_ListRouteTablesRequest.Size(m)
}
func (m *ListRouteTablesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRouteTablesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListRouteTablesRequest proto.InternalMessageInfo

func (m *ListRouteTablesRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListRouteTablesRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListRouteTablesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListRouteTablesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListRouteTablesResponse struct {
	// List of RouteTable resources.
	RouteTables []*RouteTable `protobuf:"bytes,1,rep,name=route_tables,json=routeTables,proto3" json:"route_tables,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListRouteTablesRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListRouteTablesRequest.page_token] query parameter
	// in the next list request. Subsequent list requests will have their own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRouteTablesResponse) Reset()         { *m = ListRouteTablesResponse{} }
func (m *ListRouteTablesResponse) String() string { return proto.CompactTextString(m) }
func (*ListRouteTablesResponse) ProtoMessage()    {}
func (*ListRouteTablesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_route_table_service_18dbfac795d82b53, []int{2}
}
func (m *ListRouteTablesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRouteTablesResponse.Unmarshal(m, b)
}
func (m *ListRouteTablesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRouteTablesResponse.Marshal(b, m, deterministic)
}
func (dst *ListRouteTablesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRouteTablesResponse.Merge(dst, src)
}
func (m *ListRouteTablesResponse) XXX_Size() int {
	return xxx_messageInfo_ListRouteTablesResponse.Size(m)
}
func (m *ListRouteTablesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRouteTablesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListRouteTablesResponse proto.InternalMessageInfo

func (m *ListRouteTablesResponse) GetRouteTables() []*RouteTable {
	if m != nil {
		return m.RouteTables
	}
	return nil
}

func (m *ListRouteTablesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateRouteTableRequest struct {
	// ID of the folder that the route table belongs to.
	// To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the route table.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the route table.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels, `` key:value `` pairs.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ID of the network the route table belongs to.
	NetworkId string `protobuf:"bytes,5,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// List of static routes.
	StaticRoutes         []*StaticRoute `protobuf:"bytes,6,rep,name=static_routes,json=staticRoutes,proto3" json:"static_routes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *CreateRouteTableRequest) Reset()         { *m = CreateRouteTableRequest{} }
func (m *CreateRouteTableRequest) String() string { return proto.CompactTextString(m) }
func (*CreateRouteTableRequest) ProtoMessage()    {}
func (*CreateRouteTableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_route_table_service_18dbfac795d82b53, []int{3}
}
func (m *CreateRouteTableRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateRouteTableRequest.Unmarshal(m, b)
}
func (m *CreateRouteTableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateRouteTableRequest.Marshal(b, m, deterministic)
}
func (dst *CreateRouteTableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateRouteTableRequest.Merge(dst, src)
}
func (m *CreateRouteTableRequest) XXX_Size() int {
	return xxx_messageInfo_CreateRouteTableRequest.Size(m)
}
func (m *CreateRouteTableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateRouteTableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateRouteTableRequest proto.InternalMessageInfo

func (m *CreateRouteTableRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateRouteTableRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateRouteTableRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateRouteTableRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CreateRouteTableRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *CreateRouteTableRequest) GetStaticRoutes() []*StaticRoute {
	if m != nil {
		return m.StaticRoutes
	}
	return nil
}

type CreateRouteTableMetadata struct {
	// ID of the route table that is being created.
	RouteTableId         string   `protobuf:"bytes,1,opt,name=route_table_id,json=routeTableId,proto3" json:"route_table_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateRouteTableMetadata) Reset()         { *m = CreateRouteTableMetadata{} }
func (m *CreateRouteTableMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateRouteTableMetadata) ProtoMessage()    {}
func (*CreateRouteTableMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_route_table_service_18dbfac795d82b53, []int{4}
}
func (m *CreateRouteTableMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateRouteTableMetadata.Unmarshal(m, b)
}
func (m *CreateRouteTableMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateRouteTableMetadata.Marshal(b, m, deterministic)
}
func (dst *CreateRouteTableMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateRouteTableMetadata.Merge(dst, src)
}
func (m *CreateRouteTableMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateRouteTableMetadata.Size(m)
}
func (m *CreateRouteTableMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateRouteTableMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateRouteTableMetadata proto.InternalMessageInfo

func (m *CreateRouteTableMetadata) GetRouteTableId() string {
	if m != nil {
		return m.RouteTableId
	}
	return ""
}

type UpdateRouteTableRequest struct {
	// ID of the RouteTable resource to update.
	RouteTableId string `protobuf:"bytes,1,opt,name=route_table_id,json=routeTableId,proto3" json:"route_table_id,omitempty"`
	// Field mask that specifies which fields of the RouteTable resource are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the route table.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the route table.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `` key:value `` pairs.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// List of static routes.
	StaticRoutes         []*StaticRoute `protobuf:"bytes,6,rep,name=static_routes,json=staticRoutes,proto3" json:"static_routes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *UpdateRouteTableRequest) Reset()         { *m = UpdateRouteTableRequest{} }
func (m *UpdateRouteTableRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateRouteTableRequest) ProtoMessage()    {}
func (*UpdateRouteTableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_route_table_service_18dbfac795d82b53, []int{5}
}
func (m *UpdateRouteTableRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateRouteTableRequest.Unmarshal(m, b)
}
func (m *UpdateRouteTableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateRouteTableRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateRouteTableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateRouteTableRequest.Merge(dst, src)
}
func (m *UpdateRouteTableRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateRouteTableRequest.Size(m)
}
func (m *UpdateRouteTableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateRouteTableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateRouteTableRequest proto.InternalMessageInfo

func (m *UpdateRouteTableRequest) GetRouteTableId() string {
	if m != nil {
		return m.RouteTableId
	}
	return ""
}

func (m *UpdateRouteTableRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateRouteTableRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateRouteTableRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateRouteTableRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *UpdateRouteTableRequest) GetStaticRoutes() []*StaticRoute {
	if m != nil {
		return m.StaticRoutes
	}
	return nil
}

type UpdateRouteTableMetadata struct {
	// ID of the RouteTable resource that is being updated.
	RouteTableId         string   `protobuf:"bytes,1,opt,name=route_table_id,json=routeTableId,proto3" json:"route_table_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateRouteTableMetadata) Reset()         { *m = UpdateRouteTableMetadata{} }
func (m *UpdateRouteTableMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateRouteTableMetadata) ProtoMessage()    {}
func (*UpdateRouteTableMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_route_table_service_18dbfac795d82b53, []int{6}
}
func (m *UpdateRouteTableMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateRouteTableMetadata.Unmarshal(m, b)
}
func (m *UpdateRouteTableMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateRouteTableMetadata.Marshal(b, m, deterministic)
}
func (dst *UpdateRouteTableMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateRouteTableMetadata.Merge(dst, src)
}
func (m *UpdateRouteTableMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateRouteTableMetadata.Size(m)
}
func (m *UpdateRouteTableMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateRouteTableMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateRouteTableMetadata proto.InternalMessageInfo

func (m *UpdateRouteTableMetadata) GetRouteTableId() string {
	if m != nil {
		return m.RouteTableId
	}
	return ""
}

type DeleteRouteTableRequest struct {
	// ID of the route table to delete.
	// To get the route table ID use a [RouteTableService.List] request.
	RouteTableId         string   `protobuf:"bytes,1,opt,name=route_table_id,json=routeTableId,proto3" json:"route_table_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteRouteTableRequest) Reset()         { *m = DeleteRouteTableRequest{} }
func (m *DeleteRouteTableRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteRouteTableRequest) ProtoMessage()    {}
func (*DeleteRouteTableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_route_table_service_18dbfac795d82b53, []int{7}
}
func (m *DeleteRouteTableRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteRouteTableRequest.Unmarshal(m, b)
}
func (m *DeleteRouteTableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteRouteTableRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteRouteTableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteRouteTableRequest.Merge(dst, src)
}
func (m *DeleteRouteTableRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteRouteTableRequest.Size(m)
}
func (m *DeleteRouteTableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteRouteTableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteRouteTableRequest proto.InternalMessageInfo

func (m *DeleteRouteTableRequest) GetRouteTableId() string {
	if m != nil {
		return m.RouteTableId
	}
	return ""
}

type DeleteRouteTableMetadata struct {
	// ID of the RouteTable resource that is being deleted.
	RouteTableId         string   `protobuf:"bytes,1,opt,name=route_table_id,json=routeTableId,proto3" json:"route_table_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteRouteTableMetadata) Reset()         { *m = DeleteRouteTableMetadata{} }
func (m *DeleteRouteTableMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteRouteTableMetadata) ProtoMessage()    {}
func (*DeleteRouteTableMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_route_table_service_18dbfac795d82b53, []int{8}
}
func (m *DeleteRouteTableMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteRouteTableMetadata.Unmarshal(m, b)
}
func (m *DeleteRouteTableMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteRouteTableMetadata.Marshal(b, m, deterministic)
}
func (dst *DeleteRouteTableMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteRouteTableMetadata.Merge(dst, src)
}
func (m *DeleteRouteTableMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteRouteTableMetadata.Size(m)
}
func (m *DeleteRouteTableMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteRouteTableMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteRouteTableMetadata proto.InternalMessageInfo

func (m *DeleteRouteTableMetadata) GetRouteTableId() string {
	if m != nil {
		return m.RouteTableId
	}
	return ""
}

type ListRouteTableOperationsRequest struct {
	// ID of the RouteTable resource to list operations for.
	RouteTableId string `protobuf:"bytes,1,opt,name=route_table_id,json=routeTableId,proto3" json:"route_table_id,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available
	// results is larger than [page_size], the service returns a [ListRouteTableOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests. Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListRouteTableOperationsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRouteTableOperationsRequest) Reset()         { *m = ListRouteTableOperationsRequest{} }
func (m *ListRouteTableOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListRouteTableOperationsRequest) ProtoMessage()    {}
func (*ListRouteTableOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_route_table_service_18dbfac795d82b53, []int{9}
}
func (m *ListRouteTableOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRouteTableOperationsRequest.Unmarshal(m, b)
}
func (m *ListRouteTableOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRouteTableOperationsRequest.Marshal(b, m, deterministic)
}
func (dst *ListRouteTableOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRouteTableOperationsRequest.Merge(dst, src)
}
func (m *ListRouteTableOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListRouteTableOperationsRequest.Size(m)
}
func (m *ListRouteTableOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRouteTableOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListRouteTableOperationsRequest proto.InternalMessageInfo

func (m *ListRouteTableOperationsRequest) GetRouteTableId() string {
	if m != nil {
		return m.RouteTableId
	}
	return ""
}

func (m *ListRouteTableOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListRouteTableOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListRouteTableOperationsResponse struct {
	// List of operations for the specified RouteTable resource.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListRouteTableOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListRouteTableOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRouteTableOperationsResponse) Reset()         { *m = ListRouteTableOperationsResponse{} }
func (m *ListRouteTableOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListRouteTableOperationsResponse) ProtoMessage()    {}
func (*ListRouteTableOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_route_table_service_18dbfac795d82b53, []int{10}
}
func (m *ListRouteTableOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRouteTableOperationsResponse.Unmarshal(m, b)
}
func (m *ListRouteTableOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRouteTableOperationsResponse.Marshal(b, m, deterministic)
}
func (dst *ListRouteTableOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRouteTableOperationsResponse.Merge(dst, src)
}
func (m *ListRouteTableOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListRouteTableOperationsResponse.Size(m)
}
func (m *ListRouteTableOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRouteTableOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListRouteTableOperationsResponse proto.InternalMessageInfo

func (m *ListRouteTableOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListRouteTableOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetRouteTableRequest)(nil), "yandex.cloud.vpc.v1.GetRouteTableRequest")
	proto.RegisterType((*ListRouteTablesRequest)(nil), "yandex.cloud.vpc.v1.ListRouteTablesRequest")
	proto.RegisterType((*ListRouteTablesResponse)(nil), "yandex.cloud.vpc.v1.ListRouteTablesResponse")
	proto.RegisterType((*CreateRouteTableRequest)(nil), "yandex.cloud.vpc.v1.CreateRouteTableRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.vpc.v1.CreateRouteTableRequest.LabelsEntry")
	proto.RegisterType((*CreateRouteTableMetadata)(nil), "yandex.cloud.vpc.v1.CreateRouteTableMetadata")
	proto.RegisterType((*UpdateRouteTableRequest)(nil), "yandex.cloud.vpc.v1.UpdateRouteTableRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.vpc.v1.UpdateRouteTableRequest.LabelsEntry")
	proto.RegisterType((*UpdateRouteTableMetadata)(nil), "yandex.cloud.vpc.v1.UpdateRouteTableMetadata")
	proto.RegisterType((*DeleteRouteTableRequest)(nil), "yandex.cloud.vpc.v1.DeleteRouteTableRequest")
	proto.RegisterType((*DeleteRouteTableMetadata)(nil), "yandex.cloud.vpc.v1.DeleteRouteTableMetadata")
	proto.RegisterType((*ListRouteTableOperationsRequest)(nil), "yandex.cloud.vpc.v1.ListRouteTableOperationsRequest")
	proto.RegisterType((*ListRouteTableOperationsResponse)(nil), "yandex.cloud.vpc.v1.ListRouteTableOperationsResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// RouteTableServiceClient is the client API for RouteTableService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RouteTableServiceClient interface {
	// Returns the specified RouteTable resource.
	//
	// To get the list of available RouteTable resources, make a [List] request.
	Get(ctx context.Context, in *GetRouteTableRequest, opts ...grpc.CallOption) (*RouteTable, error)
	// Retrieves the list of RouteTable resources in the specified folder.
	List(ctx context.Context, in *ListRouteTablesRequest, opts ...grpc.CallOption) (*ListRouteTablesResponse, error)
	// Creates a route table in the specified folder and network.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Create(ctx context.Context, in *CreateRouteTableRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified route table.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Update(ctx context.Context, in *UpdateRouteTableRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified route table.
	Delete(ctx context.Context, in *DeleteRouteTableRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// List operations for the specified route table.
	ListOperations(ctx context.Context, in *ListRouteTableOperationsRequest, opts ...grpc.CallOption) (*ListRouteTableOperationsResponse, error)
}

type routeTableServiceClient struct {
	cc *grpc.ClientConn
}

func NewRouteTableServiceClient(cc *grpc.ClientConn) RouteTableServiceClient {
	return &routeTableServiceClient{cc}
}

func (c *routeTableServiceClient) Get(ctx context.Context, in *GetRouteTableRequest, opts ...grpc.CallOption) (*RouteTable, error) {
	out := new(RouteTable)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.RouteTableService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *routeTableServiceClient) List(ctx context.Context, in *ListRouteTablesRequest, opts ...grpc.CallOption) (*ListRouteTablesResponse, error) {
	out := new(ListRouteTablesResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.RouteTableService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *routeTableServiceClient) Create(ctx context.Context, in *CreateRouteTableRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.RouteTableService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *routeTableServiceClient) Update(ctx context.Context, in *UpdateRouteTableRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.RouteTableService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *routeTableServiceClient) Delete(ctx context.Context, in *DeleteRouteTableRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.RouteTableService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *routeTableServiceClient) ListOperations(ctx context.Context, in *ListRouteTableOperationsRequest, opts ...grpc.CallOption) (*ListRouteTableOperationsResponse, error) {
	out := new(ListRouteTableOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.RouteTableService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RouteTableServiceServer is the server API for RouteTableService service.
type RouteTableServiceServer interface {
	// Returns the specified RouteTable resource.
	//
	// To get the list of available RouteTable resources, make a [List] request.
	Get(context.Context, *GetRouteTableRequest) (*RouteTable, error)
	// Retrieves the list of RouteTable resources in the specified folder.
	List(context.Context, *ListRouteTablesRequest) (*ListRouteTablesResponse, error)
	// Creates a route table in the specified folder and network.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Create(context.Context, *CreateRouteTableRequest) (*operation.Operation, error)
	// Updates the specified route table.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Update(context.Context, *UpdateRouteTableRequest) (*operation.Operation, error)
	// Deletes the specified route table.
	Delete(context.Context, *DeleteRouteTableRequest) (*operation.Operation, error)
	// List operations for the specified route table.
	ListOperations(context.Context, *ListRouteTableOperationsRequest) (*ListRouteTableOperationsResponse, error)
}

func RegisterRouteTableServiceServer(s *grpc.Server, srv RouteTableServiceServer) {
	s.RegisterService(&_RouteTableService_serviceDesc, srv)
}

func _RouteTableService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRouteTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RouteTableServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.RouteTableService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RouteTableServiceServer).Get(ctx, req.(*GetRouteTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RouteTableService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRouteTablesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RouteTableServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.RouteTableService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RouteTableServiceServer).List(ctx, req.(*ListRouteTablesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RouteTableService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRouteTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RouteTableServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.RouteTableService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RouteTableServiceServer).Create(ctx, req.(*CreateRouteTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RouteTableService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRouteTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RouteTableServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.RouteTableService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RouteTableServiceServer).Update(ctx, req.(*UpdateRouteTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RouteTableService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRouteTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RouteTableServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.RouteTableService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RouteTableServiceServer).Delete(ctx, req.(*DeleteRouteTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RouteTableService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRouteTableOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RouteTableServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.RouteTableService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RouteTableServiceServer).ListOperations(ctx, req.(*ListRouteTableOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RouteTableService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.vpc.v1.RouteTableService",
	HandlerType: (*RouteTableServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _RouteTableService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _RouteTableService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _RouteTableService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _RouteTableService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _RouteTableService_Delete_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _RouteTableService_ListOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/vpc/v1/route_table_service.proto",
}

func init() {
	proto.RegisterFile("yandex/cloud/vpc/v1/route_table_service.proto", fileDescriptor_route_table_service_18dbfac795d82b53)
}

var fileDescriptor_route_table_service_18dbfac795d82b53 = []byte{
	// 1036 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x57, 0xcf, 0x6f, 0x1b, 0xc5,
	0x17, 0xd7, 0xc6, 0x8e, 0xbf, 0xf5, 0x73, 0xda, 0x6f, 0x99, 0xb6, 0xc4, 0x5a, 0xa8, 0xea, 0xae,
	0x4a, 0x48, 0x9c, 0xec, 0xae, 0xd7, 0x6d, 0x42, 0xd3, 0x34, 0x02, 0x0c, 0xa1, 0x04, 0x35, 0x02,
	0x6d, 0xca, 0x01, 0xa2, 0xca, 0x1a, 0x7b, 0x27, 0x66, 0xe5, 0xcd, 0xee, 0xb2, 0xb3, 0x36, 0x4d,
	0x4a, 0x41, 0xaa, 0xe0, 0x12, 0x89, 0x03, 0xe2, 0x4f, 0xe0, 0xc2, 0x39, 0x42, 0x1c, 0x10, 0xf7,
	0xe4, 0x5c, 0xfe, 0x05, 0x0e, 0x20, 0x6e, 0x3d, 0x72, 0x42, 0x33, 0xb3, 0xfe, 0x99, 0x75, 0xb2,
	0xa6, 0x45, 0xe2, 0xb6, 0xe3, 0xf7, 0x23, 0x9f, 0xf7, 0x99, 0xcf, 0x7b, 0x6f, 0x02, 0xea, 0x2e,
	0x76, 0x2d, 0xf2, 0x40, 0xaf, 0x3b, 0x5e, 0xcb, 0xd2, 0xdb, 0x7e, 0x5d, 0x6f, 0x1b, 0x7a, 0xe0,
	0xb5, 0x42, 0x52, 0x0d, 0x71, 0xcd, 0x21, 0x55, 0x4a, 0x82, 0xb6, 0x5d, 0x27, 0x9a, 0x1f, 0x78,
	0xa1, 0x87, 0x2e, 0x08, 0x77, 0x8d, 0xbb, 0x6b, 0x6d, 0xbf, 0xae, 0xb5, 0x0d, 0xf9, 0xe5, 0x86,
	0xe7, 0x35, 0x1c, 0xa2, 0x63, 0xdf, 0xd6, 0xb1, 0xeb, 0x7a, 0x21, 0x0e, 0x6d, 0xcf, 0xa5, 0x22,
	0x44, 0x2e, 0x44, 0x56, 0x7e, 0xaa, 0xb5, 0xb6, 0xf5, 0x6d, 0x9b, 0x38, 0x56, 0x75, 0x07, 0xd3,
	0x66, 0xe4, 0x21, 0x47, 0x18, 0x58, 0xbc, 0xe7, 0x93, 0x80, 0x87, 0x47, 0xb6, 0x57, 0x4e, 0xc1,
	0x17, 0xb9, 0xcd, 0x0c, 0xb8, 0x75, 0x93, 0x1c, 0x4b, 0x77, 0x79, 0x30, 0x1d, 0x76, 0x6c, 0xab,
	0xcf, 0xac, 0xbc, 0x07, 0x17, 0xef, 0x90, 0xd0, 0x64, 0xe9, 0xef, 0xb1, 0xec, 0x26, 0xf9, 0xb4,
	0x45, 0x68, 0x88, 0xca, 0x70, 0xae, 0x9f, 0x13, 0xdb, 0xca, 0x4b, 0x05, 0x69, 0x36, 0x5b, 0x99,
	0xfa, 0xfd, 0xd0, 0x90, 0xf6, 0x8f, 0x8c, 0xf4, 0xed, 0xd5, 0xc5, 0x92, 0x39, 0x15, 0x74, 0x03,
	0xd7, 0x2d, 0xe5, 0x67, 0x09, 0x5e, 0xbc, 0x6b, 0xd3, 0xbe, 0x6c, 0xb4, 0x93, 0x6e, 0x0e, 0xb2,
	0xdb, 0x9e, 0x63, 0x91, 0x60, 0x54, 0xa6, 0x33, 0xc2, 0xbc, 0x6e, 0xa1, 0x57, 0x21, 0xeb, 0xe3,
	0x06, 0xa9, 0x52, 0x7b, 0x8f, 0xe4, 0x27, 0x0a, 0xd2, 0x6c, 0xaa, 0x02, 0x7f, 0x1d, 0x1a, 0x99,
	0xdb, 0xab, 0x46, 0xa9, 0x54, 0x32, 0xcf, 0x30, 0xe3, 0xa6, 0xbd, 0x47, 0xd0, 0x2c, 0x00, 0x77,
	0x0c, 0xbd, 0x26, 0x71, 0xf3, 0x29, 0x9e, 0x34, 0xbb, 0x7f, 0x64, 0x4c, 0x72, 0x4f, 0x93, 0x67,
	0xb9, 0xc7, 0x6c, 0x48, 0x81, 0xcc, 0xb6, 0xed, 0x84, 0x24, 0xc8, 0xa7, 0xb9, 0x17, 0xec, 0x1f,
	0x75, 0xf3, 0x45, 0x16, 0xe5, 0x6b, 0x09, 0xa6, 0x8f, 0x81, 0xa7, 0xbe, 0xe7, 0x52, 0x82, 0x2a,
	0x30, 0xd5, 0x47, 0x06, 0xcd, 0x4b, 0x85, 0xd4, 0x6c, 0xae, 0x7c, 0x45, 0x8b, 0x91, 0x86, 0xd6,
	0x47, 0x65, 0xae, 0xc7, 0x0e, 0x45, 0x33, 0xf0, 0x7f, 0x97, 0x3c, 0x08, 0xab, 0x7d, 0x90, 0x59,
	0x71, 0x59, 0xf3, 0x2c, 0xfb, 0xf9, 0x83, 0x0e, 0x56, 0xe5, 0xcf, 0x14, 0x4c, 0xbf, 0x15, 0x10,
	0x1c, 0x92, 0xe3, 0x97, 0x32, 0x06, 0x8b, 0x8b, 0x90, 0x76, 0xf1, 0x8e, 0x20, 0x30, 0x5b, 0xb9,
	0xfa, 0xf4, 0xd0, 0xb8, 0xfc, 0xf9, 0x16, 0x56, 0xf7, 0xee, 0x6f, 0xa9, 0x58, 0xdd, 0x2b, 0xa9,
	0xcb, 0xf7, 0x1f, 0x1a, 0x0b, 0x4b, 0xc6, 0xa3, 0xad, 0xe8, 0x64, 0x72, 0x77, 0x34, 0x0f, 0x39,
	0x8b, 0xd0, 0x7a, 0x60, 0xfb, 0x4c, 0x23, 0x83, 0xa4, 0x96, 0x17, 0x97, 0xcc, 0x7e, 0x2b, 0xfa,
	0x56, 0x82, 0x8c, 0x83, 0x6b, 0xc4, 0xa1, 0xf9, 0x34, 0x67, 0xe4, 0x66, 0x2c, 0x23, 0x23, 0xaa,
	0xd1, 0xee, 0xf2, 0xd0, 0x35, 0x37, 0x0c, 0x76, 0x2b, 0xaf, 0x3f, 0x3d, 0x34, 0x72, 0x5b, 0x6a,
	0xb5, 0xa4, 0x2e, 0x33, 0x90, 0xc5, 0xc7, 0xbc, 0xa2, 0xa5, 0x1b, 0xa2, 0xb2, 0xa5, 0xeb, 0x07,
	0x47, 0x46, 0x46, 0x4e, 0x1b, 0x2a, 0xff, 0x42, 0xe8, 0x7c, 0x54, 0x4a, 0xd7, 0xdf, 0x8c, 0x80,
	0xa0, 0x79, 0x00, 0x97, 0x84, 0x9f, 0x79, 0x41, 0x93, 0x71, 0x34, 0x19, 0xc3, 0x51, 0x36, 0xb2,
	0xaf, 0x5b, 0x68, 0x0d, 0xce, 0x52, 0xd6, 0xba, 0xf5, 0x2a, 0xbf, 0x29, 0x9a, 0xcf, 0xf0, 0x32,
	0x0a, 0xb1, 0x65, 0x6c, 0x72, 0x4f, 0x5e, 0x86, 0x39, 0x45, 0x7b, 0x07, 0x2a, 0x2f, 0x43, 0xae,
	0xaf, 0x16, 0x74, 0x1e, 0x52, 0x4d, 0xb2, 0x2b, 0xee, 0xc7, 0x64, 0x9f, 0xe8, 0x22, 0x4c, 0xb6,
	0xb1, 0xd3, 0x8a, 0x6e, 0xc3, 0x14, 0x87, 0x5b, 0x13, 0x37, 0x25, 0xe5, 0x0d, 0xc8, 0x0f, 0xd3,
	0xb3, 0x41, 0x42, 0x6c, 0xe1, 0x10, 0xa3, 0x6b, 0xf1, 0x2d, 0x38, 0xd4, 0x74, 0x5f, 0xa5, 0x61,
	0xfa, 0x43, 0xdf, 0x8a, 0xd5, 0xcb, 0x3f, 0x68, 0x62, 0xb4, 0x02, 0xb9, 0x16, 0x4f, 0xc7, 0xe7,
	0x15, 0x47, 0x9c, 0x2b, 0xcb, 0x9a, 0x18, 0x69, 0x5a, 0x67, 0xa4, 0x69, 0xef, 0xb0, 0x91, 0xb6,
	0x81, 0x69, 0xd3, 0x04, 0xe1, 0xce, 0xbe, 0xbb, 0xaa, 0x4b, 0x3d, 0x93, 0xea, 0xd2, 0x49, 0x55,
	0x37, 0x79, 0x82, 0xea, 0x46, 0x70, 0xf2, 0xef, 0xa8, 0xee, 0x3f, 0x21, 0xa4, 0xe1, 0x8a, 0xc7,
	0x14, 0xd2, 0x06, 0x4c, 0xbf, 0x4d, 0x1c, 0xf2, 0x9c, 0x74, 0xc4, 0x00, 0x0d, 0xa7, 0x1b, 0x13,
	0xd0, 0x0f, 0x12, 0x5c, 0x19, 0x9c, 0xc8, 0xef, 0x77, 0x76, 0x1b, 0x7d, 0x16, 0x85, 0x3f, 0xff,
	0x05, 0xa3, 0x7c, 0x23, 0x41, 0x61, 0x34, 0xd4, 0x68, 0x8b, 0xbc, 0x09, 0xd0, 0x5d, 0xce, 0x9d,
	0x1d, 0x72, 0x75, 0x50, 0x21, 0xbd, 0xe5, 0xdd, 0x8d, 0x37, 0xfb, 0x82, 0x92, 0x2e, 0x91, 0xf2,
	0x1f, 0xff, 0x83, 0x17, 0x7a, 0x58, 0x36, 0xc5, 0x83, 0x06, 0x7d, 0x09, 0xa9, 0x3b, 0x24, 0x44,
	0x73, 0xb1, 0xaa, 0x8c, 0x7b, 0x05, 0xc8, 0xa7, 0xad, 0x38, 0x65, 0xe1, 0xf1, 0xaf, 0xbf, 0x7d,
	0x37, 0x31, 0x83, 0xae, 0x0d, 0x3c, 0x54, 0xc4, 0xca, 0xd3, 0x1f, 0x0e, 0x5e, 0xcd, 0x23, 0xf4,
	0x05, 0xa4, 0x19, 0x4b, 0x68, 0x3e, 0x36, 0x6d, 0xfc, 0xd3, 0x41, 0x5e, 0x48, 0xe6, 0x2c, 0x48,
	0x56, 0x5e, 0xe2, 0x80, 0x2e, 0xa1, 0x0b, 0x31, 0x80, 0xd0, 0xf7, 0x12, 0x64, 0xc4, 0xb8, 0x45,
	0x0b, 0xe3, 0xac, 0x2a, 0xf9, 0xf4, 0x6b, 0x52, 0xde, 0x3d, 0x78, 0x52, 0x9c, 0x39, 0x61, 0x9a,
	0x43, 0xef, 0x37, 0x0e, 0x31, 0xaf, 0xc4, 0x41, 0xbc, 0x25, 0x15, 0xd1, 0x8f, 0x12, 0x64, 0x44,
	0x2f, 0x8f, 0x40, 0x39, 0x62, 0xb4, 0x25, 0x41, 0xf9, 0x91, 0x40, 0x39, 0x72, 0x54, 0x0c, 0xa3,
	0x9c, 0x2b, 0x27, 0xba, 0x59, 0x06, 0xfb, 0x17, 0x09, 0x32, 0xa2, 0xe3, 0x47, 0xc0, 0x1e, 0x31,
	0x5d, 0x92, 0xc0, 0xc6, 0x07, 0x4f, 0x8a, 0xc6, 0x09, 0x03, 0xe5, 0xd2, 0xf0, 0x7a, 0x5a, 0xdb,
	0xf1, 0xc3, 0x5d, 0xa1, 0xcd, 0x62, 0x32, 0x6d, 0xfe, 0x24, 0xc1, 0x39, 0x26, 0xaa, 0x5e, 0xe3,
	0xa2, 0x1b, 0x09, 0x94, 0x77, 0x6c, 0x24, 0xc9, 0x8b, 0x63, 0x46, 0x45, 0xc2, 0x7d, 0x8d, 0xa3,
	0x35, 0x90, 0x9e, 0x04, 0x6d, 0xef, 0x95, 0x4f, 0x2b, 0xab, 0x1f, 0xaf, 0x34, 0xec, 0xf0, 0x93,
	0x56, 0x4d, 0xab, 0x7b, 0x3b, 0xba, 0xf8, 0xdb, 0xaa, 0x78, 0xed, 0x37, 0x3c, 0xb5, 0x41, 0x5c,
	0x4e, 0x8a, 0x1e, 0xf3, 0x5f, 0xc5, 0x4a, 0xdb, 0xaf, 0xd7, 0x32, 0xdc, 0x7c, 0xfd, 0xef, 0x00,
	0x00, 0x00, 0xff, 0xff, 0x80, 0x29, 0xd2, 0x08, 0x17, 0x0d, 0x00, 0x00,
}
