---
layout: guides
sidebar_current: guides-packer-on-cicd-trigger-tfe-run
page_title: Trigger Terraform Enterprise runs
---

# Create Terraform Enterprise Runs

Once an image is built and uploaded to an artifact store, the next step is to
use this new image. In some cases the image will be downloaded by the dev team
and used locally in development, like is often done with VirtualBox images with
Vagrant. In most other cases, the new image will be used to provision new
infrastructure.

[Terraform](https://www.terraform.io/) is an open source tool that is ideal for
provisioning new infrastructure with images generated by Packer, and [Terraform
Enterprise](https://www.hashicorp.com/products/terraform/) is the best way to
perform automated Terraform runs.

## Create a Terraform Configuration and Workspace

The following is a sample Terraform configuration which provisions a new AWS
EC2 instance.  The `aws_ami_id` is a variable which will be provided when
running `terraform plan` and `terraform apply`. This variable references the
latest AMI generated with the Packer build in CI/CD.

```hcl
variable "aws_ami_id" { }

provider "aws" {
  region = "us-west-2"
}

resource "aws_instance" "web" {
  ami           = "${var.aws_ami_id}"
  instance_type = "t2.micro"
}
```

Terraform Enterprise should have a workspace with this terraform configuration
and a placeholder variable `aws_ami_id`.

## Include Terraform Enterprise in Your CI Builds

Follow these steps to create a new run from CI/CD after a Packer build is
complete and uploaded.

1. Add a new step to the CI/CD pipeline.
2. In the new step add a `curl` call to update the variables in the workspace
   using the [update variables
   API](https://www.terraform.io/docs/enterprise/api/variables.html#update-variables),
   so that Terraform has a reference to the latest image. For the sample
   configuration above, the `aws_ami_id` variable should be updated to the AMI
   ID of the latest image.
3. In that same step, add another `curl` call to [create a new run via the
   API](https://www.terraform.io/docs/enterprise/api/run.html#create-a-run).
   A run performs a plan and apply on the last configuration version created,
   using the variables set in the workspace. In the previous step we update the
   variables, so the new run can be created using the previous configuration
   version.
