#include <tuple>

namespace Ubpa::Nested {
	template<typename T> // template
	struct [[size(sizeof(T))]] /*compile-time attr*/ Vec {
		// default constructor
		Vec() : x{ 0.f }, y{ 0.f } {}
		// overload constructor
		Vec(T x, T y) : x{ x }, y{ y } {}
		// destructor
		~Vec() {}

		[[not_serialize]] // non-value attr
		T x;
		[[info("hello"), maximum(10.f)]] // attr list
		T y;
		// static member variable
		inline static size_t num{ 0 };

		// non-static member function
		float Sum() const {
			return x + y;
		}
		// overload function, default value
		float Sum(float z = 1.f) const {
			return x + y + z;
		}

		// static member function
		static T Dot(const Vec& lhs, const Vec& rhs) {
			return lhs.x * rhs.x + lhs.y * rhs.y;
		}
	};
}

// CMake will generate this file before building
// it contains the reflection declaration of Vec
#include "Vec_AutoRefl.inl"
/*
// This file is generated by Ubpa::USRefl::AutoRefl

#pragma once

#include <USRefl/USRefl.h>

template<typename T>
struct Ubpa::USRefl::TypeInfo<Vec<T>>
	: Ubpa::USRefl::TypeInfoBase<Vec<T>>
{
	static constexpr AttrList attrs = {
		Attr{"size", sizeof(T)},
	};

	static constexpr FieldList fields = {
		Field{"x", &Vec<T>::x,
			AttrList{
				Attr{"not_serialize"},
			}
		},
		Field{"y", &Vec<T>::y,
			AttrList{
				Attr{"info", "hello"},
				Attr{"maximum", 10.f},
			}
		},
		Field{"num", &Vec<T>::num},
		Field{"__constructor", WrapConstructor<Vec<T>()>()},
		Field{"__constructor", WrapConstructor<Vec<T>(T, T)>(),
			AttrList {
				Attr{"__arg_0",
					AttrList{
						Attr{"__name", "x"},
					}
				},
				Attr{"__arg_1",
					AttrList{
						Attr{"__name", "y"},
					}
				},
			}
		},
		Field{"__destructor", WrapDestructor<Vec<T>>()},
		Field{"Sum", static_cast<float(Vec<T>::*)()const>(&Vec<T>::Sum)},
		Field{"Sum", static_cast<float(Vec<T>::*)(float)const>(&Vec<T>::Sum),
			AttrList {
				Attr{"__arg_0",
					AttrList{
						Attr{"__name", "z"},
						Attr{"__default_value", 1.f},
					}
				},
			}
		},
		Field{"Dot", &Vec<T>::Dot,
			AttrList {
				Attr{"__arg_0",
					AttrList{
						Attr{"__name", "lhs"},
					}
				},
				Attr{"__arg_1",
					AttrList{
						Attr{"__name", "rhs"},
					}
				},
			}
		},
	};
};
*/
