#include <USRefl/USRefl.h>

// Vec's definition
// and Vec's reflection declaration (Vec_AutoRefl.inl, generated by CMake before building)
#include "Vec.h"

using namespace Ubpa::Nested;

#include <iostream>

using namespace Ubpa::USRefl;
using namespace std;

int main() {
	cout << TypeInfo<Vec<float>>::name << endl;

	TypeInfo<Vec<float>>::fields.ForEach([](auto field) {
		cout << field.name << endl;
	});

	constexpr auto y_idx = TypeInfo<Vec<float>>::fields.Find("y");
	constexpr auto y_field = TypeInfo<Vec<float>>::fields.Get<y_idx>();
	static_assert(y_field.name == "y");

	static_assert(TypeInfo<Vec<float>>::fields.Contains("x"));

	TypeInfo<Vec<float>>::attrs.ForEach([](auto attr) {
		cout << "name  : " << attr.name << endl;
		if constexpr (!attr.has_value)
			cout << "value : " << attr.value << endl;
	});

	TypeInfo<Vec<float>>::ForEachVarOf(Vec<float>{ 1,2 }, [](auto&& var) {
		cout << var << endl;
	});
}
