// line 1 "raw.rl"
// GO SOURCE FILE MACHINE GENERATED BY RAGEL; DO NOT EDIT

// Copyright 2014 The Cayley Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package nquads

import (
	"fmt"
	"unicode"

	"github.com/cayleygraph/cayley/quad"
)

// line 30 "raw.go"
const raw_start int = 1
const raw_first_final int = 88
const raw_error int = 0

const raw_en_statement int = 1

// line 117 "raw.rl"

// ParseRaw returns a valid quad.Quad or a non-nil error. ParseRaw does
// handle comments except where the comment placement does not prevent
// a complete valid quad.Quad from being defined.
func ParseRaw(statement string) (quad.Quad, error) {
	data := []rune(statement)

	var (
		cs, p int
		pe    = len(data)
		eof   = pe

		subject   = -1
		predicate = -1
		object    = -1
		label     = -1

		isEscaped bool

		q quad.Quad
	)

	// line 63 "raw.go"
	{
		cs = raw_start
	}

	// line 141 "raw.rl"

	// line 71 "raw.go"
	{
		if p == pe {
			goto _test_eof
		}
		switch cs {
		case 1:
			goto st_case_1
		case 0:
			goto st_case_0
		case 2:
			goto st_case_2
		case 3:
			goto st_case_3
		case 4:
			goto st_case_4
		case 5:
			goto st_case_5
		case 6:
			goto st_case_6
		case 7:
			goto st_case_7
		case 8:
			goto st_case_8
		case 9:
			goto st_case_9
		case 10:
			goto st_case_10
		case 88:
			goto st_case_88
		case 89:
			goto st_case_89
		case 11:
			goto st_case_11
		case 12:
			goto st_case_12
		case 13:
			goto st_case_13
		case 14:
			goto st_case_14
		case 15:
			goto st_case_15
		case 16:
			goto st_case_16
		case 17:
			goto st_case_17
		case 18:
			goto st_case_18
		case 19:
			goto st_case_19
		case 20:
			goto st_case_20
		case 21:
			goto st_case_21
		case 22:
			goto st_case_22
		case 23:
			goto st_case_23
		case 24:
			goto st_case_24
		case 25:
			goto st_case_25
		case 26:
			goto st_case_26
		case 90:
			goto st_case_90
		case 27:
			goto st_case_27
		case 28:
			goto st_case_28
		case 29:
			goto st_case_29
		case 30:
			goto st_case_30
		case 31:
			goto st_case_31
		case 32:
			goto st_case_32
		case 33:
			goto st_case_33
		case 34:
			goto st_case_34
		case 35:
			goto st_case_35
		case 36:
			goto st_case_36
		case 37:
			goto st_case_37
		case 38:
			goto st_case_38
		case 39:
			goto st_case_39
		case 40:
			goto st_case_40
		case 41:
			goto st_case_41
		case 42:
			goto st_case_42
		case 43:
			goto st_case_43
		case 44:
			goto st_case_44
		case 45:
			goto st_case_45
		case 46:
			goto st_case_46
		case 47:
			goto st_case_47
		case 48:
			goto st_case_48
		case 49:
			goto st_case_49
		case 50:
			goto st_case_50
		case 51:
			goto st_case_51
		case 52:
			goto st_case_52
		case 53:
			goto st_case_53
		case 54:
			goto st_case_54
		case 55:
			goto st_case_55
		case 56:
			goto st_case_56
		case 57:
			goto st_case_57
		case 58:
			goto st_case_58
		case 91:
			goto st_case_91
		case 59:
			goto st_case_59
		case 60:
			goto st_case_60
		case 61:
			goto st_case_61
		case 62:
			goto st_case_62
		case 92:
			goto st_case_92
		case 63:
			goto st_case_63
		case 64:
			goto st_case_64
		case 65:
			goto st_case_65
		case 66:
			goto st_case_66
		case 67:
			goto st_case_67
		case 68:
			goto st_case_68
		case 69:
			goto st_case_69
		case 70:
			goto st_case_70
		case 71:
			goto st_case_71
		case 72:
			goto st_case_72
		case 73:
			goto st_case_73
		case 74:
			goto st_case_74
		case 75:
			goto st_case_75
		case 76:
			goto st_case_76
		case 77:
			goto st_case_77
		case 78:
			goto st_case_78
		case 79:
			goto st_case_79
		case 80:
			goto st_case_80
		case 81:
			goto st_case_81
		case 82:
			goto st_case_82
		case 83:
			goto st_case_83
		case 84:
			goto st_case_84
		case 85:
			goto st_case_85
		case 86:
			goto st_case_86
		case 87:
			goto st_case_87
		}
		goto st_out
	st1:
		if p++; p == pe {
			goto _test_eof1
		}
	st_case_1:
		switch data[p] {
		case 9:
			goto st1
		case 32:
			goto st1
		case 60:
			goto tr2
		case 95:
			goto tr3
		}
		goto tr0
	tr0:
		// line 88 "raw.rl"

		if p < len(data) {
			if r := data[p]; r < unicode.MaxASCII {
				return q, fmt.Errorf("%v: unexpected rune %q at %d", quad.ErrInvalid, data[p], p)
			} else {
				return q, fmt.Errorf("%v: unexpected rune %q (\\u%04x) at %d", quad.ErrInvalid, data[p], data[p], p)
			}
		}
		return q, quad.ErrIncomplete

		goto st0
		// line 295 "raw.go"
	st_case_0:
	st0:
		cs = 0
		goto _out
	tr2:
		// line 33 "raw.rl"

		subject = p

		goto st2
	tr120:
		// line 29 "raw.rl"

		isEscaped = true

		goto st2
	st2:
		if p++; p == pe {
			goto _test_eof2
		}
	st_case_2:
		// line 319 "raw.go"
		switch data[p] {
		case 33:
			goto st2
		case 62:
			goto st3
		case 92:
			goto st74
		case 95:
			goto st2
		case 126:
			goto st2
		}
		switch {
		case data[p] < 61:
			if 35 <= data[p] && data[p] <= 59 {
				goto st2
			}
		case data[p] > 93:
			switch {
			case data[p] > 122:
				if 128 <= data[p] && data[p] <= 1114111 {
					goto st2
				}
			case data[p] >= 97:
				goto st2
			}
		default:
			goto st2
		}
		goto tr0
	tr121:
		// line 29 "raw.rl"

		isEscaped = true

		goto st3
	st3:
		if p++; p == pe {
			goto _test_eof3
		}
	st_case_3:
		// line 362 "raw.go"
		switch data[p] {
		case 9:
			goto tr7
		case 32:
			goto tr7
		case 60:
			goto tr8
		}
		goto tr0
	tr7:
		// line 49 "raw.rl"

		if subject < 0 {
			panic("unexpected parser state: subject start not set")
		}
		q.Subject = unEscapeRaw(data[subject:p], isEscaped)
		isEscaped = false

		goto st4
	st4:
		if p++; p == pe {
			goto _test_eof4
		}
	st_case_4:
		// line 388 "raw.go"
		switch data[p] {
		case 9:
			goto st4
		case 32:
			goto st4
		case 60:
			goto tr10
		}
		goto tr0
	tr8:
		// line 49 "raw.rl"

		if subject < 0 {
			panic("unexpected parser state: subject start not set")
		}
		q.Subject = unEscapeRaw(data[subject:p], isEscaped)
		isEscaped = false

		// line 37 "raw.rl"

		predicate = p

		goto st5
	tr10:
		// line 37 "raw.rl"

		predicate = p

		goto st5
	tr108:
		// line 29 "raw.rl"

		isEscaped = true

		goto st5
	st5:
		if p++; p == pe {
			goto _test_eof5
		}
	st_case_5:
		// line 433 "raw.go"
		switch data[p] {
		case 33:
			goto st5
		case 62:
			goto st6
		case 92:
			goto st64
		case 95:
			goto st5
		case 126:
			goto st5
		}
		switch {
		case data[p] < 61:
			if 35 <= data[p] && data[p] <= 59 {
				goto st5
			}
		case data[p] > 93:
			switch {
			case data[p] > 122:
				if 128 <= data[p] && data[p] <= 1114111 {
					goto st5
				}
			case data[p] >= 97:
				goto st5
			}
		default:
			goto st5
		}
		goto tr0
	tr109:
		// line 29 "raw.rl"

		isEscaped = true

		goto st6
	st6:
		if p++; p == pe {
			goto _test_eof6
		}
	st_case_6:
		// line 476 "raw.go"
		switch data[p] {
		case 9:
			goto tr14
		case 32:
			goto tr14
		case 34:
			goto tr15
		case 60:
			goto tr16
		case 95:
			goto tr17
		}
		goto tr0
	tr14:
		// line 57 "raw.rl"

		if predicate < 0 {
			panic("unexpected parser state: predicate start not set")
		}
		q.Predicate = unEscapeRaw(data[predicate:p], isEscaped)
		isEscaped = false

		goto st7
	st7:
		if p++; p == pe {
			goto _test_eof7
		}
	st_case_7:
		// line 506 "raw.go"
		switch data[p] {
		case 9:
			goto st7
		case 32:
			goto st7
		case 34:
			goto tr19
		case 60:
			goto tr20
		case 95:
			goto tr21
		}
		goto tr0
	tr15:
		// line 57 "raw.rl"

		if predicate < 0 {
			panic("unexpected parser state: predicate start not set")
		}
		q.Predicate = unEscapeRaw(data[predicate:p], isEscaped)
		isEscaped = false

		// line 41 "raw.rl"

		object = p

		goto st8
	tr19:
		// line 41 "raw.rl"

		object = p

		goto st8
	tr79:
		// line 29 "raw.rl"

		isEscaped = true

		goto st8
	st8:
		if p++; p == pe {
			goto _test_eof8
		}
	st_case_8:
		// line 555 "raw.go"
		switch data[p] {
		case 34:
			goto st9
		case 92:
			goto st46
		}
		switch {
		case data[p] < 11:
			if 0 <= data[p] && data[p] <= 9 {
				goto st8
			}
		case data[p] > 12:
			if 14 <= data[p] && data[p] <= 1114111 {
				goto st8
			}
		default:
			goto st8
		}
		goto tr0
	tr80:
		// line 29 "raw.rl"

		isEscaped = true

		goto st9
	st9:
		if p++; p == pe {
			goto _test_eof9
		}
	st_case_9:
		// line 587 "raw.go"
		switch data[p] {
		case 9:
			goto tr25
		case 32:
			goto tr25
		case 46:
			goto tr26
		case 60:
			goto tr27
		case 64:
			goto st28
		case 94:
			goto st32
		case 95:
			goto tr30
		}
		goto tr0
	tr25:
		// line 65 "raw.rl"

		if object < 0 {
			panic("unexpected parser state: object start not set")
		}
		q.Object = unEscapeRaw(data[object:p], isEscaped)
		isEscaped = false

		goto st10
	tr96:
		// line 65 "raw.rl"

		if object < 0 {
			panic("unexpected parser state: object start not set")
		}
		q.Object = unEscapeRaw(data[object:p], isEscaped)
		isEscaped = false

		// line 73 "raw.rl"

		if label < 0 {
			panic("unexpected parser state: label start not set")
		}
		q.Label = unEscapeRaw(data[label:p], isEscaped)
		isEscaped = false

		goto st10
	st10:
		if p++; p == pe {
			goto _test_eof10
		}
	st_case_10:
		// line 641 "raw.go"
		switch data[p] {
		case 9:
			goto st10
		case 32:
			goto st10
		case 46:
			goto st88
		case 60:
			goto tr33
		case 95:
			goto tr34
		}
		goto tr0
	tr26:
		// line 65 "raw.rl"

		if object < 0 {
			panic("unexpected parser state: object start not set")
		}
		q.Object = unEscapeRaw(data[object:p], isEscaped)
		isEscaped = false

		goto st88
	tr39:
		// line 73 "raw.rl"

		if label < 0 {
			panic("unexpected parser state: label start not set")
		}
		q.Label = unEscapeRaw(data[label:p], isEscaped)
		isEscaped = false

		goto st88
	st88:
		if p++; p == pe {
			goto _test_eof88
		}
	st_case_88:
		// line 682 "raw.go"
		switch data[p] {
		case 9:
			goto st88
		case 32:
			goto st88
		case 35:
			goto tr127
		}
		goto st0
	tr127:
		// line 85 "raw.rl"

		goto st89
	st89:
		if p++; p == pe {
			goto _test_eof89
		}
	st_case_89:
		// line 703 "raw.go"
		goto st89
	tr27:
		// line 65 "raw.rl"

		if object < 0 {
			panic("unexpected parser state: object start not set")
		}
		q.Object = unEscapeRaw(data[object:p], isEscaped)
		isEscaped = false

		// line 45 "raw.rl"

		label = p

		goto st11
	tr33:
		// line 45 "raw.rl"

		label = p

		goto st11
	tr50:
		// line 29 "raw.rl"

		isEscaped = true

		goto st11
	st11:
		if p++; p == pe {
			goto _test_eof11
		}
	st_case_11:
		// line 740 "raw.go"
		switch data[p] {
		case 33:
			goto st11
		case 62:
			goto st12
		case 92:
			goto st14
		case 95:
			goto st11
		case 126:
			goto st11
		}
		switch {
		case data[p] < 61:
			if 35 <= data[p] && data[p] <= 59 {
				goto st11
			}
		case data[p] > 93:
			switch {
			case data[p] > 122:
				if 128 <= data[p] && data[p] <= 1114111 {
					goto st11
				}
			case data[p] >= 97:
				goto st11
			}
		default:
			goto st11
		}
		goto tr0
	tr51:
		// line 29 "raw.rl"

		isEscaped = true

		goto st12
	st12:
		if p++; p == pe {
			goto _test_eof12
		}
	st_case_12:
		// line 783 "raw.go"
		switch data[p] {
		case 9:
			goto tr38
		case 32:
			goto tr38
		case 46:
			goto tr39
		}
		goto tr0
	tr38:
		// line 73 "raw.rl"

		if label < 0 {
			panic("unexpected parser state: label start not set")
		}
		q.Label = unEscapeRaw(data[label:p], isEscaped)
		isEscaped = false

		goto st13
	st13:
		if p++; p == pe {
			goto _test_eof13
		}
	st_case_13:
		// line 809 "raw.go"
		switch data[p] {
		case 9:
			goto st13
		case 32:
			goto st13
		case 46:
			goto st88
		}
		goto tr0
	tr52:
		// line 29 "raw.rl"

		isEscaped = true

		goto st14
	st14:
		if p++; p == pe {
			goto _test_eof14
		}
	st_case_14:
		// line 831 "raw.go"
		switch data[p] {
		case 85:
			goto st15
		case 117:
			goto st19
		}
		goto tr0
	st15:
		if p++; p == pe {
			goto _test_eof15
		}
	st_case_15:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st16
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st16
			}
		default:
			goto st16
		}
		goto tr0
	st16:
		if p++; p == pe {
			goto _test_eof16
		}
	st_case_16:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st17
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st17
			}
		default:
			goto st17
		}
		goto tr0
	st17:
		if p++; p == pe {
			goto _test_eof17
		}
	st_case_17:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st18
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st18
			}
		default:
			goto st18
		}
		goto tr0
	st18:
		if p++; p == pe {
			goto _test_eof18
		}
	st_case_18:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st19
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st19
			}
		default:
			goto st19
		}
		goto tr0
	st19:
		if p++; p == pe {
			goto _test_eof19
		}
	st_case_19:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st20
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st20
			}
		default:
			goto st20
		}
		goto tr0
	st20:
		if p++; p == pe {
			goto _test_eof20
		}
	st_case_20:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st21
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st21
			}
		default:
			goto st21
		}
		goto tr0
	st21:
		if p++; p == pe {
			goto _test_eof21
		}
	st_case_21:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st22
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st22
			}
		default:
			goto st22
		}
		goto tr0
	st22:
		if p++; p == pe {
			goto _test_eof22
		}
	st_case_22:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st23
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st23
			}
		default:
			goto st23
		}
		goto tr0
	st23:
		if p++; p == pe {
			goto _test_eof23
		}
	st_case_23:
		switch data[p] {
		case 33:
			goto tr50
		case 62:
			goto tr51
		case 92:
			goto tr52
		case 95:
			goto tr50
		case 126:
			goto tr50
		}
		switch {
		case data[p] < 61:
			if 35 <= data[p] && data[p] <= 59 {
				goto tr50
			}
		case data[p] > 93:
			switch {
			case data[p] > 122:
				if 128 <= data[p] && data[p] <= 1114111 {
					goto tr50
				}
			case data[p] >= 97:
				goto tr50
			}
		default:
			goto tr50
		}
		goto tr0
	tr30:
		// line 65 "raw.rl"

		if object < 0 {
			panic("unexpected parser state: object start not set")
		}
		q.Object = unEscapeRaw(data[object:p], isEscaped)
		isEscaped = false

		// line 45 "raw.rl"

		label = p

		goto st24
	tr34:
		// line 45 "raw.rl"

		label = p

		goto st24
	st24:
		if p++; p == pe {
			goto _test_eof24
		}
	st_case_24:
		// line 1046 "raw.go"
		if data[p] == 58 {
			goto st25
		}
		goto tr0
	st25:
		if p++; p == pe {
			goto _test_eof25
		}
	st_case_25:
		if data[p] == 95 {
			goto st26
		}
		switch {
		case data[p] < 895:
			switch {
			case data[p] < 192:
				switch {
				case data[p] < 65:
					if 48 <= data[p] && data[p] <= 58 {
						goto st26
					}
				case data[p] > 90:
					if 97 <= data[p] && data[p] <= 122 {
						goto st26
					}
				default:
					goto st26
				}
			case data[p] > 214:
				switch {
				case data[p] < 248:
					if 216 <= data[p] && data[p] <= 246 {
						goto st26
					}
				case data[p] > 767:
					if 880 <= data[p] && data[p] <= 893 {
						goto st26
					}
				default:
					goto st26
				}
			default:
				goto st26
			}
		case data[p] > 8191:
			switch {
			case data[p] < 12289:
				switch {
				case data[p] < 8304:
					if 8204 <= data[p] && data[p] <= 8205 {
						goto st26
					}
				case data[p] > 8591:
					if 11264 <= data[p] && data[p] <= 12271 {
						goto st26
					}
				default:
					goto st26
				}
			case data[p] > 55295:
				switch {
				case data[p] < 65008:
					if 63744 <= data[p] && data[p] <= 64975 {
						goto st26
					}
				case data[p] > 65533:
					if 65536 <= data[p] && data[p] <= 983039 {
						goto st26
					}
				default:
					goto st26
				}
			default:
				goto st26
			}
		default:
			goto st26
		}
		goto tr0
	st26:
		if p++; p == pe {
			goto _test_eof26
		}
	st_case_26:
		switch data[p] {
		case 9:
			goto tr38
		case 32:
			goto tr38
		case 45:
			goto st26
		case 46:
			goto tr55
		case 95:
			goto st26
		case 183:
			goto st26
		}
		switch {
		case data[p] < 8204:
			switch {
			case data[p] < 192:
				switch {
				case data[p] < 65:
					if 48 <= data[p] && data[p] <= 58 {
						goto st26
					}
				case data[p] > 90:
					if 97 <= data[p] && data[p] <= 122 {
						goto st26
					}
				default:
					goto st26
				}
			case data[p] > 214:
				switch {
				case data[p] < 248:
					if 216 <= data[p] && data[p] <= 246 {
						goto st26
					}
				case data[p] > 893:
					if 895 <= data[p] && data[p] <= 8191 {
						goto st26
					}
				default:
					goto st26
				}
			default:
				goto st26
			}
		case data[p] > 8205:
			switch {
			case data[p] < 12289:
				switch {
				case data[p] < 8304:
					if 8255 <= data[p] && data[p] <= 8256 {
						goto st26
					}
				case data[p] > 8591:
					if 11264 <= data[p] && data[p] <= 12271 {
						goto st26
					}
				default:
					goto st26
				}
			case data[p] > 55295:
				switch {
				case data[p] < 65008:
					if 63744 <= data[p] && data[p] <= 64975 {
						goto st26
					}
				case data[p] > 65533:
					if 65536 <= data[p] && data[p] <= 983039 {
						goto st26
					}
				default:
					goto st26
				}
			default:
				goto st26
			}
		default:
			goto st26
		}
		goto tr0
	tr55:
		// line 73 "raw.rl"

		if label < 0 {
			panic("unexpected parser state: label start not set")
		}
		q.Label = unEscapeRaw(data[label:p], isEscaped)
		isEscaped = false

		goto st90
	st90:
		if p++; p == pe {
			goto _test_eof90
		}
	st_case_90:
		// line 1228 "raw.go"
		switch data[p] {
		case 9:
			goto st88
		case 32:
			goto st88
		case 35:
			goto tr127
		case 45:
			goto st26
		case 46:
			goto st27
		case 95:
			goto st26
		case 183:
			goto st26
		}
		switch {
		case data[p] < 8204:
			switch {
			case data[p] < 192:
				switch {
				case data[p] < 65:
					if 48 <= data[p] && data[p] <= 58 {
						goto st26
					}
				case data[p] > 90:
					if 97 <= data[p] && data[p] <= 122 {
						goto st26
					}
				default:
					goto st26
				}
			case data[p] > 214:
				switch {
				case data[p] < 248:
					if 216 <= data[p] && data[p] <= 246 {
						goto st26
					}
				case data[p] > 893:
					if 895 <= data[p] && data[p] <= 8191 {
						goto st26
					}
				default:
					goto st26
				}
			default:
				goto st26
			}
		case data[p] > 8205:
			switch {
			case data[p] < 12289:
				switch {
				case data[p] < 8304:
					if 8255 <= data[p] && data[p] <= 8256 {
						goto st26
					}
				case data[p] > 8591:
					if 11264 <= data[p] && data[p] <= 12271 {
						goto st26
					}
				default:
					goto st26
				}
			case data[p] > 55295:
				switch {
				case data[p] < 65008:
					if 63744 <= data[p] && data[p] <= 64975 {
						goto st26
					}
				case data[p] > 65533:
					if 65536 <= data[p] && data[p] <= 983039 {
						goto st26
					}
				default:
					goto st26
				}
			default:
				goto st26
			}
		default:
			goto st26
		}
		goto st0
	st27:
		if p++; p == pe {
			goto _test_eof27
		}
	st_case_27:
		switch data[p] {
		case 45:
			goto st26
		case 46:
			goto st27
		case 95:
			goto st26
		case 183:
			goto st26
		}
		switch {
		case data[p] < 8204:
			switch {
			case data[p] < 192:
				switch {
				case data[p] < 65:
					if 48 <= data[p] && data[p] <= 58 {
						goto st26
					}
				case data[p] > 90:
					if 97 <= data[p] && data[p] <= 122 {
						goto st26
					}
				default:
					goto st26
				}
			case data[p] > 214:
				switch {
				case data[p] < 248:
					if 216 <= data[p] && data[p] <= 246 {
						goto st26
					}
				case data[p] > 893:
					if 895 <= data[p] && data[p] <= 8191 {
						goto st26
					}
				default:
					goto st26
				}
			default:
				goto st26
			}
		case data[p] > 8205:
			switch {
			case data[p] < 12289:
				switch {
				case data[p] < 8304:
					if 8255 <= data[p] && data[p] <= 8256 {
						goto st26
					}
				case data[p] > 8591:
					if 11264 <= data[p] && data[p] <= 12271 {
						goto st26
					}
				default:
					goto st26
				}
			case data[p] > 55295:
				switch {
				case data[p] < 65008:
					if 63744 <= data[p] && data[p] <= 64975 {
						goto st26
					}
				case data[p] > 65533:
					if 65536 <= data[p] && data[p] <= 983039 {
						goto st26
					}
				default:
					goto st26
				}
			default:
				goto st26
			}
		default:
			goto st26
		}
		goto tr0
	st28:
		if p++; p == pe {
			goto _test_eof28
		}
	st_case_28:
		switch {
		case data[p] > 90:
			if 97 <= data[p] && data[p] <= 122 {
				goto st29
			}
		case data[p] >= 65:
			goto st29
		}
		goto tr0
	st29:
		if p++; p == pe {
			goto _test_eof29
		}
	st_case_29:
		switch data[p] {
		case 9:
			goto tr25
		case 32:
			goto tr25
		case 45:
			goto st30
		case 46:
			goto tr26
		case 60:
			goto tr27
		case 95:
			goto tr30
		}
		switch {
		case data[p] > 90:
			if 97 <= data[p] && data[p] <= 122 {
				goto st29
			}
		case data[p] >= 65:
			goto st29
		}
		goto tr0
	st30:
		if p++; p == pe {
			goto _test_eof30
		}
	st_case_30:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st31
			}
		case data[p] > 90:
			if 97 <= data[p] && data[p] <= 122 {
				goto st31
			}
		default:
			goto st31
		}
		goto tr0
	st31:
		if p++; p == pe {
			goto _test_eof31
		}
	st_case_31:
		switch data[p] {
		case 9:
			goto tr25
		case 32:
			goto tr25
		case 45:
			goto st30
		case 46:
			goto tr26
		case 60:
			goto tr27
		case 95:
			goto tr30
		}
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st31
			}
		case data[p] > 90:
			if 97 <= data[p] && data[p] <= 122 {
				goto st31
			}
		default:
			goto st31
		}
		goto tr0
	st32:
		if p++; p == pe {
			goto _test_eof32
		}
	st_case_32:
		if data[p] == 94 {
			goto st33
		}
		goto tr0
	st33:
		if p++; p == pe {
			goto _test_eof33
		}
	st_case_33:
		if data[p] == 60 {
			goto st34
		}
		goto tr0
	tr16:
		// line 57 "raw.rl"

		if predicate < 0 {
			panic("unexpected parser state: predicate start not set")
		}
		q.Predicate = unEscapeRaw(data[predicate:p], isEscaped)
		isEscaped = false

		// line 41 "raw.rl"

		object = p

		goto st34
	tr20:
		// line 41 "raw.rl"

		object = p

		goto st34
	tr73:
		// line 29 "raw.rl"

		isEscaped = true

		goto st34
	st34:
		if p++; p == pe {
			goto _test_eof34
		}
	st_case_34:
		// line 1539 "raw.go"
		switch data[p] {
		case 33:
			goto st34
		case 62:
			goto st35
		case 92:
			goto st36
		case 95:
			goto st34
		case 126:
			goto st34
		}
		switch {
		case data[p] < 61:
			if 35 <= data[p] && data[p] <= 59 {
				goto st34
			}
		case data[p] > 93:
			switch {
			case data[p] > 122:
				if 128 <= data[p] && data[p] <= 1114111 {
					goto st34
				}
			case data[p] >= 97:
				goto st34
			}
		default:
			goto st34
		}
		goto tr0
	tr74:
		// line 29 "raw.rl"

		isEscaped = true

		goto st35
	st35:
		if p++; p == pe {
			goto _test_eof35
		}
	st_case_35:
		// line 1582 "raw.go"
		switch data[p] {
		case 9:
			goto tr25
		case 32:
			goto tr25
		case 46:
			goto tr26
		case 60:
			goto tr27
		case 95:
			goto tr30
		}
		goto tr0
	tr75:
		// line 29 "raw.rl"

		isEscaped = true

		goto st36
	st36:
		if p++; p == pe {
			goto _test_eof36
		}
	st_case_36:
		// line 1608 "raw.go"
		switch data[p] {
		case 85:
			goto st37
		case 117:
			goto st41
		}
		goto tr0
	st37:
		if p++; p == pe {
			goto _test_eof37
		}
	st_case_37:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st38
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st38
			}
		default:
			goto st38
		}
		goto tr0
	st38:
		if p++; p == pe {
			goto _test_eof38
		}
	st_case_38:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st39
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st39
			}
		default:
			goto st39
		}
		goto tr0
	st39:
		if p++; p == pe {
			goto _test_eof39
		}
	st_case_39:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st40
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st40
			}
		default:
			goto st40
		}
		goto tr0
	st40:
		if p++; p == pe {
			goto _test_eof40
		}
	st_case_40:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st41
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st41
			}
		default:
			goto st41
		}
		goto tr0
	st41:
		if p++; p == pe {
			goto _test_eof41
		}
	st_case_41:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st42
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st42
			}
		default:
			goto st42
		}
		goto tr0
	st42:
		if p++; p == pe {
			goto _test_eof42
		}
	st_case_42:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st43
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st43
			}
		default:
			goto st43
		}
		goto tr0
	st43:
		if p++; p == pe {
			goto _test_eof43
		}
	st_case_43:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st44
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st44
			}
		default:
			goto st44
		}
		goto tr0
	st44:
		if p++; p == pe {
			goto _test_eof44
		}
	st_case_44:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st45
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st45
			}
		default:
			goto st45
		}
		goto tr0
	st45:
		if p++; p == pe {
			goto _test_eof45
		}
	st_case_45:
		switch data[p] {
		case 33:
			goto tr73
		case 62:
			goto tr74
		case 92:
			goto tr75
		case 95:
			goto tr73
		case 126:
			goto tr73
		}
		switch {
		case data[p] < 61:
			if 35 <= data[p] && data[p] <= 59 {
				goto tr73
			}
		case data[p] > 93:
			switch {
			case data[p] > 122:
				if 128 <= data[p] && data[p] <= 1114111 {
					goto tr73
				}
			case data[p] >= 97:
				goto tr73
			}
		default:
			goto tr73
		}
		goto tr0
	tr81:
		// line 29 "raw.rl"

		isEscaped = true

		goto st46
	st46:
		if p++; p == pe {
			goto _test_eof46
		}
	st_case_46:
		// line 1807 "raw.go"
		switch data[p] {
		case 34:
			goto st47
		case 39:
			goto st47
		case 85:
			goto st48
		case 92:
			goto st47
		case 98:
			goto st47
		case 102:
			goto st47
		case 110:
			goto st47
		case 114:
			goto st47
		case 116:
			goto st47
		case 117:
			goto st52
		}
		goto tr0
	st47:
		if p++; p == pe {
			goto _test_eof47
		}
	st_case_47:
		switch data[p] {
		case 34:
			goto tr80
		case 92:
			goto tr81
		}
		switch {
		case data[p] < 11:
			if 0 <= data[p] && data[p] <= 9 {
				goto tr79
			}
		case data[p] > 12:
			if 14 <= data[p] && data[p] <= 1114111 {
				goto tr79
			}
		default:
			goto tr79
		}
		goto tr0
	st48:
		if p++; p == pe {
			goto _test_eof48
		}
	st_case_48:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st49
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st49
			}
		default:
			goto st49
		}
		goto tr0
	st49:
		if p++; p == pe {
			goto _test_eof49
		}
	st_case_49:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st50
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st50
			}
		default:
			goto st50
		}
		goto tr0
	st50:
		if p++; p == pe {
			goto _test_eof50
		}
	st_case_50:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st51
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st51
			}
		default:
			goto st51
		}
		goto tr0
	st51:
		if p++; p == pe {
			goto _test_eof51
		}
	st_case_51:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st52
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st52
			}
		default:
			goto st52
		}
		goto tr0
	st52:
		if p++; p == pe {
			goto _test_eof52
		}
	st_case_52:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st53
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st53
			}
		default:
			goto st53
		}
		goto tr0
	st53:
		if p++; p == pe {
			goto _test_eof53
		}
	st_case_53:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st54
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st54
			}
		default:
			goto st54
		}
		goto tr0
	st54:
		if p++; p == pe {
			goto _test_eof54
		}
	st_case_54:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st55
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st55
			}
		default:
			goto st55
		}
		goto tr0
	st55:
		if p++; p == pe {
			goto _test_eof55
		}
	st_case_55:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st47
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st47
			}
		default:
			goto st47
		}
		goto tr0
	tr17:
		// line 57 "raw.rl"

		if predicate < 0 {
			panic("unexpected parser state: predicate start not set")
		}
		q.Predicate = unEscapeRaw(data[predicate:p], isEscaped)
		isEscaped = false

		// line 41 "raw.rl"

		object = p

		goto st56
	tr21:
		// line 41 "raw.rl"

		object = p

		goto st56
	st56:
		if p++; p == pe {
			goto _test_eof56
		}
	st_case_56:
		// line 2027 "raw.go"
		if data[p] == 58 {
			goto st57
		}
		goto tr0
	st57:
		if p++; p == pe {
			goto _test_eof57
		}
	st_case_57:
		if data[p] == 95 {
			goto st58
		}
		switch {
		case data[p] < 895:
			switch {
			case data[p] < 192:
				switch {
				case data[p] < 65:
					if 48 <= data[p] && data[p] <= 58 {
						goto st58
					}
				case data[p] > 90:
					if 97 <= data[p] && data[p] <= 122 {
						goto st58
					}
				default:
					goto st58
				}
			case data[p] > 214:
				switch {
				case data[p] < 248:
					if 216 <= data[p] && data[p] <= 246 {
						goto st58
					}
				case data[p] > 767:
					if 880 <= data[p] && data[p] <= 893 {
						goto st58
					}
				default:
					goto st58
				}
			default:
				goto st58
			}
		case data[p] > 8191:
			switch {
			case data[p] < 12289:
				switch {
				case data[p] < 8304:
					if 8204 <= data[p] && data[p] <= 8205 {
						goto st58
					}
				case data[p] > 8591:
					if 11264 <= data[p] && data[p] <= 12271 {
						goto st58
					}
				default:
					goto st58
				}
			case data[p] > 55295:
				switch {
				case data[p] < 65008:
					if 63744 <= data[p] && data[p] <= 64975 {
						goto st58
					}
				case data[p] > 65533:
					if 65536 <= data[p] && data[p] <= 983039 {
						goto st58
					}
				default:
					goto st58
				}
			default:
				goto st58
			}
		default:
			goto st58
		}
		goto tr0
	st58:
		if p++; p == pe {
			goto _test_eof58
		}
	st_case_58:
		switch data[p] {
		case 9:
			goto tr25
		case 32:
			goto tr25
		case 45:
			goto st58
		case 46:
			goto tr90
		case 60:
			goto tr27
		case 95:
			goto tr91
		case 183:
			goto st58
		}
		switch {
		case data[p] < 8204:
			switch {
			case data[p] < 192:
				switch {
				case data[p] < 65:
					if 48 <= data[p] && data[p] <= 58 {
						goto st58
					}
				case data[p] > 90:
					if 97 <= data[p] && data[p] <= 122 {
						goto st58
					}
				default:
					goto st58
				}
			case data[p] > 214:
				switch {
				case data[p] < 248:
					if 216 <= data[p] && data[p] <= 246 {
						goto st58
					}
				case data[p] > 893:
					if 895 <= data[p] && data[p] <= 8191 {
						goto st58
					}
				default:
					goto st58
				}
			default:
				goto st58
			}
		case data[p] > 8205:
			switch {
			case data[p] < 12289:
				switch {
				case data[p] < 8304:
					if 8255 <= data[p] && data[p] <= 8256 {
						goto st58
					}
				case data[p] > 8591:
					if 11264 <= data[p] && data[p] <= 12271 {
						goto st58
					}
				default:
					goto st58
				}
			case data[p] > 55295:
				switch {
				case data[p] < 65008:
					if 63744 <= data[p] && data[p] <= 64975 {
						goto st58
					}
				case data[p] > 65533:
					if 65536 <= data[p] && data[p] <= 983039 {
						goto st58
					}
				default:
					goto st58
				}
			default:
				goto st58
			}
		default:
			goto st58
		}
		goto tr0
	tr90:
		// line 65 "raw.rl"

		if object < 0 {
			panic("unexpected parser state: object start not set")
		}
		q.Object = unEscapeRaw(data[object:p], isEscaped)
		isEscaped = false

		goto st91
	st91:
		if p++; p == pe {
			goto _test_eof91
		}
	st_case_91:
		// line 2211 "raw.go"
		switch data[p] {
		case 9:
			goto st88
		case 32:
			goto st88
		case 35:
			goto tr127
		case 45:
			goto st58
		case 46:
			goto st59
		case 95:
			goto st58
		case 183:
			goto st58
		}
		switch {
		case data[p] < 8204:
			switch {
			case data[p] < 192:
				switch {
				case data[p] < 65:
					if 48 <= data[p] && data[p] <= 58 {
						goto st58
					}
				case data[p] > 90:
					if 97 <= data[p] && data[p] <= 122 {
						goto st58
					}
				default:
					goto st58
				}
			case data[p] > 214:
				switch {
				case data[p] < 248:
					if 216 <= data[p] && data[p] <= 246 {
						goto st58
					}
				case data[p] > 893:
					if 895 <= data[p] && data[p] <= 8191 {
						goto st58
					}
				default:
					goto st58
				}
			default:
				goto st58
			}
		case data[p] > 8205:
			switch {
			case data[p] < 12289:
				switch {
				case data[p] < 8304:
					if 8255 <= data[p] && data[p] <= 8256 {
						goto st58
					}
				case data[p] > 8591:
					if 11264 <= data[p] && data[p] <= 12271 {
						goto st58
					}
				default:
					goto st58
				}
			case data[p] > 55295:
				switch {
				case data[p] < 65008:
					if 63744 <= data[p] && data[p] <= 64975 {
						goto st58
					}
				case data[p] > 65533:
					if 65536 <= data[p] && data[p] <= 983039 {
						goto st58
					}
				default:
					goto st58
				}
			default:
				goto st58
			}
		default:
			goto st58
		}
		goto st0
	st59:
		if p++; p == pe {
			goto _test_eof59
		}
	st_case_59:
		switch data[p] {
		case 45:
			goto st58
		case 46:
			goto st59
		case 95:
			goto st58
		case 183:
			goto st58
		}
		switch {
		case data[p] < 8204:
			switch {
			case data[p] < 192:
				switch {
				case data[p] < 65:
					if 48 <= data[p] && data[p] <= 58 {
						goto st58
					}
				case data[p] > 90:
					if 97 <= data[p] && data[p] <= 122 {
						goto st58
					}
				default:
					goto st58
				}
			case data[p] > 214:
				switch {
				case data[p] < 248:
					if 216 <= data[p] && data[p] <= 246 {
						goto st58
					}
				case data[p] > 893:
					if 895 <= data[p] && data[p] <= 8191 {
						goto st58
					}
				default:
					goto st58
				}
			default:
				goto st58
			}
		case data[p] > 8205:
			switch {
			case data[p] < 12289:
				switch {
				case data[p] < 8304:
					if 8255 <= data[p] && data[p] <= 8256 {
						goto st58
					}
				case data[p] > 8591:
					if 11264 <= data[p] && data[p] <= 12271 {
						goto st58
					}
				default:
					goto st58
				}
			case data[p] > 55295:
				switch {
				case data[p] < 65008:
					if 63744 <= data[p] && data[p] <= 64975 {
						goto st58
					}
				case data[p] > 65533:
					if 65536 <= data[p] && data[p] <= 983039 {
						goto st58
					}
				default:
					goto st58
				}
			default:
				goto st58
			}
		default:
			goto st58
		}
		goto tr0
	tr91:
		// line 65 "raw.rl"

		if object < 0 {
			panic("unexpected parser state: object start not set")
		}
		q.Object = unEscapeRaw(data[object:p], isEscaped)
		isEscaped = false

		// line 45 "raw.rl"

		label = p

		goto st60
	st60:
		if p++; p == pe {
			goto _test_eof60
		}
	st_case_60:
		// line 2398 "raw.go"
		switch data[p] {
		case 9:
			goto tr25
		case 32:
			goto tr25
		case 45:
			goto st58
		case 46:
			goto tr90
		case 58:
			goto st61
		case 60:
			goto tr27
		case 95:
			goto tr91
		case 183:
			goto st58
		}
		switch {
		case data[p] < 8204:
			switch {
			case data[p] < 192:
				switch {
				case data[p] < 65:
					if 48 <= data[p] && data[p] <= 57 {
						goto st58
					}
				case data[p] > 90:
					if 97 <= data[p] && data[p] <= 122 {
						goto st58
					}
				default:
					goto st58
				}
			case data[p] > 214:
				switch {
				case data[p] < 248:
					if 216 <= data[p] && data[p] <= 246 {
						goto st58
					}
				case data[p] > 893:
					if 895 <= data[p] && data[p] <= 8191 {
						goto st58
					}
				default:
					goto st58
				}
			default:
				goto st58
			}
		case data[p] > 8205:
			switch {
			case data[p] < 12289:
				switch {
				case data[p] < 8304:
					if 8255 <= data[p] && data[p] <= 8256 {
						goto st58
					}
				case data[p] > 8591:
					if 11264 <= data[p] && data[p] <= 12271 {
						goto st58
					}
				default:
					goto st58
				}
			case data[p] > 55295:
				switch {
				case data[p] < 65008:
					if 63744 <= data[p] && data[p] <= 64975 {
						goto st58
					}
				case data[p] > 65533:
					if 65536 <= data[p] && data[p] <= 983039 {
						goto st58
					}
				default:
					goto st58
				}
			default:
				goto st58
			}
		default:
			goto st58
		}
		goto tr0
	st61:
		if p++; p == pe {
			goto _test_eof61
		}
	st_case_61:
		switch data[p] {
		case 9:
			goto tr25
		case 32:
			goto tr25
		case 45:
			goto st58
		case 46:
			goto tr90
		case 60:
			goto tr27
		case 95:
			goto tr95
		case 183:
			goto st58
		}
		switch {
		case data[p] < 895:
			switch {
			case data[p] < 192:
				switch {
				case data[p] < 65:
					if 48 <= data[p] && data[p] <= 58 {
						goto st62
					}
				case data[p] > 90:
					if 97 <= data[p] && data[p] <= 122 {
						goto st62
					}
				default:
					goto st62
				}
			case data[p] > 214:
				switch {
				case data[p] < 248:
					if 216 <= data[p] && data[p] <= 246 {
						goto st62
					}
				case data[p] > 767:
					switch {
					case data[p] > 879:
						if 880 <= data[p] && data[p] <= 893 {
							goto st62
						}
					case data[p] >= 768:
						goto st58
					}
				default:
					goto st62
				}
			default:
				goto st62
			}
		case data[p] > 8191:
			switch {
			case data[p] < 11264:
				switch {
				case data[p] < 8255:
					if 8204 <= data[p] && data[p] <= 8205 {
						goto st62
					}
				case data[p] > 8256:
					if 8304 <= data[p] && data[p] <= 8591 {
						goto st62
					}
				default:
					goto st58
				}
			case data[p] > 12271:
				switch {
				case data[p] < 63744:
					if 12289 <= data[p] && data[p] <= 55295 {
						goto st62
					}
				case data[p] > 64975:
					switch {
					case data[p] > 65533:
						if 65536 <= data[p] && data[p] <= 983039 {
							goto st62
						}
					case data[p] >= 65008:
						goto st62
					}
				default:
					goto st62
				}
			default:
				goto st62
			}
		default:
			goto st62
		}
		goto tr0
	tr95:
		// line 65 "raw.rl"

		if object < 0 {
			panic("unexpected parser state: object start not set")
		}
		q.Object = unEscapeRaw(data[object:p], isEscaped)
		isEscaped = false

		// line 45 "raw.rl"

		label = p

		goto st62
	st62:
		if p++; p == pe {
			goto _test_eof62
		}
	st_case_62:
		// line 2603 "raw.go"
		switch data[p] {
		case 9:
			goto tr96
		case 32:
			goto tr96
		case 45:
			goto st62
		case 46:
			goto tr97
		case 60:
			goto tr27
		case 95:
			goto tr95
		case 183:
			goto st62
		}
		switch {
		case data[p] < 8204:
			switch {
			case data[p] < 192:
				switch {
				case data[p] < 65:
					if 48 <= data[p] && data[p] <= 58 {
						goto st62
					}
				case data[p] > 90:
					if 97 <= data[p] && data[p] <= 122 {
						goto st62
					}
				default:
					goto st62
				}
			case data[p] > 214:
				switch {
				case data[p] < 248:
					if 216 <= data[p] && data[p] <= 246 {
						goto st62
					}
				case data[p] > 893:
					if 895 <= data[p] && data[p] <= 8191 {
						goto st62
					}
				default:
					goto st62
				}
			default:
				goto st62
			}
		case data[p] > 8205:
			switch {
			case data[p] < 12289:
				switch {
				case data[p] < 8304:
					if 8255 <= data[p] && data[p] <= 8256 {
						goto st62
					}
				case data[p] > 8591:
					if 11264 <= data[p] && data[p] <= 12271 {
						goto st62
					}
				default:
					goto st62
				}
			case data[p] > 55295:
				switch {
				case data[p] < 65008:
					if 63744 <= data[p] && data[p] <= 64975 {
						goto st62
					}
				case data[p] > 65533:
					if 65536 <= data[p] && data[p] <= 983039 {
						goto st62
					}
				default:
					goto st62
				}
			default:
				goto st62
			}
		default:
			goto st62
		}
		goto tr0
	tr97:
		// line 65 "raw.rl"

		if object < 0 {
			panic("unexpected parser state: object start not set")
		}
		q.Object = unEscapeRaw(data[object:p], isEscaped)
		isEscaped = false

		// line 73 "raw.rl"

		if label < 0 {
			panic("unexpected parser state: label start not set")
		}
		q.Label = unEscapeRaw(data[label:p], isEscaped)
		isEscaped = false

		goto st92
	st92:
		if p++; p == pe {
			goto _test_eof92
		}
	st_case_92:
		// line 2712 "raw.go"
		switch data[p] {
		case 9:
			goto st88
		case 32:
			goto st88
		case 35:
			goto tr127
		case 45:
			goto st62
		case 46:
			goto st63
		case 95:
			goto st62
		case 183:
			goto st62
		}
		switch {
		case data[p] < 8204:
			switch {
			case data[p] < 192:
				switch {
				case data[p] < 65:
					if 48 <= data[p] && data[p] <= 58 {
						goto st62
					}
				case data[p] > 90:
					if 97 <= data[p] && data[p] <= 122 {
						goto st62
					}
				default:
					goto st62
				}
			case data[p] > 214:
				switch {
				case data[p] < 248:
					if 216 <= data[p] && data[p] <= 246 {
						goto st62
					}
				case data[p] > 893:
					if 895 <= data[p] && data[p] <= 8191 {
						goto st62
					}
				default:
					goto st62
				}
			default:
				goto st62
			}
		case data[p] > 8205:
			switch {
			case data[p] < 12289:
				switch {
				case data[p] < 8304:
					if 8255 <= data[p] && data[p] <= 8256 {
						goto st62
					}
				case data[p] > 8591:
					if 11264 <= data[p] && data[p] <= 12271 {
						goto st62
					}
				default:
					goto st62
				}
			case data[p] > 55295:
				switch {
				case data[p] < 65008:
					if 63744 <= data[p] && data[p] <= 64975 {
						goto st62
					}
				case data[p] > 65533:
					if 65536 <= data[p] && data[p] <= 983039 {
						goto st62
					}
				default:
					goto st62
				}
			default:
				goto st62
			}
		default:
			goto st62
		}
		goto st0
	st63:
		if p++; p == pe {
			goto _test_eof63
		}
	st_case_63:
		switch data[p] {
		case 45:
			goto st62
		case 46:
			goto st63
		case 95:
			goto st62
		case 183:
			goto st62
		}
		switch {
		case data[p] < 8204:
			switch {
			case data[p] < 192:
				switch {
				case data[p] < 65:
					if 48 <= data[p] && data[p] <= 58 {
						goto st62
					}
				case data[p] > 90:
					if 97 <= data[p] && data[p] <= 122 {
						goto st62
					}
				default:
					goto st62
				}
			case data[p] > 214:
				switch {
				case data[p] < 248:
					if 216 <= data[p] && data[p] <= 246 {
						goto st62
					}
				case data[p] > 893:
					if 895 <= data[p] && data[p] <= 8191 {
						goto st62
					}
				default:
					goto st62
				}
			default:
				goto st62
			}
		case data[p] > 8205:
			switch {
			case data[p] < 12289:
				switch {
				case data[p] < 8304:
					if 8255 <= data[p] && data[p] <= 8256 {
						goto st62
					}
				case data[p] > 8591:
					if 11264 <= data[p] && data[p] <= 12271 {
						goto st62
					}
				default:
					goto st62
				}
			case data[p] > 55295:
				switch {
				case data[p] < 65008:
					if 63744 <= data[p] && data[p] <= 64975 {
						goto st62
					}
				case data[p] > 65533:
					if 65536 <= data[p] && data[p] <= 983039 {
						goto st62
					}
				default:
					goto st62
				}
			default:
				goto st62
			}
		default:
			goto st62
		}
		goto tr0
	tr110:
		// line 29 "raw.rl"

		isEscaped = true

		goto st64
	st64:
		if p++; p == pe {
			goto _test_eof64
		}
	st_case_64:
		// line 2890 "raw.go"
		switch data[p] {
		case 85:
			goto st65
		case 117:
			goto st69
		}
		goto tr0
	st65:
		if p++; p == pe {
			goto _test_eof65
		}
	st_case_65:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st66
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st66
			}
		default:
			goto st66
		}
		goto tr0
	st66:
		if p++; p == pe {
			goto _test_eof66
		}
	st_case_66:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st67
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st67
			}
		default:
			goto st67
		}
		goto tr0
	st67:
		if p++; p == pe {
			goto _test_eof67
		}
	st_case_67:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st68
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st68
			}
		default:
			goto st68
		}
		goto tr0
	st68:
		if p++; p == pe {
			goto _test_eof68
		}
	st_case_68:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st69
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st69
			}
		default:
			goto st69
		}
		goto tr0
	st69:
		if p++; p == pe {
			goto _test_eof69
		}
	st_case_69:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st70
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st70
			}
		default:
			goto st70
		}
		goto tr0
	st70:
		if p++; p == pe {
			goto _test_eof70
		}
	st_case_70:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st71
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st71
			}
		default:
			goto st71
		}
		goto tr0
	st71:
		if p++; p == pe {
			goto _test_eof71
		}
	st_case_71:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st72
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st72
			}
		default:
			goto st72
		}
		goto tr0
	st72:
		if p++; p == pe {
			goto _test_eof72
		}
	st_case_72:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st73
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st73
			}
		default:
			goto st73
		}
		goto tr0
	st73:
		if p++; p == pe {
			goto _test_eof73
		}
	st_case_73:
		switch data[p] {
		case 33:
			goto tr108
		case 62:
			goto tr109
		case 92:
			goto tr110
		case 95:
			goto tr108
		case 126:
			goto tr108
		}
		switch {
		case data[p] < 61:
			if 35 <= data[p] && data[p] <= 59 {
				goto tr108
			}
		case data[p] > 93:
			switch {
			case data[p] > 122:
				if 128 <= data[p] && data[p] <= 1114111 {
					goto tr108
				}
			case data[p] >= 97:
				goto tr108
			}
		default:
			goto tr108
		}
		goto tr0
	tr122:
		// line 29 "raw.rl"

		isEscaped = true

		goto st74
	st74:
		if p++; p == pe {
			goto _test_eof74
		}
	st_case_74:
		// line 3089 "raw.go"
		switch data[p] {
		case 85:
			goto st75
		case 117:
			goto st79
		}
		goto tr0
	st75:
		if p++; p == pe {
			goto _test_eof75
		}
	st_case_75:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st76
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st76
			}
		default:
			goto st76
		}
		goto tr0
	st76:
		if p++; p == pe {
			goto _test_eof76
		}
	st_case_76:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st77
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st77
			}
		default:
			goto st77
		}
		goto tr0
	st77:
		if p++; p == pe {
			goto _test_eof77
		}
	st_case_77:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st78
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st78
			}
		default:
			goto st78
		}
		goto tr0
	st78:
		if p++; p == pe {
			goto _test_eof78
		}
	st_case_78:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st79
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st79
			}
		default:
			goto st79
		}
		goto tr0
	st79:
		if p++; p == pe {
			goto _test_eof79
		}
	st_case_79:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st80
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st80
			}
		default:
			goto st80
		}
		goto tr0
	st80:
		if p++; p == pe {
			goto _test_eof80
		}
	st_case_80:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st81
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st81
			}
		default:
			goto st81
		}
		goto tr0
	st81:
		if p++; p == pe {
			goto _test_eof81
		}
	st_case_81:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st82
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st82
			}
		default:
			goto st82
		}
		goto tr0
	st82:
		if p++; p == pe {
			goto _test_eof82
		}
	st_case_82:
		switch {
		case data[p] < 65:
			if 48 <= data[p] && data[p] <= 57 {
				goto st83
			}
		case data[p] > 70:
			if 97 <= data[p] && data[p] <= 102 {
				goto st83
			}
		default:
			goto st83
		}
		goto tr0
	st83:
		if p++; p == pe {
			goto _test_eof83
		}
	st_case_83:
		switch data[p] {
		case 33:
			goto tr120
		case 62:
			goto tr121
		case 92:
			goto tr122
		case 95:
			goto tr120
		case 126:
			goto tr120
		}
		switch {
		case data[p] < 61:
			if 35 <= data[p] && data[p] <= 59 {
				goto tr120
			}
		case data[p] > 93:
			switch {
			case data[p] > 122:
				if 128 <= data[p] && data[p] <= 1114111 {
					goto tr120
				}
			case data[p] >= 97:
				goto tr120
			}
		default:
			goto tr120
		}
		goto tr0
	tr3:
		// line 33 "raw.rl"

		subject = p

		goto st84
	st84:
		if p++; p == pe {
			goto _test_eof84
		}
	st_case_84:
		// line 3288 "raw.go"
		if data[p] == 58 {
			goto st85
		}
		goto tr0
	st85:
		if p++; p == pe {
			goto _test_eof85
		}
	st_case_85:
		if data[p] == 95 {
			goto st86
		}
		switch {
		case data[p] < 895:
			switch {
			case data[p] < 192:
				switch {
				case data[p] < 65:
					if 48 <= data[p] && data[p] <= 58 {
						goto st86
					}
				case data[p] > 90:
					if 97 <= data[p] && data[p] <= 122 {
						goto st86
					}
				default:
					goto st86
				}
			case data[p] > 214:
				switch {
				case data[p] < 248:
					if 216 <= data[p] && data[p] <= 246 {
						goto st86
					}
				case data[p] > 767:
					if 880 <= data[p] && data[p] <= 893 {
						goto st86
					}
				default:
					goto st86
				}
			default:
				goto st86
			}
		case data[p] > 8191:
			switch {
			case data[p] < 12289:
				switch {
				case data[p] < 8304:
					if 8204 <= data[p] && data[p] <= 8205 {
						goto st86
					}
				case data[p] > 8591:
					if 11264 <= data[p] && data[p] <= 12271 {
						goto st86
					}
				default:
					goto st86
				}
			case data[p] > 55295:
				switch {
				case data[p] < 65008:
					if 63744 <= data[p] && data[p] <= 64975 {
						goto st86
					}
				case data[p] > 65533:
					if 65536 <= data[p] && data[p] <= 983039 {
						goto st86
					}
				default:
					goto st86
				}
			default:
				goto st86
			}
		default:
			goto st86
		}
		goto tr0
	st86:
		if p++; p == pe {
			goto _test_eof86
		}
	st_case_86:
		switch data[p] {
		case 9:
			goto tr7
		case 32:
			goto tr7
		case 45:
			goto st86
		case 46:
			goto st87
		case 60:
			goto tr8
		case 95:
			goto st86
		case 183:
			goto st86
		}
		switch {
		case data[p] < 8204:
			switch {
			case data[p] < 192:
				switch {
				case data[p] < 65:
					if 48 <= data[p] && data[p] <= 58 {
						goto st86
					}
				case data[p] > 90:
					if 97 <= data[p] && data[p] <= 122 {
						goto st86
					}
				default:
					goto st86
				}
			case data[p] > 214:
				switch {
				case data[p] < 248:
					if 216 <= data[p] && data[p] <= 246 {
						goto st86
					}
				case data[p] > 893:
					if 895 <= data[p] && data[p] <= 8191 {
						goto st86
					}
				default:
					goto st86
				}
			default:
				goto st86
			}
		case data[p] > 8205:
			switch {
			case data[p] < 12289:
				switch {
				case data[p] < 8304:
					if 8255 <= data[p] && data[p] <= 8256 {
						goto st86
					}
				case data[p] > 8591:
					if 11264 <= data[p] && data[p] <= 12271 {
						goto st86
					}
				default:
					goto st86
				}
			case data[p] > 55295:
				switch {
				case data[p] < 65008:
					if 63744 <= data[p] && data[p] <= 64975 {
						goto st86
					}
				case data[p] > 65533:
					if 65536 <= data[p] && data[p] <= 983039 {
						goto st86
					}
				default:
					goto st86
				}
			default:
				goto st86
			}
		default:
			goto st86
		}
		goto tr0
	st87:
		if p++; p == pe {
			goto _test_eof87
		}
	st_case_87:
		switch data[p] {
		case 45:
			goto st86
		case 46:
			goto st87
		case 95:
			goto st86
		case 183:
			goto st86
		}
		switch {
		case data[p] < 8204:
			switch {
			case data[p] < 192:
				switch {
				case data[p] < 65:
					if 48 <= data[p] && data[p] <= 58 {
						goto st86
					}
				case data[p] > 90:
					if 97 <= data[p] && data[p] <= 122 {
						goto st86
					}
				default:
					goto st86
				}
			case data[p] > 214:
				switch {
				case data[p] < 248:
					if 216 <= data[p] && data[p] <= 246 {
						goto st86
					}
				case data[p] > 893:
					if 895 <= data[p] && data[p] <= 8191 {
						goto st86
					}
				default:
					goto st86
				}
			default:
				goto st86
			}
		case data[p] > 8205:
			switch {
			case data[p] < 12289:
				switch {
				case data[p] < 8304:
					if 8255 <= data[p] && data[p] <= 8256 {
						goto st86
					}
				case data[p] > 8591:
					if 11264 <= data[p] && data[p] <= 12271 {
						goto st86
					}
				default:
					goto st86
				}
			case data[p] > 55295:
				switch {
				case data[p] < 65008:
					if 63744 <= data[p] && data[p] <= 64975 {
						goto st86
					}
				case data[p] > 65533:
					if 65536 <= data[p] && data[p] <= 983039 {
						goto st86
					}
				default:
					goto st86
				}
			default:
				goto st86
			}
		default:
			goto st86
		}
		goto tr0
	st_out:
	_test_eof1:
		cs = 1
		goto _test_eof
	_test_eof2:
		cs = 2
		goto _test_eof
	_test_eof3:
		cs = 3
		goto _test_eof
	_test_eof4:
		cs = 4
		goto _test_eof
	_test_eof5:
		cs = 5
		goto _test_eof
	_test_eof6:
		cs = 6
		goto _test_eof
	_test_eof7:
		cs = 7
		goto _test_eof
	_test_eof8:
		cs = 8
		goto _test_eof
	_test_eof9:
		cs = 9
		goto _test_eof
	_test_eof10:
		cs = 10
		goto _test_eof
	_test_eof88:
		cs = 88
		goto _test_eof
	_test_eof89:
		cs = 89
		goto _test_eof
	_test_eof11:
		cs = 11
		goto _test_eof
	_test_eof12:
		cs = 12
		goto _test_eof
	_test_eof13:
		cs = 13
		goto _test_eof
	_test_eof14:
		cs = 14
		goto _test_eof
	_test_eof15:
		cs = 15
		goto _test_eof
	_test_eof16:
		cs = 16
		goto _test_eof
	_test_eof17:
		cs = 17
		goto _test_eof
	_test_eof18:
		cs = 18
		goto _test_eof
	_test_eof19:
		cs = 19
		goto _test_eof
	_test_eof20:
		cs = 20
		goto _test_eof
	_test_eof21:
		cs = 21
		goto _test_eof
	_test_eof22:
		cs = 22
		goto _test_eof
	_test_eof23:
		cs = 23
		goto _test_eof
	_test_eof24:
		cs = 24
		goto _test_eof
	_test_eof25:
		cs = 25
		goto _test_eof
	_test_eof26:
		cs = 26
		goto _test_eof
	_test_eof90:
		cs = 90
		goto _test_eof
	_test_eof27:
		cs = 27
		goto _test_eof
	_test_eof28:
		cs = 28
		goto _test_eof
	_test_eof29:
		cs = 29
		goto _test_eof
	_test_eof30:
		cs = 30
		goto _test_eof
	_test_eof31:
		cs = 31
		goto _test_eof
	_test_eof32:
		cs = 32
		goto _test_eof
	_test_eof33:
		cs = 33
		goto _test_eof
	_test_eof34:
		cs = 34
		goto _test_eof
	_test_eof35:
		cs = 35
		goto _test_eof
	_test_eof36:
		cs = 36
		goto _test_eof
	_test_eof37:
		cs = 37
		goto _test_eof
	_test_eof38:
		cs = 38
		goto _test_eof
	_test_eof39:
		cs = 39
		goto _test_eof
	_test_eof40:
		cs = 40
		goto _test_eof
	_test_eof41:
		cs = 41
		goto _test_eof
	_test_eof42:
		cs = 42
		goto _test_eof
	_test_eof43:
		cs = 43
		goto _test_eof
	_test_eof44:
		cs = 44
		goto _test_eof
	_test_eof45:
		cs = 45
		goto _test_eof
	_test_eof46:
		cs = 46
		goto _test_eof
	_test_eof47:
		cs = 47
		goto _test_eof
	_test_eof48:
		cs = 48
		goto _test_eof
	_test_eof49:
		cs = 49
		goto _test_eof
	_test_eof50:
		cs = 50
		goto _test_eof
	_test_eof51:
		cs = 51
		goto _test_eof
	_test_eof52:
		cs = 52
		goto _test_eof
	_test_eof53:
		cs = 53
		goto _test_eof
	_test_eof54:
		cs = 54
		goto _test_eof
	_test_eof55:
		cs = 55
		goto _test_eof
	_test_eof56:
		cs = 56
		goto _test_eof
	_test_eof57:
		cs = 57
		goto _test_eof
	_test_eof58:
		cs = 58
		goto _test_eof
	_test_eof91:
		cs = 91
		goto _test_eof
	_test_eof59:
		cs = 59
		goto _test_eof
	_test_eof60:
		cs = 60
		goto _test_eof
	_test_eof61:
		cs = 61
		goto _test_eof
	_test_eof62:
		cs = 62
		goto _test_eof
	_test_eof92:
		cs = 92
		goto _test_eof
	_test_eof63:
		cs = 63
		goto _test_eof
	_test_eof64:
		cs = 64
		goto _test_eof
	_test_eof65:
		cs = 65
		goto _test_eof
	_test_eof66:
		cs = 66
		goto _test_eof
	_test_eof67:
		cs = 67
		goto _test_eof
	_test_eof68:
		cs = 68
		goto _test_eof
	_test_eof69:
		cs = 69
		goto _test_eof
	_test_eof70:
		cs = 70
		goto _test_eof
	_test_eof71:
		cs = 71
		goto _test_eof
	_test_eof72:
		cs = 72
		goto _test_eof
	_test_eof73:
		cs = 73
		goto _test_eof
	_test_eof74:
		cs = 74
		goto _test_eof
	_test_eof75:
		cs = 75
		goto _test_eof
	_test_eof76:
		cs = 76
		goto _test_eof
	_test_eof77:
		cs = 77
		goto _test_eof
	_test_eof78:
		cs = 78
		goto _test_eof
	_test_eof79:
		cs = 79
		goto _test_eof
	_test_eof80:
		cs = 80
		goto _test_eof
	_test_eof81:
		cs = 81
		goto _test_eof
	_test_eof82:
		cs = 82
		goto _test_eof
	_test_eof83:
		cs = 83
		goto _test_eof
	_test_eof84:
		cs = 84
		goto _test_eof
	_test_eof85:
		cs = 85
		goto _test_eof
	_test_eof86:
		cs = 86
		goto _test_eof
	_test_eof87:
		cs = 87
		goto _test_eof

	_test_eof:
		{
		}
		if p == eof {
			switch cs {
			case 89:
				// line 81 "raw.rl"

				return q, nil

			case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87:
				// line 88 "raw.rl"

				if p < len(data) {
					if r := data[p]; r < unicode.MaxASCII {
						return q, fmt.Errorf("%v: unexpected rune %q at %d", quad.ErrInvalid, data[p], p)
					} else {
						return q, fmt.Errorf("%v: unexpected rune %q (\\u%04x) at %d", quad.ErrInvalid, data[p], data[p], p)
					}
				}
				return q, quad.ErrIncomplete

			case 88, 90, 91, 92:
				// line 85 "raw.rl"

				// line 81 "raw.rl"

				return q, nil

				// line 3664 "raw.go"
			}
		}

	_out:
		{
		}
	}

	// line 143 "raw.rl"

	return quad.Quad{}, quad.ErrInvalid
}
