// Code generated by protoc-gen-gogo.
// source: quads.proto
// DO NOT EDIT!

/*
	Package pquads is a generated protocol buffer package.

	It is generated from these files:
		quads.proto

	It has these top-level messages:
		Quad
		WireQuad
		StrictQuad
		Value
		Header
*/
package pquads

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Quad is in internal representation of quad used by Cayley.
type Quad struct {
	Subject        string `protobuf:"bytes,1,opt,name=subject,proto3" json:"subject,omitempty"`
	Predicate      string `protobuf:"bytes,2,opt,name=predicate,proto3" json:"predicate,omitempty"`
	Object         string `protobuf:"bytes,3,opt,name=object,proto3" json:"object,omitempty"`
	Label          string `protobuf:"bytes,4,opt,name=label,proto3" json:"label,omitempty"`
	SubjectValue   *Value `protobuf:"bytes,5,opt,name=subject_value,json=subjectValue" json:"subject_value,omitempty"`
	PredicateValue *Value `protobuf:"bytes,6,opt,name=predicate_value,json=predicateValue" json:"predicate_value,omitempty"`
	ObjectValue    *Value `protobuf:"bytes,7,opt,name=object_value,json=objectValue" json:"object_value,omitempty"`
	LabelValue     *Value `protobuf:"bytes,8,opt,name=label_value,json=labelValue" json:"label_value,omitempty"`
}

func (m *Quad) Reset()                    { *m = Quad{} }
func (m *Quad) String() string            { return proto.CompactTextString(m) }
func (*Quad) ProtoMessage()               {}
func (*Quad) Descriptor() ([]byte, []int) { return fileDescriptorQuads, []int{0} }

func (m *Quad) GetSubjectValue() *Value {
	if m != nil {
		return m.SubjectValue
	}
	return nil
}

func (m *Quad) GetPredicateValue() *Value {
	if m != nil {
		return m.PredicateValue
	}
	return nil
}

func (m *Quad) GetObjectValue() *Value {
	if m != nil {
		return m.ObjectValue
	}
	return nil
}

func (m *Quad) GetLabelValue() *Value {
	if m != nil {
		return m.LabelValue
	}
	return nil
}

// WireQuad is a quad that allows any value for it's directions.
type WireQuad struct {
	Subject   *Value `protobuf:"bytes,1,opt,name=subject" json:"subject,omitempty"`
	Predicate *Value `protobuf:"bytes,2,opt,name=predicate" json:"predicate,omitempty"`
	Object    *Value `protobuf:"bytes,3,opt,name=object" json:"object,omitempty"`
	Label     *Value `protobuf:"bytes,4,opt,name=label" json:"label,omitempty"`
}

func (m *WireQuad) Reset()                    { *m = WireQuad{} }
func (m *WireQuad) String() string            { return proto.CompactTextString(m) }
func (*WireQuad) ProtoMessage()               {}
func (*WireQuad) Descriptor() ([]byte, []int) { return fileDescriptorQuads, []int{1} }

func (m *WireQuad) GetSubject() *Value {
	if m != nil {
		return m.Subject
	}
	return nil
}

func (m *WireQuad) GetPredicate() *Value {
	if m != nil {
		return m.Predicate
	}
	return nil
}

func (m *WireQuad) GetObject() *Value {
	if m != nil {
		return m.Object
	}
	return nil
}

func (m *WireQuad) GetLabel() *Value {
	if m != nil {
		return m.Label
	}
	return nil
}

// StrictQuad is a quad as described by RDF spec.
type StrictQuad struct {
	Subject   *StrictQuad_Ref `protobuf:"bytes,1,opt,name=subject" json:"subject,omitempty"`
	Predicate *StrictQuad_Ref `protobuf:"bytes,2,opt,name=predicate" json:"predicate,omitempty"`
	Object    *Value          `protobuf:"bytes,3,opt,name=object" json:"object,omitempty"`
	Label     *StrictQuad_Ref `protobuf:"bytes,4,opt,name=label" json:"label,omitempty"`
}

func (m *StrictQuad) Reset()                    { *m = StrictQuad{} }
func (m *StrictQuad) String() string            { return proto.CompactTextString(m) }
func (*StrictQuad) ProtoMessage()               {}
func (*StrictQuad) Descriptor() ([]byte, []int) { return fileDescriptorQuads, []int{2} }

func (m *StrictQuad) GetSubject() *StrictQuad_Ref {
	if m != nil {
		return m.Subject
	}
	return nil
}

func (m *StrictQuad) GetPredicate() *StrictQuad_Ref {
	if m != nil {
		return m.Predicate
	}
	return nil
}

func (m *StrictQuad) GetObject() *Value {
	if m != nil {
		return m.Object
	}
	return nil
}

func (m *StrictQuad) GetLabel() *StrictQuad_Ref {
	if m != nil {
		return m.Label
	}
	return nil
}

type StrictQuad_Ref struct {
	// Types that are valid to be assigned to Value:
	//	*StrictQuad_Ref_BnodeLabel
	//	*StrictQuad_Ref_Iri
	Value isStrictQuad_Ref_Value `protobuf_oneof:"value"`
}

func (m *StrictQuad_Ref) Reset()                    { *m = StrictQuad_Ref{} }
func (m *StrictQuad_Ref) String() string            { return proto.CompactTextString(m) }
func (*StrictQuad_Ref) ProtoMessage()               {}
func (*StrictQuad_Ref) Descriptor() ([]byte, []int) { return fileDescriptorQuads, []int{2, 0} }

type isStrictQuad_Ref_Value interface {
	isStrictQuad_Ref_Value()
	MarshalTo([]byte) (int, error)
	ProtoSize() int
}

type StrictQuad_Ref_BnodeLabel struct {
	BnodeLabel string `protobuf:"bytes,2,opt,name=bnode_label,json=bnodeLabel,proto3,oneof"`
}
type StrictQuad_Ref_Iri struct {
	Iri string `protobuf:"bytes,3,opt,name=iri,proto3,oneof"`
}

func (*StrictQuad_Ref_BnodeLabel) isStrictQuad_Ref_Value() {}
func (*StrictQuad_Ref_Iri) isStrictQuad_Ref_Value()        {}

func (m *StrictQuad_Ref) GetValue() isStrictQuad_Ref_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *StrictQuad_Ref) GetBnodeLabel() string {
	if x, ok := m.GetValue().(*StrictQuad_Ref_BnodeLabel); ok {
		return x.BnodeLabel
	}
	return ""
}

func (m *StrictQuad_Ref) GetIri() string {
	if x, ok := m.GetValue().(*StrictQuad_Ref_Iri); ok {
		return x.Iri
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StrictQuad_Ref) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StrictQuad_Ref_OneofMarshaler, _StrictQuad_Ref_OneofUnmarshaler, _StrictQuad_Ref_OneofSizer, []interface{}{
		(*StrictQuad_Ref_BnodeLabel)(nil),
		(*StrictQuad_Ref_Iri)(nil),
	}
}

func _StrictQuad_Ref_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StrictQuad_Ref)
	// value
	switch x := m.Value.(type) {
	case *StrictQuad_Ref_BnodeLabel:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.BnodeLabel)
	case *StrictQuad_Ref_Iri:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Iri)
	case nil:
	default:
		return fmt.Errorf("StrictQuad_Ref.Value has unexpected type %T", x)
	}
	return nil
}

func _StrictQuad_Ref_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StrictQuad_Ref)
	switch tag {
	case 2: // value.bnode_label
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &StrictQuad_Ref_BnodeLabel{x}
		return true, err
	case 3: // value.iri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &StrictQuad_Ref_Iri{x}
		return true, err
	default:
		return false, nil
	}
}

func _StrictQuad_Ref_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StrictQuad_Ref)
	// value
	switch x := m.Value.(type) {
	case *StrictQuad_Ref_BnodeLabel:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.BnodeLabel)))
		n += len(x.BnodeLabel)
	case *StrictQuad_Ref_Iri:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Iri)))
		n += len(x.Iri)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type Value struct {
	// Types that are valid to be assigned to Value:
	//	*Value_Raw
	//	*Value_Str
	//	*Value_Iri
	//	*Value_Bnode
	//	*Value_TypedStr
	//	*Value_LangStr
	//	*Value_Int
	//	*Value_Float
	//	*Value_Boolean
	//	*Value_Time
	Value isValue_Value `protobuf_oneof:"value"`
}

func (m *Value) Reset()                    { *m = Value{} }
func (m *Value) String() string            { return proto.CompactTextString(m) }
func (*Value) ProtoMessage()               {}
func (*Value) Descriptor() ([]byte, []int) { return fileDescriptorQuads, []int{3} }

type isValue_Value interface {
	isValue_Value()
	MarshalTo([]byte) (int, error)
	ProtoSize() int
}

type Value_Raw struct {
	Raw []byte `protobuf:"bytes,1,opt,name=raw,proto3,oneof"`
}
type Value_Str struct {
	Str string `protobuf:"bytes,2,opt,name=str,proto3,oneof"`
}
type Value_Iri struct {
	Iri string `protobuf:"bytes,3,opt,name=iri,proto3,oneof"`
}
type Value_Bnode struct {
	Bnode string `protobuf:"bytes,4,opt,name=bnode,proto3,oneof"`
}
type Value_TypedStr struct {
	TypedStr *Value_TypedString `protobuf:"bytes,5,opt,name=typed_str,json=typedStr,oneof"`
}
type Value_LangStr struct {
	LangStr *Value_LangString `protobuf:"bytes,6,opt,name=lang_str,json=langStr,oneof"`
}
type Value_Int struct {
	Int int64 `protobuf:"varint,7,opt,name=int,proto3,oneof"`
}
type Value_Float struct {
	Float float64 `protobuf:"fixed64,8,opt,name=float,proto3,oneof"`
}
type Value_Boolean struct {
	Boolean bool `protobuf:"varint,9,opt,name=boolean,proto3,oneof"`
}
type Value_Time struct {
	Time *Value_Timestamp `protobuf:"bytes,10,opt,name=time,oneof"`
}

func (*Value_Raw) isValue_Value()      {}
func (*Value_Str) isValue_Value()      {}
func (*Value_Iri) isValue_Value()      {}
func (*Value_Bnode) isValue_Value()    {}
func (*Value_TypedStr) isValue_Value() {}
func (*Value_LangStr) isValue_Value()  {}
func (*Value_Int) isValue_Value()      {}
func (*Value_Float) isValue_Value()    {}
func (*Value_Boolean) isValue_Value()  {}
func (*Value_Time) isValue_Value()     {}

func (m *Value) GetValue() isValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Value) GetRaw() []byte {
	if x, ok := m.GetValue().(*Value_Raw); ok {
		return x.Raw
	}
	return nil
}

func (m *Value) GetStr() string {
	if x, ok := m.GetValue().(*Value_Str); ok {
		return x.Str
	}
	return ""
}

func (m *Value) GetIri() string {
	if x, ok := m.GetValue().(*Value_Iri); ok {
		return x.Iri
	}
	return ""
}

func (m *Value) GetBnode() string {
	if x, ok := m.GetValue().(*Value_Bnode); ok {
		return x.Bnode
	}
	return ""
}

func (m *Value) GetTypedStr() *Value_TypedString {
	if x, ok := m.GetValue().(*Value_TypedStr); ok {
		return x.TypedStr
	}
	return nil
}

func (m *Value) GetLangStr() *Value_LangString {
	if x, ok := m.GetValue().(*Value_LangStr); ok {
		return x.LangStr
	}
	return nil
}

func (m *Value) GetInt() int64 {
	if x, ok := m.GetValue().(*Value_Int); ok {
		return x.Int
	}
	return 0
}

func (m *Value) GetFloat() float64 {
	if x, ok := m.GetValue().(*Value_Float); ok {
		return x.Float
	}
	return 0
}

func (m *Value) GetBoolean() bool {
	if x, ok := m.GetValue().(*Value_Boolean); ok {
		return x.Boolean
	}
	return false
}

func (m *Value) GetTime() *Value_Timestamp {
	if x, ok := m.GetValue().(*Value_Time); ok {
		return x.Time
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Value) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Value_OneofMarshaler, _Value_OneofUnmarshaler, _Value_OneofSizer, []interface{}{
		(*Value_Raw)(nil),
		(*Value_Str)(nil),
		(*Value_Iri)(nil),
		(*Value_Bnode)(nil),
		(*Value_TypedStr)(nil),
		(*Value_LangStr)(nil),
		(*Value_Int)(nil),
		(*Value_Float)(nil),
		(*Value_Boolean)(nil),
		(*Value_Time)(nil),
	}
}

func _Value_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Value)
	// value
	switch x := m.Value.(type) {
	case *Value_Raw:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeRawBytes(x.Raw)
	case *Value_Str:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Str)
	case *Value_Iri:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Iri)
	case *Value_Bnode:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Bnode)
	case *Value_TypedStr:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TypedStr); err != nil {
			return err
		}
	case *Value_LangStr:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LangStr); err != nil {
			return err
		}
	case *Value_Int:
		_ = b.EncodeVarint(7<<3 | proto.WireVarint)
		_ = b.EncodeVarint(uint64(x.Int))
	case *Value_Float:
		_ = b.EncodeVarint(8<<3 | proto.WireFixed64)
		_ = b.EncodeFixed64(math.Float64bits(x.Float))
	case *Value_Boolean:
		t := uint64(0)
		if x.Boolean {
			t = 1
		}
		_ = b.EncodeVarint(9<<3 | proto.WireVarint)
		_ = b.EncodeVarint(t)
	case *Value_Time:
		_ = b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Time); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Value.Value has unexpected type %T", x)
	}
	return nil
}

func _Value_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Value)
	switch tag {
	case 1: // value.raw
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Value = &Value_Raw{x}
		return true, err
	case 2: // value.str
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &Value_Str{x}
		return true, err
	case 3: // value.iri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &Value_Iri{x}
		return true, err
	case 4: // value.bnode
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &Value_Bnode{x}
		return true, err
	case 5: // value.typed_str
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Value_TypedString)
		err := b.DecodeMessage(msg)
		m.Value = &Value_TypedStr{msg}
		return true, err
	case 6: // value.lang_str
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Value_LangString)
		err := b.DecodeMessage(msg)
		m.Value = &Value_LangStr{msg}
		return true, err
	case 7: // value.int
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &Value_Int{int64(x)}
		return true, err
	case 8: // value.float
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Value = &Value_Float{math.Float64frombits(x)}
		return true, err
	case 9: // value.boolean
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &Value_Boolean{x != 0}
		return true, err
	case 10: // value.time
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Value_Timestamp)
		err := b.DecodeMessage(msg)
		m.Value = &Value_Time{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Value_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Value)
	// value
	switch x := m.Value.(type) {
	case *Value_Raw:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Raw)))
		n += len(x.Raw)
	case *Value_Str:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Str)))
		n += len(x.Str)
	case *Value_Iri:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Iri)))
		n += len(x.Iri)
	case *Value_Bnode:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Bnode)))
		n += len(x.Bnode)
	case *Value_TypedStr:
		s := proto.Size(x.TypedStr)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Value_LangStr:
		s := proto.Size(x.LangStr)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Value_Int:
		n += proto.SizeVarint(7<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.Int))
	case *Value_Float:
		n += proto.SizeVarint(8<<3 | proto.WireFixed64)
		n += 8
	case *Value_Boolean:
		n += proto.SizeVarint(9<<3 | proto.WireVarint)
		n += 1
	case *Value_Time:
		s := proto.Size(x.Time)
		n += proto.SizeVarint(10<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type Value_TypedString struct {
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Type  string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
}

func (m *Value_TypedString) Reset()                    { *m = Value_TypedString{} }
func (m *Value_TypedString) String() string            { return proto.CompactTextString(m) }
func (*Value_TypedString) ProtoMessage()               {}
func (*Value_TypedString) Descriptor() ([]byte, []int) { return fileDescriptorQuads, []int{3, 0} }

type Value_LangString struct {
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Lang  string `protobuf:"bytes,2,opt,name=lang,proto3" json:"lang,omitempty"`
}

func (m *Value_LangString) Reset()                    { *m = Value_LangString{} }
func (m *Value_LangString) String() string            { return proto.CompactTextString(m) }
func (*Value_LangString) ProtoMessage()               {}
func (*Value_LangString) Descriptor() ([]byte, []int) { return fileDescriptorQuads, []int{3, 1} }

// From https://github.com/golang/protobuf/blob/master/ptypes/timestamp/timestamp.proto
type Value_Timestamp struct {
	Seconds int64 `protobuf:"varint,1,opt,name=seconds,proto3" json:"seconds,omitempty"`
	Nanos   int32 `protobuf:"varint,2,opt,name=nanos,proto3" json:"nanos,omitempty"`
}

func (m *Value_Timestamp) Reset()                    { *m = Value_Timestamp{} }
func (m *Value_Timestamp) String() string            { return proto.CompactTextString(m) }
func (*Value_Timestamp) ProtoMessage()               {}
func (*Value_Timestamp) Descriptor() ([]byte, []int) { return fileDescriptorQuads, []int{3, 2} }

type Header struct {
	// Full is set if encoder always writes every quad directions instead of
	// skipping duplicated values on each direction (except label) for subsequent quads.
	Full bool `protobuf:"varint,1,opt,name=full,proto3" json:"full,omitempty"`
	// NotStrict is set if encoder emits WireQuad instead of StrictQuad messages.
	NotStrict bool `protobuf:"varint,2,opt,name=not_strict,json=notStrict,proto3" json:"not_strict,omitempty"`
}

func (m *Header) Reset()                    { *m = Header{} }
func (m *Header) String() string            { return proto.CompactTextString(m) }
func (*Header) ProtoMessage()               {}
func (*Header) Descriptor() ([]byte, []int) { return fileDescriptorQuads, []int{4} }

func init() {
	proto.RegisterType((*Quad)(nil), "pquads.Quad")
	proto.RegisterType((*WireQuad)(nil), "pquads.WireQuad")
	proto.RegisterType((*StrictQuad)(nil), "pquads.StrictQuad")
	proto.RegisterType((*StrictQuad_Ref)(nil), "pquads.StrictQuad.Ref")
	proto.RegisterType((*Value)(nil), "pquads.Value")
	proto.RegisterType((*Value_TypedString)(nil), "pquads.Value.TypedString")
	proto.RegisterType((*Value_LangString)(nil), "pquads.Value.LangString")
	proto.RegisterType((*Value_Timestamp)(nil), "pquads.Value.Timestamp")
	proto.RegisterType((*Header)(nil), "pquads.Header")
}
func (m *Quad) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Quad) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Subject) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintQuads(data, i, uint64(len(m.Subject)))
		i += copy(data[i:], m.Subject)
	}
	if len(m.Predicate) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintQuads(data, i, uint64(len(m.Predicate)))
		i += copy(data[i:], m.Predicate)
	}
	if len(m.Object) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintQuads(data, i, uint64(len(m.Object)))
		i += copy(data[i:], m.Object)
	}
	if len(m.Label) > 0 {
		data[i] = 0x22
		i++
		i = encodeVarintQuads(data, i, uint64(len(m.Label)))
		i += copy(data[i:], m.Label)
	}
	if m.SubjectValue != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintQuads(data, i, uint64(m.SubjectValue.ProtoSize()))
		n1, err := m.SubjectValue.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.PredicateValue != nil {
		data[i] = 0x32
		i++
		i = encodeVarintQuads(data, i, uint64(m.PredicateValue.ProtoSize()))
		n2, err := m.PredicateValue.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.ObjectValue != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintQuads(data, i, uint64(m.ObjectValue.ProtoSize()))
		n3, err := m.ObjectValue.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.LabelValue != nil {
		data[i] = 0x42
		i++
		i = encodeVarintQuads(data, i, uint64(m.LabelValue.ProtoSize()))
		n4, err := m.LabelValue.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}

func (m *WireQuad) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *WireQuad) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Subject != nil {
		data[i] = 0xa
		i++
		i = encodeVarintQuads(data, i, uint64(m.Subject.ProtoSize()))
		n5, err := m.Subject.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.Predicate != nil {
		data[i] = 0x12
		i++
		i = encodeVarintQuads(data, i, uint64(m.Predicate.ProtoSize()))
		n6, err := m.Predicate.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.Object != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintQuads(data, i, uint64(m.Object.ProtoSize()))
		n7, err := m.Object.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.Label != nil {
		data[i] = 0x22
		i++
		i = encodeVarintQuads(data, i, uint64(m.Label.ProtoSize()))
		n8, err := m.Label.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}

func (m *StrictQuad) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *StrictQuad) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Subject != nil {
		data[i] = 0xa
		i++
		i = encodeVarintQuads(data, i, uint64(m.Subject.ProtoSize()))
		n9, err := m.Subject.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.Predicate != nil {
		data[i] = 0x12
		i++
		i = encodeVarintQuads(data, i, uint64(m.Predicate.ProtoSize()))
		n10, err := m.Predicate.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.Object != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintQuads(data, i, uint64(m.Object.ProtoSize()))
		n11, err := m.Object.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.Label != nil {
		data[i] = 0x22
		i++
		i = encodeVarintQuads(data, i, uint64(m.Label.ProtoSize()))
		n12, err := m.Label.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}

func (m *StrictQuad_Ref) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *StrictQuad_Ref) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		nn13, err := m.Value.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += nn13
	}
	return i, nil
}

func (m *StrictQuad_Ref_BnodeLabel) MarshalTo(data []byte) (int, error) {
	i := 0
	data[i] = 0x12
	i++
	i = encodeVarintQuads(data, i, uint64(len(m.BnodeLabel)))
	i += copy(data[i:], m.BnodeLabel)
	return i, nil
}
func (m *StrictQuad_Ref_Iri) MarshalTo(data []byte) (int, error) {
	i := 0
	data[i] = 0x1a
	i++
	i = encodeVarintQuads(data, i, uint64(len(m.Iri)))
	i += copy(data[i:], m.Iri)
	return i, nil
}
func (m *Value) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Value) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		nn14, err := m.Value.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += nn14
	}
	return i, nil
}

func (m *Value_Raw) MarshalTo(data []byte) (int, error) {
	i := 0
	if m.Raw != nil {
		data[i] = 0xa
		i++
		i = encodeVarintQuads(data, i, uint64(len(m.Raw)))
		i += copy(data[i:], m.Raw)
	}
	return i, nil
}
func (m *Value_Str) MarshalTo(data []byte) (int, error) {
	i := 0
	data[i] = 0x12
	i++
	i = encodeVarintQuads(data, i, uint64(len(m.Str)))
	i += copy(data[i:], m.Str)
	return i, nil
}
func (m *Value_Iri) MarshalTo(data []byte) (int, error) {
	i := 0
	data[i] = 0x1a
	i++
	i = encodeVarintQuads(data, i, uint64(len(m.Iri)))
	i += copy(data[i:], m.Iri)
	return i, nil
}
func (m *Value_Bnode) MarshalTo(data []byte) (int, error) {
	i := 0
	data[i] = 0x22
	i++
	i = encodeVarintQuads(data, i, uint64(len(m.Bnode)))
	i += copy(data[i:], m.Bnode)
	return i, nil
}
func (m *Value_TypedStr) MarshalTo(data []byte) (int, error) {
	i := 0
	if m.TypedStr != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintQuads(data, i, uint64(m.TypedStr.ProtoSize()))
		n15, err := m.TypedStr.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}
func (m *Value_LangStr) MarshalTo(data []byte) (int, error) {
	i := 0
	if m.LangStr != nil {
		data[i] = 0x32
		i++
		i = encodeVarintQuads(data, i, uint64(m.LangStr.ProtoSize()))
		n16, err := m.LangStr.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	return i, nil
}
func (m *Value_Int) MarshalTo(data []byte) (int, error) {
	i := 0
	data[i] = 0x38
	i++
	i = encodeVarintQuads(data, i, uint64(m.Int))
	return i, nil
}
func (m *Value_Float) MarshalTo(data []byte) (int, error) {
	i := 0
	data[i] = 0x41
	i++
	i = encodeFixed64Quads(data, i, uint64(math.Float64bits(float64(m.Float))))
	return i, nil
}
func (m *Value_Boolean) MarshalTo(data []byte) (int, error) {
	i := 0
	data[i] = 0x48
	i++
	if m.Boolean {
		data[i] = 1
	} else {
		data[i] = 0
	}
	i++
	return i, nil
}
func (m *Value_Time) MarshalTo(data []byte) (int, error) {
	i := 0
	if m.Time != nil {
		data[i] = 0x52
		i++
		i = encodeVarintQuads(data, i, uint64(m.Time.ProtoSize()))
		n17, err := m.Time.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	return i, nil
}
func (m *Value_TypedString) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Value_TypedString) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintQuads(data, i, uint64(len(m.Value)))
		i += copy(data[i:], m.Value)
	}
	if len(m.Type) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintQuads(data, i, uint64(len(m.Type)))
		i += copy(data[i:], m.Type)
	}
	return i, nil
}

func (m *Value_LangString) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Value_LangString) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintQuads(data, i, uint64(len(m.Value)))
		i += copy(data[i:], m.Value)
	}
	if len(m.Lang) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintQuads(data, i, uint64(len(m.Lang)))
		i += copy(data[i:], m.Lang)
	}
	return i, nil
}

func (m *Value_Timestamp) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Value_Timestamp) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Seconds != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintQuads(data, i, uint64(m.Seconds))
	}
	if m.Nanos != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintQuads(data, i, uint64(m.Nanos))
	}
	return i, nil
}

func (m *Header) Marshal() (data []byte, err error) {
	size := m.ProtoSize()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Header) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Full {
		data[i] = 0x8
		i++
		if m.Full {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.NotStrict {
		data[i] = 0x10
		i++
		if m.NotStrict {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	return i, nil
}

func encodeFixed64Quads(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Quads(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintQuads(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}
func (m *Quad) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Subject)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	l = len(m.Predicate)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	l = len(m.Object)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	l = len(m.Label)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.SubjectValue != nil {
		l = m.SubjectValue.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.PredicateValue != nil {
		l = m.PredicateValue.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.ObjectValue != nil {
		l = m.ObjectValue.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.LabelValue != nil {
		l = m.LabelValue.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	return n
}

func (m *WireQuad) ProtoSize() (n int) {
	var l int
	_ = l
	if m.Subject != nil {
		l = m.Subject.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.Predicate != nil {
		l = m.Predicate.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.Object != nil {
		l = m.Object.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.Label != nil {
		l = m.Label.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	return n
}

func (m *StrictQuad) ProtoSize() (n int) {
	var l int
	_ = l
	if m.Subject != nil {
		l = m.Subject.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.Predicate != nil {
		l = m.Predicate.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.Object != nil {
		l = m.Object.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.Label != nil {
		l = m.Label.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	return n
}

func (m *StrictQuad_Ref) ProtoSize() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		n += m.Value.ProtoSize()
	}
	return n
}

func (m *StrictQuad_Ref_BnodeLabel) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.BnodeLabel)
	n += 1 + l + sovQuads(uint64(l))
	return n
}
func (m *StrictQuad_Ref_Iri) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Iri)
	n += 1 + l + sovQuads(uint64(l))
	return n
}
func (m *Value) ProtoSize() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		n += m.Value.ProtoSize()
	}
	return n
}

func (m *Value_Raw) ProtoSize() (n int) {
	var l int
	_ = l
	if m.Raw != nil {
		l = len(m.Raw)
		n += 1 + l + sovQuads(uint64(l))
	}
	return n
}
func (m *Value_Str) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Str)
	n += 1 + l + sovQuads(uint64(l))
	return n
}
func (m *Value_Iri) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Iri)
	n += 1 + l + sovQuads(uint64(l))
	return n
}
func (m *Value_Bnode) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Bnode)
	n += 1 + l + sovQuads(uint64(l))
	return n
}
func (m *Value_TypedStr) ProtoSize() (n int) {
	var l int
	_ = l
	if m.TypedStr != nil {
		l = m.TypedStr.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	return n
}
func (m *Value_LangStr) ProtoSize() (n int) {
	var l int
	_ = l
	if m.LangStr != nil {
		l = m.LangStr.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	return n
}
func (m *Value_Int) ProtoSize() (n int) {
	var l int
	_ = l
	n += 1 + sovQuads(uint64(m.Int))
	return n
}
func (m *Value_Float) ProtoSize() (n int) {
	var l int
	_ = l
	n += 9
	return n
}
func (m *Value_Boolean) ProtoSize() (n int) {
	var l int
	_ = l
	n += 2
	return n
}
func (m *Value_Time) ProtoSize() (n int) {
	var l int
	_ = l
	if m.Time != nil {
		l = m.Time.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	return n
}
func (m *Value_TypedString) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	return n
}

func (m *Value_LangString) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	l = len(m.Lang)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	return n
}

func (m *Value_Timestamp) ProtoSize() (n int) {
	var l int
	_ = l
	if m.Seconds != 0 {
		n += 1 + sovQuads(uint64(m.Seconds))
	}
	if m.Nanos != 0 {
		n += 1 + sovQuads(uint64(m.Nanos))
	}
	return n
}

func (m *Header) ProtoSize() (n int) {
	var l int
	_ = l
	if m.Full {
		n += 2
	}
	if m.NotStrict {
		n += 2
	}
	return n
}

func sovQuads(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozQuads(x uint64) (n int) {
	return sovQuads(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Quad) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Quad: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Quad: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subject", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subject = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Predicate", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Predicate = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Object", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Object = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Label", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Label = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubjectValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SubjectValue == nil {
				m.SubjectValue = &Value{}
			}
			if err := m.SubjectValue.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PredicateValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PredicateValue == nil {
				m.PredicateValue = &Value{}
			}
			if err := m.PredicateValue.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ObjectValue == nil {
				m.ObjectValue = &Value{}
			}
			if err := m.ObjectValue.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LabelValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LabelValue == nil {
				m.LabelValue = &Value{}
			}
			if err := m.LabelValue.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WireQuad) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WireQuad: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WireQuad: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subject", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subject == nil {
				m.Subject = &Value{}
			}
			if err := m.Subject.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Predicate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Predicate == nil {
				m.Predicate = &Value{}
			}
			if err := m.Predicate.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Object", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Object == nil {
				m.Object = &Value{}
			}
			if err := m.Object.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Label", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Label == nil {
				m.Label = &Value{}
			}
			if err := m.Label.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StrictQuad) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StrictQuad: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StrictQuad: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subject", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subject == nil {
				m.Subject = &StrictQuad_Ref{}
			}
			if err := m.Subject.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Predicate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Predicate == nil {
				m.Predicate = &StrictQuad_Ref{}
			}
			if err := m.Predicate.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Object", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Object == nil {
				m.Object = &Value{}
			}
			if err := m.Object.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Label", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Label == nil {
				m.Label = &StrictQuad_Ref{}
			}
			if err := m.Label.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StrictQuad_Ref) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Ref: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Ref: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BnodeLabel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = &StrictQuad_Ref_BnodeLabel{string(data[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Iri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = &StrictQuad_Ref_Iri{string(data[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Value: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Value: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Raw", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, data[iNdEx:postIndex])
			m.Value = &Value_Raw{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Str", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = &Value_Str{string(data[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Iri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = &Value_Iri{string(data[iNdEx:postIndex])}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bnode", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = &Value_Bnode{string(data[iNdEx:postIndex])}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypedStr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Value_TypedString{}
			if err := v.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Value_TypedStr{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LangStr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Value_LangString{}
			if err := v.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Value_LangStr{v}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Value = &Value_Int{v}
		case 8:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Float", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			m.Value = &Value_Float{float64(math.Float64frombits(v))}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Boolean", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Value = &Value_Boolean{b}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Value_Timestamp{}
			if err := v.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Value_Time{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value_TypedString) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TypedString: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TypedString: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value_LangString) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LangString: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LangString: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lang", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Lang = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value_Timestamp) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Timestamp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Timestamp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seconds", wireType)
			}
			m.Seconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Seconds |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nanos", wireType)
			}
			m.Nanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Nanos |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Header) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Header: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Header: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Full", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Full = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotStrict", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NotStrict = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipQuads(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthQuads
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowQuads
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipQuads(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthQuads = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowQuads   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("quads.proto", fileDescriptorQuads) }

var fileDescriptorQuads = []byte{
	// 620 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x94, 0x54, 0xcd, 0x6e, 0xd3, 0x40,
	0x10, 0xc6, 0xb1, 0x9d, 0xd8, 0xe3, 0x14, 0xd0, 0x0a, 0x15, 0x63, 0x41, 0x05, 0x41, 0x08, 0x24,
	0xa8, 0x5b, 0x15, 0x28, 0x48, 0xbd, 0xf5, 0x54, 0x41, 0x2f, 0x18, 0x04, 0xc7, 0x6a, 0x1d, 0x6f,
	0x82, 0x91, 0xb3, 0x1b, 0xec, 0x35, 0x88, 0x17, 0xe1, 0xcc, 0x03, 0xf0, 0x04, 0x3c, 0x01, 0x47,
	0x9e, 0x01, 0xde, 0x82, 0x13, 0xbb, 0xb3, 0x8e, 0xf3, 0x7f, 0xe0, 0x10, 0x69, 0xbf, 0x99, 0xf9,
	0x66, 0xbf, 0x99, 0x7c, 0x5e, 0x08, 0x3e, 0xd6, 0x34, 0xab, 0xe2, 0x69, 0x29, 0xa4, 0x20, 0xdd,
	0x29, 0xa2, 0x68, 0x7f, 0x9c, 0xcb, 0xf7, 0x75, 0x1a, 0x0f, 0xc5, 0xe4, 0x60, 0x2c, 0xc6, 0xe2,
	0x00, 0xd3, 0x69, 0x3d, 0x42, 0x84, 0x00, 0x4f, 0x86, 0x36, 0xf8, 0xd1, 0x01, 0xe7, 0x95, 0x22,
	0x92, 0x10, 0x7a, 0x55, 0x9d, 0x7e, 0x60, 0x43, 0x19, 0x5a, 0xb7, 0xad, 0x07, 0x7e, 0x32, 0x83,
	0xe4, 0x26, 0xf8, 0xd3, 0x92, 0x65, 0xf9, 0x90, 0x4a, 0x16, 0x76, 0x30, 0x37, 0x0f, 0x90, 0x5d,
	0xe8, 0x0a, 0x43, 0xb3, 0x31, 0xd5, 0x20, 0x72, 0x0d, 0xdc, 0x82, 0xa6, 0xac, 0x08, 0x1d, 0x0c,
	0x1b, 0x40, 0x8e, 0x60, 0xa7, 0x69, 0x7b, 0xf1, 0x89, 0x16, 0x35, 0x0b, 0x5d, 0x95, 0x0d, 0x8e,
	0x76, 0x62, 0xa3, 0x3e, 0x7e, 0xab, 0x83, 0x49, 0xbf, 0xa9, 0x41, 0x44, 0x8e, 0xe1, 0x4a, 0x7b,
	0x5d, 0xc3, 0xea, 0x6e, 0x62, 0x5d, 0x6e, 0xab, 0x0c, 0xef, 0x10, 0xfa, 0x62, 0xf1, 0xaa, 0xde,
	0x26, 0x52, 0x20, 0x16, 0x6e, 0x8a, 0x21, 0x40, 0x99, 0x0d, 0xc1, 0xdb, 0x44, 0x00, 0xac, 0xc0,
	0xf3, 0xe0, 0xbb, 0x05, 0xde, 0xbb, 0xbc, 0x64, 0xb8, 0xc0, 0xfb, 0xcb, 0x0b, 0x5c, 0x23, 0xb6,
	0xfb, 0x7c, 0xb8, 0xba, 0xcf, 0xb5, 0xd2, 0x85, 0xf5, 0xde, 0x5b, 0x5a, 0xef, 0x5a, 0xe5, 0x6c,
	0xdb, 0x77, 0x17, 0xb7, 0xbd, 0x56, 0x65, 0x72, 0x83, 0xaf, 0x1d, 0x80, 0xd7, 0xb2, 0xcc, 0x87,
	0x12, 0x05, 0x1f, 0xae, 0x0a, 0xde, 0x9d, 0xb1, 0xe6, 0x45, 0x71, 0xc2, 0x46, 0x73, 0xe5, 0x4f,
	0xd6, 0x95, 0x6f, 0xe3, 0xfc, 0xff, 0x08, 0x8f, 0x96, 0x47, 0xd8, 0xd6, 0xd8, 0x14, 0x45, 0x2f,
	0xc1, 0x56, 0x88, 0xdc, 0x81, 0x20, 0xe5, 0x22, 0x63, 0x17, 0x86, 0x8a, 0xee, 0x3c, 0xbb, 0x94,
	0x00, 0x06, 0xcf, 0xd1, 0x72, 0x04, 0xec, 0xbc, 0xcc, 0x8d, 0x3b, 0x55, 0x4a, 0x83, 0xd3, 0x1e,
	0xb8, 0xf8, 0x17, 0xbf, 0x70, 0x3c, 0xeb, 0x6a, 0x67, 0xf0, 0xd7, 0x06, 0xd7, 0x38, 0x40, 0x15,
	0x97, 0xf4, 0x33, 0xee, 0xa3, 0xaf, 0x8b, 0x15, 0xd0, 0xb1, 0x4a, 0x96, 0x6d, 0x6f, 0x0d, 0x36,
	0x35, 0x55, 0x5f, 0x82, 0x8b, 0xd7, 0x1a, 0xc7, 0xab, 0xa8, 0x81, 0xe4, 0x39, 0xf8, 0xf2, 0xcb,
	0x94, 0x65, 0x17, 0xba, 0x8b, 0xf1, 0xfb, 0x8d, 0xa5, 0x15, 0xc4, 0x6f, 0x74, 0x5a, 0xcf, 0xc9,
	0xc7, 0x8a, 0xe6, 0xc9, 0x06, 0x92, 0xa7, 0xe0, 0x15, 0x94, 0x8f, 0x91, 0x68, 0x2c, 0x1f, 0x2e,
	0x13, 0xcf, 0x55, 0xb6, 0xe5, 0xf5, 0x0a, 0x83, 0x50, 0x1c, 0x97, 0xe8, 0x77, 0x1b, 0xc5, 0x71,
	0xa9, 0xc5, 0x8d, 0x0a, 0x41, 0x25, 0x9a, 0xda, 0xd2, 0xe2, 0x10, 0x92, 0x08, 0x7a, 0xa9, 0x10,
	0x05, 0xa3, 0x3c, 0xf4, 0x55, 0xc6, 0xd3, 0x7d, 0x9a, 0x00, 0xd9, 0x07, 0x47, 0xe6, 0x13, 0x16,
	0x02, 0x5e, 0x7d, 0x7d, 0x45, 0xb3, 0xca, 0x54, 0x92, 0x4e, 0xa6, 0x8a, 0x81, 0x65, 0xd1, 0x33,
	0x08, 0x16, 0x06, 0xd1, 0x0f, 0x80, 0xf9, 0x8c, 0xcc, 0x73, 0x62, 0x80, 0xd2, 0xe6, 0xe8, 0xf1,
	0x9a, 0x77, 0x04, 0xcf, 0xd1, 0x31, 0xc0, 0x7c, 0x90, 0xed, 0x3c, 0x3d, 0xde, 0x8c, 0xa7, 0xcf,
	0xd1, 0x09, 0xf8, 0xad, 0x0a, 0x7c, 0xbf, 0xd8, 0x50, 0xf0, 0xac, 0x42, 0xa2, 0x9d, 0xcc, 0xa0,
	0x6e, 0xc8, 0x29, 0x17, 0x15, 0x72, 0xdd, 0xc4, 0x80, 0xd6, 0x02, 0x83, 0x13, 0xe8, 0x9e, 0x31,
	0x9a, 0x31, 0xbd, 0x37, 0x67, 0x54, 0x17, 0x05, 0xf2, 0xbd, 0x04, 0xcf, 0xe4, 0x16, 0x00, 0x17,
	0x52, 0xff, 0x03, 0xca, 0x84, 0xd8, 0xc1, 0x4b, 0x7c, 0x15, 0x31, 0xae, 0x3c, 0xed, 0xff, 0xfc,
	0xbd, 0x67, 0xfd, 0x52, 0xbf, 0x6f, 0x7f, 0xf6, 0xac, 0xb4, 0x8b, 0x6f, 0xea, 0xe3, 0x7f, 0x01,
	0x00, 0x00, 0xff, 0xff, 0xd8, 0x36, 0x01, 0x85, 0x99, 0x05, 0x00, 0x00,
}
